# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['VirtualFileSystemStorageArgs', 'VirtualFileSystemStorage']

@pulumi.input_type
class VirtualFileSystemStorageArgs:
    def __init__(__self__, *,
                 label: pulumi.Input[_builtins.str],
                 region: pulumi.Input[_builtins.str],
                 size_gb: pulumi.Input[_builtins.int],
                 attached_instances: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 disk_type: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None):
        """
        The set of arguments for constructing a VirtualFileSystemStorage resource.
        :param pulumi.Input[_builtins.str] label: The label to give to the virtual file system storage subscription.
        :param pulumi.Input[_builtins.str] region: The region in which this virtual file system storage will reside.
        :param pulumi.Input[_builtins.int] size_gb: The size of the given virtual file system storage subscription.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] attached_instances: A list of UUIDs to attach to the virtual file system storage subscription.
        :param pulumi.Input[_builtins.str] disk_type: The underlying disk type to use for the virtual file system storage.  Default is `nvme`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tags: A list of tags to be used on the virtual file system storage subscription.
        """
        pulumi.set(__self__, "label", label)
        pulumi.set(__self__, "region", region)
        pulumi.set(__self__, "size_gb", size_gb)
        if attached_instances is not None:
            pulumi.set(__self__, "attached_instances", attached_instances)
        if disk_type is not None:
            pulumi.set(__self__, "disk_type", disk_type)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter
    def label(self) -> pulumi.Input[_builtins.str]:
        """
        The label to give to the virtual file system storage subscription.
        """
        return pulumi.get(self, "label")

    @label.setter
    def label(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "label", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Input[_builtins.str]:
        """
        The region in which this virtual file system storage will reside.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="sizeGb")
    def size_gb(self) -> pulumi.Input[_builtins.int]:
        """
        The size of the given virtual file system storage subscription.
        """
        return pulumi.get(self, "size_gb")

    @size_gb.setter
    def size_gb(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "size_gb", value)

    @_builtins.property
    @pulumi.getter(name="attachedInstances")
    def attached_instances(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A list of UUIDs to attach to the virtual file system storage subscription.
        """
        return pulumi.get(self, "attached_instances")

    @attached_instances.setter
    def attached_instances(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "attached_instances", value)

    @_builtins.property
    @pulumi.getter(name="diskType")
    def disk_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The underlying disk type to use for the virtual file system storage.  Default is `nvme`.
        """
        return pulumi.get(self, "disk_type")

    @disk_type.setter
    def disk_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "disk_type", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A list of tags to be used on the virtual file system storage subscription.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _VirtualFileSystemStorageState:
    def __init__(__self__, *,
                 attached_instances: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 attachments: Optional[pulumi.Input[Sequence[pulumi.Input['VirtualFileSystemStorageAttachmentArgs']]]] = None,
                 charges: Optional[pulumi.Input[_builtins.float]] = None,
                 cost: Optional[pulumi.Input[_builtins.float]] = None,
                 date_created: Optional[pulumi.Input[_builtins.str]] = None,
                 disk_type: Optional[pulumi.Input[_builtins.str]] = None,
                 label: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 size_gb: Optional[pulumi.Input[_builtins.int]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None):
        """
        Input properties used for looking up and filtering VirtualFileSystemStorage resources.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] attached_instances: A list of UUIDs to attach to the virtual file system storage subscription.
        :param pulumi.Input[Sequence[pulumi.Input['VirtualFileSystemStorageAttachmentArgs']]] attachments: A list of attchment states for instances currently attached to the virtual file system storage.
        :param pulumi.Input[_builtins.float] charges: The current pending charges for the virtual file system storage subscription in USD.
        :param pulumi.Input[_builtins.float] cost: The cost per month of the virtual file system storage subscription in USD.
        :param pulumi.Input[_builtins.str] date_created: The date the virtual file system storage subscription was added to your Vultr account.
        :param pulumi.Input[_builtins.str] disk_type: The underlying disk type to use for the virtual file system storage.  Default is `nvme`.
        :param pulumi.Input[_builtins.str] label: The label to give to the virtual file system storage subscription.
        :param pulumi.Input[_builtins.str] region: The region in which this virtual file system storage will reside.
        :param pulumi.Input[_builtins.int] size_gb: The size of the given virtual file system storage subscription.
        :param pulumi.Input[_builtins.str] status: The status of the virtual file system storage subscription.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tags: A list of tags to be used on the virtual file system storage subscription.
        """
        if attached_instances is not None:
            pulumi.set(__self__, "attached_instances", attached_instances)
        if attachments is not None:
            pulumi.set(__self__, "attachments", attachments)
        if charges is not None:
            pulumi.set(__self__, "charges", charges)
        if cost is not None:
            pulumi.set(__self__, "cost", cost)
        if date_created is not None:
            pulumi.set(__self__, "date_created", date_created)
        if disk_type is not None:
            pulumi.set(__self__, "disk_type", disk_type)
        if label is not None:
            pulumi.set(__self__, "label", label)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if size_gb is not None:
            pulumi.set(__self__, "size_gb", size_gb)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter(name="attachedInstances")
    def attached_instances(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A list of UUIDs to attach to the virtual file system storage subscription.
        """
        return pulumi.get(self, "attached_instances")

    @attached_instances.setter
    def attached_instances(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "attached_instances", value)

    @_builtins.property
    @pulumi.getter
    def attachments(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['VirtualFileSystemStorageAttachmentArgs']]]]:
        """
        A list of attchment states for instances currently attached to the virtual file system storage.
        """
        return pulumi.get(self, "attachments")

    @attachments.setter
    def attachments(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['VirtualFileSystemStorageAttachmentArgs']]]]):
        pulumi.set(self, "attachments", value)

    @_builtins.property
    @pulumi.getter
    def charges(self) -> Optional[pulumi.Input[_builtins.float]]:
        """
        The current pending charges for the virtual file system storage subscription in USD.
        """
        return pulumi.get(self, "charges")

    @charges.setter
    def charges(self, value: Optional[pulumi.Input[_builtins.float]]):
        pulumi.set(self, "charges", value)

    @_builtins.property
    @pulumi.getter
    def cost(self) -> Optional[pulumi.Input[_builtins.float]]:
        """
        The cost per month of the virtual file system storage subscription in USD.
        """
        return pulumi.get(self, "cost")

    @cost.setter
    def cost(self, value: Optional[pulumi.Input[_builtins.float]]):
        pulumi.set(self, "cost", value)

    @_builtins.property
    @pulumi.getter(name="dateCreated")
    def date_created(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The date the virtual file system storage subscription was added to your Vultr account.
        """
        return pulumi.get(self, "date_created")

    @date_created.setter
    def date_created(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "date_created", value)

    @_builtins.property
    @pulumi.getter(name="diskType")
    def disk_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The underlying disk type to use for the virtual file system storage.  Default is `nvme`.
        """
        return pulumi.get(self, "disk_type")

    @disk_type.setter
    def disk_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "disk_type", value)

    @_builtins.property
    @pulumi.getter
    def label(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The label to give to the virtual file system storage subscription.
        """
        return pulumi.get(self, "label")

    @label.setter
    def label(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "label", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The region in which this virtual file system storage will reside.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="sizeGb")
    def size_gb(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The size of the given virtual file system storage subscription.
        """
        return pulumi.get(self, "size_gb")

    @size_gb.setter
    def size_gb(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "size_gb", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The status of the virtual file system storage subscription.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A list of tags to be used on the virtual file system storage subscription.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.type_token("vultr:index/virtualFileSystemStorage:VirtualFileSystemStorage")
class VirtualFileSystemStorage(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 attached_instances: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 disk_type: Optional[pulumi.Input[_builtins.str]] = None,
                 label: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 size_gb: Optional[pulumi.Input[_builtins.int]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        """
        Provides a Vultr virtual file system storage resource. This can be used to create, read, modify and delete a virtual file system storage.

        ## Example Usage

        Define a virtual file system storage resource:

        ```python
        import pulumi
        import ediri_vultr as vultr

        my_vfs_storage = vultr.VirtualFileSystemStorage("myVfsStorage",
            label="vultr-vfs-storage",
            region="ewr",
            size_gb=10,
            tags=[
                "terraform",
                "important",
            ])
        ```

        ## Import

        Virtual file system storage can be imported using the `ID`, e.g.

        ```sh
        $ pulumi import vultr:index/virtualFileSystemStorage:VirtualFileSystemStorage my_vfs_storage 79210a84-bc58-494f-8dd1-953685654f7f
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] attached_instances: A list of UUIDs to attach to the virtual file system storage subscription.
        :param pulumi.Input[_builtins.str] disk_type: The underlying disk type to use for the virtual file system storage.  Default is `nvme`.
        :param pulumi.Input[_builtins.str] label: The label to give to the virtual file system storage subscription.
        :param pulumi.Input[_builtins.str] region: The region in which this virtual file system storage will reside.
        :param pulumi.Input[_builtins.int] size_gb: The size of the given virtual file system storage subscription.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tags: A list of tags to be used on the virtual file system storage subscription.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: VirtualFileSystemStorageArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Vultr virtual file system storage resource. This can be used to create, read, modify and delete a virtual file system storage.

        ## Example Usage

        Define a virtual file system storage resource:

        ```python
        import pulumi
        import ediri_vultr as vultr

        my_vfs_storage = vultr.VirtualFileSystemStorage("myVfsStorage",
            label="vultr-vfs-storage",
            region="ewr",
            size_gb=10,
            tags=[
                "terraform",
                "important",
            ])
        ```

        ## Import

        Virtual file system storage can be imported using the `ID`, e.g.

        ```sh
        $ pulumi import vultr:index/virtualFileSystemStorage:VirtualFileSystemStorage my_vfs_storage 79210a84-bc58-494f-8dd1-953685654f7f
        ```

        :param str resource_name: The name of the resource.
        :param VirtualFileSystemStorageArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(VirtualFileSystemStorageArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 attached_instances: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 disk_type: Optional[pulumi.Input[_builtins.str]] = None,
                 label: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 size_gb: Optional[pulumi.Input[_builtins.int]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = VirtualFileSystemStorageArgs.__new__(VirtualFileSystemStorageArgs)

            __props__.__dict__["attached_instances"] = attached_instances
            __props__.__dict__["disk_type"] = disk_type
            if label is None and not opts.urn:
                raise TypeError("Missing required property 'label'")
            __props__.__dict__["label"] = label
            if region is None and not opts.urn:
                raise TypeError("Missing required property 'region'")
            __props__.__dict__["region"] = region
            if size_gb is None and not opts.urn:
                raise TypeError("Missing required property 'size_gb'")
            __props__.__dict__["size_gb"] = size_gb
            __props__.__dict__["tags"] = tags
            __props__.__dict__["attachments"] = None
            __props__.__dict__["charges"] = None
            __props__.__dict__["cost"] = None
            __props__.__dict__["date_created"] = None
            __props__.__dict__["status"] = None
        super(VirtualFileSystemStorage, __self__).__init__(
            'vultr:index/virtualFileSystemStorage:VirtualFileSystemStorage',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            attached_instances: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            attachments: Optional[pulumi.Input[Sequence[pulumi.Input[Union['VirtualFileSystemStorageAttachmentArgs', 'VirtualFileSystemStorageAttachmentArgsDict']]]]] = None,
            charges: Optional[pulumi.Input[_builtins.float]] = None,
            cost: Optional[pulumi.Input[_builtins.float]] = None,
            date_created: Optional[pulumi.Input[_builtins.str]] = None,
            disk_type: Optional[pulumi.Input[_builtins.str]] = None,
            label: Optional[pulumi.Input[_builtins.str]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            size_gb: Optional[pulumi.Input[_builtins.int]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None,
            tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None) -> 'VirtualFileSystemStorage':
        """
        Get an existing VirtualFileSystemStorage resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] attached_instances: A list of UUIDs to attach to the virtual file system storage subscription.
        :param pulumi.Input[Sequence[pulumi.Input[Union['VirtualFileSystemStorageAttachmentArgs', 'VirtualFileSystemStorageAttachmentArgsDict']]]] attachments: A list of attchment states for instances currently attached to the virtual file system storage.
        :param pulumi.Input[_builtins.float] charges: The current pending charges for the virtual file system storage subscription in USD.
        :param pulumi.Input[_builtins.float] cost: The cost per month of the virtual file system storage subscription in USD.
        :param pulumi.Input[_builtins.str] date_created: The date the virtual file system storage subscription was added to your Vultr account.
        :param pulumi.Input[_builtins.str] disk_type: The underlying disk type to use for the virtual file system storage.  Default is `nvme`.
        :param pulumi.Input[_builtins.str] label: The label to give to the virtual file system storage subscription.
        :param pulumi.Input[_builtins.str] region: The region in which this virtual file system storage will reside.
        :param pulumi.Input[_builtins.int] size_gb: The size of the given virtual file system storage subscription.
        :param pulumi.Input[_builtins.str] status: The status of the virtual file system storage subscription.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tags: A list of tags to be used on the virtual file system storage subscription.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _VirtualFileSystemStorageState.__new__(_VirtualFileSystemStorageState)

        __props__.__dict__["attached_instances"] = attached_instances
        __props__.__dict__["attachments"] = attachments
        __props__.__dict__["charges"] = charges
        __props__.__dict__["cost"] = cost
        __props__.__dict__["date_created"] = date_created
        __props__.__dict__["disk_type"] = disk_type
        __props__.__dict__["label"] = label
        __props__.__dict__["region"] = region
        __props__.__dict__["size_gb"] = size_gb
        __props__.__dict__["status"] = status
        __props__.__dict__["tags"] = tags
        return VirtualFileSystemStorage(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="attachedInstances")
    def attached_instances(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        A list of UUIDs to attach to the virtual file system storage subscription.
        """
        return pulumi.get(self, "attached_instances")

    @_builtins.property
    @pulumi.getter
    def attachments(self) -> pulumi.Output[Sequence['outputs.VirtualFileSystemStorageAttachment']]:
        """
        A list of attchment states for instances currently attached to the virtual file system storage.
        """
        return pulumi.get(self, "attachments")

    @_builtins.property
    @pulumi.getter
    def charges(self) -> pulumi.Output[_builtins.float]:
        """
        The current pending charges for the virtual file system storage subscription in USD.
        """
        return pulumi.get(self, "charges")

    @_builtins.property
    @pulumi.getter
    def cost(self) -> pulumi.Output[_builtins.float]:
        """
        The cost per month of the virtual file system storage subscription in USD.
        """
        return pulumi.get(self, "cost")

    @_builtins.property
    @pulumi.getter(name="dateCreated")
    def date_created(self) -> pulumi.Output[_builtins.str]:
        """
        The date the virtual file system storage subscription was added to your Vultr account.
        """
        return pulumi.get(self, "date_created")

    @_builtins.property
    @pulumi.getter(name="diskType")
    def disk_type(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The underlying disk type to use for the virtual file system storage.  Default is `nvme`.
        """
        return pulumi.get(self, "disk_type")

    @_builtins.property
    @pulumi.getter
    def label(self) -> pulumi.Output[_builtins.str]:
        """
        The label to give to the virtual file system storage subscription.
        """
        return pulumi.get(self, "label")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        The region in which this virtual file system storage will reside.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="sizeGb")
    def size_gb(self) -> pulumi.Output[_builtins.int]:
        """
        The size of the given virtual file system storage subscription.
        """
        return pulumi.get(self, "size_gb")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        The status of the virtual file system storage subscription.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        A list of tags to be used on the virtual file system storage subscription.
        """
        return pulumi.get(self, "tags")

