/* CONSTANTS */
#ifndef PI
#define PI 3.1415926535897932384626433832795028841971693993751058209749445923078164062
#endif

#ifndef ROOT2
#define ROOT2 1.41421356237309504880168872420969807856967187537694807317667973799
#endif

#ifndef HALFPI
#define HALFPI (PI/2.0)
#endif

#ifndef PI2
#define PI2 (PI*2.0)
#endif

#ifndef EULER
#define EULER 2.718281828459045235360287471352662497757247093
#endif

#define LPVSPEED_MIN 0.001

#define GRID_EMPTY 0x2800
#define GRID_FULL  0x28ff

#ifndef LPMAXKEY
#define LPMAXKEY 64
#endif

#ifndef LPMAXNAME
#define LPMAXNAME 16
#endif

#define LOGISTIC_SEED_DEFAULT 3.999
#define LOGISTIC_X_DEFAULT 0.555

#define LORENZ_TIMESTEP_DEFAULT 0.011
#define LORENZ_A_DEFAULT 10.0
#define LORENZ_B_DEFAULT 28.0
#define LORENZ_C_DEFAULT (8.0 / 3.0)
#define LORENZ_X_DEFAULT 0.1
#define LORENZ_Y_DEFAULT 0.0
#define LORENZ_Z_DEFAULT 0.0

/* plot width/height is measured in display chars */
#define PLOT_WIDTH 20
#define PLOT_HEIGHT 10

/* braille width/height correspond to the number of dots in 
 * each unicode braille char: 2 columns of 4 dots */
#define BRAILLE_WIDTH 2
#define BRAILLE_HEIGHT 4

/* This is the virtual pixel grid, drawn in braille dot 
 * configurations across the field of braille chars */
#define PIXEL_WIDTH (PLOT_WIDTH * BRAILLE_WIDTH)
#define PIXEL_HEIGHT (PLOT_HEIGHT * BRAILLE_HEIGHT)

#define DEFAULT_CHANNELS 2
#define DEFAULT_SAMPLERATE 48000
#define DEFAULT_TABLESIZE 4096

#ifdef LP_FLOAT
#define HANN_WINDOW_SIZE 256
#define BUILTIN_WINDOW_SIZE 256
static const float LPWIN_HANN[] = { 0.0000000000,0.0001517740,0.0006070039,0.0013654133,0.0024265418,0.0037897452,0.0054541958,0.0074188833,0.0096826148,0.0122440160,0.0151015320,0.0182534279,0.0216977902,0.0254325280,0.0294553737,0.0337638853,0.0383554469,0.0432272712,0.0483764003,0.0537997084,0.0594939029,0.0654555268,0.0716809611,0.0781664261,0.0849079846,0.0919015438,0.0991428580,0.1066275310,0.1143510188,0.1223086326,0.1304955414,0.1389067748,0.1475372265,0.1563816570,0.1654346968,0.1746908499,0.1841444969,0.1937898985,0.2036211990,0.2136324300,0.2238175135,0.2341702664,0.2446844034,0.2553535415,0.2661712036,0.2771308221,0.2882257437,0.2994492325,0.3107944750,0.3222545833,0.3338226003,0.3454915028,0.3572542069,0.3691035713,0.3810324025,0.3930334584,0.4050994533,0.4172230619,0.4293969241,0.4416136491,0.4538658203,0.4661459993,0.4784467310,0.4907605475,0.5030799733,0.5153975293,0.5277057375,0.5399971256,0.5522642316,0.5644996083,0.5766958274,0.5888454849,0.6009412046,0.6129756433,0.6249414949,0.6368314950,0.6486384253,0.6603551178,0.6719744593,0.6834893958,0.6948929366,0.7061781587,0.7173382109,0.7283663179,0.7392557846,0.7500000000,0.7605924414,0.7710266782,0.7812963758,0.7913952995,0.8013173182,0.8110564084,0.8206066574,0.8299622674,0.8391175587,0.8480669730,0.8568050772,0.8653265665,0.8736262674,0.8816991414,0.8895402873,0.8971449448,0.9045084972,0.9116264741,0.9184945542,0.9251085679,0.9314644998,0.9375584914,0.9433868430,0.9489460161,0.9542326359,0.9592434929,0.9639755449,0.9684259193,0.9725919141,0.9764710002,0.9800608227,0.9833592021,0.9863641361,0.9890738004,0.9914865498,0.9936009198,0.9954156265,0.9969295684,0.9981418264,0.9990516644,0.9996585301,0.9999620551,0.9999620551,0.9996585301,0.9990516644,0.9981418264,0.9969295684,0.9954156265,0.9936009198,0.9914865498,0.9890738004,0.9863641361,0.9833592021,0.9800608227,0.9764710002,0.9725919141,0.9684259193,0.9639755449,0.9592434929,0.9542326359,0.9489460161,0.9433868430,0.9375584914,0.9314644998,0.9251085679,0.9184945542,0.9116264741,0.9045084972,0.8971449448,0.8895402873,0.8816991414,0.8736262674,0.8653265665,0.8568050772,0.8480669730,0.8391175587,0.8299622674,0.8206066574,0.8110564084,0.8013173182,0.7913952995,0.7812963758,0.7710266782,0.7605924414,0.7500000000,0.7392557846,0.7283663179,0.7173382109,0.7061781587,0.6948929366,0.6834893958,0.6719744593,0.6603551178,0.6486384253,0.6368314950,0.6249414949,0.6129756433,0.6009412046,0.5888454849,0.5766958274,0.5644996083,0.5522642316,0.5399971256,0.5277057375,0.5153975293,0.5030799733,0.4907605475,0.4784467310,0.4661459993,0.4538658203,0.4416136491,0.4293969241,0.4172230619,0.4050994533,0.3930334584,0.3810324025,0.3691035713,0.3572542069,0.3454915028,0.3338226003,0.3222545833,0.3107944750,0.2994492325,0.2882257437,0.2771308221,0.2661712036,0.2553535415,0.2446844034,0.2341702664,0.2238175135,0.2136324300,0.2036211990,0.1937898985,0.1841444969,0.1746908499,0.1654346968,0.1563816570,0.1475372265,0.1389067748,0.1304955414,0.1223086326,0.1143510188,0.1066275310,0.0991428580,0.0919015438,0.0849079846,0.0781664261,0.0716809611,0.0654555268,0.0594939029,0.0537997084,0.0483764003,0.0432272712,0.0383554469,0.0337638853,0.0294553737,0.0254325280,0.0216977902,0.0182534279,0.0151015320,0.0122440160,0.0096826148,0.0074188833,0.0054541958,0.0037897452,0.0024265418,0.0013654133,0.0006070039,0.0001517740,0.0000000000 };
static const float LPWIN_PLUCKOUT[256] = {
    0.0000,0.9562,0.8374,0.6677,0.4791,0.3036,0.2434,0.2402,0.2370,0.2339,0.2307,0.2275,0.2244,0.2213,0.2181,0.2150,0.2119,0.2088,0.2057,0.2027,0.1996,0.1966,0.1935,0.1905,0.1875,0.1846,0.1816,0.1786,0.1757,0.1728,0.1699,0.1671,0.1642,0.1614,0.1586,0.1558,0.1530,0.1503,0.1476,0.1449,0.1422,0.1396,0.1369,0.1343,0.1318,0.1292,0.1267,0.1242,0.1218,0.1193,0.1169,0.1145,0.1122,0.1098,0.1075,0.1052,0.1030,0.1008,0.0986,0.0964,0.0943,0.0922,0.0901,0.0880,0.0860,0.0840,0.0821,0.0801,0.0782,0.0763,0.0745,0.0727,0.0709,0.0691,0.0674,0.0657,0.0640,0.0624,0.0607,0.0591,0.0576,0.0560,0.0545,0.0531,0.0516,0.0502,0.0488,0.0474,0.0461,0.0447,0.0435,0.0422,0.0409,0.0397,0.0385,0.0374,0.0362,0.0351,0.0340,0.0330,0.0319,0.0309,0.0299,0.0290,0.0280,0.0271,0.0262,0.0253,0.0245,0.0236,0.0228,0.0220,0.0212,0.0205,0.0198,0.0190,0.0184,0.0177,0.0170,0.0164,0.0158,0.0152,0.0146,0.0140,0.0135,0.0129,0.0124,0.0119,0.0114,0.0110,0.0105,0.0101,0.0096,0.0092,0.0088,0.0084,0.0081,0.0077,0.0074,0.0070,0.0067,0.0064,0.0061,0.0058,0.0055,0.0053,0.0050,0.0048,0.0045,0.0043,0.0041,0.0039,0.0037,0.0035,0.0033,0.0031,0.0030,0.0028,0.0026,0.0025,0.0024,0.0022,0.0021,0.0020,0.0018,0.0017,0.0016,0.0015,0.0014,0.0013,0.0013,0.0012,0.0011,0.0010,0.0010,0.0009,0.0008,0.0008,0.0007,0.0007,0.0006,0.0006,0.0005,0.0005,0.0005,0.0004,0.0004,0.0004,0.0003,0.0003,0.0003,0.0003,0.0002,0.0002,0.0002,0.0002,0.0002,0.0001,0.0001,0.0001,0.0001,0.0001,0.0001,0.0001,0.0001,0.0001,0.0001,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000
};
#else
#define HANN_WINDOW_SIZE 4096
#define BUILTIN_WINDOW_SIZE 4096
static const double LPWIN_HANN[] = { 0.0000000000,0.0000005886,0.0000023542,0.0000052970,0.0000094170,0.0000147140,0.0000211881,0.0000288392,0.0000376675,0.0000476727,0.0000588550,0.0000712143,0.0000847505,0.0000994636,0.0001153536,0.0001324205,0.0001506642,0.0001700847,0.0001906818,0.0002124557,0.0002354062,0.0002595332,0.0002848368,0.0003113168,0.0003389732,0.0003678059,0.0003978149,0.0004290001,0.0004613613,0.0004948987,0.0005296119,0.0005655011,0.0006025660,0.0006408067,0.0006802229,0.0007208147,0.0007625819,0.0008055245,0.0008496422,0.0008949351,0.0009414030,0.0009890458,0.0010378634,0.0010878557,0.0011390226,0.0011913638,0.0012448795,0.0012995693,0.0013554331,0.0014124709,0.0014706825,0.0015300677,0.0015906265,0.0016523587,0.0017152641,0.0017793425,0.0018445939,0.0019110181,0.0019786149,0.0020473842,0.0021173258,0.0021884395,0.0022607252,0.0023341826,0.0024088118,0.0024846123,0.0025615842,0.0026397271,0.0027190409,0.0027995255,0.0028811806,0.0029640060,0.0030480016,0.0031331671,0.0032195024,0.0033070072,0.0033956813,0.0034855246,0.0035765368,0.0036687177,0.0037620671,0.0038565848,0.0039522705,0.0040491240,0.0041471451,0.0042463336,0.0043466891,0.0044482116,0.0045509008,0.0046547563,0.0047597780,0.0048659656,0.0049733189,0.0050818376,0.0051915215,0.0053023703,0.0054143837,0.0055275614,0.0056419033,0.0057574091,0.0058740784,0.0059919110,0.0061109066,0.0062310649,0.0063523857,0.0064748687,0.0065985135,0.0067233200,0.0068492877,0.0069764164,0.0071047059,0.0072341557,0.0073647656,0.0074965353,0.0076294645,0.0077635528,0.0078988000,0.0080352057,0.0081727696,0.0083114914,0.0084513708,0.0085924073,0.0087346008,0.0088779509,0.0090224571,0.0091681193,0.0093149369,0.0094629098,0.0096120375,0.0097623197,0.0099137561,0.0100663462,0.0102200898,0.0103749864,0.0105310357,0.0106882374,0.0108465910,0.0110060962,0.0111667526,0.0113285598,0.0114915175,0.0116556253,0.0118208827,0.0119872894,0.0121548451,0.0123235492,0.0124934015,0.0126644015,0.0128365487,0.0130098429,0.0131842836,0.0133598704,0.0135366028,0.0137144805,0.0138935030,0.0140736699,0.0142549809,0.0144374353,0.0146210330,0.0148057733,0.0149916559,0.0151786803,0.0153668461,0.0155561529,0.0157466001,0.0159381874,0.0161309143,0.0163247804,0.0165197851,0.0167159281,0.0169132088,0.0171116269,0.0173111818,0.0175118730,0.0177137002,0.0179166627,0.0181207602,0.0183259922,0.0185323582,0.0187398576,0.0189484901,0.0191582550,0.0193691520,0.0195811805,0.0197943401,0.0200086301,0.0202240502,0.0204405998,0.0206582784,0.0208770854,0.0210970205,0.0213180830,0.0215402724,0.0217635883,0.0219880300,0.0222135971,0.0224402890,0.0226681052,0.0228970452,0.0231271084,0.0233582943,0.0235906023,0.0238240318,0.0240585824,0.0242942535,0.0245310446,0.0247689550,0.0250079842,0.0252481316,0.0254893968,0.0257317790,0.0259752778,0.0262198926,0.0264656228,0.0267124677,0.0269604270,0.0272094998,0.0274596857,0.0277109842,0.0279633944,0.0282169160,0.0284715483,0.0287272907,0.0289841425,0.0292421033,0.0295011723,0.0297613490,0.0300226328,0.0302850230,0.0305485190,0.0308131202,0.0310788260,0.0313456358,0.0316135489,0.0318825647,0.0321526825,0.0324239018,0.0326962219,0.0329696421,0.0332441618,0.0335197804,0.0337964972,0.0340743115,0.0343532228,0.0346332303,0.0349143334,0.0351965314,0.0354798237,0.0357642095,0.0360496883,0.0363362594,0.0366239220,0.0369126755,0.0372025193,0.0374934526,0.0377854747,0.0380785850,0.0383727828,0.0386680674,0.0389644380,0.0392618941,0.0395604348,0.0398600595,0.0401607675,0.0404625581,0.0407654306,0.0410693842,0.0413744182,0.0416805320,0.0419877247,0.0422959957,0.0426053443,0.0429157697,0.0432272712,0.0435398480,0.0438534995,0.0441682248,0.0444840233,0.0448008942,0.0451188367,0.0454378501,0.0457579337,0.0460790866,0.0464013083,0.0467245978,0.0470489544,0.0473743774,0.0477008659,0.0480284193,0.0483570368,0.0486867175,0.0490174607,0.0493492657,0.0496821316,0.0500160576,0.0503510430,0.0506870871,0.0510241889,0.0513623477,0.0517015627,0.0520418331,0.0523831581,0.0527255369,0.0530689687,0.0534134527,0.0537589881,0.0541055740,0.0544532097,0.0548018943,0.0551516270,0.0555024070,0.0558542334,0.0562071055,0.0565610224,0.0569159832,0.0572719872,0.0576290334,0.0579871211,0.0583462495,0.0587064175,0.0590676245,0.0594298696,0.0597931518,0.0601574704,0.0605228246,0.0608892133,0.0612566358,0.0616250913,0.0619945788,0.0623650974,0.0627366464,0.0631092247,0.0634828317,0.0638574663,0.0642331276,0.0646098149,0.0649875272,0.0653662637,0.0657460233,0.0661268053,0.0665086088,0.0668914328,0.0672752764,0.0676601388,0.0680460190,0.0684329161,0.0688208293,0.0692097575,0.0695997000,0.0699906557,0.0703826237,0.0707756032,0.0711695932,0.0715645927,0.0719606009,0.0723576168,0.0727556395,0.0731546680,0.0735547014,0.0739557388,0.0743577792,0.0747608217,0.0751648652,0.0755699090,0.0759759519,0.0763829931,0.0767910316,0.0772000665,0.0776100967,0.0780211213,0.0784331394,0.0788461499,0.0792601520,0.0796751446,0.0800911267,0.0805080974,0.0809260556,0.0813450005,0.0817649310,0.0821858461,0.0826077449,0.0830306263,0.0834544893,0.0838793330,0.0843051564,0.0847319584,0.0851597380,0.0855884943,0.0860182262,0.0864489327,0.0868806128,0.0873132655,0.0877468898,0.0881814846,0.0886170490,0.0890535818,0.0894910821,0.0899295489,0.0903689810,0.0908093775,0.0912507374,0.0916930595,0.0921363430,0.0925805866,0.0930257894,0.0934719503,0.0939190682,0.0943671422,0.0948161712,0.0952661540,0.0957170897,0.0961689772,0.0966218154,0.0970756032,0.0975303396,0.0979860236,0.0984426539,0.0989002297,0.0993587497,0.0998182129,0.1002786183,0.1007399647,0.1012022511,0.1016654763,0.1021296393,0.1025947390,0.1030607743,0.1035277440,0.1039956472,0.1044644827,0.1049342493,0.1054049460,0.1058765717,0.1063491253,0.1068226056,0.1072970116,0.1077723421,0.1082485959,0.1087257721,0.1092038694,0.1096828867,0.1101628230,0.1106436770,0.1111254476,0.1116081338,0.1120917343,0.1125762481,0.1130616739,0.1135480107,0.1140352573,0.1145234126,0.1150124754,0.1155024445,0.1159933188,0.1164850972,0.1169777784,0.1174713614,0.1179658450,0.1184612279,0.1189575091,0.1194546874,0.1199527615,0.1204517304,0.1209515929,0.1214523477,0.1219539937,0.1224565297,0.1229599545,0.1234642670,0.1239694659,0.1244755502,0.1249825184,0.1254903696,0.1259991025,0.1265087158,0.1270192085,0.1275305792,0.1280428268,0.1285559501,0.1290699479,0.1295848189,0.1301005620,0.1306171759,0.1311346594,0.1316530113,0.1321722304,0.1326923155,0.1332132653,0.1337350786,0.1342577542,0.1347812908,0.1353056872,0.1358309423,0.1363570546,0.1368840231,0.1374118464,0.1379405234,0.1384700527,0.1390004332,0.1395316635,0.1400637425,0.1405966689,0.1411304413,0.1416650587,0.1422005196,0.1427368229,0.1432739673,0.1438119515,0.1443507743,0.1448904343,0.1454309304,0.1459722612,0.1465144255,0.1470574219,0.1476012493,0.1481459063,0.1486913917,0.1492377041,0.1497848423,0.1503328050,0.1508815910,0.1514311988,0.1519816272,0.1525328750,0.1530849407,0.1536378232,0.1541915212,0.1547460332,0.1553013581,0.1558574944,0.1564144410,0.1569721964,0.1575307594,0.1580901287,0.1586503029,0.1592112807,0.1597730609,0.1603356420,0.1608990227,0.1614632018,0.1620281779,0.1625939497,0.1631605158,0.1637278749,0.1642960256,0.1648649667,0.1654346968,0.1660052146,0.1665765186,0.1671486076,0.1677214802,0.1682951351,0.1688695709,0.1694447862,0.1700207798,0.1705975502,0.1711750961,0.1717534162,0.1723325090,0.1729123732,0.1734930075,0.1740744105,0.1746565807,0.1752395169,0.1758232177,0.1764076816,0.1769929074,0.1775788936,0.1781656389,0.1787531419,0.1793414011,0.1799304152,0.1805201829,0.1811107027,0.1817019733,0.1822939932,0.1828867610,0.1834802755,0.1840745351,0.1846695384,0.1852652841,0.1858617708,0.1864589971,0.1870569615,0.1876556626,0.1882550991,0.1888552695,0.1894561724,0.1900578064,0.1906601701,0.1912632620,0.1918670808,0.1924716250,0.1930768932,0.1936828840,0.1942895960,0.1948970276,0.1955051775,0.1961140443,0.1967236265,0.1973339227,0.1979449315,0.1985566513,0.1991690809,0.1997822186,0.2003960632,0.2010106131,0.2016258669,0.2022418231,0.2028584803,0.2034758371,0.2040938920,0.2047126435,0.2053320901,0.2059522305,0.2065730632,0.2071945866,0.2078167994,0.2084397001,0.2090632872,0.2096875592,0.2103125147,0.2109381521,0.2115644701,0.2121914672,0.2128191418,0.2134474925,0.2140765178,0.2147062163,0.2153365864,0.2159676266,0.2165993356,0.2172317117,0.2178647536,0.2184984597,0.2191328285,0.2197678585,0.2204035483,0.2210398963,0.2216769010,0.2223145610,0.2229528747,0.2235918407,0.2242314574,0.2248717233,0.2255126369,0.2261541968,0.2267964013,0.2274392491,0.2280827385,0.2287268681,0.2293716363,0.2300170416,0.2306630826,0.2313097576,0.2319570652,0.2326050039,0.2332535720,0.2339027681,0.2345525907,0.2352030383,0.2358541092,0.2365058020,0.2371581151,0.2378110470,0.2384645962,0.2391187611,0.2397735401,0.2404289318,0.2410849346,0.2417415470,0.2423987673,0.2430565941,0.2437150259,0.2443740609,0.2450336978,0.2456939349,0.2463547708,0.2470162037,0.2476782323,0.2483408549,0.2490040700,0.2496678759,0.2503322712,0.2509972543,0.2516628236,0.2523289776,0.2529957146,0.2536630331,0.2543309316,0.2549994084,0.2556684620,0.2563380909,0.2570082934,0.2576790679,0.2583504130,0.2590223269,0.2596948081,0.2603678551,0.2610414663,0.2617156400,0.2623903747,0.2630656688,0.2637415206,0.2644179287,0.2650948915,0.2657724072,0.2664504744,0.2671290914,0.2678082566,0.2684879685,0.2691682254,0.2698490257,0.2705303679,0.2712122503,0.2718946713,0.2725776294,0.2732611228,0.2739451501,0.2746297095,0.2753147995,0.2760004185,0.2766865648,0.2773732369,0.2780604331,0.2787481518,0.2794363913,0.2801251501,0.2808144266,0.2815042191,0.2821945260,0.2828853456,0.2835766764,0.2842685167,0.2849608649,0.2856537193,0.2863470784,0.2870409404,0.2877353038,0.2884301670,0.2891255282,0.2898213858,0.2905177383,0.2912145840,0.2919119212,0.2926097483,0.2933080636,0.2940068655,0.2947061524,0.2954059226,0.2961061745,0.2968069063,0.2975081166,0.2982098036,0.2989119656,0.2996146010,0.3003177082,0.3010212855,0.3017253313,0.3024298438,0.3031348214,0.3038402626,0.3045461655,0.3052525286,0.3059593501,0.3066666285,0.3073743621,0.3080825491,0.3087911879,0.3095002769,0.3102098144,0.3109197987,0.3116302282,0.3123411011,0.3130524158,0.3137641706,0.3144763639,0.3151889939,0.3159020590,0.3166155575,0.3173294878,0.3180438481,0.3187586368,0.3194738522,0.3201894926,0.3209055563,0.3216220416,0.3223389469,0.3230562704,0.3237740105,0.3244921655,0.3252107337,0.3259297133,0.3266491028,0.3273689004,0.3280891044,0.3288097131,0.3295307249,0.3302521379,0.3309739506,0.3316961613,0.3324187681,0.3331417695,0.3338651637,0.3345889490,0.3353131238,0.3360376862,0.3367626347,0.3374879675,0.3382136829,0.3389397791,0.3396662545,0.3403931074,0.3411203361,0.3418479387,0.3425759138,0.3433042594,0.3440329739,0.3447620556,0.3454915028,0.3462213137,0.3469514867,0.3476820200,0.3484129119,0.3491441606,0.3498757645,0.3506077218,0.3513400309,0.3520726899,0.3528056972,0.3535390510,0.3542727496,0.3550067913,0.3557411743,0.3564758970,0.3572109575,0.3579463542,0.3586820854,0.3594181492,0.3601545440,0.3608912680,0.3616283196,0.3623656969,0.3631033982,0.3638414218,0.3645797659,0.3653184289,0.3660574089,0.3667967043,0.3675363133,0.3682762341,0.3690164650,0.3697570043,0.3704978502,0.3712390010,0.3719804550,0.3727222103,0.3734642653,0.3742066181,0.3749492671,0.3756922106,0.3764354466,0.3771789736,0.3779227897,0.3786668932,0.3794112824,0.3801559554,0.3809009106,0.3816461462,0.3823916605,0.3831374516,0.3838835178,0.3846298574,0.3853764686,0.3861233496,0.3868704988,0.3876179143,0.3883655943,0.3891135372,0.3898617411,0.3906102043,0.3913589251,0.3921079016,0.3928571321,0.3936066149,0.3943563481,0.3951063301,0.3958565590,0.3966070331,0.3973577506,0.3981087097,0.3988599087,0.3996113458,0.4003630193,0.4011149273,0.4018670681,0.4026194400,0.4033720411,0.4041248697,0.4048779240,0.4056312023,0.4063847027,0.4071384235,0.4078923629,0.4086465192,0.4094008906,0.4101554752,0.4109102714,0.4116652773,0.4124204911,0.4131759112,0.4139315356,0.4146873627,0.4154433906,0.4161996176,0.4169560419,0.4177126616,0.4184694751,0.4192264806,0.4199836762,0.4207410602,0.4214986308,0.4222563862,0.4230143246,0.4237724442,0.4245307434,0.4252892202,0.4260478728,0.4268066996,0.4275656987,0.4283248684,0.4290842067,0.4298437120,0.4306033825,0.4313632164,0.4321232118,0.4328833671,0.4336436803,0.4344041498,0.4351647737,0.4359255503,0.4366864777,0.4374475541,0.4382087778,0.4389701470,0.4397316599,0.4404933146,0.4412551095,0.4420170426,0.4427791123,0.4435413166,0.4443036539,0.4450661223,0.4458287200,0.4465914453,0.4473542963,0.4481172712,0.4488803683,0.4496435857,0.4504069217,0.4511703745,0.4519339421,0.4526976230,0.4534614152,0.4542253170,0.4549893265,0.4557534420,0.4565176617,0.4572819838,0.4580464064,0.4588109278,0.4595755461,0.4603402596,0.4611050665,0.4618699650,0.4626349532,0.4634000294,0.4641651918,0.4649304385,0.4656957678,0.4664611778,0.4672266668,0.4679922330,0.4687578745,0.4695235895,0.4702893764,0.4710552331,0.4718211580,0.4725871493,0.4733532050,0.4741193236,0.4748855030,0.4756517416,0.4764180375,0.4771843889,0.4779507940,0.4787172510,0.4794837582,0.4802503136,0.4810169155,0.4817835621,0.4825502516,0.4833169822,0.4840837521,0.4848505594,0.4856174024,0.4863842793,0.4871511882,0.4879181274,0.4886850950,0.4894520892,0.4902191083,0.4909861504,0.4917532138,0.4925202965,0.4932873968,0.4940545130,0.4948216431,0.4955887855,0.4963559382,0.4971230995,0.4978902676,0.4986574407,0.4994246169,0.5001917944,0.5009589715,0.5017261464,0.5024933172,0.5032604821,0.5040276393,0.5047947871,0.5055619236,0.5063290469,0.5070961554,0.5078632472,0.5086303205,0.5093973734,0.5101644042,0.5109314111,0.5116983923,0.5124653459,0.5132322701,0.5139991632,0.5147660234,0.5155328488,0.5162996376,0.5170663881,0.5178330984,0.5185997666,0.5193663911,0.5201329701,0.5208995016,0.5216659839,0.5224324152,0.5231987937,0.5239651175,0.5247313850,0.5254975942,0.5262637434,0.5270298308,0.5277958545,0.5285618128,0.5293277039,0.5300935259,0.5308592771,0.5316249556,0.5323905596,0.5331560875,0.5339215372,0.5346869071,0.5354521953,0.5362174001,0.5369825196,0.5377475520,0.5385124956,0.5392773485,0.5400421089,0.5408067751,0.5415713452,0.5423358174,0.5431001899,0.5438644610,0.5446286288,0.5453926916,0.5461566475,0.5469204947,0.5476842315,0.5484478560,0.5492113664,0.5499747610,0.5507380379,0.5515011954,0.5522642316,0.5530271448,0.5537899332,0.5545525949,0.5553151282,0.5560775313,0.5568398023,0.5576019395,0.5583639411,0.5591258054,0.5598875304,0.5606491144,0.5614105557,0.5621718523,0.5629330026,0.5636940048,0.5644548570,0.5652155574,0.5659761043,0.5667364959,0.5674967304,0.5682568060,0.5690167209,0.5697764732,0.5705360614,0.5712954834,0.5720547377,0.5728138223,0.5735727354,0.5743314754,0.5750900403,0.5758484285,0.5766066381,0.5773646674,0.5781225145,0.5788801777,0.5796376552,0.5803949453,0.5811520460,0.5819089557,0.5826656726,0.5834221948,0.5841785207,0.5849346483,0.5856905761,0.5864463020,0.5872018245,0.5879571417,0.5887122518,0.5894671530,0.5902218437,0.5909763219,0.5917305859,0.5924846340,0.5932384643,0.5939920752,0.5947454647,0.5954986312,0.5962515729,0.5970042880,0.5977567747,0.5985090313,0.5992610559,0.6000128469,0.6007644024,0.6015157207,0.6022668000,0.6030176385,0.6037682345,0.6045185862,0.6052686919,0.6060185497,0.6067681579,0.6075175148,0.6082666185,0.6090154674,0.6097640596,0.6105123934,0.6112604670,0.6120082787,0.6127558267,0.6135031092,0.6142501245,0.6149968709,0.6157433465,0.6164895496,0.6172354785,0.6179811314,0.6187265065,0.6194716021,0.6202164165,0.6209609478,0.6217051944,0.6224491544,0.6231928262,0.6239362079,0.6246792978,0.6254220943,0.6261645954,0.6269067996,0.6276487049,0.6283903098,0.6291316124,0.6298726109,0.6306133038,0.6313536891,0.6320937652,0.6328335303,0.6335729827,0.6343121206,0.6350509423,0.6357894461,0.6365276302,0.6372654929,0.6380030324,0.6387402470,0.6394771350,0.6402136947,0.6409499242,0.6416858219,0.6424213860,0.6431566149,0.6438915067,0.6446260598,0.6453602723,0.6460941427,0.6468276691,0.6475608499,0.6482936833,0.6490261675,0.6497583009,0.6504900817,0.6512215083,0.6519525788,0.6526832916,0.6534136449,0.6541436371,0.6548732664,0.6556025310,0.6563314294,0.6570599596,0.6577881202,0.6585159092,0.6592433251,0.6599703661,0.6606970305,0.6614233165,0.6621492225,0.6628747468,0.6635998877,0.6643246433,0.6650490122,0.6657729924,0.6664965824,0.6672197804,0.6679425847,0.6686649937,0.6693870056,0.6701086187,0.6708298313,0.6715506417,0.6722710483,0.6729910493,0.6737106430,0.6744298278,0.6751486020,0.6758669637,0.6765849115,0.6773024435,0.6780195581,0.6787362537,0.6794525284,0.6801683806,0.6808838087,0.6815988110,0.6823133857,0.6830275312,0.6837412458,0.6844545278,0.6851673756,0.6858797875,0.6865917617,0.6873032967,0.6880143907,0.6887250421,0.6894352492,0.6901450103,0.6908543237,0.6915631879,0.6922716010,0.6929795615,0.6936870677,0.6943941178,0.6951007104,0.6958068436,0.6965125158,0.6972177254,0.6979224707,0.6986267501,0.6993305618,0.7000339042,0.7007367758,0.7014391747,0.7021410994,0.7028425482,0.7035435195,0.7042440116,0.7049440228,0.7056435516,0.7063425962,0.7070411550,0.7077392264,0.7084368088,0.7091339004,0.7098304997,0.7105266049,0.7112222146,0.7119173270,0.7126119405,0.7133060534,0.7139996641,0.7146927711,0.7153853726,0.7160774671,0.7167690528,0.7174601282,0.7181506917,0.7188407416,0.7195302762,0.7202192941,0.7209077935,0.7215957728,0.7222832304,0.7229701648,0.7236565742,0.7243424570,0.7250278117,0.7257126366,0.7263969302,0.7270806907,0.7277639167,0.7284466064,0.7291287583,0.7298103708,0.7304914423,0.7311719711,0.7318519557,0.7325313945,0.7332102858,0.7338886281,0.7345664197,0.7352436591,0.7359203447,0.7365964749,0.7372720481,0.7379470627,0.7386215171,0.7392954097,0.7399687390,0.7406415033,0.7413137011,0.7419853308,0.7426563908,0.7433268795,0.7439967953,0.7446661368,0.7453349022,0.7460030900,0.7466706987,0.7473377267,0.7480041724,0.7486700342,0.7493353106,0.7500000000,0.7506641008,0.7513276115,0.7519905306,0.7526528563,0.7533145873,0.7539757219,0.7546362586,0.7552961958,0.7559555319,0.7566142655,0.7572723950,0.7579299188,0.7585868353,0.7592431431,0.7598988405,0.7605539261,0.7612083982,0.7618622555,0.7625154962,0.7631681189,0.7638201221,0.7644715041,0.7651222635,0.7657723988,0.7664219083,0.7670707907,0.7677190442,0.7683666676,0.7690136591,0.7696600172,0.7703057406,0.7709508276,0.7715952766,0.7722390863,0.7728822551,0.7735247814,0.7741666638,0.7748079008,0.7754484907,0.7760884322,0.7767277237,0.7773663638,0.7780043508,0.7786416834,0.7792783599,0.7799143790,0.7805497391,0.7811844387,0.7818184763,0.7824518504,0.7830845596,0.7837166024,0.7843479772,0.7849786826,0.7856087170,0.7862380791,0.7868667673,0.7874947801,0.7881221162,0.7887487739,0.7893747518,0.7900000484,0.7906246623,0.7912485921,0.7918718361,0.7924943930,0.7931162613,0.7937374396,0.7943579263,0.7949777200,0.7955968193,0.7962152226,0.7968329286,0.7974499358,0.7980662427,0.7986818479,0.7992967499,0.7999109473,0.8005244387,0.8011372225,0.8017492974,0.8023606619,0.8029713145,0.8035812539,0.8041904786,0.8047989871,0.8054067781,0.8060138501,0.8066202016,0.8072258313,0.8078307377,0.8084349193,0.8090383749,0.8096411029,0.8102431019,0.8108443705,0.8114449074,0.8120447110,0.8126437800,0.8132421129,0.8138397084,0.8144365651,0.8150326814,0.8156280562,0.8162226878,0.8168165750,0.8174097163,0.8180021104,0.8185937558,0.8191846511,0.8197747950,0.8203641861,0.8209528230,0.8215407042,0.8221278285,0.8227141944,0.8232998006,0.8238846456,0.8244687282,0.8250520468,0.8256346002,0.8262163870,0.8267974058,0.8273776552,0.8279571339,0.8285358405,0.8291137737,0.8296909320,0.8302673142,0.8308429188,0.8314177445,0.8319917900,0.8325650540,0.8331375349,0.8337092316,0.8342801427,0.8348502668,0.8354196025,0.8359881486,0.8365559037,0.8371228665,0.8376890356,0.8382544097,0.8388189874,0.8393827675,0.8399457486,0.8405079294,0.8410693085,0.8416298847,0.8421896566,0.8427486229,0.8433067823,0.8438641335,0.8444206751,0.8449764059,0.8455313245,0.8460854296,0.8466387200,0.8471911943,0.8477428512,0.8482936895,0.8488437078,0.8493929048,0.8499412793,0.8504888299,0.8510355554,0.8515814544,0.8521265258,0.8526707682,0.8532141802,0.8537567608,0.8542985085,0.8548394221,0.8553795003,0.8559187418,0.8564571455,0.8569947099,0.8575314339,0.8580673162,0.8586023555,0.8591365506,0.8596699002,0.8602024030,0.8607340578,0.8612648634,0.8617948184,0.8623239217,0.8628521720,0.8633795681,0.8639061086,0.8644317925,0.8649566184,0.8654805851,0.8660036913,0.8665259359,0.8670473176,0.8675678352,0.8680874874,0.8686062731,0.8691241910,0.8696412398,0.8701574185,0.8706727257,0.8711871602,0.8717007209,0.8722134065,0.8727252158,0.8732361477,0.8737462008,0.8742553741,0.8747636663,0.8752710761,0.8757776025,0.8762832443,0.8767880001,0.8772918689,0.8777948495,0.8782969407,0.8787981412,0.8792984500,0.8797978658,0.8802963875,0.8807940138,0.8812907437,0.8817865759,0.8822815093,0.8827755427,0.8832686750,0.8837609049,0.8842522314,0.8847426533,0.8852321694,0.8857207785,0.8862084796,0.8866952715,0.8871811529,0.8876661229,0.8881501802,0.8886333237,0.8891155522,0.8895968647,0.8900772599,0.8905567369,0.8910352943,0.8915129312,0.8919896464,0.8924654387,0.8929403070,0.8934142503,0.8938872674,0.8943593572,0.8948305185,0.8953007503,0.8957700515,0.8962384210,0.8967058576,0.8971723602,0.8976379279,0.8981025594,0.8985662536,0.8990290095,0.8994908261,0.8999517021,0.9004116365,0.9008706283,0.9013286763,0.9017857795,0.9022419368,0.9026971471,0.9031514094,0.9036047225,0.9040570855,0.9045084972,0.9049589566,0.9054084626,0.9058570142,0.9063046103,0.9067512499,0.9071969319,0.9076416552,0.9080854188,0.9085282218,0.9089700629,0.9094109412,0.9098508557,0.9102898053,0.9107277889,0.9111648056,0.9116008543,0.9120359340,0.9124700437,0.9129031823,0.9133353489,0.9137665423,0.9141967616,0.9146260059,0.9150542739,0.9154815649,0.9159078777,0.9163332113,0.9167575648,0.9171809372,0.9176033274,0.9180247345,0.9184451574,0.9188645952,0.9192830469,0.9197005115,0.9201169880,0.9205324755,0.9209469729,0.9213604793,0.9217729938,0.9221845152,0.9225950428,0.9230045754,0.9234131122,0.9238206522,0.9242271944,0.9246327379,0.9250372816,0.9254408248,0.9258433663,0.9262449053,0.9266454408,0.9270449719,0.9274434976,0.9278410170,0.9282375292,0.9286330332,0.9290275281,0.9294210129,0.9298134868,0.9302049488,0.9305953980,0.9309848334,0.9313732543,0.9317606595,0.9321470483,0.9325324197,0.9329167728,0.9333001068,0.9336824206,0.9340637134,0.9344439844,0.9348232325,0.9352014570,0.9355786569,0.9359548313,0.9363299794,0.9367041003,0.9370771931,0.9374492568,0.9378202908,0.9381902939,0.9385592655,0.9389272046,0.9392941103,0.9396599819,0.9400248184,0.9403886189,0.9407513827,0.9411131088,0.9414737964,0.9418334447,0.9421920528,0.9425496199,0.9429061451,0.9432616277,0.9436160666,0.9439694612,0.9443218106,0.9446731139,0.9450233703,0.9453725791,0.9457207393,0.9460678502,0.9464139110,0.9467589208,0.9471028788,0.9474457842,0.9477876362,0.9481284340,0.9484681768,0.9488068638,0.9491444942,0.9494810672,0.9498165820,0.9501510379,0.9504844340,0.9508167695,0.9511480437,0.9514782557,0.9518074049,0.9521354904,0.9524625115,0.9527884674,0.9531133573,0.9534371804,0.9537599361,0.9540816235,0.9544022418,0.9547217904,0.9550402685,0.9553576753,0.9556740101,0.9559892721,0.9563034605,0.9566165748,0.9569286140,0.9572395776,0.9575494646,0.9578582745,0.9581660065,0.9584726598,0.9587782338,0.9590827277,0.9593861408,0.9596884724,0.9599897218,0.9602898883,0.9605889711,0.9608869696,0.9611838830,0.9614797107,0.9617744520,0.9620681061,0.9623606724,0.9626521502,0.9629425388,0.9632318376,0.9635200457,0.9638071626,0.9640931876,0.9643781201,0.9646619592,0.9649447044,0.9652263551,0.9655069104,0.9657863699,0.9660647328,0.9663419984,0.9666181662,0.9668932354,0.9671672055,0.9674400757,0.9677118455,0.9679825141,0.9682520810,0.9685205455,0.9687879070,0.9690541649,0.9693193185,0.9695833672,0.9698463104,0.9701081474,0.9703688778,0.9706285007,0.9708870157,0.9711444220,0.9714007192,0.9716559066,0.9719099836,0.9721629496,0.9724148041,0.9726655463,0.9729151758,0.9731636919,0.9734110941,0.9736573817,0.9739025543,0.9741466111,0.9743895517,0.9746313755,0.9748720818,0.9751116702,0.9753501401,0.9755874909,0.9758237220,0.9760588330,0.9762928231,0.9765256920,0.9767574390,0.9769880636,0.9772175652,0.9774459434,0.9776731975,0.9778993271,0.9781243316,0.9783482104,0.9785709631,0.9787925892,0.9790130880,0.9792324591,0.9794507020,0.9796678162,0.9798838011,0.9800986562,0.9803123810,0.9805249751,0.9807364379,0.9809467690,0.9811559677,0.9813640338,0.9815709665,0.9817767655,0.9819814303,0.9821849604,0.9823873554,0.9825886146,0.9827887378,0.9829877243,0.9831855737,0.9833822857,0.9835778596,0.9837722950,0.9839655916,0.9841577487,0.9843487661,0.9845386431,0.9847273794,0.9849149746,0.9851014282,0.9852867397,0.9854709087,0.9856539348,0.9858358176,0.9860165566,0.9861961513,0.9863746015,0.9865519066,0.9867280663,0.9869030800,0.9870769475,0.9872496683,0.9874212420,0.9875916681,0.9877609464,0.9879290763,0.9880960576,0.9882618897,0.9884265724,0.9885901051,0.9887524876,0.9889137195,0.9890738004,0.9892327298,0.9893905075,0.9895471330,0.9897026060,0.9898569262,0.9900100931,0.9901621063,0.9903129657,0.9904626707,0.9906112210,0.9907586163,0.9909048563,0.9910499405,0.9911938687,0.9913366405,0.9914782556,0.9916187136,0.9917580142,0.9918961571,0.9920331420,0.9921689684,0.9923036362,0.9924371450,0.9925694945,0.9927006844,0.9928307143,0.9929595839,0.9930872930,0.9932138413,0.9933392284,0.9934634541,0.9935865181,0.9937084200,0.9938291596,0.9939487366,0.9940671507,0.9941844017,0.9943004893,0.9944154131,0.9945291730,0.9946417686,0.9947531997,0.9948634661,0.9949725674,0.9950805034,0.9951872739,0.9952928786,0.9953973173,0.9955005896,0.9956026955,0.9957036345,0.9958034066,0.9959020114,0.9959994487,0.9960957184,0.9961908201,0.9962847536,0.9963775188,0.9964691154,0.9965595431,0.9966488019,0.9967368914,0.9968238115,0.9969095619,0.9969941425,0.9970775530,0.9971597933,0.9972408631,0.9973207623,0.9973994908,0.9974770482,0.9975534344,0.9976286492,0.9977026926,0.9977755642,0.9978472639,0.9979177916,0.9979871470,0.9980553301,0.9981223406,0.9981881784,0.9982528433,0.9983163353,0.9983786541,0.9984397995,0.9984997716,0.9985585700,0.9986161947,0.9986726456,0.9987279224,0.9987820251,0.9988349536,0.9988867077,0.9989372873,0.9989866922,0.9990349224,0.9990819778,0.9991278582,0.9991725635,0.9992160937,0.9992584486,0.9992996281,0.9993396321,0.9993784606,0.9994161134,0.9994525905,0.9994878917,0.9995220170,0.9995549663,0.9995867395,0.9996173366,0.9996467575,0.9996750021,0.9997020703,0.9997279621,0.9997526774,0.9997762161,0.9997985783,0.9998197638,0.9998397727,0.9998586047,0.9998762600,0.9998927385,0.9999080401,0.9999221647,0.9999351125,0.9999468833,0.9999574770,0.9999668938,0.9999751335,0.9999821961,0.9999880817,0.9999927901,0.9999963215,0.9999986757,0.9999998529,0.9999998529,0.9999986757,0.9999963215,0.9999927901,0.9999880817,0.9999821961,0.9999751335,0.9999668938,0.9999574770,0.9999468833,0.9999351125,0.9999221647,0.9999080401,0.9998927385,0.9998762600,0.9998586047,0.9998397727,0.9998197638,0.9997985783,0.9997762161,0.9997526774,0.9997279621,0.9997020703,0.9996750021,0.9996467575,0.9996173366,0.9995867395,0.9995549663,0.9995220170,0.9994878917,0.9994525905,0.9994161134,0.9993784606,0.9993396321,0.9992996281,0.9992584486,0.9992160937,0.9991725635,0.9991278582,0.9990819778,0.9990349224,0.9989866922,0.9989372873,0.9988867077,0.9988349536,0.9987820251,0.9987279224,0.9986726456,0.9986161947,0.9985585700,0.9984997716,0.9984397995,0.9983786541,0.9983163353,0.9982528433,0.9981881784,0.9981223406,0.9980553301,0.9979871470,0.9979177916,0.9978472639,0.9977755642,0.9977026926,0.9976286492,0.9975534344,0.9974770482,0.9973994908,0.9973207623,0.9972408631,0.9971597933,0.9970775530,0.9969941425,0.9969095619,0.9968238115,0.9967368914,0.9966488019,0.9965595431,0.9964691154,0.9963775188,0.9962847536,0.9961908201,0.9960957184,0.9959994487,0.9959020114,0.9958034066,0.9957036345,0.9956026955,0.9955005896,0.9953973173,0.9952928786,0.9951872739,0.9950805034,0.9949725674,0.9948634661,0.9947531997,0.9946417686,0.9945291730,0.9944154131,0.9943004893,0.9941844017,0.9940671507,0.9939487366,0.9938291596,0.9937084200,0.9935865181,0.9934634541,0.9933392284,0.9932138413,0.9930872930,0.9929595839,0.9928307143,0.9927006844,0.9925694945,0.9924371450,0.9923036362,0.9921689684,0.9920331420,0.9918961571,0.9917580142,0.9916187136,0.9914782556,0.9913366405,0.9911938687,0.9910499405,0.9909048563,0.9907586163,0.9906112210,0.9904626707,0.9903129657,0.9901621063,0.9900100931,0.9898569262,0.9897026060,0.9895471330,0.9893905075,0.9892327298,0.9890738004,0.9889137195,0.9887524876,0.9885901051,0.9884265724,0.9882618897,0.9880960576,0.9879290763,0.9877609464,0.9875916681,0.9874212420,0.9872496683,0.9870769475,0.9869030800,0.9867280663,0.9865519066,0.9863746015,0.9861961513,0.9860165566,0.9858358176,0.9856539348,0.9854709087,0.9852867397,0.9851014282,0.9849149746,0.9847273794,0.9845386431,0.9843487661,0.9841577487,0.9839655916,0.9837722950,0.9835778596,0.9833822857,0.9831855737,0.9829877243,0.9827887378,0.9825886146,0.9823873554,0.9821849604,0.9819814303,0.9817767655,0.9815709665,0.9813640338,0.9811559677,0.9809467690,0.9807364379,0.9805249751,0.9803123810,0.9800986562,0.9798838011,0.9796678162,0.9794507020,0.9792324591,0.9790130880,0.9787925892,0.9785709631,0.9783482104,0.9781243316,0.9778993271,0.9776731975,0.9774459434,0.9772175652,0.9769880636,0.9767574390,0.9765256920,0.9762928231,0.9760588330,0.9758237220,0.9755874909,0.9753501401,0.9751116702,0.9748720818,0.9746313755,0.9743895517,0.9741466111,0.9739025543,0.9736573817,0.9734110941,0.9731636919,0.9729151758,0.9726655463,0.9724148041,0.9721629496,0.9719099836,0.9716559066,0.9714007192,0.9711444220,0.9708870157,0.9706285007,0.9703688778,0.9701081474,0.9698463104,0.9695833672,0.9693193185,0.9690541649,0.9687879070,0.9685205455,0.9682520810,0.9679825141,0.9677118455,0.9674400757,0.9671672055,0.9668932354,0.9666181662,0.9663419984,0.9660647328,0.9657863699,0.9655069104,0.9652263551,0.9649447044,0.9646619592,0.9643781201,0.9640931876,0.9638071626,0.9635200457,0.9632318376,0.9629425388,0.9626521502,0.9623606724,0.9620681061,0.9617744520,0.9614797107,0.9611838830,0.9608869696,0.9605889711,0.9602898883,0.9599897218,0.9596884724,0.9593861408,0.9590827277,0.9587782338,0.9584726598,0.9581660065,0.9578582745,0.9575494646,0.9572395776,0.9569286140,0.9566165748,0.9563034605,0.9559892721,0.9556740101,0.9553576753,0.9550402685,0.9547217904,0.9544022418,0.9540816235,0.9537599361,0.9534371804,0.9531133573,0.9527884674,0.9524625115,0.9521354904,0.9518074049,0.9514782557,0.9511480437,0.9508167695,0.9504844340,0.9501510379,0.9498165820,0.9494810672,0.9491444942,0.9488068638,0.9484681768,0.9481284340,0.9477876362,0.9474457842,0.9471028788,0.9467589208,0.9464139110,0.9460678502,0.9457207393,0.9453725791,0.9450233703,0.9446731139,0.9443218106,0.9439694612,0.9436160666,0.9432616277,0.9429061451,0.9425496199,0.9421920528,0.9418334447,0.9414737964,0.9411131088,0.9407513827,0.9403886189,0.9400248184,0.9396599819,0.9392941103,0.9389272046,0.9385592655,0.9381902939,0.9378202908,0.9374492568,0.9370771931,0.9367041003,0.9363299794,0.9359548313,0.9355786569,0.9352014570,0.9348232325,0.9344439844,0.9340637134,0.9336824206,0.9333001068,0.9329167728,0.9325324197,0.9321470483,0.9317606595,0.9313732543,0.9309848334,0.9305953980,0.9302049488,0.9298134868,0.9294210129,0.9290275281,0.9286330332,0.9282375292,0.9278410170,0.9274434976,0.9270449719,0.9266454408,0.9262449053,0.9258433663,0.9254408248,0.9250372816,0.9246327379,0.9242271944,0.9238206522,0.9234131122,0.9230045754,0.9225950428,0.9221845152,0.9217729938,0.9213604793,0.9209469729,0.9205324755,0.9201169880,0.9197005115,0.9192830469,0.9188645952,0.9184451574,0.9180247345,0.9176033274,0.9171809372,0.9167575648,0.9163332113,0.9159078777,0.9154815649,0.9150542739,0.9146260059,0.9141967616,0.9137665423,0.9133353489,0.9129031823,0.9124700437,0.9120359340,0.9116008543,0.9111648056,0.9107277889,0.9102898053,0.9098508557,0.9094109412,0.9089700629,0.9085282218,0.9080854188,0.9076416552,0.9071969319,0.9067512499,0.9063046103,0.9058570142,0.9054084626,0.9049589566,0.9045084972,0.9040570855,0.9036047225,0.9031514094,0.9026971471,0.9022419368,0.9017857795,0.9013286763,0.9008706283,0.9004116365,0.8999517021,0.8994908261,0.8990290095,0.8985662536,0.8981025594,0.8976379279,0.8971723602,0.8967058576,0.8962384210,0.8957700515,0.8953007503,0.8948305185,0.8943593572,0.8938872674,0.8934142503,0.8929403070,0.8924654387,0.8919896464,0.8915129312,0.8910352943,0.8905567369,0.8900772599,0.8895968647,0.8891155522,0.8886333237,0.8881501802,0.8876661229,0.8871811529,0.8866952715,0.8862084796,0.8857207785,0.8852321694,0.8847426533,0.8842522314,0.8837609049,0.8832686750,0.8827755427,0.8822815093,0.8817865759,0.8812907437,0.8807940138,0.8802963875,0.8797978658,0.8792984500,0.8787981412,0.8782969407,0.8777948495,0.8772918689,0.8767880001,0.8762832443,0.8757776025,0.8752710761,0.8747636663,0.8742553741,0.8737462008,0.8732361477,0.8727252158,0.8722134065,0.8717007209,0.8711871602,0.8706727257,0.8701574185,0.8696412398,0.8691241910,0.8686062731,0.8680874874,0.8675678352,0.8670473176,0.8665259359,0.8660036913,0.8654805851,0.8649566184,0.8644317925,0.8639061086,0.8633795681,0.8628521720,0.8623239217,0.8617948184,0.8612648634,0.8607340578,0.8602024030,0.8596699002,0.8591365506,0.8586023555,0.8580673162,0.8575314339,0.8569947099,0.8564571455,0.8559187418,0.8553795003,0.8548394221,0.8542985085,0.8537567608,0.8532141802,0.8526707682,0.8521265258,0.8515814544,0.8510355554,0.8504888299,0.8499412793,0.8493929048,0.8488437078,0.8482936895,0.8477428512,0.8471911943,0.8466387200,0.8460854296,0.8455313245,0.8449764059,0.8444206751,0.8438641335,0.8433067823,0.8427486229,0.8421896566,0.8416298847,0.8410693085,0.8405079294,0.8399457486,0.8393827675,0.8388189874,0.8382544097,0.8376890356,0.8371228665,0.8365559037,0.8359881486,0.8354196025,0.8348502668,0.8342801427,0.8337092316,0.8331375349,0.8325650540,0.8319917900,0.8314177445,0.8308429188,0.8302673142,0.8296909320,0.8291137737,0.8285358405,0.8279571339,0.8273776552,0.8267974058,0.8262163870,0.8256346002,0.8250520468,0.8244687282,0.8238846456,0.8232998006,0.8227141944,0.8221278285,0.8215407042,0.8209528230,0.8203641861,0.8197747950,0.8191846511,0.8185937558,0.8180021104,0.8174097163,0.8168165750,0.8162226878,0.8156280562,0.8150326814,0.8144365651,0.8138397084,0.8132421129,0.8126437800,0.8120447110,0.8114449074,0.8108443705,0.8102431019,0.8096411029,0.8090383749,0.8084349193,0.8078307377,0.8072258313,0.8066202016,0.8060138501,0.8054067781,0.8047989871,0.8041904786,0.8035812539,0.8029713145,0.8023606619,0.8017492974,0.8011372225,0.8005244387,0.7999109473,0.7992967499,0.7986818479,0.7980662427,0.7974499358,0.7968329286,0.7962152226,0.7955968193,0.7949777200,0.7943579263,0.7937374396,0.7931162613,0.7924943930,0.7918718361,0.7912485921,0.7906246623,0.7900000484,0.7893747518,0.7887487739,0.7881221162,0.7874947801,0.7868667673,0.7862380791,0.7856087170,0.7849786826,0.7843479772,0.7837166024,0.7830845596,0.7824518504,0.7818184763,0.7811844387,0.7805497391,0.7799143790,0.7792783599,0.7786416834,0.7780043508,0.7773663638,0.7767277237,0.7760884322,0.7754484907,0.7748079008,0.7741666638,0.7735247814,0.7728822551,0.7722390863,0.7715952766,0.7709508276,0.7703057406,0.7696600172,0.7690136591,0.7683666676,0.7677190442,0.7670707907,0.7664219083,0.7657723988,0.7651222635,0.7644715041,0.7638201221,0.7631681189,0.7625154962,0.7618622555,0.7612083982,0.7605539261,0.7598988405,0.7592431431,0.7585868353,0.7579299188,0.7572723950,0.7566142655,0.7559555319,0.7552961958,0.7546362586,0.7539757219,0.7533145873,0.7526528563,0.7519905306,0.7513276115,0.7506641008,0.7500000000,0.7493353106,0.7486700342,0.7480041724,0.7473377267,0.7466706987,0.7460030900,0.7453349022,0.7446661368,0.7439967953,0.7433268795,0.7426563908,0.7419853308,0.7413137011,0.7406415033,0.7399687390,0.7392954097,0.7386215171,0.7379470627,0.7372720481,0.7365964749,0.7359203447,0.7352436591,0.7345664197,0.7338886281,0.7332102858,0.7325313945,0.7318519557,0.7311719711,0.7304914423,0.7298103708,0.7291287583,0.7284466064,0.7277639167,0.7270806907,0.7263969302,0.7257126366,0.7250278117,0.7243424570,0.7236565742,0.7229701648,0.7222832304,0.7215957728,0.7209077935,0.7202192941,0.7195302762,0.7188407416,0.7181506917,0.7174601282,0.7167690528,0.7160774671,0.7153853726,0.7146927711,0.7139996641,0.7133060534,0.7126119405,0.7119173270,0.7112222146,0.7105266049,0.7098304997,0.7091339004,0.7084368088,0.7077392264,0.7070411550,0.7063425962,0.7056435516,0.7049440228,0.7042440116,0.7035435195,0.7028425482,0.7021410994,0.7014391747,0.7007367758,0.7000339042,0.6993305618,0.6986267501,0.6979224707,0.6972177254,0.6965125158,0.6958068436,0.6951007104,0.6943941178,0.6936870677,0.6929795615,0.6922716010,0.6915631879,0.6908543237,0.6901450103,0.6894352492,0.6887250421,0.6880143907,0.6873032967,0.6865917617,0.6858797875,0.6851673756,0.6844545278,0.6837412458,0.6830275312,0.6823133857,0.6815988110,0.6808838087,0.6801683806,0.6794525284,0.6787362537,0.6780195581,0.6773024435,0.6765849115,0.6758669637,0.6751486020,0.6744298278,0.6737106430,0.6729910493,0.6722710483,0.6715506417,0.6708298313,0.6701086187,0.6693870056,0.6686649937,0.6679425847,0.6672197804,0.6664965824,0.6657729924,0.6650490122,0.6643246433,0.6635998877,0.6628747468,0.6621492225,0.6614233165,0.6606970305,0.6599703661,0.6592433251,0.6585159092,0.6577881202,0.6570599596,0.6563314294,0.6556025310,0.6548732664,0.6541436371,0.6534136449,0.6526832916,0.6519525788,0.6512215083,0.6504900817,0.6497583009,0.6490261675,0.6482936833,0.6475608499,0.6468276691,0.6460941427,0.6453602723,0.6446260598,0.6438915067,0.6431566149,0.6424213860,0.6416858219,0.6409499242,0.6402136947,0.6394771350,0.6387402470,0.6380030324,0.6372654929,0.6365276302,0.6357894461,0.6350509423,0.6343121206,0.6335729827,0.6328335303,0.6320937652,0.6313536891,0.6306133038,0.6298726109,0.6291316124,0.6283903098,0.6276487049,0.6269067996,0.6261645954,0.6254220943,0.6246792978,0.6239362079,0.6231928262,0.6224491544,0.6217051944,0.6209609478,0.6202164165,0.6194716021,0.6187265065,0.6179811314,0.6172354785,0.6164895496,0.6157433465,0.6149968709,0.6142501245,0.6135031092,0.6127558267,0.6120082787,0.6112604670,0.6105123934,0.6097640596,0.6090154674,0.6082666185,0.6075175148,0.6067681579,0.6060185497,0.6052686919,0.6045185862,0.6037682345,0.6030176385,0.6022668000,0.6015157207,0.6007644024,0.6000128469,0.5992610559,0.5985090313,0.5977567747,0.5970042880,0.5962515729,0.5954986312,0.5947454647,0.5939920752,0.5932384643,0.5924846340,0.5917305859,0.5909763219,0.5902218437,0.5894671530,0.5887122518,0.5879571417,0.5872018245,0.5864463020,0.5856905761,0.5849346483,0.5841785207,0.5834221948,0.5826656726,0.5819089557,0.5811520460,0.5803949453,0.5796376552,0.5788801777,0.5781225145,0.5773646674,0.5766066381,0.5758484285,0.5750900403,0.5743314754,0.5735727354,0.5728138223,0.5720547377,0.5712954834,0.5705360614,0.5697764732,0.5690167209,0.5682568060,0.5674967304,0.5667364959,0.5659761043,0.5652155574,0.5644548570,0.5636940048,0.5629330026,0.5621718523,0.5614105557,0.5606491144,0.5598875304,0.5591258054,0.5583639411,0.5576019395,0.5568398023,0.5560775313,0.5553151282,0.5545525949,0.5537899332,0.5530271448,0.5522642316,0.5515011954,0.5507380379,0.5499747610,0.5492113664,0.5484478560,0.5476842315,0.5469204947,0.5461566475,0.5453926916,0.5446286288,0.5438644610,0.5431001899,0.5423358174,0.5415713452,0.5408067751,0.5400421089,0.5392773485,0.5385124956,0.5377475520,0.5369825196,0.5362174001,0.5354521953,0.5346869071,0.5339215372,0.5331560875,0.5323905596,0.5316249556,0.5308592771,0.5300935259,0.5293277039,0.5285618128,0.5277958545,0.5270298308,0.5262637434,0.5254975942,0.5247313850,0.5239651175,0.5231987937,0.5224324152,0.5216659839,0.5208995016,0.5201329701,0.5193663911,0.5185997666,0.5178330984,0.5170663881,0.5162996376,0.5155328488,0.5147660234,0.5139991632,0.5132322701,0.5124653459,0.5116983923,0.5109314111,0.5101644042,0.5093973734,0.5086303205,0.5078632472,0.5070961554,0.5063290469,0.5055619236,0.5047947871,0.5040276393,0.5032604821,0.5024933172,0.5017261464,0.5009589715,0.5001917944,0.4994246169,0.4986574407,0.4978902676,0.4971230995,0.4963559382,0.4955887855,0.4948216431,0.4940545130,0.4932873968,0.4925202965,0.4917532138,0.4909861504,0.4902191083,0.4894520892,0.4886850950,0.4879181274,0.4871511882,0.4863842793,0.4856174024,0.4848505594,0.4840837521,0.4833169822,0.4825502516,0.4817835621,0.4810169155,0.4802503136,0.4794837582,0.4787172510,0.4779507940,0.4771843889,0.4764180375,0.4756517416,0.4748855030,0.4741193236,0.4733532050,0.4725871493,0.4718211580,0.4710552331,0.4702893764,0.4695235895,0.4687578745,0.4679922330,0.4672266668,0.4664611778,0.4656957678,0.4649304385,0.4641651918,0.4634000294,0.4626349532,0.4618699650,0.4611050665,0.4603402596,0.4595755461,0.4588109278,0.4580464064,0.4572819838,0.4565176617,0.4557534420,0.4549893265,0.4542253170,0.4534614152,0.4526976230,0.4519339421,0.4511703745,0.4504069217,0.4496435857,0.4488803683,0.4481172712,0.4473542963,0.4465914453,0.4458287200,0.4450661223,0.4443036539,0.4435413166,0.4427791123,0.4420170426,0.4412551095,0.4404933146,0.4397316599,0.4389701470,0.4382087778,0.4374475541,0.4366864777,0.4359255503,0.4351647737,0.4344041498,0.4336436803,0.4328833671,0.4321232118,0.4313632164,0.4306033825,0.4298437120,0.4290842067,0.4283248684,0.4275656987,0.4268066996,0.4260478728,0.4252892202,0.4245307434,0.4237724442,0.4230143246,0.4222563862,0.4214986308,0.4207410602,0.4199836762,0.4192264806,0.4184694751,0.4177126616,0.4169560419,0.4161996176,0.4154433906,0.4146873627,0.4139315356,0.4131759112,0.4124204911,0.4116652773,0.4109102714,0.4101554752,0.4094008906,0.4086465192,0.4078923629,0.4071384235,0.4063847027,0.4056312023,0.4048779240,0.4041248697,0.4033720411,0.4026194400,0.4018670681,0.4011149273,0.4003630193,0.3996113458,0.3988599087,0.3981087097,0.3973577506,0.3966070331,0.3958565590,0.3951063301,0.3943563481,0.3936066149,0.3928571321,0.3921079016,0.3913589251,0.3906102043,0.3898617411,0.3891135372,0.3883655943,0.3876179143,0.3868704988,0.3861233496,0.3853764686,0.3846298574,0.3838835178,0.3831374516,0.3823916605,0.3816461462,0.3809009106,0.3801559554,0.3794112824,0.3786668932,0.3779227897,0.3771789736,0.3764354466,0.3756922106,0.3749492671,0.3742066181,0.3734642653,0.3727222103,0.3719804550,0.3712390010,0.3704978502,0.3697570043,0.3690164650,0.3682762341,0.3675363133,0.3667967043,0.3660574089,0.3653184289,0.3645797659,0.3638414218,0.3631033982,0.3623656969,0.3616283196,0.3608912680,0.3601545440,0.3594181492,0.3586820854,0.3579463542,0.3572109575,0.3564758970,0.3557411743,0.3550067913,0.3542727496,0.3535390510,0.3528056972,0.3520726899,0.3513400309,0.3506077218,0.3498757645,0.3491441606,0.3484129119,0.3476820200,0.3469514867,0.3462213137,0.3454915028,0.3447620556,0.3440329739,0.3433042594,0.3425759138,0.3418479387,0.3411203361,0.3403931074,0.3396662545,0.3389397791,0.3382136829,0.3374879675,0.3367626347,0.3360376862,0.3353131238,0.3345889490,0.3338651637,0.3331417695,0.3324187681,0.3316961613,0.3309739506,0.3302521379,0.3295307249,0.3288097131,0.3280891044,0.3273689004,0.3266491028,0.3259297133,0.3252107337,0.3244921655,0.3237740105,0.3230562704,0.3223389469,0.3216220416,0.3209055563,0.3201894926,0.3194738522,0.3187586368,0.3180438481,0.3173294878,0.3166155575,0.3159020590,0.3151889939,0.3144763639,0.3137641706,0.3130524158,0.3123411011,0.3116302282,0.3109197987,0.3102098144,0.3095002769,0.3087911879,0.3080825491,0.3073743621,0.3066666285,0.3059593501,0.3052525286,0.3045461655,0.3038402626,0.3031348214,0.3024298438,0.3017253313,0.3010212855,0.3003177082,0.2996146010,0.2989119656,0.2982098036,0.2975081166,0.2968069063,0.2961061745,0.2954059226,0.2947061524,0.2940068655,0.2933080636,0.2926097483,0.2919119212,0.2912145840,0.2905177383,0.2898213858,0.2891255282,0.2884301670,0.2877353038,0.2870409404,0.2863470784,0.2856537193,0.2849608649,0.2842685167,0.2835766764,0.2828853456,0.2821945260,0.2815042191,0.2808144266,0.2801251501,0.2794363913,0.2787481518,0.2780604331,0.2773732369,0.2766865648,0.2760004185,0.2753147995,0.2746297095,0.2739451501,0.2732611228,0.2725776294,0.2718946713,0.2712122503,0.2705303679,0.2698490257,0.2691682254,0.2684879685,0.2678082566,0.2671290914,0.2664504744,0.2657724072,0.2650948915,0.2644179287,0.2637415206,0.2630656688,0.2623903747,0.2617156400,0.2610414663,0.2603678551,0.2596948081,0.2590223269,0.2583504130,0.2576790679,0.2570082934,0.2563380909,0.2556684620,0.2549994084,0.2543309316,0.2536630331,0.2529957146,0.2523289776,0.2516628236,0.2509972543,0.2503322712,0.2496678759,0.2490040700,0.2483408549,0.2476782323,0.2470162037,0.2463547708,0.2456939349,0.2450336978,0.2443740609,0.2437150259,0.2430565941,0.2423987673,0.2417415470,0.2410849346,0.2404289318,0.2397735401,0.2391187611,0.2384645962,0.2378110470,0.2371581151,0.2365058020,0.2358541092,0.2352030383,0.2345525907,0.2339027681,0.2332535720,0.2326050039,0.2319570652,0.2313097576,0.2306630826,0.2300170416,0.2293716363,0.2287268681,0.2280827385,0.2274392491,0.2267964013,0.2261541968,0.2255126369,0.2248717233,0.2242314574,0.2235918407,0.2229528747,0.2223145610,0.2216769010,0.2210398963,0.2204035483,0.2197678585,0.2191328285,0.2184984597,0.2178647536,0.2172317117,0.2165993356,0.2159676266,0.2153365864,0.2147062163,0.2140765178,0.2134474925,0.2128191418,0.2121914672,0.2115644701,0.2109381521,0.2103125147,0.2096875592,0.2090632872,0.2084397001,0.2078167994,0.2071945866,0.2065730632,0.2059522305,0.2053320901,0.2047126435,0.2040938920,0.2034758371,0.2028584803,0.2022418231,0.2016258669,0.2010106131,0.2003960632,0.1997822186,0.1991690809,0.1985566513,0.1979449315,0.1973339227,0.1967236265,0.1961140443,0.1955051775,0.1948970276,0.1942895960,0.1936828840,0.1930768932,0.1924716250,0.1918670808,0.1912632620,0.1906601701,0.1900578064,0.1894561724,0.1888552695,0.1882550991,0.1876556626,0.1870569615,0.1864589971,0.1858617708,0.1852652841,0.1846695384,0.1840745351,0.1834802755,0.1828867610,0.1822939932,0.1817019733,0.1811107027,0.1805201829,0.1799304152,0.1793414011,0.1787531419,0.1781656389,0.1775788936,0.1769929074,0.1764076816,0.1758232177,0.1752395169,0.1746565807,0.1740744105,0.1734930075,0.1729123732,0.1723325090,0.1717534162,0.1711750961,0.1705975502,0.1700207798,0.1694447862,0.1688695709,0.1682951351,0.1677214802,0.1671486076,0.1665765186,0.1660052146,0.1654346968,0.1648649667,0.1642960256,0.1637278749,0.1631605158,0.1625939497,0.1620281779,0.1614632018,0.1608990227,0.1603356420,0.1597730609,0.1592112807,0.1586503029,0.1580901287,0.1575307594,0.1569721964,0.1564144410,0.1558574944,0.1553013581,0.1547460332,0.1541915212,0.1536378232,0.1530849407,0.1525328750,0.1519816272,0.1514311988,0.1508815910,0.1503328050,0.1497848423,0.1492377041,0.1486913917,0.1481459063,0.1476012493,0.1470574219,0.1465144255,0.1459722612,0.1454309304,0.1448904343,0.1443507743,0.1438119515,0.1432739673,0.1427368229,0.1422005196,0.1416650587,0.1411304413,0.1405966689,0.1400637425,0.1395316635,0.1390004332,0.1384700527,0.1379405234,0.1374118464,0.1368840231,0.1363570546,0.1358309423,0.1353056872,0.1347812908,0.1342577542,0.1337350786,0.1332132653,0.1326923155,0.1321722304,0.1316530113,0.1311346594,0.1306171759,0.1301005620,0.1295848189,0.1290699479,0.1285559501,0.1280428268,0.1275305792,0.1270192085,0.1265087158,0.1259991025,0.1254903696,0.1249825184,0.1244755502,0.1239694659,0.1234642670,0.1229599545,0.1224565297,0.1219539937,0.1214523477,0.1209515929,0.1204517304,0.1199527615,0.1194546874,0.1189575091,0.1184612279,0.1179658450,0.1174713614,0.1169777784,0.1164850972,0.1159933188,0.1155024445,0.1150124754,0.1145234126,0.1140352573,0.1135480107,0.1130616739,0.1125762481,0.1120917343,0.1116081338,0.1111254476,0.1106436770,0.1101628230,0.1096828867,0.1092038694,0.1087257721,0.1082485959,0.1077723421,0.1072970116,0.1068226056,0.1063491253,0.1058765717,0.1054049460,0.1049342493,0.1044644827,0.1039956472,0.1035277440,0.1030607743,0.1025947390,0.1021296393,0.1016654763,0.1012022511,0.1007399647,0.1002786183,0.0998182129,0.0993587497,0.0989002297,0.0984426539,0.0979860236,0.0975303396,0.0970756032,0.0966218154,0.0961689772,0.0957170897,0.0952661540,0.0948161712,0.0943671422,0.0939190682,0.0934719503,0.0930257894,0.0925805866,0.0921363430,0.0916930595,0.0912507374,0.0908093775,0.0903689810,0.0899295489,0.0894910821,0.0890535818,0.0886170490,0.0881814846,0.0877468898,0.0873132655,0.0868806128,0.0864489327,0.0860182262,0.0855884943,0.0851597380,0.0847319584,0.0843051564,0.0838793330,0.0834544893,0.0830306263,0.0826077449,0.0821858461,0.0817649310,0.0813450005,0.0809260556,0.0805080974,0.0800911267,0.0796751446,0.0792601520,0.0788461499,0.0784331394,0.0780211213,0.0776100967,0.0772000665,0.0767910316,0.0763829931,0.0759759519,0.0755699090,0.0751648652,0.0747608217,0.0743577792,0.0739557388,0.0735547014,0.0731546680,0.0727556395,0.0723576168,0.0719606009,0.0715645927,0.0711695932,0.0707756032,0.0703826237,0.0699906557,0.0695997000,0.0692097575,0.0688208293,0.0684329161,0.0680460190,0.0676601388,0.0672752764,0.0668914328,0.0665086088,0.0661268053,0.0657460233,0.0653662637,0.0649875272,0.0646098149,0.0642331276,0.0638574663,0.0634828317,0.0631092247,0.0627366464,0.0623650974,0.0619945788,0.0616250913,0.0612566358,0.0608892133,0.0605228246,0.0601574704,0.0597931518,0.0594298696,0.0590676245,0.0587064175,0.0583462495,0.0579871211,0.0576290334,0.0572719872,0.0569159832,0.0565610224,0.0562071055,0.0558542334,0.0555024070,0.0551516270,0.0548018943,0.0544532097,0.0541055740,0.0537589881,0.0534134527,0.0530689687,0.0527255369,0.0523831581,0.0520418331,0.0517015627,0.0513623477,0.0510241889,0.0506870871,0.0503510430,0.0500160576,0.0496821316,0.0493492657,0.0490174607,0.0486867175,0.0483570368,0.0480284193,0.0477008659,0.0473743774,0.0470489544,0.0467245978,0.0464013083,0.0460790866,0.0457579337,0.0454378501,0.0451188367,0.0448008942,0.0444840233,0.0441682248,0.0438534995,0.0435398480,0.0432272712,0.0429157697,0.0426053443,0.0422959957,0.0419877247,0.0416805320,0.0413744182,0.0410693842,0.0407654306,0.0404625581,0.0401607675,0.0398600595,0.0395604348,0.0392618941,0.0389644380,0.0386680674,0.0383727828,0.0380785850,0.0377854747,0.0374934526,0.0372025193,0.0369126755,0.0366239220,0.0363362594,0.0360496883,0.0357642095,0.0354798237,0.0351965314,0.0349143334,0.0346332303,0.0343532228,0.0340743115,0.0337964972,0.0335197804,0.0332441618,0.0329696421,0.0326962219,0.0324239018,0.0321526825,0.0318825647,0.0316135489,0.0313456358,0.0310788260,0.0308131202,0.0305485190,0.0302850230,0.0300226328,0.0297613490,0.0295011723,0.0292421033,0.0289841425,0.0287272907,0.0284715483,0.0282169160,0.0279633944,0.0277109842,0.0274596857,0.0272094998,0.0269604270,0.0267124677,0.0264656228,0.0262198926,0.0259752778,0.0257317790,0.0254893968,0.0252481316,0.0250079842,0.0247689550,0.0245310446,0.0242942535,0.0240585824,0.0238240318,0.0235906023,0.0233582943,0.0231271084,0.0228970452,0.0226681052,0.0224402890,0.0222135971,0.0219880300,0.0217635883,0.0215402724,0.0213180830,0.0210970205,0.0208770854,0.0206582784,0.0204405998,0.0202240502,0.0200086301,0.0197943401,0.0195811805,0.0193691520,0.0191582550,0.0189484901,0.0187398576,0.0185323582,0.0183259922,0.0181207602,0.0179166627,0.0177137002,0.0175118730,0.0173111818,0.0171116269,0.0169132088,0.0167159281,0.0165197851,0.0163247804,0.0161309143,0.0159381874,0.0157466001,0.0155561529,0.0153668461,0.0151786803,0.0149916559,0.0148057733,0.0146210330,0.0144374353,0.0142549809,0.0140736699,0.0138935030,0.0137144805,0.0135366028,0.0133598704,0.0131842836,0.0130098429,0.0128365487,0.0126644015,0.0124934015,0.0123235492,0.0121548451,0.0119872894,0.0118208827,0.0116556253,0.0114915175,0.0113285598,0.0111667526,0.0110060962,0.0108465910,0.0106882374,0.0105310357,0.0103749864,0.0102200898,0.0100663462,0.0099137561,0.0097623197,0.0096120375,0.0094629098,0.0093149369,0.0091681193,0.0090224571,0.0088779509,0.0087346008,0.0085924073,0.0084513708,0.0083114914,0.0081727696,0.0080352057,0.0078988000,0.0077635528,0.0076294645,0.0074965353,0.0073647656,0.0072341557,0.0071047059,0.0069764164,0.0068492877,0.0067233200,0.0065985135,0.0064748687,0.0063523857,0.0062310649,0.0061109066,0.0059919110,0.0058740784,0.0057574091,0.0056419033,0.0055275614,0.0054143837,0.0053023703,0.0051915215,0.0050818376,0.0049733189,0.0048659656,0.0047597780,0.0046547563,0.0045509008,0.0044482116,0.0043466891,0.0042463336,0.0041471451,0.0040491240,0.0039522705,0.0038565848,0.0037620671,0.0036687177,0.0035765368,0.0034855246,0.0033956813,0.0033070072,0.0032195024,0.0031331671,0.0030480016,0.0029640060,0.0028811806,0.0027995255,0.0027190409,0.0026397271,0.0025615842,0.0024846123,0.0024088118,0.0023341826,0.0022607252,0.0021884395,0.0021173258,0.0020473842,0.0019786149,0.0019110181,0.0018445939,0.0017793425,0.0017152641,0.0016523587,0.0015906265,0.0015300677,0.0014706825,0.0014124709,0.0013554331,0.0012995693,0.0012448795,0.0011913638,0.0011390226,0.0010878557,0.0010378634,0.0009890458,0.0009414030,0.0008949351,0.0008496422,0.0008055245,0.0007625819,0.0007208147,0.0006802229,0.0006408067,0.0006025660,0.0005655011,0.0005296119,0.0004948987,0.0004613613,0.0004290001,0.0003978149,0.0003678059,0.0003389732,0.0003113168,0.0002848368,0.0002595332,0.0002354062,0.0002124557,0.0001906818,0.0001700847,0.0001506642,0.0001324205,0.0001153536,0.0000994636,0.0000847505,0.0000712143,0.0000588550,0.0000476727,0.0000376675,0.0000288392,0.0000211881,0.0000147140,0.0000094170,0.0000052970,0.0000023542,0.0000005886,0.0000000000 };
static const double LPWIN_PLUCKOUT[4096] = {
    0.0,0.01,0.1,0.3,0.5,0.6,0.7,0.9944,0.9927,0.9908,0.9887,0.9863,0.9837,0.9809,0.9779,0.9747,0.9712,0.9676,0.9637,0.9596,0.9554,0.9509,0.9462,0.9413,0.9363,0.9310,0.9256,0.9200,0.9141,0.9082,0.9020,0.8957,0.8891,0.8825,0.8756,0.8687,0.8615,0.8542,0.8468,0.8392,0.8315,0.8236,0.8156,0.8075,0.7993,0.7910,0.7825,0.7739,0.7653,0.7565,0.7476,0.7387,0.7296,0.7205,0.7113,0.7021,0.6927,0.6833,0.6739,0.6644,0.6548,0.6452,0.6356,0.6259,0.6162,0.6065,0.5967,0.5870,0.5772,0.5674,0.5576,0.5479,0.5381,0.5283,0.5186,0.5089,0.4992,0.4895,0.4798,0.4702,0.4607,0.4511,0.4417,0.4322,0.4229,0.4136,0.4043,0.3951,0.3860,0.3770,0.3680,0.3591,0.3503,0.3416,0.3330,0.3244,0.3160,0.3077,0.2994,0.2912,0.2832,0.2753,0.2674,0.2597,0.2521,0.2492,0.2490,0.2488,0.2486,0.2484,0.2482,0.2480,0.2478,0.2476,0.2474,0.2472,0.2470,0.2468,0.2465,0.2463,0.2461,0.2459,0.2457,0.2455,0.2453,0.2451,0.2449,0.2447,0.2445,0.2443,0.2441,0.2439,0.2437,0.2435,0.2433,0.2431,0.2429,0.2427,0.2425,0.2423,0.2421,0.2419,0.2417,0.2415,0.2413,0.2411,0.2409,0.2407,0.2404,0.2402,0.2400,0.2398,0.2396,0.2394,0.2392,0.2390,0.2388,0.2386,0.2384,0.2382,0.2380,0.2378,0.2376,0.2374,0.2372,0.2370,0.2368,0.2366,0.2364,0.2362,0.2360,0.2358,0.2356,0.2354,0.2352,0.2350,0.2348,0.2346,0.2344,0.2342,0.2340,0.2338,0.2336,0.2334,0.2332,0.2330,0.2328,0.2326,0.2323,0.2321,0.2319,0.2317,0.2315,0.2313,0.2311,0.2309,0.2307,0.2305,0.2303,0.2301,0.2299,0.2297,0.2295,0.2293,0.2291,0.2289,0.2287,0.2285,0.2283,0.2281,0.2279,0.2277,0.2275,0.2273,0.2271,0.2269,0.2267,0.2265,0.2263,0.2261,0.2259,0.2257,0.2255,0.2253,0.2251,0.2249,0.2247,0.2245,0.2243,0.2241,0.2239,0.2237,0.2235,0.2233,0.2231,0.2229,0.2227,0.2225,0.2223,0.2221,0.2219,0.2217,0.2215,0.2213,0.2211,0.2209,0.2207,0.2205,0.2203,0.2201,0.2199,0.2197,0.2195,0.2193,0.2191,0.2189,0.2187,0.2185,0.2183,0.2181,0.2179,0.2177,0.2175,0.2173,0.2171,0.2169,0.2167,0.2165,0.2163,0.2161,0.2159,0.2157,0.2155,0.2153,0.2151,0.2149,0.2147,0.2145,0.2143,0.2141,0.2139,0.2137,0.2135,0.2133,0.2131,0.2129,0.2127,0.2126,0.2124,0.2122,0.2120,0.2118,0.2116,0.2114,0.2112,0.2110,0.2108,0.2106,0.2104,0.2102,0.2100,0.2098,0.2096,0.2094,0.2092,0.2090,0.2088,0.2086,0.2084,0.2082,0.2080,0.2078,0.2076,0.2074,0.2072,0.2070,0.2068,0.2066,0.2064,0.2062,0.2061,0.2059,0.2057,0.2055,0.2053,0.2051,0.2049,0.2047,0.2045,0.2043,0.2041,0.2039,0.2037,0.2035,0.2033,0.2031,0.2029,0.2027,0.2025,0.2023,0.2021,0.2019,0.2018,0.2016,0.2014,0.2012,0.2010,0.2008,0.2006,0.2004,0.2002,0.2000,0.1998,0.1996,0.1994,0.1992,0.1990,0.1988,0.1986,0.1984,0.1983,0.1981,0.1979,0.1977,0.1975,0.1973,0.1971,0.1969,0.1967,0.1965,0.1963,0.1961,0.1959,0.1957,0.1955,0.1954,0.1952,0.1950,0.1948,0.1946,0.1944,0.1942,0.1940,0.1938,0.1936,0.1934,0.1932,0.1930,0.1929,0.1927,0.1925,0.1923,0.1921,0.1919,0.1917,0.1915,0.1913,0.1911,0.1909,0.1907,0.1906,0.1904,0.1902,0.1900,0.1898,0.1896,0.1894,0.1892,0.1890,0.1888,0.1886,0.1885,0.1883,0.1881,0.1879,0.1877,0.1875,0.1873,0.1871,0.1869,0.1867,0.1866,0.1864,0.1862,0.1860,0.1858,0.1856,0.1854,0.1852,0.1850,0.1849,0.1847,0.1845,0.1843,0.1841,0.1839,0.1837,0.1835,0.1833,0.1832,0.1830,0.1828,0.1826,0.1824,0.1822,0.1820,0.1818,0.1817,0.1815,0.1813,0.1811,0.1809,0.1807,0.1805,0.1803,0.1802,0.1800,0.1798,0.1796,0.1794,0.1792,0.1790,0.1788,0.1787,0.1785,0.1783,0.1781,0.1779,0.1777,0.1775,0.1774,0.1772,0.1770,0.1768,0.1766,0.1764,0.1762,0.1760,0.1759,0.1757,0.1755,0.1753,0.1751,0.1749,0.1748,0.1746,0.1744,0.1742,0.1740,0.1738,0.1736,0.1735,0.1733,0.1731,0.1729,0.1727,0.1725,0.1724,0.1722,0.1720,0.1718,0.1716,0.1714,0.1713,0.1711,0.1709,0.1707,0.1705,0.1703,0.1702,0.1700,0.1698,0.1696,0.1694,0.1692,0.1691,0.1689,0.1687,0.1685,0.1683,0.1681,0.1680,0.1678,0.1676,0.1674,0.1672,0.1671,0.1669,0.1667,0.1665,0.1663,0.1661,0.1660,0.1658,0.1656,0.1654,0.1652,0.1651,0.1649,0.1647,0.1645,0.1643,0.1642,0.1640,0.1638,0.1636,0.1634,0.1633,0.1631,0.1629,0.1627,0.1625,0.1624,0.1622,0.1620,0.1618,0.1616,0.1615,0.1613,0.1611,0.1609,0.1608,0.1606,0.1604,0.1602,0.1600,0.1599,0.1597,0.1595,0.1593,0.1592,0.1590,0.1588,0.1586,0.1584,0.1583,0.1581,0.1579,0.1577,0.1576,0.1574,0.1572,0.1570,0.1568,0.1567,0.1565,0.1563,0.1561,0.1560,0.1558,0.1556,0.1554,0.1553,0.1551,0.1549,0.1547,0.1546,0.1544,0.1542,0.1540,0.1539,0.1537,0.1535,0.1533,0.1532,0.1530,0.1528,0.1526,0.1525,0.1523,0.1521,0.1519,0.1518,0.1516,0.1514,0.1512,0.1511,0.1509,0.1507,0.1506,0.1504,0.1502,0.1500,0.1499,0.1497,0.1495,0.1493,0.1492,0.1490,0.1488,0.1487,0.1485,0.1483,0.1481,0.1480,0.1478,0.1476,0.1474,0.1473,0.1471,0.1469,0.1468,0.1466,0.1464,0.1462,0.1461,0.1459,0.1457,0.1456,0.1454,0.1452,0.1451,0.1449,0.1447,0.1445,0.1444,0.1442,0.1440,0.1439,0.1437,0.1435,0.1434,0.1432,0.1430,0.1429,0.1427,0.1425,0.1423,0.1422,0.1420,0.1418,0.1417,0.1415,0.1413,0.1412,0.1410,0.1408,0.1407,0.1405,0.1403,0.1402,0.1400,0.1398,0.1397,0.1395,0.1393,0.1392,0.1390,0.1388,0.1387,0.1385,0.1383,0.1382,0.1380,0.1378,0.1377,0.1375,0.1373,0.1372,0.1370,0.1368,0.1367,0.1365,0.1363,0.1362,0.1360,0.1358,0.1357,0.1355,0.1354,0.1352,0.1350,0.1349,0.1347,0.1345,0.1344,0.1342,0.1340,0.1339,0.1337,0.1335,0.1334,0.1332,0.1331,0.1329,0.1327,0.1326,0.1324,0.1322,0.1321,0.1319,0.1318,0.1316,0.1314,0.1313,0.1311,0.1310,0.1308,0.1306,0.1305,0.1303,0.1301,0.1300,0.1298,0.1297,0.1295,0.1293,0.1292,0.1290,0.1289,0.1287,0.1285,0.1284,0.1282,0.1281,0.1279,0.1277,0.1276,0.1274,0.1273,0.1271,0.1269,0.1268,0.1266,0.1265,0.1263,0.1261,0.1260,0.1258,0.1257,0.1255,0.1254,0.1252,0.1250,0.1249,0.1247,0.1246,0.1244,0.1243,0.1241,0.1239,0.1238,0.1236,0.1235,0.1233,0.1232,0.1230,0.1228,0.1227,0.1225,0.1224,0.1222,0.1221,0.1219,0.1218,0.1216,0.1214,0.1213,0.1211,0.1210,0.1208,0.1207,0.1205,0.1204,0.1202,0.1200,0.1199,0.1197,0.1196,0.1194,0.1193,0.1191,0.1190,0.1188,0.1187,0.1185,0.1184,0.1182,0.1181,0.1179,0.1177,0.1176,0.1174,0.1173,0.1171,0.1170,0.1168,0.1167,0.1165,0.1164,0.1162,0.1161,0.1159,0.1158,0.1156,0.1155,0.1153,0.1152,0.1150,0.1149,0.1147,0.1146,0.1144,0.1143,0.1141,0.1140,0.1138,0.1137,0.1135,0.1134,0.1132,0.1131,0.1129,0.1128,0.1126,0.1125,0.1123,0.1122,0.1120,0.1119,0.1117,0.1116,0.1114,0.1113,0.1111,0.1110,0.1108,0.1107,0.1105,0.1104,0.1103,0.1101,0.1100,0.1098,0.1097,0.1095,0.1094,0.1092,0.1091,0.1089,0.1088,0.1086,0.1085,0.1083,0.1082,0.1081,0.1079,0.1078,0.1076,0.1075,0.1073,0.1072,0.1070,0.1069,0.1068,0.1066,0.1065,0.1063,0.1062,0.1060,0.1059,0.1057,0.1056,0.1055,0.1053,0.1052,0.1050,0.1049,0.1047,0.1046,0.1045,0.1043,0.1042,0.1040,0.1039,0.1037,0.1036,0.1035,0.1033,0.1032,0.1030,0.1029,0.1028,0.1026,0.1025,0.1023,0.1022,0.1020,0.1019,0.1018,0.1016,0.1015,0.1013,0.1012,0.1011,0.1009,0.1008,0.1006,0.1005,0.1004,0.1002,0.1001,0.0999,0.0998,0.0997,0.0995,0.0994,0.0993,0.0991,0.0990,0.0988,0.0987,0.0986,0.0984,0.0983,0.0982,0.0980,0.0979,0.0977,0.0976,0.0975,0.0973,0.0972,0.0971,0.0969,0.0968,0.0966,0.0965,0.0964,0.0962,0.0961,0.0960,0.0958,0.0957,0.0956,0.0954,0.0953,0.0952,0.0950,0.0949,0.0947,0.0946,0.0945,0.0943,0.0942,0.0941,0.0939,0.0938,0.0937,0.0935,0.0934,0.0933,0.0931,0.0930,0.0929,0.0927,0.0926,0.0925,0.0923,0.0922,0.0921,0.0919,0.0918,0.0917,0.0916,0.0914,0.0913,0.0912,0.0910,0.0909,0.0908,0.0906,0.0905,0.0904,0.0902,0.0901,0.0900,0.0898,0.0897,0.0896,0.0895,0.0893,0.0892,0.0891,0.0889,0.0888,0.0887,0.0885,0.0884,0.0883,0.0882,0.0880,0.0879,0.0878,0.0876,0.0875,0.0874,0.0873,0.0871,0.0870,0.0869,0.0867,0.0866,0.0865,0.0864,0.0862,0.0861,0.0860,0.0859,0.0857,0.0856,0.0855,0.0854,0.0852,0.0851,0.0850,0.0848,0.0847,0.0846,0.0845,0.0843,0.0842,0.0841,0.0840,0.0838,0.0837,0.0836,0.0835,0.0833,0.0832,0.0831,0.0830,0.0828,0.0827,0.0826,0.0825,0.0824,0.0822,0.0821,0.0820,0.0819,0.0817,0.0816,0.0815,0.0814,0.0812,0.0811,0.0810,0.0809,0.0808,0.0806,0.0805,0.0804,0.0803,0.0801,0.0800,0.0799,0.0798,0.0797,0.0795,0.0794,0.0793,0.0792,0.0791,0.0789,0.0788,0.0787,0.0786,0.0785,0.0783,0.0782,0.0781,0.0780,0.0779,0.0777,0.0776,0.0775,0.0774,0.0773,0.0771,0.0770,0.0769,0.0768,0.0767,0.0766,0.0764,0.0763,0.0762,0.0761,0.0760,0.0758,0.0757,0.0756,0.0755,0.0754,0.0753,0.0751,0.0750,0.0749,0.0748,0.0747,0.0746,0.0744,0.0743,0.0742,0.0741,0.0740,0.0739,0.0738,0.0736,0.0735,0.0734,0.0733,0.0732,0.0731,0.0730,0.0728,0.0727,0.0726,0.0725,0.0724,0.0723,0.0722,0.0720,0.0719,0.0718,0.0717,0.0716,0.0715,0.0714,0.0712,0.0711,0.0710,0.0709,0.0708,0.0707,0.0706,0.0705,0.0704,0.0702,0.0701,0.0700,0.0699,0.0698,0.0697,0.0696,0.0695,0.0693,0.0692,0.0691,0.0690,0.0689,0.0688,0.0687,0.0686,0.0685,0.0684,0.0682,0.0681,0.0680,0.0679,0.0678,0.0677,0.0676,0.0675,0.0674,0.0673,0.0672,0.0670,0.0669,0.0668,0.0667,0.0666,0.0665,0.0664,0.0663,0.0662,0.0661,0.0660,0.0659,0.0658,0.0656,0.0655,0.0654,0.0653,0.0652,0.0651,0.0650,0.0649,0.0648,0.0647,0.0646,0.0645,0.0644,0.0643,0.0642,0.0641,0.0640,0.0639,0.0637,0.0636,0.0635,0.0634,0.0633,0.0632,0.0631,0.0630,0.0629,0.0628,0.0627,0.0626,0.0625,0.0624,0.0623,0.0622,0.0621,0.0620,0.0619,0.0618,0.0617,0.0616,0.0615,0.0614,0.0613,0.0612,0.0611,0.0610,0.0609,0.0608,0.0607,0.0606,0.0604,0.0603,0.0602,0.0601,0.0600,0.0599,0.0598,0.0597,0.0596,0.0595,0.0594,0.0593,0.0592,0.0591,0.0590,0.0589,0.0588,0.0587,0.0586,0.0585,0.0584,0.0584,0.0583,0.0582,0.0581,0.0580,0.0579,0.0578,0.0577,0.0576,0.0575,0.0574,0.0573,0.0572,0.0571,0.0570,0.0569,0.0568,0.0567,0.0566,0.0565,0.0564,0.0563,0.0562,0.0561,0.0560,0.0559,0.0558,0.0557,0.0556,0.0555,0.0554,0.0553,0.0552,0.0552,0.0551,0.0550,0.0549,0.0548,0.0547,0.0546,0.0545,0.0544,0.0543,0.0542,0.0541,0.0540,0.0539,0.0538,0.0537,0.0536,0.0535,0.0535,0.0534,0.0533,0.0532,0.0531,0.0530,0.0529,0.0528,0.0527,0.0526,0.0525,0.0524,0.0523,0.0523,0.0522,0.0521,0.0520,0.0519,0.0518,0.0517,0.0516,0.0515,0.0514,0.0513,0.0513,0.0512,0.0511,0.0510,0.0509,0.0508,0.0507,0.0506,0.0505,0.0504,0.0504,0.0503,0.0502,0.0501,0.0500,0.0499,0.0498,0.0497,0.0496,0.0496,0.0495,0.0494,0.0493,0.0492,0.0491,0.0490,0.0489,0.0489,0.0488,0.0487,0.0486,0.0485,0.0484,0.0483,0.0482,0.0482,0.0481,0.0480,0.0479,0.0478,0.0477,0.0476,0.0475,0.0475,0.0474,0.0473,0.0472,0.0471,0.0470,0.0469,0.0469,0.0468,0.0467,0.0466,0.0465,0.0464,0.0464,0.0463,0.0462,0.0461,0.0460,0.0459,0.0459,0.0458,0.0457,0.0456,0.0455,0.0454,0.0454,0.0453,0.0452,0.0451,0.0450,0.0449,0.0449,0.0448,0.0447,0.0446,0.0445,0.0444,0.0444,0.0443,0.0442,0.0441,0.0440,0.0440,0.0439,0.0438,0.0437,0.0436,0.0435,0.0435,0.0434,0.0433,0.0432,0.0431,0.0431,0.0430,0.0429,0.0428,0.0427,0.0427,0.0426,0.0425,0.0424,0.0423,0.0423,0.0422,0.0421,0.0420,0.0420,0.0419,0.0418,0.0417,0.0416,0.0416,0.0415,0.0414,0.0413,0.0412,0.0412,0.0411,0.0410,0.0409,0.0409,0.0408,0.0407,0.0406,0.0405,0.0405,0.0404,0.0403,0.0402,0.0402,0.0401,0.0400,0.0399,0.0399,0.0398,0.0397,0.0396,0.0396,0.0395,0.0394,0.0393,0.0393,0.0392,0.0391,0.0390,0.0390,0.0389,0.0388,0.0387,0.0387,0.0386,0.0385,0.0384,0.0384,0.0383,0.0382,0.0381,0.0381,0.0380,0.0379,0.0378,0.0378,0.0377,0.0376,0.0376,0.0375,0.0374,0.0373,0.0373,0.0372,0.0371,0.0370,0.0370,0.0369,0.0368,0.0368,0.0367,0.0366,0.0365,0.0365,0.0364,0.0363,0.0363,0.0362,0.0361,0.0360,0.0360,0.0359,0.0358,0.0358,0.0357,0.0356,0.0356,0.0355,0.0354,0.0353,0.0353,0.0352,0.0351,0.0351,0.0350,0.0349,0.0349,0.0348,0.0347,0.0347,0.0346,0.0345,0.0344,0.0344,0.0343,0.0342,0.0342,0.0341,0.0340,0.0340,0.0339,0.0338,0.0338,0.0337,0.0336,0.0336,0.0335,0.0334,0.0334,0.0333,0.0332,0.0332,0.0331,0.0330,0.0330,0.0329,0.0328,0.0328,0.0327,0.0326,0.0326,0.0325,0.0324,0.0324,0.0323,0.0322,0.0322,0.0321,0.0320,0.0320,0.0319,0.0319,0.0318,0.0317,0.0317,0.0316,0.0315,0.0315,0.0314,0.0313,0.0313,0.0312,0.0311,0.0311,0.0310,0.0310,0.0309,0.0308,0.0308,0.0307,0.0306,0.0306,0.0305,0.0304,0.0304,0.0303,0.0303,0.0302,0.0301,0.0301,0.0300,0.0300,0.0299,0.0298,0.0298,0.0297,0.0296,0.0296,0.0295,0.0295,0.0294,0.0293,0.0293,0.0292,0.0292,0.0291,0.0290,0.0290,0.0289,0.0289,0.0288,0.0287,0.0287,0.0286,0.0286,0.0285,0.0284,0.0284,0.0283,0.0283,0.0282,0.0281,0.0281,0.0280,0.0280,0.0279,0.0278,0.0278,0.0277,0.0277,0.0276,0.0275,0.0275,0.0274,0.0274,0.0273,0.0273,0.0272,0.0271,0.0271,0.0270,0.0270,0.0269,0.0269,0.0268,0.0267,0.0267,0.0266,0.0266,0.0265,0.0265,0.0264,0.0263,0.0263,0.0262,0.0262,0.0261,0.0261,0.0260,0.0260,0.0259,0.0258,0.0258,0.0257,0.0257,0.0256,0.0256,0.0255,0.0255,0.0254,0.0253,0.0253,0.0252,0.0252,0.0251,0.0251,0.0250,0.0250,0.0249,0.0249,0.0248,0.0247,0.0247,0.0246,0.0246,0.0245,0.0245,0.0244,0.0244,0.0243,0.0243,0.0242,0.0242,0.0241,0.0241,0.0240,0.0239,0.0239,0.0238,0.0238,0.0237,0.0237,0.0236,0.0236,0.0235,0.0235,0.0234,0.0234,0.0233,0.0233,0.0232,0.0232,0.0231,0.0231,0.0230,0.0230,0.0229,0.0229,0.0228,0.0228,0.0227,0.0227,0.0226,0.0226,0.0225,0.0225,0.0224,0.0224,0.0223,0.0223,0.0222,0.0222,0.0221,0.0221,0.0220,0.0220,0.0219,0.0219,0.0218,0.0218,0.0217,0.0217,0.0216,0.0216,0.0215,0.0215,0.0214,0.0214,0.0213,0.0213,0.0212,0.0212,0.0211,0.0211,0.0210,0.0210,0.0209,0.0209,0.0208,0.0208,0.0208,0.0207,0.0207,0.0206,0.0206,0.0205,0.0205,0.0204,0.0204,0.0203,0.0203,0.0202,0.0202,0.0201,0.0201,0.0201,0.0200,0.0200,0.0199,0.0199,0.0198,0.0198,0.0197,0.0197,0.0196,0.0196,0.0196,0.0195,0.0195,0.0194,0.0194,0.0193,0.0193,0.0192,0.0192,0.0191,0.0191,0.0191,0.0190,0.0190,0.0189,0.0189,0.0188,0.0188,0.0188,0.0187,0.0187,0.0186,0.0186,0.0185,0.0185,0.0184,0.0184,0.0184,0.0183,0.0183,0.0182,0.0182,0.0181,0.0181,0.0181,0.0180,0.0180,0.0179,0.0179,0.0178,0.0178,0.0178,0.0177,0.0177,0.0176,0.0176,0.0176,0.0175,0.0175,0.0174,0.0174,0.0173,0.0173,0.0173,0.0172,0.0172,0.0171,0.0171,0.0171,0.0170,0.0170,0.0169,0.0169,0.0169,0.0168,0.0168,0.0167,0.0167,0.0167,0.0166,0.0166,0.0165,0.0165,0.0165,0.0164,0.0164,0.0163,0.0163,0.0163,0.0162,0.0162,0.0161,0.0161,0.0161,0.0160,0.0160,0.0159,0.0159,0.0159,0.0158,0.0158,0.0158,0.0157,0.0157,0.0156,0.0156,0.0156,0.0155,0.0155,0.0154,0.0154,0.0154,0.0153,0.0153,0.0153,0.0152,0.0152,0.0151,0.0151,0.0151,0.0150,0.0150,0.0150,0.0149,0.0149,0.0149,0.0148,0.0148,0.0147,0.0147,0.0147,0.0146,0.0146,0.0146,0.0145,0.0145,0.0145,0.0144,0.0144,0.0143,0.0143,0.0143,0.0142,0.0142,0.0142,0.0141,0.0141,0.0141,0.0140,0.0140,0.0140,0.0139,0.0139,0.0138,0.0138,0.0138,0.0137,0.0137,0.0137,0.0136,0.0136,0.0136,0.0135,0.0135,0.0135,0.0134,0.0134,0.0134,0.0133,0.0133,0.0133,0.0132,0.0132,0.0132,0.0131,0.0131,0.0131,0.0130,0.0130,0.0130,0.0129,0.0129,0.0129,0.0128,0.0128,0.0128,0.0127,0.0127,0.0127,0.0126,0.0126,0.0126,0.0125,0.0125,0.0125,0.0124,0.0124,0.0124,0.0123,0.0123,0.0123,0.0123,0.0122,0.0122,0.0122,0.0121,0.0121,0.0121,0.0120,0.0120,0.0120,0.0119,0.0119,0.0119,0.0118,0.0118,0.0118,0.0118,0.0117,0.0117,0.0117,0.0116,0.0116,0.0116,0.0115,0.0115,0.0115,0.0114,0.0114,0.0114,0.0114,0.0113,0.0113,0.0113,0.0112,0.0112,0.0112,0.0111,0.0111,0.0111,0.0111,0.0110,0.0110,0.0110,0.0109,0.0109,0.0109,0.0109,0.0108,0.0108,0.0108,0.0107,0.0107,0.0107,0.0107,0.0106,0.0106,0.0106,0.0105,0.0105,0.0105,0.0105,0.0104,0.0104,0.0104,0.0103,0.0103,0.0103,0.0103,0.0102,0.0102,0.0102,0.0102,0.0101,0.0101,0.0101,0.0100,0.0100,0.0100,0.0100,0.0099,0.0099,0.0099,0.0099,0.0098,0.0098,0.0098,0.0097,0.0097,0.0097,0.0097,0.0096,0.0096,0.0096,0.0096,0.0095,0.0095,0.0095,0.0095,0.0094,0.0094,0.0094,0.0094,0.0093,0.0093,0.0093,0.0092,0.0092,0.0092,0.0092,0.0091,0.0091,0.0091,0.0091,0.0090,0.0090,0.0090,0.0090,0.0089,0.0089,0.0089,0.0089,0.0088,0.0088,0.0088,0.0088,0.0087,0.0087,0.0087,0.0087,0.0087,0.0086,0.0086,0.0086,0.0086,0.0085,0.0085,0.0085,0.0085,0.0084,0.0084,0.0084,0.0084,0.0083,0.0083,0.0083,0.0083,0.0082,0.0082,0.0082,0.0082,0.0082,0.0081,0.0081,0.0081,0.0081,0.0080,0.0080,0.0080,0.0080,0.0079,0.0079,0.0079,0.0079,0.0079,0.0078,0.0078,0.0078,0.0078,0.0077,0.0077,0.0077,0.0077,0.0077,0.0076,0.0076,0.0076,0.0076,0.0075,0.0075,0.0075,0.0075,0.0075,0.0074,0.0074,0.0074,0.0074,0.0074,0.0073,0.0073,0.0073,0.0073,0.0072,0.0072,0.0072,0.0072,0.0072,0.0071,0.0071,0.0071,0.0071,0.0071,0.0070,0.0070,0.0070,0.0070,0.0070,0.0069,0.0069,0.0069,0.0069,0.0069,0.0068,0.0068,0.0068,0.0068,0.0068,0.0067,0.0067,0.0067,0.0067,0.0067,0.0066,0.0066,0.0066,0.0066,0.0066,0.0065,0.0065,0.0065,0.0065,0.0065,0.0064,0.0064,0.0064,0.0064,0.0064,0.0063,0.0063,0.0063,0.0063,0.0063,0.0062,0.0062,0.0062,0.0062,0.0062,0.0062,0.0061,0.0061,0.0061,0.0061,0.0061,0.0060,0.0060,0.0060,0.0060,0.0060,0.0060,0.0059,0.0059,0.0059,0.0059,0.0059,0.0058,0.0058,0.0058,0.0058,0.0058,0.0058,0.0057,0.0057,0.0057,0.0057,0.0057,0.0056,0.0056,0.0056,0.0056,0.0056,0.0056,0.0055,0.0055,0.0055,0.0055,0.0055,0.0055,0.0054,0.0054,0.0054,0.0054,0.0054,0.0054,0.0053,0.0053,0.0053,0.0053,0.0053,0.0053,0.0052,0.0052,0.0052,0.0052,0.0052,0.0052,0.0051,0.0051,0.0051,0.0051,0.0051,0.0051,0.0050,0.0050,0.0050,0.0050,0.0050,0.0050,0.0050,0.0049,0.0049,0.0049,0.0049,0.0049,0.0049,0.0048,0.0048,0.0048,0.0048,0.0048,0.0048,0.0048,0.0047,0.0047,0.0047,0.0047,0.0047,0.0047,0.0046,0.0046,0.0046,0.0046,0.0046,0.0046,0.0046,0.0045,0.0045,0.0045,0.0045,0.0045,0.0045,0.0045,0.0044,0.0044,0.0044,0.0044,0.0044,0.0044,0.0044,0.0043,0.0043,0.0043,0.0043,0.0043,0.0043,0.0043,0.0042,0.0042,0.0042,0.0042,0.0042,0.0042,0.0042,0.0041,0.0041,0.0041,0.0041,0.0041,0.0041,0.0041,0.0041,0.0040,0.0040,0.0040,0.0040,0.0040,0.0040,0.0040,0.0039,0.0039,0.0039,0.0039,0.0039,0.0039,0.0039,0.0039,0.0038,0.0038,0.0038,0.0038,0.0038,0.0038,0.0038,0.0038,0.0037,0.0037,0.0037,0.0037,0.0037,0.0037,0.0037,0.0037,0.0036,0.0036,0.0036,0.0036,0.0036,0.0036,0.0036,0.0036,0.0035,0.0035,0.0035,0.0035,0.0035,0.0035,0.0035,0.0035,0.0034,0.0034,0.0034,0.0034,0.0034,0.0034,0.0034,0.0034,0.0034,0.0033,0.0033,0.0033,0.0033,0.0033,0.0033,0.0033,0.0033,0.0033,0.0032,0.0032,0.0032,0.0032,0.0032,0.0032,0.0032,0.0032,0.0032,0.0031,0.0031,0.0031,0.0031,0.0031,0.0031,0.0031,0.0031,0.0031,0.0030,0.0030,0.0030,0.0030,0.0030,0.0030,0.0030,0.0030,0.0030,0.0030,0.0029,0.0029,0.0029,0.0029,0.0029,0.0029,0.0029,0.0029,0.0029,0.0028,0.0028,0.0028,0.0028,0.0028,0.0028,0.0028,0.0028,0.0028,0.0028,0.0027,0.0027,0.0027,0.0027,0.0027,0.0027,0.0027,0.0027,0.0027,0.0027,0.0027,0.0026,0.0026,0.0026,0.0026,0.0026,0.0026,0.0026,0.0026,0.0026,0.0026,0.0025,0.0025,0.0025,0.0025,0.0025,0.0025,0.0025,0.0025,0.0025,0.0025,0.0025,0.0024,0.0024,0.0024,0.0024,0.0024,0.0024,0.0024,0.0024,0.0024,0.0024,0.0024,0.0024,0.0023,0.0023,0.0023,0.0023,0.0023,0.0023,0.0023,0.0023,0.0023,0.0023,0.0023,0.0022,0.0022,0.0022,0.0022,0.0022,0.0022,0.0022,0.0022,0.0022,0.0022,0.0022,0.0022,0.0021,0.0021,0.0021,0.0021,0.0021,0.0021,0.0021,0.0021,0.0021,0.0021,0.0021,0.0021,0.0021,0.0020,0.0020,0.0020,0.0020,0.0020,0.0020,0.0020,0.0020,0.0020,0.0020,0.0020,0.0020,0.0020,0.0019,0.0019,0.0019,0.0019,0.0019,0.0019,0.0019,0.0019,0.0019,0.0019,0.0019,0.0019,0.0019,0.0019,0.0018,0.0018,0.0018,0.0018,0.0018,0.0018,0.0018,0.0018,0.0018,0.0018,0.0018,0.0018,0.0018,0.0018,0.0017,0.0017,0.0017,0.0017,0.0017,0.0017,0.0017,0.0017,0.0017,0.0017,0.0017,0.0017,0.0017,0.0017,0.0017,0.0016,0.0016,0.0016,0.0016,0.0016,0.0016,0.0016,0.0016,0.0016,0.0016,0.0016,0.0016,0.0016,0.0016,0.0016,0.0016,0.0015,0.0015,0.0015,0.0015,0.0015,0.0015,0.0015,0.0015,0.0015,0.0015,0.0015,0.0015,0.0015,0.0015,0.0015,0.0015,0.0014,0.0014,0.0014,0.0014,0.0014,0.0014,0.0014,0.0014,0.0014,0.0014,0.0014,0.0014,0.0014,0.0014,0.0014,0.0014,0.0014,0.0014,0.0013,0.0013,0.0013,0.0013,0.0013,0.0013,0.0013,0.0013,0.0013,0.0013,0.0013,0.0013,0.0013,0.0013,0.0013,0.0013,0.0013,0.0013,0.0012,0.0012,0.0012,0.0012,0.0012,0.0012,0.0012,0.0012,0.0012,0.0012,0.0012,0.0012,0.0012,0.0012,0.0012,0.0012,0.0012,0.0012,0.0012,0.0012,0.0011,0.0011,0.0011,0.0011,0.0011,0.0011,0.0011,0.0011,0.0011,0.0011,0.0011,0.0011,0.0011,0.0011,0.0011,0.0011,0.0011,0.0011,0.0011,0.0011,0.0011,0.0010,0.0010,0.0010,0.0010,0.0010,0.0010,0.0010,0.0010,0.0010,0.0010,0.0010,0.0010,0.0010,0.0010,0.0010,0.0010,0.0010,0.0010,0.0010,0.0010,0.0010,0.0010,0.0010,0.0009,0.0009,0.0009,0.0009,0.0009,0.0009,0.0009,0.0009,0.0009,0.0009,0.0009,0.0009,0.0009,0.0009,0.0009,0.0009,0.0009,0.0009,0.0009,0.0009,0.0009,0.0009,0.0009,0.0009,0.0009,0.0008,0.0008,0.0008,0.0008,0.0008,0.0008,0.0008,0.0008,0.0008,0.0008,0.0008,0.0008,0.0008,0.0008,0.0008,0.0008,0.0008,0.0008,0.0008,0.0008,0.0008,0.0008,0.0008,0.0008,0.0008,0.0008,0.0008,0.0008,0.0007,0.0007,0.0007,0.0007,0.0007,0.0007,0.0007,0.0007,0.0007,0.0007,0.0007,0.0007,0.0007,0.0007,0.0007,0.0007,0.0007,0.0007,0.0007,0.0007,0.0007,0.0007,0.0007,0.0007,0.0007,0.0007,0.0007,0.0007,0.0007,0.0007,0.0006,0.0006,0.0006,0.0006,0.0006,0.0006,0.0006,0.0006,0.0006,0.0006,0.0006,0.0006,0.0006,0.0006,0.0006,0.0006,0.0006,0.0006,0.0006,0.0006,0.0006,0.0006,0.0006,0.0006,0.0006,0.0006,0.0006,0.0006,0.0006,0.0006,0.0006,0.0006,0.0006,0.0006,0.0006,0.0005,0.0005,0.0005,0.0005,0.0005,0.0005,0.0005,0.0005,0.0005,0.0005,0.0005,0.0005,0.0005,0.0005,0.0005,0.0005,0.0005,0.0005,0.0005,0.0005,0.0005,0.0005,0.0005,0.0005,0.0005,0.0005,0.0005,0.0005,0.0005,0.0005,0.0005,0.0005,0.0005,0.0005,0.0005,0.0005,0.0005,0.0005,0.0005,0.0005,0.0004,0.0004,0.0004,0.0004,0.0004,0.0004,0.0004,0.0004,0.0004,0.0004,0.0004,0.0004,0.0004,0.0004,0.0004,0.0004,0.0004,0.0004,0.0004,0.0004,0.0004,0.0004,0.0004,0.0004,0.0004,0.0004,0.0004,0.0004,0.0004,0.0004,0.0004,0.0004,0.0004,0.0004,0.0004,0.0004,0.0004,0.0004,0.0004,0.0004,0.0004,0.0004,0.0004,0.0004,0.0004,0.0004,0.0004,0.0004,0.0004,0.0003,0.0003,0.0003,0.0003,0.0003,0.0003,0.0003,0.0003,0.0003,0.0003,0.0003,0.0003,0.0003,0.0003,0.0003,0.0003,0.0003,0.0003,0.0003,0.0003,0.0003,0.0003,0.0003,0.0003,0.0003,0.0003,0.0003,0.0003,0.0003,0.0003,0.0003,0.0003,0.0003,0.0003,0.0003,0.0003,0.0003,0.0003,0.0003,0.0003,0.0003,0.0003,0.0003,0.0003,0.0003,0.0003,0.0003,0.0003,0.0003,0.0003,0.0003,0.0003,0.0003,0.0003,0.0003,0.0003,0.0003,0.0003,0.0003,0.0003,0.0003,0.0002,0.0002,0.0002,0.0002,0.0002,0.0002,0.0002,0.0002,0.0002,0.0002,0.0002,0.0002,0.0002,0.0002,0.0002,0.0002,0.0002,0.0002,0.0002,0.0002,0.0002,0.0002,0.0002,0.0002,0.0002,0.0002,0.0002,0.0002,0.0002,0.0002,0.0002,0.0002,0.0002,0.0002,0.0002,0.0002,0.0002,0.0002,0.0002,0.0002,0.0002,0.0002,0.0002,0.0002,0.0002,0.0002,0.0002,0.0002,0.0002,0.0002,0.0002,0.0002,0.0002,0.0002,0.0002,0.0002,0.0002,0.0002,0.0002,0.0002,0.0002,0.0002,0.0002,0.0002,0.0002,0.0002,0.0002,0.0002,0.0002,0.0002,0.0002,0.0002,0.0002,0.0002,0.0002,0.0002,0.0002,0.0002,0.0002,0.0002,0.0002,0.0002,0.0002,0.0002,0.0002,0.0002,0.0002,0.0001,0.0001,0.0001,0.0001,0.0001,0.0001,0.0001,0.0001,0.0001,0.0001,0.0001,0.0001,0.0001,0.0001,0.0001,0.0001,0.0001,0.0001,0.0001,0.0001,0.0001,0.0001,0.0001,0.0001,0.0001,0.0001,0.0001,0.0001,0.0001,0.0001,0.0001,0.0001,0.0001,0.0001,0.0001,0.0001,0.0001,0.0001,0.0001,0.0001,0.0001,0.0001,0.0001,0.0001,0.0001,0.0001,0.0001,0.0001,0.0001,0.0001,0.0001,0.0001,0.0001,0.0001,0.0001,0.0001,0.0001,0.0001,0.0001,0.0001,0.0001,0.0001,0.0001,0.0001,0.0001,0.0001,0.0001,0.0001,0.0001,0.0001,0.0001,0.0001,0.0001,0.0001,0.0001,0.0001,0.0001,0.0001,0.0001,0.0001,0.0001,0.0001,0.0001,0.0001,0.0001,0.0001,0.0001,0.0001,0.0001,0.0001,0.0001,0.0001,0.0001,0.0001,0.0001,0.0001,0.0001,0.0001,0.0001,0.0001,0.0001,0.0001,0.0001,0.0001,0.0001,0.0001,0.0001,0.0001,0.0001,0.0001,0.0001,0.0001,0.0001,0.0001,0.0001,0.0001,0.0001,0.0001,0.0001,0.0001,0.0001,0.0001,0.0001,0.0001,0.0001,0.0001,0.0001,0.0001,0.0001,0.0001,0.0001,0.0001,0.0001,0.0001,0.0001,0.0001,0.0001,0.0001,0.0001,0.0001,0.0001,0.0001,0.0001,0.0001,0.0001,0.0001,0.0001,0.0001,0.0001,0.0001,0.0001,0.0001,0.0001,0.0001,0.0001,0.0001,0.0001,0.0001,0.0001,0.0001,0.0001,0.0001,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000,0.0000
};
#endif

#ifndef PIPE_BUF
#define PIPE_BUF 4096
#endif

/* Magic number for the FNV-1 hash from:
 * http://www.isthe.com/chongo/src/fnv/fnv.h */
#define FNV1_32_MAGIC_NUMBER ((uint32_t)0x811c9dc5)

enum Wavetables {
    WT_SINE,
    WT_COS,
    WT_SQUARE, 
    WT_TRI, 
    WT_TRI2, 
    WT_SAW,
    WT_RSAW,
    WT_RND,
    WT_USER,
    NUM_WAVETABLES
};

enum Windows {
    WIN_NONE,
    WIN_SINE,
    WIN_SINEIN,
    WIN_SINEOUT,
    WIN_COS,
    WIN_TRI, 
    WIN_PHASOR, 
    WIN_HANN, 
    WIN_HANNIN, 
    WIN_HANNOUT, 
    WIN_HAMM,
    WIN_BART,
    WIN_BLACK,
    WIN_SINC,
    WIN_GAUSS,
    WIN_GAUSSIN,
    WIN_GAUSSOUT,
    WIN_PLUCKIN, 
    WIN_PLUCKOUT, 
    WIN_RND,
    WIN_SAW,
    WIN_RSAW,
    WIN_USER,
    NUM_WINDOWS
};

enum FilterTypes {
    FILTER_LOWPASS,
    FILTER_BANDPASS,
    FILTER_HIGHPASS,
    FILTER_NOTCH,
    FILTER_PEAK,
    FILTER_BELL,
    FILTER_LOWSHELF,
    FILTER_HIGHSHELF,
    NUM_FILTER_TYPES
};

enum PanMethods {
    PANMETHOD_CONSTANT,
    PANMETHOD_LINEAR,
    PANMETHOD_SINE,
    PANMETHOD_GOGINS,
    NUM_PANMETHODS
};


