#ifndef LP_UGEN_PULSAR_H
#define LP_UGEN_PULSAR_H

#include "ugens.core.h"
#include "oscs.pulsar.h"

#define UGEN_PULSAR_PARAM_FREQ "freq"
#define UGEN_PULSAR_PARAM_PHASE "phase"

enum UgenPulsarParams {
    UPULSARIN_WTTABLE,
    UPULSARIN_WTTABLELENGTH,
    UPULSARIN_NUMWTS,
    UPULSARIN_WTMORPH,
    UPULSARIN_WTMORPHFREQ,

    UPULSARIN_WINTABLE,
    UPULSARIN_WINTABLELENGTH,
    UPULSARIN_NUMWINS,
    UPULSARIN_WINMORPH,
    UPULSARIN_WINMORPHFREQ,

    UPULSARIN_BURSTTABLE,
    UPULSARIN_BURSTSIZE,
    UPULSARIN_BURSTPOS,

    UPULSARIN_PHASE,
    UPULSARIN_SATURATION,
    UPULSARIN_PULSEWIDTH,
    UPULSARIN_SAMPLERATE,
    UPULSARIN_FREQ,
    UPULSAR_NUMINPUTS
};

enum UgenPulsarOutputs {
    UPULSAROUT_MAIN,
    UPULSAROUT_WTTABLE,
    UPULSAROUT_WTTABLELENGTH,
    UPULSAROUT_NUMWTS,
    UPULSAROUT_WTMORPH,
    UPULSAROUT_WTMORPHFREQ,

    UPULSAROUT_WINTABLE,
    UPULSAROUT_WINTABLELENGTH,
    UPULSAROUT_NUMWINS,
    UPULSAROUT_WINMORPH,
    UPULSAROUT_WINMORPHFREQ,

    UPULSAROUT_BURSTTABLE,
    UPULSAROUT_BURSTSIZE,
    UPULSAROUT_BURSTPOS,

    UPULSAROUT_PHASE,
    UPULSAROUT_SATURATION,
    UPULSAROUT_PULSEWIDTH,
    UPULSAROUT_SAMPLERATE,
    UPULSAROUT_FREQ,
    UPULSAR_NUMOUTPUTS
};

typedef struct lpugenpulsar_t {
    lppulsarosc_t * osc;
    lpfloat_t outputs[UPULSAR_NUMOUTPUTS];
} lpugenpulsar_t;

// Legacy interface for Cython compatibility
ugen_t * create_pulsar_ugen(void);

// New unified interface
lpfloat_t lpugen_pulsar_process(ugen_t * u);

#endif
