#cython: language_level=3

from libc.stdint cimport uint16_t, uint32_t, uint64_t, int32_t, int64_t, uintptr_t

cdef extern from "stdint.h":
    ctypedef uint32_t u_int32_t

cdef extern from "pippicore.h":
    ctypedef double lpfloat_t
    ctypedef int lpint_t
    cdef const int LPMAXMSG
    cdef const int LPMAXNAME
    cdef const int LPMAXPATH

    cdef enum Wavetables:
        WT_SINE,
        WT_COS,
        WT_SQUARE, 
        WT_TRI, 
        WT_TRI2, 
        WT_SAW,
        WT_RSAW,
        WT_RND,
        WT_USER,
        NUM_WAVETABLES

    cdef enum Windows:
        WIN_NONE,
        WIN_SINE,
        WIN_SINEIN,
        WIN_SINEOUT,
        WIN_COS,
        WIN_TRI, 
        WIN_PHASOR, 
        WIN_HANN, 
        WIN_HANNIN, 
        WIN_HANNOUT, 
        WIN_HAMM,
        WIN_BART,
        WIN_BLACK,
        WIN_SINC,
        WIN_GAUSS,
        WIN_GAUSSIN,
        WIN_GAUSSOUT,
        WIN_PLUCKIN, 
        WIN_PLUCKOUT, 
        WIN_RND,
        WIN_SAW,
        WIN_RSAW,
        WIN_USER,
        NUM_WINDOWS

    cdef enum FilterTypes:
        FILTER_LOWPASS,
        FILTER_BANDPASS,
        FILTER_HIGHPASS,
        FILTER_NOTCH,
        FILTER_PEAK,
        FILTER_BELL,
        FILTER_LOWSHELF,
        FILTER_HIGHSHELF,
        NUM_FILTER_TYPES

    cdef enum PanMethods:
        PANMETHOD_CONSTANT,
        PANMETHOD_LINEAR,
        PANMETHOD_SINE,
        PANMETHOD_GOGINS,
        NUM_PANMETHODS

    ctypedef struct lpbuffer_t:
        size_t length
        int samplerate
        int channels
        lpfloat_t phase
        size_t boundry
        size_t range
        size_t pos
        size_t onset
        int is_looping
        lpfloat_t data[]

    cdef lpfloat_t lpzapgremlins(lpfloat_t x)
    cdef lpfloat_t lpfilternan(lpfloat_t x)
    cdef u_int32_t lphashstr(char * str)

    ctypedef struct lpbalance_t:
        lpfloat_t asig, csig, ihp
        lpfloat_t c1, c2, prvq, prvr, prva

    ctypedef struct lpbli_t:
        int quality;
        int samples_per_0x;
        int filter_length;
        int wrap;
        lpfloat_t * filter_table;
        int table_length;
        lpfloat_t resampling_factor;

    ctypedef struct lpbfilter_t:
        lpfloat_t sr, freq, istor;
        lpfloat_t lkf;
        lpfloat_t a[8];
        lpfloat_t pidsr;

    ctypedef struct lpsvf_t:
        lpfloat_t Az[4];
        lpfloat_t Bz[2];
        lpfloat_t Cz[3];
        lpfloat_t X[2];

        lpfloat_t M[3];
        lpfloat_t freq;
        lpfloat_t res;
        lpfloat_t gain;
        lpfloat_t shelf;
        int mode;

    ctypedef lpfloat_t (*lphbap_process)(void * data, lpfloat_t sample);
    ctypedef struct lphbap_t:
        lpfloat_t d1;
        lpfloat_t d2;
        lpfloat_t d3;
        lpfloat_t a0;
        lpfloat_t a1;
        lphbap_process process;

    ctypedef struct lpfilter_factory_t:
        lpbfilter_t * (*create_bhp)(lpfloat_t cutoff, lpfloat_t samplerate);
        lpfloat_t (*process_bhp)(lpbfilter_t *, lpfloat_t);
        lpbfilter_t * (*create_blp)(lpfloat_t cutoff, lpfloat_t samplerate);
        lpfloat_t (*process_blp)(lpbfilter_t *, lpfloat_t);
        lpsvf_t * (*create_svf)(int svf_mode);
        lpfloat_t (*process_svf)(lpsvf_t * svf, lpfloat_t sample);
        void (*destroy_svf)(lpsvf_t * svf);

    ctypedef struct lpfx_factory_t:
        lpfloat_t (*read_skewed_buffer)(lpfloat_t freq, lpbuffer_t * buf, lpfloat_t phase, lpfloat_t skew);
        lpfloat_t (*lpf1)(lpfloat_t x, lpfloat_t * y, lpfloat_t cutoff, lpfloat_t samplerate);
        lpfloat_t (*hpf1)(lpfloat_t x, lpfloat_t * y, lpfloat_t cutoff, lpfloat_t samplerate);
        void (*convolve)(lpbuffer_t * a, lpbuffer_t * b, lpbuffer_t * out);
        void (*norm)(lpbuffer_t * buf, lpfloat_t ceiling);
        lpfloat_t (*crossover)(lpfloat_t val, lpfloat_t amount, lpfloat_t smooth, lpfloat_t fade);
        lpfloat_t (*fold)(lpfloat_t val, lpfloat_t * prev, lpfloat_t samplerate);
        lpfloat_t (*limit)(lpfloat_t val, lpfloat_t * prev, lpfloat_t threshold, lpfloat_t release, lpbuffer_t * delay);
        lpfloat_t (*crush)(lpfloat_t val, int bits);
        lpbalance_t * (*create_balancer)(lpfloat_t samplerate);
        lpfloat_t (*balance)(lpbalance_t * bal, lpfloat_t val, lpfloat_t reference);
        void (*destroy_balancer)(lpbalance_t * bal);
        lpbuffer_t * (*crossfade)(lpbuffer_t * a, lpbuffer_t * b, lpbuffer_t * curve);
        lpfloat_t (*multifade)(lpbuffer_t * buf, lpfloat_t pos, lpfloat_t pan, int method);
        void (*diffuse)(lpbuffer_t * out, size_t frame, lpfloat_t sample, lpfloat_t pan, int method);
        void (*diffuse_into)(lpbuffer_t * out, size_t frame, lpfloat_t sample, lpfloat_t pan, int method);

    ctypedef struct lpwavetable_factory_t:
        lpbuffer_t * (*create)(int name, size_t length)
        void (*destroy)(lpbuffer_t *)

    ctypedef struct lpwindow_factory_t:
        lpbuffer_t * (*create)(int name, size_t length)
        void (*destroy)(lpbuffer_t *)

    ctypedef struct lpmemorypool_t:
        unsigned char * pool
        size_t poolsize
        size_t pos

    ctypedef struct lpmemorypool_factory_t:
        unsigned char * pool
        size_t poolsize
        size_t pos

        void (*init)(unsigned char *, size_t)
        lpmemorypool_t * (*custom_init)(unsigned char *, size_t)
        void * (*alloc)(size_t, size_t)
        void * (*custom_alloc)(lpmemorypool_t *, size_t, size_t)
        void (*free)(void *)

    ctypedef struct lpinterpolation_factory_t:
        lpfloat_t (*trunc_pos)(lpbuffer_t *, lpfloat_t)
        lpfloat_t (*trunc)(lpbuffer_t *, lpfloat_t)
        lpfloat_t (*linear_pos)(lpbuffer_t *, lpfloat_t)
        lpfloat_t (*linear)(lpbuffer_t *, lpfloat_t)
        lpfloat_t (*linear_channel)(lpbuffer_t *, lpfloat_t, int)
        lpbli_t * (*bli_create)(int quality, int loop);
        void (*bli_destroy)(lpbli_t * bli);
        lpfloat_t (*bli_pos)(lpbli_t * bli, lpbuffer_t *, lpfloat_t);
        lpfloat_t (*bli)(lpbli_t * bli, lpbuffer_t *, lpfloat_t);
        lpfloat_t (*hermite_pos)(lpbuffer_t *, lpfloat_t)
        lpfloat_t (*hermite)(lpbuffer_t *, lpfloat_t)

    ctypedef struct lpbuffer_factory_t: 
        lpbuffer_t * (*create)(size_t, int, int)
        lpbuffer_t * (*create_from_float)(lpfloat_t, size_t, int, int)
        lpbuffer_t * (*create_from_bytes)(char *, size_t, int, int)
        void (*copy)(lpbuffer_t *, lpbuffer_t *)
        lpbuffer_t * (*clone)(lpbuffer_t *)
        void (*clear)(lpbuffer_t *)
        void (*split2)(lpbuffer_t *, lpbuffer_t *, lpbuffer_t *)
        void (*scale)(lpbuffer_t *, lpfloat_t, lpfloat_t, lpfloat_t, lpfloat_t)
        lpfloat_t (*min)(lpbuffer_t * buf)
        lpfloat_t (*max)(lpbuffer_t * buf)
        lpfloat_t (*mag)(lpbuffer_t * buf)
        lpfloat_t (*avg)(lpbuffer_t * buf)
        lpfloat_t (*play)(lpbuffer_t *, lpfloat_t)
        void (*pan)(lpbuffer_t * buf, lpbuffer_t * pos, int method)
        lpbuffer_t * (*mix)(lpbuffer_t *, lpbuffer_t *)
        lpbuffer_t * (*remix)(lpbuffer_t *, int)
        void (*remap)(lpbuffer_t * dest, lpbuffer_t * src, int map_channels, int * channel_map)
        void (*clip)(lpbuffer_t * buf, lpfloat_t minval, lpfloat_t maxval)
        lpbuffer_t * (*cut)(lpbuffer_t * buf, size_t start, size_t length)
        void (*cut_into)(lpbuffer_t * buf, lpbuffer_t * out, size_t start, size_t length)
        lpbuffer_t * (*varispeed)(lpbuffer_t * buf, lpbuffer_t * speed)
        lpbuffer_t * (*resample)(lpbuffer_t *, size_t)
        void (*multiply)(lpbuffer_t *, lpbuffer_t *)
        void (*multiply_scalar)(lpbuffer_t *, lpfloat_t)
        void (*add)(lpbuffer_t *, lpbuffer_t *)
        void (*add_scalar)(lpbuffer_t *, lpfloat_t)
        void (*subtract)(lpbuffer_t *, lpbuffer_t *)
        void (*subtract_scalar)(lpbuffer_t *, lpfloat_t)
        void (*divide)(lpbuffer_t *, lpbuffer_t *)
        void (*divide_scalar)(lpbuffer_t *, lpfloat_t)
        void (*diff)(lpbuffer_t *, lpbuffer_t *)
        lpbuffer_t * (*concat)(lpbuffer_t *, lpbuffer_t *)
        int (*buffers_are_equal)(lpbuffer_t *, lpbuffer_t *)
        int (*buffers_are_close)(lpbuffer_t *, lpbuffer_t *, int)
        void (*dub)(lpbuffer_t *, lpbuffer_t *, size_t)
        void (*dub_into)(lpbuffer_t * buf, lpbuffer_t * src, size_t offset, lpfloat_t feedback, int wrap, int overdub)
        void (*dub_scalar)(lpbuffer_t *, lpfloat_t, size_t)
        lpfloat_t (*env_process)(lpbuffer_t * env, lpfloat_t freq)
        void (*env)(lpbuffer_t *, lpbuffer_t *)
        lpbuffer_t * (*pad)(lpbuffer_t * buf, size_t before, size_t after)
        void (*taper)(lpbuffer_t * buf, size_t start, size_t end)
        lpbuffer_t * (*trim)(lpbuffer_t * buf, size_t start, size_t end, lpfloat_t threshold, int window)
        lpbuffer_t * (*fadein)(lpbuffer_t * buf, lpfloat_t amount)
        lpbuffer_t * (*fadeout)(lpbuffer_t * buf, lpfloat_t amount)
        void (*fill)(lpbuffer_t * buf, lpbuffer_t * src, int nperiods);
        lpbuffer_t * (*loop)(lpbuffer_t * src, size_t length)
        lpbuffer_t * (*repeat)(lpbuffer_t * src, size_t repeats)
        lpbuffer_t * (*reverse)(lpbuffer_t * buf)
        lpbuffer_t * (*skew)(lpbuffer_t * buf, lpfloat_t tip);
        lpbuffer_t * (*resize)(lpbuffer_t *, size_t)
        void (*plot)(lpbuffer_t * buf)
        void (*destroy)(lpbuffer_t *)

    ctypedef struct lprand_t:
        lpfloat_t logistic_seed
        lpfloat_t logistic_x

        lpfloat_t lorenz_timestep
        lpfloat_t lorenz_x
        lpfloat_t lorenz_y
        lpfloat_t lorenz_z
        lpfloat_t lorenz_a
        lpfloat_t lorenz_b
        lpfloat_t lorenz_c

        void (*preseed)()
        void (*seed)(int)

        lpfloat_t (*stdlib)(lpfloat_t, lpfloat_t)
        lpfloat_t (*logistic)(lpfloat_t, lpfloat_t)

        lpfloat_t (*lorenz)(lpfloat_t, lpfloat_t)
        lpfloat_t (*lorenzX)(lpfloat_t, lpfloat_t)
        lpfloat_t (*lorenzY)(lpfloat_t, lpfloat_t)
        lpfloat_t (*lorenzZ)(lpfloat_t, lpfloat_t)

        lpfloat_t (*rand_base)(lpfloat_t, lpfloat_t)
        lpfloat_t (*rand)(lpfloat_t, lpfloat_t)
        int (*randint)(int, int)
        int (*randbool)()
        int (*choice)(int)

    extern lprand_t LPRand
    extern const lpbuffer_factory_t LPBuffer
    extern const lpfilter_factory_t LPFilter
    extern const lpwavetable_factory_t LPWavetable 
    extern const lpwindow_factory_t LPWindow
    extern lpmemorypool_factory_t LPMemoryPool
    extern const lpinterpolation_factory_t LPInterpolation
    extern const lpfx_factory_t LPFX

cdef extern from "mir.h":
    ctypedef struct lpenvelopefollower_t:
        lpfloat_t value
        lpfloat_t last
        lpfloat_t phase
        lpfloat_t interval

    ctypedef struct lpmir_envelopefollower_factory_t:
        lpenvelopefollower_t * (*create)(lpfloat_t, lpfloat_t)
        lpfloat_t (*process)(lpenvelopefollower_t *, lpfloat_t)
        void (*destroy)(lpenvelopefollower_t *)

    extern const lpmir_envelopefollower_factory_t LPEnvelopeFollower

cdef extern from "fx.softclip.h":
    ctypedef struct lpfxsoftclip_t:
        lpfloat_t lastval

    ctypedef struct lpfxsoftclip_factory_t:
        lpfxsoftclip_t * (*create)()
        lpfloat_t (*process)(lpfxsoftclip_t * sc, lpfloat_t val)
        void (*destroy)(lpfxsoftclip_t * sc)

    extern const lpfxsoftclip_factory_t LPSoftClip

cdef extern from "spectral.h":
    ctypedef struct lpspectral_factory_t:
        lpbuffer_t * (*convolve)(lpbuffer_t *, lpbuffer_t *)
        lpbuffer_t * (*process)(lpbuffer_t * snd, lpfloat_t length, lpbuffer_t * window, int (*callback)(lpfloat_t pos, lpbuffer_t * real, lpbuffer_t * imag), size_t blocksize)
    extern const lpspectral_factory_t LPSpectral

cdef extern from "soundfile.h":
    ctypedef struct lpsoundfile_factory_t:
        lpbuffer_t * (*read)(const char *)
        void (*write)(const char *, lpbuffer_t *)

    extern const lpsoundfile_factory_t LPSoundFile

cdef lpbuffer_t * to_window(object o, size_t length=*)
cdef lpbuffer_t * to_wavetable(object o, size_t length=*)

cdef class SoundBuffer:
    cdef lpbuffer_t * buffer
    cdef Py_ssize_t shape[2]
    cdef Py_ssize_t strides[2]
    cdef bint moved

    cdef public str _filename

    @staticmethod
    cdef SoundBuffer _fromlpbuffer(lpbuffer_t * buffer, SoundBuffer meta=*)
    cdef fromlpbuffer(SoundBuffer self, lpbuffer_t * buffer)
    cpdef SoundBuffer env(SoundBuffer self, object window=*)
    cpdef SoundBuffer fill(SoundBuffer self, object src, int nperiods=*)
    cpdef SoundBuffer loop(SoundBuffer self, double length)
    cpdef SoundBuffer convolve(SoundBuffer self, SoundBuffer impulse, bint norm=*)
    cpdef SoundBuffer diff(SoundBuffer self, SoundBuffer other)
    cpdef SoundBuffer fadein(SoundBuffer self, double amount)
    cpdef SoundBuffer fadeout(SoundBuffer self, double amount)
    cpdef SoundBuffer fdub(SoundBuffer self, object sounds, size_t framepos=*)
    cpdef SoundBuffer diffuse_into(SoundBuffer self, SoundBuffer src, object pan=*, int channel=*, str method=*)
    cpdef SoundBuffer remap(SoundBuffer self, tuple channels)
    cpdef tuple split(SoundBuffer self)
    cpdef tuple split2(SoundBuffer self)
    cpdef SoundBuffer remix(SoundBuffer self, int channels)
    cpdef SoundBuffer repeat(SoundBuffer self, size_t repeats)
    cpdef SoundBuffer reverse(SoundBuffer self)
    cpdef SoundBuffer reversed(SoundBuffer self)
    cpdef SoundBuffer env(SoundBuffer self, object window=*)
