# -*- coding: utf-8 -*-
# File generated from our OpenAPI spec
from stripe._stripe_object import StripeObject
from typing import ClassVar, Optional
from typing_extensions import Literal


class FinancialAddress(StripeObject):
    """
    A FinancialAddress contains information needed to transfer money to a Financial Account. A Financial Account can have more than one Financial Address.
    """

    OBJECT_NAME: ClassVar[Literal["v2.money_management.financial_address"]] = (
        "v2.money_management.financial_address"
    )

    class Credentials(StripeObject):
        class GbBankAccount(StripeObject):
            account_holder_name: str
            """
            The account holder name to be used during bank transference.
            """
            account_number: Optional[str]
            """
            The account number of the UK Bank Account.
            """
            last4: str
            """
            The last four digits of the UK Bank Account number. This will always be returned.
            To view the full account number when retrieving or listing FinancialAddresses, use the `include` request parameter.
            """
            sort_code: str
            """
            The sort code of the UK Bank Account.
            """

        class UsBankAccount(StripeObject):
            account_number: Optional[str]
            """
            The account number of the US Bank Account.
            """
            bank_name: Optional[str]
            """
            The name of the Bank.
            """
            last4: str
            """
            The last four digits of the US Bank Account number. This will always be returned.
            To view the full account number when retrieving or listing FinancialAddresses, use the `include` request parameter.
            """
            routing_number: str
            """
            The routing number of the US Bank Account.
            """
            swift_code: Optional[str]
            """
            The swift code of the bank or financial institution.
            """

        gb_bank_account: Optional[GbBankAccount]
        """
        The credentials of the UK Bank Account for the FinancialAddress. This contains unique banking details such as the sort code, account number, etc. of a UK bank account.
        """
        type: Literal["gb_bank_account", "us_bank_account"]
        """
        Open Enum. The type of Credentials that are provisioned for the FinancialAddress.
        """
        us_bank_account: Optional[UsBankAccount]
        """
        The credentials of the US Bank Account for the FinancialAddress. This contains unique banking details such as the routing number, account number, etc. of a US bank account.
        """
        _inner_class_types = {
            "gb_bank_account": GbBankAccount,
            "us_bank_account": UsBankAccount,
        }

    created: str
    """
    The creation timestamp of the FinancialAddress.
    """
    credentials: Optional[Credentials]
    """
    Object indicates the type of credentials that have been allocated and attached to the FinancialAddress.
    It contains all necessary banking details with which to perform money movements with the FinancialAddress.
    This field is only available for FinancialAddresses with an active status.
    """
    currency: Literal[
        "aed",
        "afn",
        "all",
        "amd",
        "ang",
        "aoa",
        "ars",
        "aud",
        "awg",
        "azn",
        "bam",
        "bbd",
        "bdt",
        "bgn",
        "bhd",
        "bif",
        "bmd",
        "bnd",
        "bob",
        "bov",
        "brl",
        "bsd",
        "btn",
        "bwp",
        "byn",
        "byr",
        "bzd",
        "cad",
        "cdf",
        "che",
        "chf",
        "chw",
        "clf",
        "clp",
        "cny",
        "cop",
        "cou",
        "crc",
        "cuc",
        "cup",
        "cve",
        "czk",
        "djf",
        "dkk",
        "dop",
        "dzd",
        "eek",
        "egp",
        "ern",
        "etb",
        "eur",
        "fjd",
        "fkp",
        "gbp",
        "gel",
        "ghc",
        "ghs",
        "gip",
        "gmd",
        "gnf",
        "gtq",
        "gyd",
        "hkd",
        "hnl",
        "hrk",
        "htg",
        "huf",
        "idr",
        "ils",
        "inr",
        "iqd",
        "irr",
        "isk",
        "jmd",
        "jod",
        "jpy",
        "kes",
        "kgs",
        "khr",
        "kmf",
        "kpw",
        "krw",
        "kwd",
        "kyd",
        "kzt",
        "lak",
        "lbp",
        "lkr",
        "lrd",
        "lsl",
        "ltl",
        "lvl",
        "lyd",
        "mad",
        "mdl",
        "mga",
        "mkd",
        "mmk",
        "mnt",
        "mop",
        "mro",
        "mru",
        "mur",
        "mvr",
        "mwk",
        "mxn",
        "mxv",
        "myr",
        "mzn",
        "nad",
        "ngn",
        "nio",
        "nok",
        "npr",
        "nzd",
        "omr",
        "pab",
        "pen",
        "pgk",
        "php",
        "pkr",
        "pln",
        "pyg",
        "qar",
        "ron",
        "rsd",
        "rub",
        "rwf",
        "sar",
        "sbd",
        "scr",
        "sdg",
        "sek",
        "sgd",
        "shp",
        "sle",
        "sll",
        "sos",
        "srd",
        "ssp",
        "std",
        "stn",
        "svc",
        "syp",
        "szl",
        "thb",
        "tjs",
        "tmt",
        "tnd",
        "top",
        "try",
        "ttd",
        "twd",
        "tzs",
        "uah",
        "ugx",
        "usd",
        "usdb",
        "usdc",
        "usn",
        "uyi",
        "uyu",
        "uzs",
        "vef",
        "ves",
        "vnd",
        "vuv",
        "wst",
        "xaf",
        "xcd",
        "xcg",
        "xof",
        "xpf",
        "yer",
        "zar",
        "zmk",
        "zmw",
        "zwd",
        "zwg",
        "zwl",
    ]
    """
    Open Enum. The currency the FinancialAddress supports.
    """
    financial_account: str
    """
    A ID of the FinancialAccount this FinancialAddress corresponds to.
    """
    id: str
    """
    The ID of a FinancialAddress.
    """
    livemode: bool
    """
    Has the value `true` if the object exists in live mode or the value `false` if the object exists in test mode.
    """
    object: Literal["v2.money_management.financial_address"]
    """
    String representing the object's type. Objects of the same type share the same value of the object field.
    """
    status: Literal["active", "archived", "failed", "pending"]
    """
    Closed Enum. An enum representing the status of the FinancialAddress. This indicates whether or not the FinancialAddress can be used for any money movement flows.
    """
    _inner_class_types = {"credentials": Credentials}
