from typing import List

from meutils.pipe import *

patterns = [
    r'([。!?\?])([^"\'])',
    r'(\.{6})([^"\'])',
    r'(\.{3,}[^\.\s])',
    r'([。!?\?]["\'])([^,。!?\?])'
]
combined_pattern = '|'.join(patterns)


def split_text(text_input: str, chunk_size: int=500, overlap_ratio: float=0.2) -> List[str]:

    # 连续标点句子去重
    sentences = re.sub(combined_pattern, r'\1\n\2', text_input).strip().split("\n")
    sentences_lengths = [len(sentence) for sentence in sentences]
    chunks = []
    fast = 0
    slow = 0
    current_length = 0
    overlap_length = chunk_size * overlap_ratio // 1
    # 防止 overlap_length 过大而 chunk_size 过小导致无限循环
    iter_count = 0
    max_iter_count = len(sentences_lengths) * 2
    while iter_count < max_iter_count and fast < len(sentences_lengths):
        current_length += sentences_lengths[fast]
        if current_length > chunk_size:
            chunk = " ".join(sentences[slow:fast])
            chunks.append(chunk)
            current_length = current_length - sentences_lengths[fast]
            while slow < fast and current_length > overlap_length:
                current_length -= sentences_lengths[slow]
                slow += 1
            fast = slow
            current_length = 0
        else:
            fast += 1
        iter_count += 1
    if iter_count >= max_iter_count:
        raise ValueError('Warning: maximum iteration reached, maybe reduce the overlap_ratio')
    if fast < len(sentences_lengths):
        chunk = " ".join(sentences[fast:])
        chunks.append(chunk)
    return chunks



text = """
中欧新蓝筹灵活配置混合型证券投资基金2023年第1季度报告2023年03月31日基金管理人:中欧基金管理有限公司基金托管人:中国建设银行股份有限公司报告送出日期:2023年04月22日中欧新蓝筹灵活配置混合型证券投资基金2023年第1季度报告§1 重要提示基金管理人的董事会及董事保证本报告所载资料不存在虚假记载、误导性陈述或重大遗漏，并对其内容的真实性、准确性和完整性承担个别及连带责任。基金托管人中国建设银行股份有限公司根据本基金合同规定，于2023年4月21日复核了本报告中的财务指标、净值表现和投资组合报告等内容，保证复核内容不存在虚假记载、误导性陈述或者重大遗漏。基金管理人承诺以诚实信用、勤勉尽责的原则管理和运用基金资产，但不保证基金一定盈利。基金的过往业绩并不代表其未来表现。投资有风险，投资者在作出投资决策前应仔细阅读本基金的招募说明书。本报告中财务资料未经审计。本报告期自2023年01月01日起至2023年03月31日止。§2 基金产品概况第2页中欧新蓝筹灵活配置混合型证券投资基金2023年第1季度报告§3 主要财务指标和基金净值表现3.1 主要财务指标单位：人民币元注：1.本期已实现收益指基金本期利息收入、投资收益、其他收入（不含公允价值变动收益）扣除相关费用和信用减值损失后的余额，本期利润为本期已实现收益加上本期公允价值变动收益。2.所述基金业绩指标不包括持有人认购或交易基金的各项费用，计入费用后实际收益水平要低于所列数字。3.2 基金净值表现3.2.1 基金份额净值增长率及其与同期业绩比较基准收益率的比较第3页中欧新蓝筹灵活配置混合型证券投资基金2023年第1季度报告中欧新蓝筹混合A净值表现中欧新蓝筹混合E净值表现中欧新蓝筹混合C净值表现第4页中欧新蓝筹灵活配置混合型证券投资基金2023年第1季度报告3.2.2 自基金合同生效以来基金累计净值增长率变动及其与同期业绩比较基准收益率变动的比较第5页中欧新蓝筹灵活配置混合型证券投资基金2023年第1季度报告注：本基金于2015年10月 8日新增 E类份额，图示日期为2015年10月12日至2023年03月31日。注：本基金于2017年 1月12日新增 C类份额，图示日期为2017年 1月13日至2023年03月31日。§4 管理人报告4.1 基金经理（或基金经理小组）简介注：1、任职日期和离任日期一般情况下指公司作出决定之日；若该基金经理自基金合同生效日起即任职，则任职日期为基金合同生效日。第6页中欧新蓝筹灵活配置混合型证券投资基金2023年第1季度报告2、证券从业的含义遵从《证券基金经营机构董事、监事、高级管理人员及从业人员监督管理办法》等相关规定。4.2 管理人对报告期内本基金运作遵规守信情况的说明本报告期内，本基金管理人严格遵循了《证券投资基金法》及其各项实施细则、本基金基金合同和其他相关法律法规的规定，本着诚实信用、勤勉尽责、取信于市场、取信于社会的原则管理和运用基金资产，为基金份额持有人谋求最大利益。本报告期内，基金投资管理符合有关法规和基金合同的规定，无违法违规、未履行基金合同承诺或损害基金份额持有人利益的行为。4.3 公平交易专项说明4.3.1 公平交易制度的执行情况本报告期内，本基金管理人严格按照《证券投资基金管理公司公平交易制度指导意见》及公司内部相关制度等规定，从研究分析、投资决策、交易执行、事后监控等环节严格把关，通过系统和人工等方式在各个环节严格控制交易公平执行。本报告期内，本基金管理人公平交易制度和控制方法总体执行情况良好，不同投资组合之间不存在非公平交易或利益输送的情况。4.3.2 异常交易行为的专项说明本报告期内，公司旗下所有投资组合参与的交易所公开竞价交易中，同日反向交易成交较少的单边交易量超过该证券当日成交量的5%的交易共有26次，为量化策略组合因投资策略需要发生的反向交易，公司内部风控对上述交易均履行相应控制程序。本报告期内，未发现本基金有可能导致不公平交易和利益输送的异常交易。4.4 报告期内基金的投资策略和运作分析一季度市场以春节为分水岭呈现先扬后抑走势，但总体各指数呈现不同程度的上涨。春节前市场对疫后的经济复苏展望较为乐观，叠加中国经济前景较海外更为确定，因此催生北上资金持续流入A股，市场呈现单边上行走势。节后随着经济和行业的高频数据出台，以及两会后全年经济增长目标逐步明朗，市场对原预期进行修正，股市走弱，震荡回调。从行业来说，与经济总量相关的消费、周期等行业表现不佳，新能源相关行业也因为短期景气度下降表现差强人意。相对而言，由于对中国特色估值体系的认同度不断提升，部分行业的央国企价值得到重估，走势明显偏强。此外，随着ChatGPT的横空出世，海外大模型以及相关人工智能的产业趋势受到市场关注，并很快扩散到国内产业界，市场聚焦于上游算力、传输和下游运用，在经济复苏相对温和的情景下，计算机、通讯、传媒、电子行业受到各方资金的追捧，涨幅遥遥领先。报告期内，本基金基本维持年初组合，相对市场继续超配了养殖与疫情受损股，我们认为今年甚至明年这两个板块的公司盈利明显好转是大概率事件。在宏观经济恢复没那么强劲的背景下，这种不低于市场预期的确定性业绩高增长是比较稀缺的。另外，基第7页中欧新蓝筹灵活配置混合型证券投资基金2023年第1季度报告金增加了处于周期底部且估值合理的化工行业以及受益于数字经济建设的通讯行业的配置，降低了弹性欠佳的部分交运、电力设备和医药行业的权重。4.5 报告期内基金的业绩表现本报告期内，A类基金份额净值增长率为1.42%，同期业绩比较基准收益率为3.08%；E类份额净值增长率为1.42%，同期业绩比较基准收益率为3.08%；C类份额净值 增长率为1.22%，同期业绩比较基准收益率为3.08%。4.6 报告期内基金持有人数或基金资产净值预警说明本报告期内基金管理人无应说明预警信息。§5 投资组合报告5.1 报告期末基金资产组合情况5.2 报告期末按行业分类的股票投资组合5.2.1 报告期末按行业分类的境内股票投资组合第8页中欧新蓝筹灵活配置混合型证券投资基金2023年第1季度报告5.2.2 报告期末按行业分类的港股通投资股票投资组合本基金本报告期末未持有港股通股票。5.3 报告期末按公允价值占基金资产净值比例大小排序的前十名股票投资明细第9页中欧新蓝筹灵活配置混合型证券投资基金2023年第1季度报告5.4 报告期末按债券品种分类的债券投资组合5.5 报告期末按公允价值占基金资产净值比例大小排序的前五名债券投资明细5.6 报告期末按公允价值占基金资产净值比例大小排序的前十名资产支持证券投资明细本基金本报告期末未持有资产支持证券。5.7 报告期末按公允价值占基金资产净值比例大小排序的前五名贵金属投资明细第10页中欧新蓝筹灵活配置混合型证券投资基金2023年第1季度报告本基金本报告期末未持有贵金属。5.8 报告期末按公允价值占基金资产净值比例大小排序的前五名权证投资明细本基金本报告期末未持有权证。5.9 报告期末本基金投资的股指期货交易情况说明5.9.1 报告期末本基金投资的股指期货持仓和损益明细股指期货不属于本基金的投资范围，故此项不适用。5.9.2 本基金投资股指期货的投资政策股指期货不属于本基金的投资范围，故此项不适用。5.10 报告期末本基金投资的国债期货交易情况说明5.10.1 本期国债期货投资政策国债期货不属于本基金的投资范围，故此项不适用。5.10.2 报告期末本基金投资的国债期货持仓和损益明细国债期货不属于本基金的投资范围，故此项不适用。5.10.3 本期国债期货投资评价国债期货不属于本基金的投资范围，故此项不适用。5.11 投资组合报告附注5.11.1 本基金投资的春秋航空的发行主体春秋航空股份有限公司于2022年12月05日受到中国民用航空华北地区管理局的华北局罚决河北字〔2022〕2号，于2022年11月18日受到中国民用航空中南地区管理局的中南局罚决广东字〔2022〕19号。 本基金对上述主体发行的相关证券的投资决策程序符合相关法律法规及基金合同的要求。其余前十大持有证券的发行主体本报告期内没有被监管部门立案调查，或在报告编制日前一年内受到公开谴责、处罚的情形。5.11.2 本基金投资的前十名股票中，没有投资于超出基金合同规定备选库之外的股票。5.11.3 其他资产构成第11页中欧新蓝筹灵活配置混合型证券投资基金2023年第1季度报告5.11.4 报告期末持有的处于转股期的可转换债券明细5.11.5 报告期末前十名股票中存在流通受限情况的说明5.11.6 投资组合报告附注的其他文字描述部分本报告中因四舍五入原因，投资组合报告中市值占总资产或净资产比例的分项之和与合计可能存在尾差。§6 开放式基金份额变动单位：份第12页中欧新蓝筹灵活配置混合型证券投资基金2023年第1季度报告注：总申购份额含红利再投、转换入份额，总赎回份额含转换出份额。§7 基金管理人运用固有资金投资本基金情况7.1 基金管理人持有本基金份额变动情况本基金管理人本报告期内未持有本基金。7.2 基金管理人运用固有资金投资本基金交易明细本基金管理人本报告期内无申购、赎回本基金的情况。§8 影响投资者决策的其他重要信息8.1 报告期内单一投资者持有基金份额比例达到或超过20%的情况报告期内单一投资者持有基金份额比例不存在达到或超过20%的情况。8.2 影响投资者决策的其他重要信息无。§9 备查文件目录9.1 备查文件目录1、中欧新蓝筹灵活配置混合型证券投资基金相关批准文件2、《中欧新蓝筹灵活配置混合型证券投资基金基金合同》3、《中欧新蓝筹灵活配置混合型证券投资基金托管协议》4、《中欧新蓝筹灵活配置混合型证券投资基金招募说明书》5、基金管理人业务资格批件、营业执照6、本报告期内在中国证监会指定媒介上公开披露的各项公告第13页中欧新蓝筹灵活配置混合型证券投资基金2023年第1季度报告9.2 存放地点基金管理人的办公场所。9.3 查阅方式投资者可登录基金管理人网站(www.zofund.com)查阅，或在营业时间内至基金管理人办公场所免费查阅。投资者对本报告书如有疑问，可咨询本基金管理人中欧基金管理有限公司：客户服务中心电话：021-68609700，400-700-9700中欧基金管理有限公司2023年04月22日第14页
"""
res = split_text(text, 500, 0.2)
for i in res:
    print("=" * 20)
    print(i)
    print(len(i))
