# **Game Solver Lib**

**A package of libraries that solve simple games.**

Currently the package only contains the `wordfinder` library which is a library that contains everything necessary to solve the word-finding game based on user input, in this case a number that represents the length that the words to be searched must have and a set of letters from which the words to be searched can be composed.

---

## **Basic Algorithm Description**

### **For the Wordfinder library**
**Summary:**  
An English words file is used to generate a database based on that file; anagram techniques are used to solve the problem.

**Detailed:**  
This is achieved thanks to a file with all the English words, which is read, cleaned, processed, and stored in an in-memory database. This database is a dict where the key is the word sorted alphabetically and its value is a list with the original word. If another word is an anagram, it would be stored under the same key but the original word would be added to the existing list, making each key unique and its value contain all possible anagrams.

User inputs are stored, cleaned, verified, processed, and stored again. In the case of the entered set of letters, it is sorted alphabetically, then all possible combinations of that set of letters with the specified length are generated. Then all those combinations are searched in the database, and the database returns all the words found. These are stored and shown to the user via the console, and a user history file is saved.

---

## **Features**

### **For the Wordfinder library**
- Enter the desired word length (e.g., `5`)
- Input a set of letters (e.g., `"nyogbsfo"`)
- Returns all valid English words (e.g., `bongo`, `bongs`, `boons`, etc.)
- Uses anagram-solving logic
- Based on a plain English word list (`words.txt`)

---

## **Installation and Testing:**

The project is cross-platform and can be installed on Unix-like systems (Gnu-Linux, Mac, etc.) and Windows systems:

**You can install the project from the PYPI Python package index:**

### **Installation instructions as a package from PYPI:**

The project has no external dependencies, so it can be installed globally without the need for a virtual environment; however, using one is recommended.

Installing locally in a virtual environment:

For Unix-like systems (Gnu-Linux, Mac, etc.):

**Enter the following command in the console:**

`python3 -m venv game_solver_lib`

Note: game_solver_lib is the name of the folder that will contain a Python virtual environment where the project will be installed.

**To activate the virtual environment, enter the following command from the root of the folder you created.**

`source ./bin/activate`

**Then install the project as a package:**

`pip install gamesolverlib`

Once installed, you can directly run the automated or custom tests from the `wordfinder` library, simply by using the `wordfindertest` command without arguments for automated tests or with arguments for custom tests. In both cases, the results will be displayed in the console and saved to files.

Example once everything is configured, activated, and installed.

**From the console, enter the following command:**

`wordfindertest`

**Example output summarized with the last 3 lines:**
```
32 tests in 9 items.
32 passed and 0 failed.
Test passed.
```

**From the console, enter the following command:**

`wordfindertest 5 nyogbsfo`

**Example output:**

`(True, 'bongo bongs boons goofs goofy goons')`

For Windows systems:
Everything is exactly the same, the only thing that changes are the configuration and installation commands:
`py -m venv game_solver_lib`
`.\scripts\Activate.ps1`
`pip install gamesolverlib`

### **Running the library directly in the console, from the project root, when the project has been cloned or downloaded:**

Here you could create and activate a virtual environment, but not install anything with pip. Instead, download and unzip or clone it directly to the virtual environment's lib path. However, it is recommended to do this as a library installation with pip, as in the previous section, and not manually. However, this section does not cover this. This method is taught not only in a virtual environment, but also globally, simply by downloading or cloning the project directly from GitHub.

In this case, you can download the project directly from GitHub and unzip it.

Or you can clone it from the console:

For Unix-like systems (Mac, Gnu-Linux, etc.)

**Enter the following command:**

`git clone https://github.com/Sharrrkkk/game_solver_lib.git`

For Windows:
If you have Git installed.

**Enter the following command:**

`git clone https://github.com/Sharrrkkk/game_solver_lib.git`

If you don't have it installed, you can install it and use the previous command, or simply download it.

Once downloaded and unzipped, or cloned,

There's no need to create a virtual environment, activate it, install it, or configure anything like you would with a package installation.

For Unix-like systems (Mac, GNU-Linux, etc.):

Everything works the same as when installed as a package. The only difference is that there is no special command to run automated or custom tests. You must use commands like this one, or create your own, which is not covered in this section.

**Example of a command without arguments to test the library's functionality with automatic arguments:**

`python3 src/gamesolverlib/wordfinder_lib/wordfinder.py`

**Example of commands with arguments to test the library's functionality with custom inputs:**

`python3 src/gamesolverlib/wordfinder_lib/wordfinder.py 5 nyogbsfo`

For Windows systems:
It's exactly the same as for Unix-like systems. Only some of the commands change.

`py src\gamesolverlib\wordfinder_lib\wordfinder.py`

`py src\gamesolverlib\wordfinder_lib\wordfinder.py 5 nyogbsfo`

### **Notes:**

- You can run the cloned library or the one downloaded from GitHub from anywhere. You just need to specify the path manually in the commands. However, the data for automated tests when called without arguments, or the data for custom tests when called with arguments, are generated and saved by the library and will be available in the library path wordfinder_lib/test_logs/wordfinder_func.txt for custom tests and wordfinder_test.txt for automated tests. However, everything will also be displayed in the console.
- Automated tests can be modified, expanded, and reduced simply by editing the tests in the wordfinder.py module.

---

## **Usage**

### **How to use the library by importing it from a Python project:**

Once everything is up and running, we can import the library into our own Python projects.

**Usage example:**
```python
import gamesolverlib

print(gamesolverlib.WordFinder.word_finder("5", "nyogbsfo"))
```

**Explanation:**
`gamesolverlib` is the library package, and the WordFinder library is exposed through a `WordFinder` class and its `word_finder` method, which accepts two arguments in the form of strings: the first, a number indicating the exact length of the words to be searched for, and the second, a string indicating the letters from which the words to be searched can be composed. The `wordfinder.py` module has all the necessary internal documentation.

Another practical example is my `Word Game Solver` project, also published on GitHub and PYPI. You can install and use it with the same examples shown here. The difference is that it has its own CLI user interface. The project itself has all the necessary information. However, this is an example of a practical way to use these libraries.

**Link to my `Word Game Solver` project, as an example of how to use this library in practice:**
`https://github.com/Sharrrkkk/word_game_solver`

**Link to this same project on PYPI:**

`https://pypi.org/project/word-game-solver/`

---

## **Project Structure**

```
.
├── LICENSE
├── README.md
├── pyproject.toml
├── src
│   └── gamesolverlib
│       ├── __about__.py
│       ├── __init__.py
│       └── _wordfinder_lib
│           ├── test_logs
│           │   ├── wordfinder_func.txt
│           │   └── wordfinder_test.txt
│           ├── word_files
│           │   └── english_words.txt
│           └── wordfinder.py
```

---

## **License**
This project is licensed under the MIT License.

---

## **Notes**
### **For the Wordfinder library:**
You can replace words.txt with any other word list you prefer.
The program filters each line to remove special characters, digits, and whitespace, and converts all text to lowercase.
Only simple alphabetic characters (A–Z, a–z) are currently supported—no accented letters or special symbols.

This project is intended 100% for educational purposes.

It is fully compatible with Unix-like systems (GNU/Linux, macOS, etc.) and Windows.

---