# JVClient (jvclient)

![GitHub release (latest by date)](https://img.shields.io/github/v/release/TrueSelph/jvclient)
![GitHub Workflow Status](https://img.shields.io/github/actions/workflow/status/TrueSelph/jvclient/test-jvclient.yaml)
![GitHub issues](https://img.shields.io/github/issues/TrueSelph/jvclient)
![GitHub pull requests](https://img.shields.io/github/issues-pr/TrueSelph/jvclient)
![GitHub](https://img.shields.io/github/license/TrueSelph/jvclient)

`jvclient` is a UI library for building JIVAS applications.

## Installation

To install `jvclient`, use `pip`:

```sh
pip install jvclient
```

## Usage

To use `jvclient`, import the required utility functions or widgets into your streamlit application


## 🔰 Contributing

- **🐛 [Report Issues](https://github.com/TrueSelph/jvclient/issues)**: Submit bugs found or log feature requests for the `jvclient` project.
- **💡 [Submit Pull Requests](https://github.com/TrueSelph/jvclient/blob/main/CONTRIBUTING.md)**: Review open PRs, and submit your own PRs.

<details closed>
<summary>Contributing Guidelines</summary>

1. **Fork the Repository**: Start by forking the project repository to your GitHub account.
2. **Clone Locally**: Clone the forked repository to your local machine using a git client.
   ```sh
   git clone https://github.com/TrueSelph/jvclient
   ```
3. **Create a New Branch**: Always work on a new branch, giving it a descriptive name.
   ```sh
   git checkout -b new-feature-x
   ```
4. **Make Your Changes**: Develop and test your changes locally.
5. **Commit Your Changes**: Commit with a clear message describing your updates.
   ```sh
   git commit -m 'Implemented new feature x.'
   ```
6. **Push to GitHub**: Push the changes to your forked repository.
   ```sh
   git push origin new-feature-x
   ```
7. **Submit a Pull Request**: Create a PR against the original project repository. Clearly describe the changes and their motivations.
8. **Review**: Once your PR is reviewed and approved, it will be merged into the main branch. Congratulations on your contribution!
</details>

<details open>
<summary>Contributor Graph</summary>
<br>
<p align="left">
    <a href="https://github.com/TrueSelph/jvclient/graphs/contributors">
        <img src="https://contrib.rocks/image?repo=TrueSelph/jvclient" />
   </a>
</p>
</details>

## 🎗 License

This project is protected under the Apache License 2.0. See [LICENSE](./LICENSE) for more information.
