# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

import types

__config__ = pulumi.Config('azuredevops')


class _ExportableConfig(types.ModuleType):
    @property
    def client_certificate(self) -> Optional[str]:
        """
        Base64 encoded certificate to use to authenticate to the service principal.
        """
        return __config__.get('clientCertificate')

    @property
    def client_certificate_password(self) -> Optional[str]:
        """
        Password for a client certificate password.
        """
        return __config__.get('clientCertificatePassword')

    @property
    def client_certificate_path(self) -> Optional[str]:
        """
        Path to a certificate to use to authenticate to the service principal.
        """
        return __config__.get('clientCertificatePath')

    @property
    def client_id(self) -> Optional[str]:
        """
        The service principal client or managed service principal id which should be used.
        """
        return __config__.get('clientId')

    @property
    def client_id_apply(self) -> Optional[str]:
        return __config__.get('clientIdApply')

    @property
    def client_id_plan(self) -> Optional[str]:
        return __config__.get('clientIdPlan')

    @property
    def client_secret(self) -> Optional[str]:
        """
        Client secret for authenticating to a service principal.
        """
        return __config__.get('clientSecret')

    @property
    def client_secret_path(self) -> Optional[str]:
        """
        Path to a file containing a client secret for authenticating to a service principal.
        """
        return __config__.get('clientSecretPath')

    @property
    def oidc_audience(self) -> Optional[str]:
        """
        Set the audience when requesting OIDC tokens.
        """
        return __config__.get('oidcAudience')

    @property
    def oidc_request_token(self) -> Optional[str]:
        """
        The bearer token for the request to the OIDC provider. For use when authenticating as a Service Principal using OpenID
        Connect.
        """
        return __config__.get('oidcRequestToken')

    @property
    def oidc_request_url(self) -> Optional[str]:
        """
        The URL for the OIDC provider from which to request an ID token. For use when authenticating as a Service Principal
        using OpenID Connect.
        """
        return __config__.get('oidcRequestUrl')

    @property
    def oidc_tfc_tag(self) -> Optional[str]:
        return __config__.get('oidcTfcTag')

    @property
    def oidc_token(self) -> Optional[str]:
        """
        OIDC token to authenticate as a service principal.
        """
        return __config__.get('oidcToken')

    @property
    def oidc_token_file_path(self) -> Optional[str]:
        """
        OIDC token from file to authenticate as a service principal.
        """
        return __config__.get('oidcTokenFilePath')

    @property
    def org_service_url(self) -> Optional[str]:
        """
        The url of the Azure DevOps instance which should be used.
        """
        return __config__.get('orgServiceUrl') or _utilities.get_env('AZDO_ORG_SERVICE_URL')

    @property
    def personal_access_token(self) -> Optional[str]:
        """
        The personal access token which should be used.
        """
        return __config__.get('personalAccessToken')

    @property
    def tenant_id(self) -> Optional[str]:
        """
        The service principal tenant id which should be used.
        """
        return __config__.get('tenantId')

    @property
    def tenant_id_apply(self) -> Optional[str]:
        return __config__.get('tenantIdApply')

    @property
    def tenant_id_plan(self) -> Optional[str]:
        return __config__.get('tenantIdPlan')

    @property
    def use_msi(self) -> Optional[bool]:
        """
        Use an Azure Managed Service Identity.
        """
        return __config__.get_bool('useMsi')

    @property
    def use_oidc(self) -> Optional[bool]:
        """
        Use an OIDC token to authenticate to a service principal.
        """
        return __config__.get_bool('useOidc')

