# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['FeedArgs', 'Feed']

@pulumi.input_type
class FeedArgs:
    def __init__(__self__, *,
                 features: Optional[pulumi.Input[Sequence[pulumi.Input['FeedFeatureArgs']]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 project_id: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a Feed resource.
        :param pulumi.Input[Sequence[pulumi.Input['FeedFeatureArgs']]] features: A `features` blocks as documented below.
               
               > **Note** *Because of ADO limitations feed name can be **reserved** for up to 15 minutes after permanent delete of the feed*
        :param pulumi.Input[str] name: The name of the Feed.
        :param pulumi.Input[str] project_id: The ID of the Project Feed is created in. If not specified, feed will be created at the organization level.
        """
        if features is not None:
            pulumi.set(__self__, "features", features)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)

    @property
    @pulumi.getter
    def features(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['FeedFeatureArgs']]]]:
        """
        A `features` blocks as documented below.

        > **Note** *Because of ADO limitations feed name can be **reserved** for up to 15 minutes after permanent delete of the feed*
        """
        return pulumi.get(self, "features")

    @features.setter
    def features(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['FeedFeatureArgs']]]]):
        pulumi.set(self, "features", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the Feed.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the Project Feed is created in. If not specified, feed will be created at the organization level.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project_id", value)


@pulumi.input_type
class _FeedState:
    def __init__(__self__, *,
                 features: Optional[pulumi.Input[Sequence[pulumi.Input['FeedFeatureArgs']]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 project_id: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering Feed resources.
        :param pulumi.Input[Sequence[pulumi.Input['FeedFeatureArgs']]] features: A `features` blocks as documented below.
               
               > **Note** *Because of ADO limitations feed name can be **reserved** for up to 15 minutes after permanent delete of the feed*
        :param pulumi.Input[str] name: The name of the Feed.
        :param pulumi.Input[str] project_id: The ID of the Project Feed is created in. If not specified, feed will be created at the organization level.
        """
        if features is not None:
            pulumi.set(__self__, "features", features)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)

    @property
    @pulumi.getter
    def features(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['FeedFeatureArgs']]]]:
        """
        A `features` blocks as documented below.

        > **Note** *Because of ADO limitations feed name can be **reserved** for up to 15 minutes after permanent delete of the feed*
        """
        return pulumi.get(self, "features")

    @features.setter
    def features(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['FeedFeatureArgs']]]]):
        pulumi.set(self, "features", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the Feed.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the Project Feed is created in. If not specified, feed will be created at the organization level.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project_id", value)


class Feed(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 features: Optional[pulumi.Input[Sequence[pulumi.Input[Union['FeedFeatureArgs', 'FeedFeatureArgsDict']]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 project_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Manages creation of the Feed within Azure DevOps organization.

        ## Example Usage

        ### Create Feed in the scope of whole Organization
        ```python
        import pulumi
        import pulumi_azuredevops as azuredevops

        example = azuredevops.Feed("example", name="releases")
        ```

        ### Create Feed in the scope of a Project
        ```python
        import pulumi
        import pulumi_azuredevops as azuredevops

        example = azuredevops.Project("example",
            name="Example Project",
            visibility="private",
            version_control="Git",
            work_item_template="Agile",
            description="Managed by Pulumi")
        example_feed = azuredevops.Feed("example",
            name="releases",
            project_id=example.id)
        ```

        ### Create Feed with Soft Delete
        ```python
        import pulumi
        import pulumi_azuredevops as azuredevops

        example = azuredevops.Feed("example",
            name="releases",
            features=[{
                "permanent_delete": False,
            }])
        ```

        ## Relevant Links

        - [Azure DevOps Service REST API 7.0 - Feed Management](https://learn.microsoft.com/en-us/rest/api/azure/devops/artifacts/feed-management?view=azure-devops-rest-7.0)

        ## Import

        Azure DevOps Feed can be imported using the Project ID and Feed ID or Feed ID e.g.:

        ```sh
        $ pulumi import azuredevops:index/feed:Feed example 00000000-0000-0000-0000-000000000000/00000000-0000-0000-0000-000000000000
        ```

        or

        ```sh
        $ pulumi import azuredevops:index/feed:Feed example 00000000-0000-0000-0000-000000000000
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['FeedFeatureArgs', 'FeedFeatureArgsDict']]]] features: A `features` blocks as documented below.
               
               > **Note** *Because of ADO limitations feed name can be **reserved** for up to 15 minutes after permanent delete of the feed*
        :param pulumi.Input[str] name: The name of the Feed.
        :param pulumi.Input[str] project_id: The ID of the Project Feed is created in. If not specified, feed will be created at the organization level.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[FeedArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages creation of the Feed within Azure DevOps organization.

        ## Example Usage

        ### Create Feed in the scope of whole Organization
        ```python
        import pulumi
        import pulumi_azuredevops as azuredevops

        example = azuredevops.Feed("example", name="releases")
        ```

        ### Create Feed in the scope of a Project
        ```python
        import pulumi
        import pulumi_azuredevops as azuredevops

        example = azuredevops.Project("example",
            name="Example Project",
            visibility="private",
            version_control="Git",
            work_item_template="Agile",
            description="Managed by Pulumi")
        example_feed = azuredevops.Feed("example",
            name="releases",
            project_id=example.id)
        ```

        ### Create Feed with Soft Delete
        ```python
        import pulumi
        import pulumi_azuredevops as azuredevops

        example = azuredevops.Feed("example",
            name="releases",
            features=[{
                "permanent_delete": False,
            }])
        ```

        ## Relevant Links

        - [Azure DevOps Service REST API 7.0 - Feed Management](https://learn.microsoft.com/en-us/rest/api/azure/devops/artifacts/feed-management?view=azure-devops-rest-7.0)

        ## Import

        Azure DevOps Feed can be imported using the Project ID and Feed ID or Feed ID e.g.:

        ```sh
        $ pulumi import azuredevops:index/feed:Feed example 00000000-0000-0000-0000-000000000000/00000000-0000-0000-0000-000000000000
        ```

        or

        ```sh
        $ pulumi import azuredevops:index/feed:Feed example 00000000-0000-0000-0000-000000000000
        ```

        :param str resource_name: The name of the resource.
        :param FeedArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(FeedArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 features: Optional[pulumi.Input[Sequence[pulumi.Input[Union['FeedFeatureArgs', 'FeedFeatureArgsDict']]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 project_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = FeedArgs.__new__(FeedArgs)

            __props__.__dict__["features"] = features
            __props__.__dict__["name"] = name
            __props__.__dict__["project_id"] = project_id
        super(Feed, __self__).__init__(
            'azuredevops:index/feed:Feed',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            features: Optional[pulumi.Input[Sequence[pulumi.Input[Union['FeedFeatureArgs', 'FeedFeatureArgsDict']]]]] = None,
            name: Optional[pulumi.Input[str]] = None,
            project_id: Optional[pulumi.Input[str]] = None) -> 'Feed':
        """
        Get an existing Feed resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['FeedFeatureArgs', 'FeedFeatureArgsDict']]]] features: A `features` blocks as documented below.
               
               > **Note** *Because of ADO limitations feed name can be **reserved** for up to 15 minutes after permanent delete of the feed*
        :param pulumi.Input[str] name: The name of the Feed.
        :param pulumi.Input[str] project_id: The ID of the Project Feed is created in. If not specified, feed will be created at the organization level.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _FeedState.__new__(_FeedState)

        __props__.__dict__["features"] = features
        __props__.__dict__["name"] = name
        __props__.__dict__["project_id"] = project_id
        return Feed(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def features(self) -> pulumi.Output[Optional[Sequence['outputs.FeedFeature']]]:
        """
        A `features` blocks as documented below.

        > **Note** *Because of ADO limitations feed name can be **reserved** for up to 15 minutes after permanent delete of the feed*
        """
        return pulumi.get(self, "features")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The name of the Feed.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Output[Optional[str]]:
        """
        The ID of the Project Feed is created in. If not specified, feed will be created at the organization level.
        """
        return pulumi.get(self, "project_id")

