# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = [
    'GetFeedResult',
    'AwaitableGetFeedResult',
    'get_feed',
    'get_feed_output',
]

@pulumi.output_type
class GetFeedResult:
    """
    A collection of values returned by getFeed.
    """
    def __init__(__self__, feed_id=None, id=None, name=None, project_id=None):
        if feed_id and not isinstance(feed_id, str):
            raise TypeError("Expected argument 'feed_id' to be a str")
        pulumi.set(__self__, "feed_id", feed_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if project_id and not isinstance(project_id, str):
            raise TypeError("Expected argument 'project_id' to be a str")
        pulumi.set(__self__, "project_id", project_id)

    @property
    @pulumi.getter(name="feedId")
    def feed_id(self) -> Optional[str]:
        """
        The ID of the Feed.
        """
        return pulumi.get(self, "feed_id")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        The name of the Feed.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[str]:
        """
        The ID of the Project.
        """
        return pulumi.get(self, "project_id")


class AwaitableGetFeedResult(GetFeedResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetFeedResult(
            feed_id=self.feed_id,
            id=self.id,
            name=self.name,
            project_id=self.project_id)


def get_feed(feed_id: Optional[str] = None,
             name: Optional[str] = None,
             project_id: Optional[str] = None,
             opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetFeedResult:
    """
    Use this data source to access information about existing Feed within a given project in Azure DevOps.

    ## Example Usage

    ### Basic Example
    ```python
    import pulumi
    import pulumi_azuredevops as azuredevops

    example = azuredevops.get_feed(name="releases")
    ```

    ### Access feed within a project
    ```python
    import pulumi
    import pulumi_azuredevops as azuredevops

    example = azuredevops.get_project(name="Example Project")
    example_get_feed = azuredevops.get_feed(name="releases",
        project_id=example.id)
    ```

    ## Relevant Links

    - [Azure DevOps Service REST API 7.0 - Feed - Get](https://learn.microsoft.com/en-us/rest/api/azure/devops/artifacts/feed-management/get-feed?view=azure-devops-rest-7.0)


    :param str feed_id: ID of the Feed.
           
           > **Note** Only one of `name` or `feed_id` can be set at the same time.
    :param str name: Name of the Feed.
    :param str project_id: ID of the Project Feed is created in.
    """
    __args__ = dict()
    __args__['feedId'] = feed_id
    __args__['name'] = name
    __args__['projectId'] = project_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('azuredevops:index/getFeed:getFeed', __args__, opts=opts, typ=GetFeedResult).value

    return AwaitableGetFeedResult(
        feed_id=pulumi.get(__ret__, 'feed_id'),
        id=pulumi.get(__ret__, 'id'),
        name=pulumi.get(__ret__, 'name'),
        project_id=pulumi.get(__ret__, 'project_id'))
def get_feed_output(feed_id: Optional[pulumi.Input[Optional[str]]] = None,
                    name: Optional[pulumi.Input[Optional[str]]] = None,
                    project_id: Optional[pulumi.Input[Optional[str]]] = None,
                    opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetFeedResult]:
    """
    Use this data source to access information about existing Feed within a given project in Azure DevOps.

    ## Example Usage

    ### Basic Example
    ```python
    import pulumi
    import pulumi_azuredevops as azuredevops

    example = azuredevops.get_feed(name="releases")
    ```

    ### Access feed within a project
    ```python
    import pulumi
    import pulumi_azuredevops as azuredevops

    example = azuredevops.get_project(name="Example Project")
    example_get_feed = azuredevops.get_feed(name="releases",
        project_id=example.id)
    ```

    ## Relevant Links

    - [Azure DevOps Service REST API 7.0 - Feed - Get](https://learn.microsoft.com/en-us/rest/api/azure/devops/artifacts/feed-management/get-feed?view=azure-devops-rest-7.0)


    :param str feed_id: ID of the Feed.
           
           > **Note** Only one of `name` or `feed_id` can be set at the same time.
    :param str name: Name of the Feed.
    :param str project_id: ID of the Project Feed is created in.
    """
    __args__ = dict()
    __args__['feedId'] = feed_id
    __args__['name'] = name
    __args__['projectId'] = project_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('azuredevops:index/getFeed:getFeed', __args__, opts=opts, typ=GetFeedResult)
    return __ret__.apply(lambda __response__: GetFeedResult(
        feed_id=pulumi.get(__response__, 'feed_id'),
        id=pulumi.get(__response__, 'id'),
        name=pulumi.get(__response__, 'name'),
        project_id=pulumi.get(__response__, 'project_id')))
