# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetSecurityroleDefinitionsResult',
    'AwaitableGetSecurityroleDefinitionsResult',
    'get_securityrole_definitions',
    'get_securityrole_definitions_output',
]

@pulumi.output_type
class GetSecurityroleDefinitionsResult:
    """
    A collection of values returned by getSecurityroleDefinitions.
    """
    def __init__(__self__, definitions=None, id=None, scope=None):
        if definitions and not isinstance(definitions, list):
            raise TypeError("Expected argument 'definitions' to be a list")
        pulumi.set(__self__, "definitions", definitions)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if scope and not isinstance(scope, str):
            raise TypeError("Expected argument 'scope' to be a str")
        pulumi.set(__self__, "scope", scope)

    @property
    @pulumi.getter
    def definitions(self) -> Sequence['outputs.GetSecurityroleDefinitionsDefinitionResult']:
        """
        A list of existing Security Role Definitions in a Scope in your Azure DevOps Organization with details about every definition which includes. A `definitions` block as defined below.
        """
        return pulumi.get(self, "definitions")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def scope(self) -> str:
        """
        The scope of the Security Role Definition.
        """
        return pulumi.get(self, "scope")


class AwaitableGetSecurityroleDefinitionsResult(GetSecurityroleDefinitionsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetSecurityroleDefinitionsResult(
            definitions=self.definitions,
            id=self.id,
            scope=self.scope)


def get_securityrole_definitions(scope: Optional[str] = None,
                                 opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetSecurityroleDefinitionsResult:
    """
    Use this data source to access information about existing Security Role Definitions within a given scope in Azure DevOps.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_azuredevops as azuredevops

    example = azuredevops.get_securityrole_definitions(scope="distributedtask.environmentreferencerole")
    pulumi.export("securityroleDefinitions", example_aazuredevops_securityrole_definitions["definitions"])
    ```

    ## Relevant Links

    - [Azure DevOps Service REST API 7.0 - Roledefinitions - List](https://learn.microsoft.com/en-us/rest/api/azure/devops/securityroles/roledefinitions/list?view=azure-devops-rest-7.1)


    :param str scope: Name of the Scope for which Security Role Definitions will be returned.
           
           DataSource without specifying any arguments will return all projects.
    """
    __args__ = dict()
    __args__['scope'] = scope
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('azuredevops:index/getSecurityroleDefinitions:getSecurityroleDefinitions', __args__, opts=opts, typ=GetSecurityroleDefinitionsResult).value

    return AwaitableGetSecurityroleDefinitionsResult(
        definitions=pulumi.get(__ret__, 'definitions'),
        id=pulumi.get(__ret__, 'id'),
        scope=pulumi.get(__ret__, 'scope'))
def get_securityrole_definitions_output(scope: Optional[pulumi.Input[str]] = None,
                                        opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetSecurityroleDefinitionsResult]:
    """
    Use this data source to access information about existing Security Role Definitions within a given scope in Azure DevOps.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_azuredevops as azuredevops

    example = azuredevops.get_securityrole_definitions(scope="distributedtask.environmentreferencerole")
    pulumi.export("securityroleDefinitions", example_aazuredevops_securityrole_definitions["definitions"])
    ```

    ## Relevant Links

    - [Azure DevOps Service REST API 7.0 - Roledefinitions - List](https://learn.microsoft.com/en-us/rest/api/azure/devops/securityroles/roledefinitions/list?view=azure-devops-rest-7.1)


    :param str scope: Name of the Scope for which Security Role Definitions will be returned.
           
           DataSource without specifying any arguments will return all projects.
    """
    __args__ = dict()
    __args__['scope'] = scope
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('azuredevops:index/getSecurityroleDefinitions:getSecurityroleDefinitions', __args__, opts=opts, typ=GetSecurityroleDefinitionsResult)
    return __ret__.apply(lambda __response__: GetSecurityroleDefinitionsResult(
        definitions=pulumi.get(__response__, 'definitions'),
        id=pulumi.get(__response__, 'id'),
        scope=pulumi.get(__response__, 'scope')))
