# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'BranchPolicyAutoReviewersSettings',
    'BranchPolicyAutoReviewersSettingsScope',
    'BranchPolicyBuildValidationSettings',
    'BranchPolicyBuildValidationSettingsScope',
    'BranchPolicyCommentResolutionSettings',
    'BranchPolicyCommentResolutionSettingsScope',
    'BranchPolicyMergeTypesSettings',
    'BranchPolicyMergeTypesSettingsScope',
    'BranchPolicyMinReviewersSettings',
    'BranchPolicyMinReviewersSettingsScope',
    'BranchPolicyStatusCheckSettings',
    'BranchPolicyStatusCheckSettingsScope',
    'BranchPolicyWorkItemLinkingSettings',
    'BranchPolicyWorkItemLinkingSettingsScope',
    'BuildDefinitionBuildCompletionTrigger',
    'BuildDefinitionBuildCompletionTriggerBranchFilter',
    'BuildDefinitionCiTrigger',
    'BuildDefinitionCiTriggerOverride',
    'BuildDefinitionCiTriggerOverrideBranchFilter',
    'BuildDefinitionCiTriggerOverridePathFilter',
    'BuildDefinitionFeature',
    'BuildDefinitionPullRequestTrigger',
    'BuildDefinitionPullRequestTriggerForks',
    'BuildDefinitionPullRequestTriggerOverride',
    'BuildDefinitionPullRequestTriggerOverrideBranchFilter',
    'BuildDefinitionPullRequestTriggerOverridePathFilter',
    'BuildDefinitionRepository',
    'BuildDefinitionSchedule',
    'BuildDefinitionScheduleBranchFilter',
    'BuildDefinitionVariable',
    'CheckRequiredTemplateRequiredTemplate',
    'FeedFeature',
    'GitInitialization',
    'ServiceEndpointArtifactoryAuthenticationBasic',
    'ServiceEndpointArtifactoryAuthenticationToken',
    'ServiceEndpointAzureEcrCredentials',
    'ServiceEndpointAzureRMCredentials',
    'ServiceEndpointAzureRMFeatures',
    'ServiceEndpointGitHubAuthOauth',
    'ServiceEndpointGitHubAuthPersonal',
    'ServiceEndpointGitHubEnterpriseAuthPersonal',
    'ServiceEndpointKubernetesAzureSubscription',
    'ServiceEndpointKubernetesKubeconfig',
    'ServiceEndpointKubernetesServiceAccount',
    'ServiceEndpointPipelineAuthPersonal',
    'ServiceEndpointServiceFabricAzureActiveDirectory',
    'ServiceEndpointServiceFabricCertificate',
    'ServiceEndpointServiceFabricNone',
    'ServiceendpointArgocdAuthenticationBasic',
    'ServiceendpointArgocdAuthenticationToken',
    'ServiceendpointExternaltfsAuthPersonal',
    'ServiceendpointJfrogArtifactoryV2AuthenticationBasic',
    'ServiceendpointJfrogArtifactoryV2AuthenticationToken',
    'ServiceendpointJfrogDistributionV2AuthenticationBasic',
    'ServiceendpointJfrogDistributionV2AuthenticationToken',
    'ServiceendpointJfrogPlatformV2AuthenticationBasic',
    'ServiceendpointJfrogPlatformV2AuthenticationToken',
    'ServiceendpointJfrogXrayV2AuthenticationBasic',
    'ServiceendpointJfrogXrayV2AuthenticationToken',
    'ServiceendpointMavenAuthenticationBasic',
    'ServiceendpointMavenAuthenticationToken',
    'ServiceendpointVisualstudiomarketplaceAuthenticationBasic',
    'ServiceendpointVisualstudiomarketplaceAuthenticationToken',
    'ServicehookStorageQueuePipelinesRunStateChangedEvent',
    'ServicehookStorageQueuePipelinesStageStateChangedEvent',
    'VariableGroupKeyVault',
    'VariableGroupVariable',
    'GetAreaChildrenResult',
    'GetBuildDefinitionCiTriggerResult',
    'GetBuildDefinitionCiTriggerOverrideResult',
    'GetBuildDefinitionCiTriggerOverrideBranchFilterResult',
    'GetBuildDefinitionCiTriggerOverridePathFilterResult',
    'GetBuildDefinitionPullRequestTriggerResult',
    'GetBuildDefinitionPullRequestTriggerForkResult',
    'GetBuildDefinitionPullRequestTriggerOverrideResult',
    'GetBuildDefinitionPullRequestTriggerOverrideBranchFilterResult',
    'GetBuildDefinitionPullRequestTriggerOverridePathFilterResult',
    'GetBuildDefinitionRepositoryResult',
    'GetBuildDefinitionScheduleResult',
    'GetBuildDefinitionScheduleBranchFilterResult',
    'GetBuildDefinitionVariableResult',
    'GetGroupsGroupResult',
    'GetIdentityGroupsGroupResult',
    'GetIterationChildrenResult',
    'GetPoolsAgentPoolResult',
    'GetProjectsProjectResult',
    'GetRepositoriesRepositoryResult',
    'GetSecurityroleDefinitionsDefinitionResult',
    'GetTeamsTeamResult',
    'GetUsersFeaturesResult',
    'GetUsersUserResult',
    'GetVariableGroupKeyVaultResult',
    'GetVariableGroupVariableResult',
]

@pulumi.output_type
class BranchPolicyAutoReviewersSettings(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "autoReviewerIds":
            suggest = "auto_reviewer_ids"
        elif key == "minimumNumberOfReviewers":
            suggest = "minimum_number_of_reviewers"
        elif key == "pathFilters":
            suggest = "path_filters"
        elif key == "submitterCanVote":
            suggest = "submitter_can_vote"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BranchPolicyAutoReviewersSettings. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BranchPolicyAutoReviewersSettings.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BranchPolicyAutoReviewersSettings.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 auto_reviewer_ids: Sequence[str],
                 scopes: Sequence['outputs.BranchPolicyAutoReviewersSettingsScope'],
                 message: Optional[str] = None,
                 minimum_number_of_reviewers: Optional[int] = None,
                 path_filters: Optional[Sequence[str]] = None,
                 submitter_can_vote: Optional[bool] = None):
        """
        :param Sequence[str] auto_reviewer_ids: Required reviewers ids. Supports multiples user Ids.
        :param Sequence['BranchPolicyAutoReviewersSettingsScopeArgs'] scopes: Controls which repositories and branches the policy will be enabled for. This block must be defined at least once.
        :param str message: Activity feed message, Message will appear in the activity feed of pull requests with automatically added reviewers.
        :param int minimum_number_of_reviewers: Minimum number of required reviewers. Defaults to `1`.
               
               > **Note** Has to be greater than `0`. Can only be greater than `1` when attribute `auto_reviewer_ids` contains exactly one group! Only has an effect when attribute `blocking` is set to `true`.
        :param Sequence[str] path_filters: Filter path(s) on which the policy is applied. Supports absolute paths, wildcards and multiple paths. Example: /WebApp/Models/Data.cs, /WebApp/* or *.cs,/WebApp/Models/Data.cs;ClientApp/Models/Data.cs.
        :param bool submitter_can_vote: Controls whether or not the submitter's vote counts. Defaults to `false`.
        """
        pulumi.set(__self__, "auto_reviewer_ids", auto_reviewer_ids)
        pulumi.set(__self__, "scopes", scopes)
        if message is not None:
            pulumi.set(__self__, "message", message)
        if minimum_number_of_reviewers is not None:
            pulumi.set(__self__, "minimum_number_of_reviewers", minimum_number_of_reviewers)
        if path_filters is not None:
            pulumi.set(__self__, "path_filters", path_filters)
        if submitter_can_vote is not None:
            pulumi.set(__self__, "submitter_can_vote", submitter_can_vote)

    @property
    @pulumi.getter(name="autoReviewerIds")
    def auto_reviewer_ids(self) -> Sequence[str]:
        """
        Required reviewers ids. Supports multiples user Ids.
        """
        return pulumi.get(self, "auto_reviewer_ids")

    @property
    @pulumi.getter
    def scopes(self) -> Sequence['outputs.BranchPolicyAutoReviewersSettingsScope']:
        """
        Controls which repositories and branches the policy will be enabled for. This block must be defined at least once.
        """
        return pulumi.get(self, "scopes")

    @property
    @pulumi.getter
    def message(self) -> Optional[str]:
        """
        Activity feed message, Message will appear in the activity feed of pull requests with automatically added reviewers.
        """
        return pulumi.get(self, "message")

    @property
    @pulumi.getter(name="minimumNumberOfReviewers")
    def minimum_number_of_reviewers(self) -> Optional[int]:
        """
        Minimum number of required reviewers. Defaults to `1`.

        > **Note** Has to be greater than `0`. Can only be greater than `1` when attribute `auto_reviewer_ids` contains exactly one group! Only has an effect when attribute `blocking` is set to `true`.
        """
        return pulumi.get(self, "minimum_number_of_reviewers")

    @property
    @pulumi.getter(name="pathFilters")
    def path_filters(self) -> Optional[Sequence[str]]:
        """
        Filter path(s) on which the policy is applied. Supports absolute paths, wildcards and multiple paths. Example: /WebApp/Models/Data.cs, /WebApp/* or *.cs,/WebApp/Models/Data.cs;ClientApp/Models/Data.cs.
        """
        return pulumi.get(self, "path_filters")

    @property
    @pulumi.getter(name="submitterCanVote")
    def submitter_can_vote(self) -> Optional[bool]:
        """
        Controls whether or not the submitter's vote counts. Defaults to `false`.
        """
        return pulumi.get(self, "submitter_can_vote")


@pulumi.output_type
class BranchPolicyAutoReviewersSettingsScope(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "matchType":
            suggest = "match_type"
        elif key == "repositoryId":
            suggest = "repository_id"
        elif key == "repositoryRef":
            suggest = "repository_ref"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BranchPolicyAutoReviewersSettingsScope. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BranchPolicyAutoReviewersSettingsScope.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BranchPolicyAutoReviewersSettingsScope.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 match_type: Optional[str] = None,
                 repository_id: Optional[str] = None,
                 repository_ref: Optional[str] = None):
        """
        :param str match_type: The match type to use when applying the policy. Supported values are `Exact` (default), `Prefix` or `DefaultBranch`.
        :param str repository_id: The repository ID. Needed only if the scope of the policy will be limited to a single repository. If `match_type` is `DefaultBranch`, this should not be defined.
        :param str repository_ref: The ref pattern to use for the match when `match_type` other than `DefaultBranch`. If `match_type` is `Exact`, this should be a qualified ref such as `refs/heads/master`. If `match_type` is `Prefix`, this should be a ref path such as `refs/heads/releases`.
        """
        if match_type is not None:
            pulumi.set(__self__, "match_type", match_type)
        if repository_id is not None:
            pulumi.set(__self__, "repository_id", repository_id)
        if repository_ref is not None:
            pulumi.set(__self__, "repository_ref", repository_ref)

    @property
    @pulumi.getter(name="matchType")
    def match_type(self) -> Optional[str]:
        """
        The match type to use when applying the policy. Supported values are `Exact` (default), `Prefix` or `DefaultBranch`.
        """
        return pulumi.get(self, "match_type")

    @property
    @pulumi.getter(name="repositoryId")
    def repository_id(self) -> Optional[str]:
        """
        The repository ID. Needed only if the scope of the policy will be limited to a single repository. If `match_type` is `DefaultBranch`, this should not be defined.
        """
        return pulumi.get(self, "repository_id")

    @property
    @pulumi.getter(name="repositoryRef")
    def repository_ref(self) -> Optional[str]:
        """
        The ref pattern to use for the match when `match_type` other than `DefaultBranch`. If `match_type` is `Exact`, this should be a qualified ref such as `refs/heads/master`. If `match_type` is `Prefix`, this should be a ref path such as `refs/heads/releases`.
        """
        return pulumi.get(self, "repository_ref")


@pulumi.output_type
class BranchPolicyBuildValidationSettings(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "buildDefinitionId":
            suggest = "build_definition_id"
        elif key == "displayName":
            suggest = "display_name"
        elif key == "filenamePatterns":
            suggest = "filename_patterns"
        elif key == "manualQueueOnly":
            suggest = "manual_queue_only"
        elif key == "queueOnSourceUpdateOnly":
            suggest = "queue_on_source_update_only"
        elif key == "validDuration":
            suggest = "valid_duration"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BranchPolicyBuildValidationSettings. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BranchPolicyBuildValidationSettings.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BranchPolicyBuildValidationSettings.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 build_definition_id: int,
                 display_name: str,
                 scopes: Sequence['outputs.BranchPolicyBuildValidationSettingsScope'],
                 filename_patterns: Optional[Sequence[str]] = None,
                 manual_queue_only: Optional[bool] = None,
                 queue_on_source_update_only: Optional[bool] = None,
                 valid_duration: Optional[int] = None):
        """
        :param int build_definition_id: The ID of the build to monitor for the policy.
        :param str display_name: The display name for the policy.
        :param Sequence['BranchPolicyBuildValidationSettingsScopeArgs'] scopes: Controls which repositories and branches the policy will be enabled for. This block must be defined at least once.
        :param Sequence[str] filename_patterns: If a path filter is set, the policy will only apply when files which match the filter are changes. Not setting this field means that the policy will always apply. You can specify absolute paths and wildcards. Example: `["/WebApp/Models/Data.cs", "/WebApp/*", "*.cs"]`. Paths prefixed with "!" are excluded. Example: `["/WebApp/*", "!/WebApp/Tests/*"]`. Order is significant.
        :param bool manual_queue_only: If set to true, the build will need to be manually queued. Defaults to `false`
        :param bool queue_on_source_update_only: True if the build should queue on source updates only. Defaults to `true`.
        :param int valid_duration: The number of minutes for which the build is valid. If `0`, the build will not expire. Defaults to `720` (12 hours).
               
               > **Note** Combine `valid_duration` and `queue_on_source_update_only` to set the build expiration.
               1.  Expire immediately when branch is updated: `valid_duration=0` and `queue_on_source_update_only=false`
               2.  Expire after a period of time : `valid_duration=360` and `queue_on_source_update_only=true`
               3.  Never expire: `valid_duration=0` and `queue_on_source_update_only=true`
        """
        pulumi.set(__self__, "build_definition_id", build_definition_id)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "scopes", scopes)
        if filename_patterns is not None:
            pulumi.set(__self__, "filename_patterns", filename_patterns)
        if manual_queue_only is not None:
            pulumi.set(__self__, "manual_queue_only", manual_queue_only)
        if queue_on_source_update_only is not None:
            pulumi.set(__self__, "queue_on_source_update_only", queue_on_source_update_only)
        if valid_duration is not None:
            pulumi.set(__self__, "valid_duration", valid_duration)

    @property
    @pulumi.getter(name="buildDefinitionId")
    def build_definition_id(self) -> int:
        """
        The ID of the build to monitor for the policy.
        """
        return pulumi.get(self, "build_definition_id")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        The display name for the policy.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def scopes(self) -> Sequence['outputs.BranchPolicyBuildValidationSettingsScope']:
        """
        Controls which repositories and branches the policy will be enabled for. This block must be defined at least once.
        """
        return pulumi.get(self, "scopes")

    @property
    @pulumi.getter(name="filenamePatterns")
    def filename_patterns(self) -> Optional[Sequence[str]]:
        """
        If a path filter is set, the policy will only apply when files which match the filter are changes. Not setting this field means that the policy will always apply. You can specify absolute paths and wildcards. Example: `["/WebApp/Models/Data.cs", "/WebApp/*", "*.cs"]`. Paths prefixed with "!" are excluded. Example: `["/WebApp/*", "!/WebApp/Tests/*"]`. Order is significant.
        """
        return pulumi.get(self, "filename_patterns")

    @property
    @pulumi.getter(name="manualQueueOnly")
    def manual_queue_only(self) -> Optional[bool]:
        """
        If set to true, the build will need to be manually queued. Defaults to `false`
        """
        return pulumi.get(self, "manual_queue_only")

    @property
    @pulumi.getter(name="queueOnSourceUpdateOnly")
    def queue_on_source_update_only(self) -> Optional[bool]:
        """
        True if the build should queue on source updates only. Defaults to `true`.
        """
        return pulumi.get(self, "queue_on_source_update_only")

    @property
    @pulumi.getter(name="validDuration")
    def valid_duration(self) -> Optional[int]:
        """
        The number of minutes for which the build is valid. If `0`, the build will not expire. Defaults to `720` (12 hours).

        > **Note** Combine `valid_duration` and `queue_on_source_update_only` to set the build expiration.
        1.  Expire immediately when branch is updated: `valid_duration=0` and `queue_on_source_update_only=false`
        2.  Expire after a period of time : `valid_duration=360` and `queue_on_source_update_only=true`
        3.  Never expire: `valid_duration=0` and `queue_on_source_update_only=true`
        """
        return pulumi.get(self, "valid_duration")


@pulumi.output_type
class BranchPolicyBuildValidationSettingsScope(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "matchType":
            suggest = "match_type"
        elif key == "repositoryId":
            suggest = "repository_id"
        elif key == "repositoryRef":
            suggest = "repository_ref"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BranchPolicyBuildValidationSettingsScope. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BranchPolicyBuildValidationSettingsScope.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BranchPolicyBuildValidationSettingsScope.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 match_type: Optional[str] = None,
                 repository_id: Optional[str] = None,
                 repository_ref: Optional[str] = None):
        """
        :param str match_type: The match type to use when applying the policy. Supported values are `Exact` (default), `Prefix` or `DefaultBranch`.
        :param str repository_id: The repository ID. Needed only if the scope of the policy will be limited to a single repository. If `match_type` is `DefaultBranch`, this should not be defined.
        :param str repository_ref: The ref pattern to use for the match when `match_type` other than `DefaultBranch`. If `match_type` is `Exact`, this should be a qualified ref such as `refs/heads/master`. If `match_type` is `Prefix`, this should be a ref path such as `refs/heads/releases`.
        """
        if match_type is not None:
            pulumi.set(__self__, "match_type", match_type)
        if repository_id is not None:
            pulumi.set(__self__, "repository_id", repository_id)
        if repository_ref is not None:
            pulumi.set(__self__, "repository_ref", repository_ref)

    @property
    @pulumi.getter(name="matchType")
    def match_type(self) -> Optional[str]:
        """
        The match type to use when applying the policy. Supported values are `Exact` (default), `Prefix` or `DefaultBranch`.
        """
        return pulumi.get(self, "match_type")

    @property
    @pulumi.getter(name="repositoryId")
    def repository_id(self) -> Optional[str]:
        """
        The repository ID. Needed only if the scope of the policy will be limited to a single repository. If `match_type` is `DefaultBranch`, this should not be defined.
        """
        return pulumi.get(self, "repository_id")

    @property
    @pulumi.getter(name="repositoryRef")
    def repository_ref(self) -> Optional[str]:
        """
        The ref pattern to use for the match when `match_type` other than `DefaultBranch`. If `match_type` is `Exact`, this should be a qualified ref such as `refs/heads/master`. If `match_type` is `Prefix`, this should be a ref path such as `refs/heads/releases`.
        """
        return pulumi.get(self, "repository_ref")


@pulumi.output_type
class BranchPolicyCommentResolutionSettings(dict):
    def __init__(__self__, *,
                 scopes: Sequence['outputs.BranchPolicyCommentResolutionSettingsScope']):
        """
        :param Sequence['BranchPolicyCommentResolutionSettingsScopeArgs'] scopes: Controls which repositories and branches the policy will be enabled for. This block must be defined at least once.
        """
        pulumi.set(__self__, "scopes", scopes)

    @property
    @pulumi.getter
    def scopes(self) -> Sequence['outputs.BranchPolicyCommentResolutionSettingsScope']:
        """
        Controls which repositories and branches the policy will be enabled for. This block must be defined at least once.
        """
        return pulumi.get(self, "scopes")


@pulumi.output_type
class BranchPolicyCommentResolutionSettingsScope(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "matchType":
            suggest = "match_type"
        elif key == "repositoryId":
            suggest = "repository_id"
        elif key == "repositoryRef":
            suggest = "repository_ref"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BranchPolicyCommentResolutionSettingsScope. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BranchPolicyCommentResolutionSettingsScope.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BranchPolicyCommentResolutionSettingsScope.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 match_type: Optional[str] = None,
                 repository_id: Optional[str] = None,
                 repository_ref: Optional[str] = None):
        """
        :param str match_type: The match type to use when applying the policy. Supported values are `Exact` (default), `Prefix` or `DefaultBranch`.
        :param str repository_id: The repository ID. Needed only if the scope of the policy will be limited to a single repository. If `match_type` is `DefaultBranch`, this should not be defined.
        :param str repository_ref: The ref pattern to use for the match when `match_type` other than `DefaultBranch`. If `match_type` is `Exact`, this should be a qualified ref such as `refs/heads/master`. If `match_type` is `Prefix`, this should be a ref path such as `refs/heads/releases`.
        """
        if match_type is not None:
            pulumi.set(__self__, "match_type", match_type)
        if repository_id is not None:
            pulumi.set(__self__, "repository_id", repository_id)
        if repository_ref is not None:
            pulumi.set(__self__, "repository_ref", repository_ref)

    @property
    @pulumi.getter(name="matchType")
    def match_type(self) -> Optional[str]:
        """
        The match type to use when applying the policy. Supported values are `Exact` (default), `Prefix` or `DefaultBranch`.
        """
        return pulumi.get(self, "match_type")

    @property
    @pulumi.getter(name="repositoryId")
    def repository_id(self) -> Optional[str]:
        """
        The repository ID. Needed only if the scope of the policy will be limited to a single repository. If `match_type` is `DefaultBranch`, this should not be defined.
        """
        return pulumi.get(self, "repository_id")

    @property
    @pulumi.getter(name="repositoryRef")
    def repository_ref(self) -> Optional[str]:
        """
        The ref pattern to use for the match when `match_type` other than `DefaultBranch`. If `match_type` is `Exact`, this should be a qualified ref such as `refs/heads/master`. If `match_type` is `Prefix`, this should be a ref path such as `refs/heads/releases`.
        """
        return pulumi.get(self, "repository_ref")


@pulumi.output_type
class BranchPolicyMergeTypesSettings(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "allowBasicNoFastForward":
            suggest = "allow_basic_no_fast_forward"
        elif key == "allowRebaseAndFastForward":
            suggest = "allow_rebase_and_fast_forward"
        elif key == "allowRebaseWithMerge":
            suggest = "allow_rebase_with_merge"
        elif key == "allowSquash":
            suggest = "allow_squash"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BranchPolicyMergeTypesSettings. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BranchPolicyMergeTypesSettings.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BranchPolicyMergeTypesSettings.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 scopes: Sequence['outputs.BranchPolicyMergeTypesSettingsScope'],
                 allow_basic_no_fast_forward: Optional[bool] = None,
                 allow_rebase_and_fast_forward: Optional[bool] = None,
                 allow_rebase_with_merge: Optional[bool] = None,
                 allow_squash: Optional[bool] = None):
        """
        :param Sequence['BranchPolicyMergeTypesSettingsScopeArgs'] scopes: Controls which repositories and branches the policy will be enabled for. This block must be defined at least once.
        :param bool allow_basic_no_fast_forward: Allow basic merge with no fast forward. Defaults to `false`.
        :param bool allow_rebase_and_fast_forward: Allow rebase with fast forward. Defaults to `false`.
        :param bool allow_rebase_with_merge: Allow rebase with merge commit. Defaults to `false`.
        :param bool allow_squash: Allow squash merge. Defaults to `false`
        """
        pulumi.set(__self__, "scopes", scopes)
        if allow_basic_no_fast_forward is not None:
            pulumi.set(__self__, "allow_basic_no_fast_forward", allow_basic_no_fast_forward)
        if allow_rebase_and_fast_forward is not None:
            pulumi.set(__self__, "allow_rebase_and_fast_forward", allow_rebase_and_fast_forward)
        if allow_rebase_with_merge is not None:
            pulumi.set(__self__, "allow_rebase_with_merge", allow_rebase_with_merge)
        if allow_squash is not None:
            pulumi.set(__self__, "allow_squash", allow_squash)

    @property
    @pulumi.getter
    def scopes(self) -> Sequence['outputs.BranchPolicyMergeTypesSettingsScope']:
        """
        Controls which repositories and branches the policy will be enabled for. This block must be defined at least once.
        """
        return pulumi.get(self, "scopes")

    @property
    @pulumi.getter(name="allowBasicNoFastForward")
    def allow_basic_no_fast_forward(self) -> Optional[bool]:
        """
        Allow basic merge with no fast forward. Defaults to `false`.
        """
        return pulumi.get(self, "allow_basic_no_fast_forward")

    @property
    @pulumi.getter(name="allowRebaseAndFastForward")
    def allow_rebase_and_fast_forward(self) -> Optional[bool]:
        """
        Allow rebase with fast forward. Defaults to `false`.
        """
        return pulumi.get(self, "allow_rebase_and_fast_forward")

    @property
    @pulumi.getter(name="allowRebaseWithMerge")
    def allow_rebase_with_merge(self) -> Optional[bool]:
        """
        Allow rebase with merge commit. Defaults to `false`.
        """
        return pulumi.get(self, "allow_rebase_with_merge")

    @property
    @pulumi.getter(name="allowSquash")
    def allow_squash(self) -> Optional[bool]:
        """
        Allow squash merge. Defaults to `false`
        """
        return pulumi.get(self, "allow_squash")


@pulumi.output_type
class BranchPolicyMergeTypesSettingsScope(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "matchType":
            suggest = "match_type"
        elif key == "repositoryId":
            suggest = "repository_id"
        elif key == "repositoryRef":
            suggest = "repository_ref"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BranchPolicyMergeTypesSettingsScope. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BranchPolicyMergeTypesSettingsScope.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BranchPolicyMergeTypesSettingsScope.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 match_type: Optional[str] = None,
                 repository_id: Optional[str] = None,
                 repository_ref: Optional[str] = None):
        """
        :param str match_type: The match type to use when applying the policy. Supported values are `Exact` (default), `Prefix` or `DefaultBranch`.
        :param str repository_id: The repository ID. Needed only if the scope of the policy will be limited to a single repository. If `match_type` is `DefaultBranch`, this should not be defined.
        :param str repository_ref: The ref pattern to use for the match when `match_type` other than `DefaultBranch`. If `match_type` is `Exact`, this should be a qualified ref such as `refs/heads/master`. If `match_type` is `Prefix`, this should be a ref path such as `refs/heads/releases`.
        """
        if match_type is not None:
            pulumi.set(__self__, "match_type", match_type)
        if repository_id is not None:
            pulumi.set(__self__, "repository_id", repository_id)
        if repository_ref is not None:
            pulumi.set(__self__, "repository_ref", repository_ref)

    @property
    @pulumi.getter(name="matchType")
    def match_type(self) -> Optional[str]:
        """
        The match type to use when applying the policy. Supported values are `Exact` (default), `Prefix` or `DefaultBranch`.
        """
        return pulumi.get(self, "match_type")

    @property
    @pulumi.getter(name="repositoryId")
    def repository_id(self) -> Optional[str]:
        """
        The repository ID. Needed only if the scope of the policy will be limited to a single repository. If `match_type` is `DefaultBranch`, this should not be defined.
        """
        return pulumi.get(self, "repository_id")

    @property
    @pulumi.getter(name="repositoryRef")
    def repository_ref(self) -> Optional[str]:
        """
        The ref pattern to use for the match when `match_type` other than `DefaultBranch`. If `match_type` is `Exact`, this should be a qualified ref such as `refs/heads/master`. If `match_type` is `Prefix`, this should be a ref path such as `refs/heads/releases`.
        """
        return pulumi.get(self, "repository_ref")


@pulumi.output_type
class BranchPolicyMinReviewersSettings(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "allowCompletionWithRejectsOrWaits":
            suggest = "allow_completion_with_rejects_or_waits"
        elif key == "lastPusherCannotApprove":
            suggest = "last_pusher_cannot_approve"
        elif key == "onLastIterationRequireVote":
            suggest = "on_last_iteration_require_vote"
        elif key == "onPushResetAllVotes":
            suggest = "on_push_reset_all_votes"
        elif key == "onPushResetApprovedVotes":
            suggest = "on_push_reset_approved_votes"
        elif key == "reviewerCount":
            suggest = "reviewer_count"
        elif key == "submitterCanVote":
            suggest = "submitter_can_vote"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BranchPolicyMinReviewersSettings. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BranchPolicyMinReviewersSettings.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BranchPolicyMinReviewersSettings.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 scopes: Sequence['outputs.BranchPolicyMinReviewersSettingsScope'],
                 allow_completion_with_rejects_or_waits: Optional[bool] = None,
                 last_pusher_cannot_approve: Optional[bool] = None,
                 on_last_iteration_require_vote: Optional[bool] = None,
                 on_push_reset_all_votes: Optional[bool] = None,
                 on_push_reset_approved_votes: Optional[bool] = None,
                 reviewer_count: Optional[int] = None,
                 submitter_can_vote: Optional[bool] = None):
        """
        :param Sequence['BranchPolicyMinReviewersSettingsScopeArgs'] scopes: A `scope` block as defined below. Controls which repositories and branches the policy will be enabled for. This block must be defined at least once.
        :param bool allow_completion_with_rejects_or_waits: Allow completion even if some reviewers vote to wait or reject. Defaults to `false`.
        :param bool last_pusher_cannot_approve: Prohibit the most recent pusher from approving their own changes. Defaults to `false`.
        :param bool on_last_iteration_require_vote: On last iteration require vote. Defaults to `false`.
        :param bool on_push_reset_all_votes: When new changes are pushed reset all code reviewer votes. Defaults to `false`.
               
               > **Note:** If `on_push_reset_all_votes` is `true` then `on_push_reset_approved_votes` will be set to `true`. To enable `on_push_reset_approved_votes`, you need explicitly set `on_push_reset_all_votes` `false` or not configure.
        :param bool on_push_reset_approved_votes: When new changes are pushed reset all approval votes (does not reset votes to reject or wait). Defaults to `false`.
        :param int reviewer_count: The number of reviewers needed to approve.
        :param bool submitter_can_vote: Allow requesters to approve their own changes. Defaults to `false`.
        """
        pulumi.set(__self__, "scopes", scopes)
        if allow_completion_with_rejects_or_waits is not None:
            pulumi.set(__self__, "allow_completion_with_rejects_or_waits", allow_completion_with_rejects_or_waits)
        if last_pusher_cannot_approve is not None:
            pulumi.set(__self__, "last_pusher_cannot_approve", last_pusher_cannot_approve)
        if on_last_iteration_require_vote is not None:
            pulumi.set(__self__, "on_last_iteration_require_vote", on_last_iteration_require_vote)
        if on_push_reset_all_votes is not None:
            pulumi.set(__self__, "on_push_reset_all_votes", on_push_reset_all_votes)
        if on_push_reset_approved_votes is not None:
            pulumi.set(__self__, "on_push_reset_approved_votes", on_push_reset_approved_votes)
        if reviewer_count is not None:
            pulumi.set(__self__, "reviewer_count", reviewer_count)
        if submitter_can_vote is not None:
            pulumi.set(__self__, "submitter_can_vote", submitter_can_vote)

    @property
    @pulumi.getter
    def scopes(self) -> Sequence['outputs.BranchPolicyMinReviewersSettingsScope']:
        """
        A `scope` block as defined below. Controls which repositories and branches the policy will be enabled for. This block must be defined at least once.
        """
        return pulumi.get(self, "scopes")

    @property
    @pulumi.getter(name="allowCompletionWithRejectsOrWaits")
    def allow_completion_with_rejects_or_waits(self) -> Optional[bool]:
        """
        Allow completion even if some reviewers vote to wait or reject. Defaults to `false`.
        """
        return pulumi.get(self, "allow_completion_with_rejects_or_waits")

    @property
    @pulumi.getter(name="lastPusherCannotApprove")
    def last_pusher_cannot_approve(self) -> Optional[bool]:
        """
        Prohibit the most recent pusher from approving their own changes. Defaults to `false`.
        """
        return pulumi.get(self, "last_pusher_cannot_approve")

    @property
    @pulumi.getter(name="onLastIterationRequireVote")
    def on_last_iteration_require_vote(self) -> Optional[bool]:
        """
        On last iteration require vote. Defaults to `false`.
        """
        return pulumi.get(self, "on_last_iteration_require_vote")

    @property
    @pulumi.getter(name="onPushResetAllVotes")
    def on_push_reset_all_votes(self) -> Optional[bool]:
        """
        When new changes are pushed reset all code reviewer votes. Defaults to `false`.

        > **Note:** If `on_push_reset_all_votes` is `true` then `on_push_reset_approved_votes` will be set to `true`. To enable `on_push_reset_approved_votes`, you need explicitly set `on_push_reset_all_votes` `false` or not configure.
        """
        return pulumi.get(self, "on_push_reset_all_votes")

    @property
    @pulumi.getter(name="onPushResetApprovedVotes")
    def on_push_reset_approved_votes(self) -> Optional[bool]:
        """
        When new changes are pushed reset all approval votes (does not reset votes to reject or wait). Defaults to `false`.
        """
        return pulumi.get(self, "on_push_reset_approved_votes")

    @property
    @pulumi.getter(name="reviewerCount")
    def reviewer_count(self) -> Optional[int]:
        """
        The number of reviewers needed to approve.
        """
        return pulumi.get(self, "reviewer_count")

    @property
    @pulumi.getter(name="submitterCanVote")
    def submitter_can_vote(self) -> Optional[bool]:
        """
        Allow requesters to approve their own changes. Defaults to `false`.
        """
        return pulumi.get(self, "submitter_can_vote")


@pulumi.output_type
class BranchPolicyMinReviewersSettingsScope(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "matchType":
            suggest = "match_type"
        elif key == "repositoryId":
            suggest = "repository_id"
        elif key == "repositoryRef":
            suggest = "repository_ref"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BranchPolicyMinReviewersSettingsScope. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BranchPolicyMinReviewersSettingsScope.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BranchPolicyMinReviewersSettingsScope.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 match_type: Optional[str] = None,
                 repository_id: Optional[str] = None,
                 repository_ref: Optional[str] = None):
        """
        :param str match_type: The match type to use when applying the policy. Supported values are `Exact` (default), `Prefix` or `DefaultBranch`.
        :param str repository_id: The repository ID. Needed only if the scope of the policy will be limited to a single repository. If `match_type` is `DefaultBranch`, this should not be defined.
        :param str repository_ref: The ref pattern to use for the match when `match_type` other than `DefaultBranch`. If `match_type` is `Exact`, this should be a qualified ref such as `refs/heads/master`. If `match_type` is `Prefix`, this should be a ref path such as `refs/heads/releases`.
        """
        if match_type is not None:
            pulumi.set(__self__, "match_type", match_type)
        if repository_id is not None:
            pulumi.set(__self__, "repository_id", repository_id)
        if repository_ref is not None:
            pulumi.set(__self__, "repository_ref", repository_ref)

    @property
    @pulumi.getter(name="matchType")
    def match_type(self) -> Optional[str]:
        """
        The match type to use when applying the policy. Supported values are `Exact` (default), `Prefix` or `DefaultBranch`.
        """
        return pulumi.get(self, "match_type")

    @property
    @pulumi.getter(name="repositoryId")
    def repository_id(self) -> Optional[str]:
        """
        The repository ID. Needed only if the scope of the policy will be limited to a single repository. If `match_type` is `DefaultBranch`, this should not be defined.
        """
        return pulumi.get(self, "repository_id")

    @property
    @pulumi.getter(name="repositoryRef")
    def repository_ref(self) -> Optional[str]:
        """
        The ref pattern to use for the match when `match_type` other than `DefaultBranch`. If `match_type` is `Exact`, this should be a qualified ref such as `refs/heads/master`. If `match_type` is `Prefix`, this should be a ref path such as `refs/heads/releases`.
        """
        return pulumi.get(self, "repository_ref")


@pulumi.output_type
class BranchPolicyStatusCheckSettings(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "authorId":
            suggest = "author_id"
        elif key == "displayName":
            suggest = "display_name"
        elif key == "filenamePatterns":
            suggest = "filename_patterns"
        elif key == "invalidateOnUpdate":
            suggest = "invalidate_on_update"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BranchPolicyStatusCheckSettings. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BranchPolicyStatusCheckSettings.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BranchPolicyStatusCheckSettings.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: str,
                 scopes: Sequence['outputs.BranchPolicyStatusCheckSettingsScope'],
                 applicability: Optional[str] = None,
                 author_id: Optional[str] = None,
                 display_name: Optional[str] = None,
                 filename_patterns: Optional[Sequence[str]] = None,
                 genre: Optional[str] = None,
                 invalidate_on_update: Optional[bool] = None):
        """
        :param str name: The status name to check.
        :param Sequence['BranchPolicyStatusCheckSettingsScopeArgs'] scopes: Controls which repositories and branches the policy will be enabled for. This block must be defined
               at least once.
        :param str applicability: Policy applicability. If policy `applicability` is `default`, apply unless "Not Applicable" 
               status is posted to the pull request. If policy `applicability` is `conditional`, policy is applied only after a status
               is posted to the pull request.
        :param str author_id: The authorized user can post the status.
        :param str display_name: The display name.
        :param Sequence[str] filename_patterns: If a path filter is set, the policy will only apply when files which match the filter are changes. Not setting this field means that the policy will always apply. You can specify absolute paths and wildcards. Example: `["/WebApp/Models/Data.cs", "/WebApp/*", "*.cs"]`. Paths prefixed with "!" are excluded. Example: `["/WebApp/*", "!/WebApp/Tests/*"]`. Order is significant.
        :param str genre: The genre of the status to check (see [Microsoft Documentation](https://docs.microsoft.com/en-us/azure/devops/repos/git/pull-request-status?view=azure-devops#status-policy))
        :param bool invalidate_on_update: Reset status whenever there are new changes.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "scopes", scopes)
        if applicability is not None:
            pulumi.set(__self__, "applicability", applicability)
        if author_id is not None:
            pulumi.set(__self__, "author_id", author_id)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if filename_patterns is not None:
            pulumi.set(__self__, "filename_patterns", filename_patterns)
        if genre is not None:
            pulumi.set(__self__, "genre", genre)
        if invalidate_on_update is not None:
            pulumi.set(__self__, "invalidate_on_update", invalidate_on_update)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The status name to check.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def scopes(self) -> Sequence['outputs.BranchPolicyStatusCheckSettingsScope']:
        """
        Controls which repositories and branches the policy will be enabled for. This block must be defined
        at least once.
        """
        return pulumi.get(self, "scopes")

    @property
    @pulumi.getter
    def applicability(self) -> Optional[str]:
        """
        Policy applicability. If policy `applicability` is `default`, apply unless "Not Applicable" 
        status is posted to the pull request. If policy `applicability` is `conditional`, policy is applied only after a status
        is posted to the pull request.
        """
        return pulumi.get(self, "applicability")

    @property
    @pulumi.getter(name="authorId")
    def author_id(self) -> Optional[str]:
        """
        The authorized user can post the status.
        """
        return pulumi.get(self, "author_id")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[str]:
        """
        The display name.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="filenamePatterns")
    def filename_patterns(self) -> Optional[Sequence[str]]:
        """
        If a path filter is set, the policy will only apply when files which match the filter are changes. Not setting this field means that the policy will always apply. You can specify absolute paths and wildcards. Example: `["/WebApp/Models/Data.cs", "/WebApp/*", "*.cs"]`. Paths prefixed with "!" are excluded. Example: `["/WebApp/*", "!/WebApp/Tests/*"]`. Order is significant.
        """
        return pulumi.get(self, "filename_patterns")

    @property
    @pulumi.getter
    def genre(self) -> Optional[str]:
        """
        The genre of the status to check (see [Microsoft Documentation](https://docs.microsoft.com/en-us/azure/devops/repos/git/pull-request-status?view=azure-devops#status-policy))
        """
        return pulumi.get(self, "genre")

    @property
    @pulumi.getter(name="invalidateOnUpdate")
    def invalidate_on_update(self) -> Optional[bool]:
        """
        Reset status whenever there are new changes.
        """
        return pulumi.get(self, "invalidate_on_update")


@pulumi.output_type
class BranchPolicyStatusCheckSettingsScope(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "matchType":
            suggest = "match_type"
        elif key == "repositoryId":
            suggest = "repository_id"
        elif key == "repositoryRef":
            suggest = "repository_ref"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BranchPolicyStatusCheckSettingsScope. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BranchPolicyStatusCheckSettingsScope.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BranchPolicyStatusCheckSettingsScope.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 match_type: Optional[str] = None,
                 repository_id: Optional[str] = None,
                 repository_ref: Optional[str] = None):
        """
        :param str match_type: The match type to use when applying the policy. Supported values are `Exact` (default), `Prefix` or `DefaultBranch`.
        :param str repository_id: The repository ID. Needed only if the scope of the policy will be limited to a single repository. If `match_type` is `DefaultBranch`, this should not be defined.
        :param str repository_ref: The ref pattern to use for the match when `match_type` other than `DefaultBranch`. If `match_type` is `Exact`, this should be a qualified ref such as `refs/heads/master`. If `match_type` is `Prefix`, this should be a ref path such as `refs/heads/releases`.
        """
        if match_type is not None:
            pulumi.set(__self__, "match_type", match_type)
        if repository_id is not None:
            pulumi.set(__self__, "repository_id", repository_id)
        if repository_ref is not None:
            pulumi.set(__self__, "repository_ref", repository_ref)

    @property
    @pulumi.getter(name="matchType")
    def match_type(self) -> Optional[str]:
        """
        The match type to use when applying the policy. Supported values are `Exact` (default), `Prefix` or `DefaultBranch`.
        """
        return pulumi.get(self, "match_type")

    @property
    @pulumi.getter(name="repositoryId")
    def repository_id(self) -> Optional[str]:
        """
        The repository ID. Needed only if the scope of the policy will be limited to a single repository. If `match_type` is `DefaultBranch`, this should not be defined.
        """
        return pulumi.get(self, "repository_id")

    @property
    @pulumi.getter(name="repositoryRef")
    def repository_ref(self) -> Optional[str]:
        """
        The ref pattern to use for the match when `match_type` other than `DefaultBranch`. If `match_type` is `Exact`, this should be a qualified ref such as `refs/heads/master`. If `match_type` is `Prefix`, this should be a ref path such as `refs/heads/releases`.
        """
        return pulumi.get(self, "repository_ref")


@pulumi.output_type
class BranchPolicyWorkItemLinkingSettings(dict):
    def __init__(__self__, *,
                 scopes: Sequence['outputs.BranchPolicyWorkItemLinkingSettingsScope']):
        """
        :param Sequence['BranchPolicyWorkItemLinkingSettingsScopeArgs'] scopes: Controls which repositories and branches the policy will be enabled for. This block must be defined at least once.
        """
        pulumi.set(__self__, "scopes", scopes)

    @property
    @pulumi.getter
    def scopes(self) -> Sequence['outputs.BranchPolicyWorkItemLinkingSettingsScope']:
        """
        Controls which repositories and branches the policy will be enabled for. This block must be defined at least once.
        """
        return pulumi.get(self, "scopes")


@pulumi.output_type
class BranchPolicyWorkItemLinkingSettingsScope(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "matchType":
            suggest = "match_type"
        elif key == "repositoryId":
            suggest = "repository_id"
        elif key == "repositoryRef":
            suggest = "repository_ref"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BranchPolicyWorkItemLinkingSettingsScope. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BranchPolicyWorkItemLinkingSettingsScope.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BranchPolicyWorkItemLinkingSettingsScope.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 match_type: Optional[str] = None,
                 repository_id: Optional[str] = None,
                 repository_ref: Optional[str] = None):
        """
        :param str match_type: The match type to use when applying the policy. Supported values are `Exact` (default), `Prefix` or `DefaultBranch`.
        :param str repository_id: The repository ID. Needed only if the scope of the policy will be limited to a single repository. If `match_type` is `DefaultBranch`, this should not be defined.
        :param str repository_ref: The ref pattern to use for the match when `match_type` other than `DefaultBranch`. If `match_type` is `Exact`, this should be a qualified ref such as `refs/heads/master`. If `match_type` is `Prefix`, this should be a ref path such as `refs/heads/releases`.
        """
        if match_type is not None:
            pulumi.set(__self__, "match_type", match_type)
        if repository_id is not None:
            pulumi.set(__self__, "repository_id", repository_id)
        if repository_ref is not None:
            pulumi.set(__self__, "repository_ref", repository_ref)

    @property
    @pulumi.getter(name="matchType")
    def match_type(self) -> Optional[str]:
        """
        The match type to use when applying the policy. Supported values are `Exact` (default), `Prefix` or `DefaultBranch`.
        """
        return pulumi.get(self, "match_type")

    @property
    @pulumi.getter(name="repositoryId")
    def repository_id(self) -> Optional[str]:
        """
        The repository ID. Needed only if the scope of the policy will be limited to a single repository. If `match_type` is `DefaultBranch`, this should not be defined.
        """
        return pulumi.get(self, "repository_id")

    @property
    @pulumi.getter(name="repositoryRef")
    def repository_ref(self) -> Optional[str]:
        """
        The ref pattern to use for the match when `match_type` other than `DefaultBranch`. If `match_type` is `Exact`, this should be a qualified ref such as `refs/heads/master`. If `match_type` is `Prefix`, this should be a ref path such as `refs/heads/releases`.
        """
        return pulumi.get(self, "repository_ref")


@pulumi.output_type
class BuildDefinitionBuildCompletionTrigger(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "branchFilters":
            suggest = "branch_filters"
        elif key == "buildDefinitionId":
            suggest = "build_definition_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BuildDefinitionBuildCompletionTrigger. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BuildDefinitionBuildCompletionTrigger.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BuildDefinitionBuildCompletionTrigger.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 branch_filters: Sequence['outputs.BuildDefinitionBuildCompletionTriggerBranchFilter'],
                 build_definition_id: int):
        """
        :param Sequence['BuildDefinitionBuildCompletionTriggerBranchFilterArgs'] branch_filters: The branches to include and exclude from the trigger. A `branch_filter` block as documented below.
        :param int build_definition_id: The ID of the build pipeline will be triggered.
        """
        pulumi.set(__self__, "branch_filters", branch_filters)
        pulumi.set(__self__, "build_definition_id", build_definition_id)

    @property
    @pulumi.getter(name="branchFilters")
    def branch_filters(self) -> Sequence['outputs.BuildDefinitionBuildCompletionTriggerBranchFilter']:
        """
        The branches to include and exclude from the trigger. A `branch_filter` block as documented below.
        """
        return pulumi.get(self, "branch_filters")

    @property
    @pulumi.getter(name="buildDefinitionId")
    def build_definition_id(self) -> int:
        """
        The ID of the build pipeline will be triggered.
        """
        return pulumi.get(self, "build_definition_id")


@pulumi.output_type
class BuildDefinitionBuildCompletionTriggerBranchFilter(dict):
    def __init__(__self__, *,
                 excludes: Optional[Sequence[str]] = None,
                 includes: Optional[Sequence[str]] = None):
        """
        :param Sequence[str] excludes: List of branch patterns to exclude.
        :param Sequence[str] includes: List of branch patterns to include.
        """
        if excludes is not None:
            pulumi.set(__self__, "excludes", excludes)
        if includes is not None:
            pulumi.set(__self__, "includes", includes)

    @property
    @pulumi.getter
    def excludes(self) -> Optional[Sequence[str]]:
        """
        List of branch patterns to exclude.
        """
        return pulumi.get(self, "excludes")

    @property
    @pulumi.getter
    def includes(self) -> Optional[Sequence[str]]:
        """
        List of branch patterns to include.
        """
        return pulumi.get(self, "includes")


@pulumi.output_type
class BuildDefinitionCiTrigger(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "useYaml":
            suggest = "use_yaml"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BuildDefinitionCiTrigger. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BuildDefinitionCiTrigger.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BuildDefinitionCiTrigger.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 override: Optional['outputs.BuildDefinitionCiTriggerOverride'] = None,
                 use_yaml: Optional[bool] = None):
        """
        :param 'BuildDefinitionCiTriggerOverrideArgs' override: Override the azure-pipeline file and use a this configuration for all builds.
        :param bool use_yaml: Use the azure-pipeline file for the build configuration. Defaults to `false`.
        """
        if override is not None:
            pulumi.set(__self__, "override", override)
        if use_yaml is not None:
            pulumi.set(__self__, "use_yaml", use_yaml)

    @property
    @pulumi.getter
    def override(self) -> Optional['outputs.BuildDefinitionCiTriggerOverride']:
        """
        Override the azure-pipeline file and use a this configuration for all builds.
        """
        return pulumi.get(self, "override")

    @property
    @pulumi.getter(name="useYaml")
    def use_yaml(self) -> Optional[bool]:
        """
        Use the azure-pipeline file for the build configuration. Defaults to `false`.
        """
        return pulumi.get(self, "use_yaml")


@pulumi.output_type
class BuildDefinitionCiTriggerOverride(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "branchFilters":
            suggest = "branch_filters"
        elif key == "maxConcurrentBuildsPerBranch":
            suggest = "max_concurrent_builds_per_branch"
        elif key == "pathFilters":
            suggest = "path_filters"
        elif key == "pollingInterval":
            suggest = "polling_interval"
        elif key == "pollingJobId":
            suggest = "polling_job_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BuildDefinitionCiTriggerOverride. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BuildDefinitionCiTriggerOverride.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BuildDefinitionCiTriggerOverride.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 branch_filters: Sequence['outputs.BuildDefinitionCiTriggerOverrideBranchFilter'],
                 batch: Optional[bool] = None,
                 max_concurrent_builds_per_branch: Optional[int] = None,
                 path_filters: Optional[Sequence['outputs.BuildDefinitionCiTriggerOverridePathFilter']] = None,
                 polling_interval: Optional[int] = None,
                 polling_job_id: Optional[str] = None):
        """
        :param Sequence['BuildDefinitionCiTriggerOverrideBranchFilterArgs'] branch_filters: The branches to include and exclude from the trigger. A `branch_filter` block as documented below.
        :param bool batch: If you set batch to true, when a pipeline is running, the system waits until the run is completed, then starts another run with all changes that have not yet been built. Defaults to `true`.
        :param int max_concurrent_builds_per_branch: The number of max builds per branch. Defaults to `1`.
        :param Sequence['BuildDefinitionCiTriggerOverridePathFilterArgs'] path_filters: Specify file paths to include or exclude. Note that the wildcard syntax is different between branches/tags and file paths.
        :param int polling_interval: How often the external repository is polled. Defaults to `0`.
        :param str polling_job_id: This is the ID of the polling job that polls the external repository. Once the build definition is saved/updated, this value is set.
        """
        pulumi.set(__self__, "branch_filters", branch_filters)
        if batch is not None:
            pulumi.set(__self__, "batch", batch)
        if max_concurrent_builds_per_branch is not None:
            pulumi.set(__self__, "max_concurrent_builds_per_branch", max_concurrent_builds_per_branch)
        if path_filters is not None:
            pulumi.set(__self__, "path_filters", path_filters)
        if polling_interval is not None:
            pulumi.set(__self__, "polling_interval", polling_interval)
        if polling_job_id is not None:
            pulumi.set(__self__, "polling_job_id", polling_job_id)

    @property
    @pulumi.getter(name="branchFilters")
    def branch_filters(self) -> Sequence['outputs.BuildDefinitionCiTriggerOverrideBranchFilter']:
        """
        The branches to include and exclude from the trigger. A `branch_filter` block as documented below.
        """
        return pulumi.get(self, "branch_filters")

    @property
    @pulumi.getter
    def batch(self) -> Optional[bool]:
        """
        If you set batch to true, when a pipeline is running, the system waits until the run is completed, then starts another run with all changes that have not yet been built. Defaults to `true`.
        """
        return pulumi.get(self, "batch")

    @property
    @pulumi.getter(name="maxConcurrentBuildsPerBranch")
    def max_concurrent_builds_per_branch(self) -> Optional[int]:
        """
        The number of max builds per branch. Defaults to `1`.
        """
        return pulumi.get(self, "max_concurrent_builds_per_branch")

    @property
    @pulumi.getter(name="pathFilters")
    def path_filters(self) -> Optional[Sequence['outputs.BuildDefinitionCiTriggerOverridePathFilter']]:
        """
        Specify file paths to include or exclude. Note that the wildcard syntax is different between branches/tags and file paths.
        """
        return pulumi.get(self, "path_filters")

    @property
    @pulumi.getter(name="pollingInterval")
    def polling_interval(self) -> Optional[int]:
        """
        How often the external repository is polled. Defaults to `0`.
        """
        return pulumi.get(self, "polling_interval")

    @property
    @pulumi.getter(name="pollingJobId")
    def polling_job_id(self) -> Optional[str]:
        """
        This is the ID of the polling job that polls the external repository. Once the build definition is saved/updated, this value is set.
        """
        return pulumi.get(self, "polling_job_id")


@pulumi.output_type
class BuildDefinitionCiTriggerOverrideBranchFilter(dict):
    def __init__(__self__, *,
                 excludes: Optional[Sequence[str]] = None,
                 includes: Optional[Sequence[str]] = None):
        """
        :param Sequence[str] excludes: List of branch patterns to exclude.
        :param Sequence[str] includes: List of branch patterns to include.
        """
        if excludes is not None:
            pulumi.set(__self__, "excludes", excludes)
        if includes is not None:
            pulumi.set(__self__, "includes", includes)

    @property
    @pulumi.getter
    def excludes(self) -> Optional[Sequence[str]]:
        """
        List of branch patterns to exclude.
        """
        return pulumi.get(self, "excludes")

    @property
    @pulumi.getter
    def includes(self) -> Optional[Sequence[str]]:
        """
        List of branch patterns to include.
        """
        return pulumi.get(self, "includes")


@pulumi.output_type
class BuildDefinitionCiTriggerOverridePathFilter(dict):
    def __init__(__self__, *,
                 excludes: Optional[Sequence[str]] = None,
                 includes: Optional[Sequence[str]] = None):
        """
        :param Sequence[str] excludes: List of path patterns to exclude.
        :param Sequence[str] includes: List of path patterns to include.
        """
        if excludes is not None:
            pulumi.set(__self__, "excludes", excludes)
        if includes is not None:
            pulumi.set(__self__, "includes", includes)

    @property
    @pulumi.getter
    def excludes(self) -> Optional[Sequence[str]]:
        """
        List of path patterns to exclude.
        """
        return pulumi.get(self, "excludes")

    @property
    @pulumi.getter
    def includes(self) -> Optional[Sequence[str]]:
        """
        List of path patterns to include.
        """
        return pulumi.get(self, "includes")


@pulumi.output_type
class BuildDefinitionFeature(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "skipFirstRun":
            suggest = "skip_first_run"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BuildDefinitionFeature. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BuildDefinitionFeature.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BuildDefinitionFeature.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 skip_first_run: Optional[bool] = None):
        """
        :param bool skip_first_run: Trigger the pipeline to run after the creation. Defaults to `true`.
               
               > **Note** The first run(`skip_first_run = false`) will only be triggered on create. If the first run fails, the build definition will still be marked as successfully created. A warning message indicating the inability to run pipeline will be displayed.
        """
        if skip_first_run is not None:
            pulumi.set(__self__, "skip_first_run", skip_first_run)

    @property
    @pulumi.getter(name="skipFirstRun")
    def skip_first_run(self) -> Optional[bool]:
        """
        Trigger the pipeline to run after the creation. Defaults to `true`.

        > **Note** The first run(`skip_first_run = false`) will only be triggered on create. If the first run fails, the build definition will still be marked as successfully created. A warning message indicating the inability to run pipeline will be displayed.
        """
        return pulumi.get(self, "skip_first_run")


@pulumi.output_type
class BuildDefinitionPullRequestTrigger(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "commentRequired":
            suggest = "comment_required"
        elif key == "initialBranch":
            suggest = "initial_branch"
        elif key == "useYaml":
            suggest = "use_yaml"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BuildDefinitionPullRequestTrigger. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BuildDefinitionPullRequestTrigger.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BuildDefinitionPullRequestTrigger.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 forks: 'outputs.BuildDefinitionPullRequestTriggerForks',
                 comment_required: Optional[str] = None,
                 initial_branch: Optional[str] = None,
                 override: Optional['outputs.BuildDefinitionPullRequestTriggerOverride'] = None,
                 use_yaml: Optional[bool] = None):
        """
        :param 'BuildDefinitionPullRequestTriggerForksArgs' forks: Set permissions for Forked repositories.
        :param 'BuildDefinitionPullRequestTriggerOverrideArgs' override: Override the azure-pipeline file and use this configuration for all builds.
        :param bool use_yaml: Use the azure-pipeline file for the build configuration. Defaults to `false`.
        """
        pulumi.set(__self__, "forks", forks)
        if comment_required is not None:
            pulumi.set(__self__, "comment_required", comment_required)
        if initial_branch is not None:
            pulumi.set(__self__, "initial_branch", initial_branch)
        if override is not None:
            pulumi.set(__self__, "override", override)
        if use_yaml is not None:
            pulumi.set(__self__, "use_yaml", use_yaml)

    @property
    @pulumi.getter
    def forks(self) -> 'outputs.BuildDefinitionPullRequestTriggerForks':
        """
        Set permissions for Forked repositories.
        """
        return pulumi.get(self, "forks")

    @property
    @pulumi.getter(name="commentRequired")
    def comment_required(self) -> Optional[str]:
        return pulumi.get(self, "comment_required")

    @property
    @pulumi.getter(name="initialBranch")
    def initial_branch(self) -> Optional[str]:
        return pulumi.get(self, "initial_branch")

    @property
    @pulumi.getter
    def override(self) -> Optional['outputs.BuildDefinitionPullRequestTriggerOverride']:
        """
        Override the azure-pipeline file and use this configuration for all builds.
        """
        return pulumi.get(self, "override")

    @property
    @pulumi.getter(name="useYaml")
    def use_yaml(self) -> Optional[bool]:
        """
        Use the azure-pipeline file for the build configuration. Defaults to `false`.
        """
        return pulumi.get(self, "use_yaml")


@pulumi.output_type
class BuildDefinitionPullRequestTriggerForks(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "shareSecrets":
            suggest = "share_secrets"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BuildDefinitionPullRequestTriggerForks. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BuildDefinitionPullRequestTriggerForks.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BuildDefinitionPullRequestTriggerForks.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 enabled: bool,
                 share_secrets: bool):
        """
        :param bool enabled: Build pull requests from forks of this repository.
        :param bool share_secrets: Make secrets available to builds of forks.
        """
        pulumi.set(__self__, "enabled", enabled)
        pulumi.set(__self__, "share_secrets", share_secrets)

    @property
    @pulumi.getter
    def enabled(self) -> bool:
        """
        Build pull requests from forks of this repository.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter(name="shareSecrets")
    def share_secrets(self) -> bool:
        """
        Make secrets available to builds of forks.
        """
        return pulumi.get(self, "share_secrets")


@pulumi.output_type
class BuildDefinitionPullRequestTriggerOverride(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "branchFilters":
            suggest = "branch_filters"
        elif key == "autoCancel":
            suggest = "auto_cancel"
        elif key == "pathFilters":
            suggest = "path_filters"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BuildDefinitionPullRequestTriggerOverride. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BuildDefinitionPullRequestTriggerOverride.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BuildDefinitionPullRequestTriggerOverride.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 branch_filters: Sequence['outputs.BuildDefinitionPullRequestTriggerOverrideBranchFilter'],
                 auto_cancel: Optional[bool] = None,
                 path_filters: Optional[Sequence['outputs.BuildDefinitionPullRequestTriggerOverridePathFilter']] = None):
        """
        :param Sequence['BuildDefinitionPullRequestTriggerOverrideBranchFilterArgs'] branch_filters: The branches to include and exclude from the trigger. A `branch_filter` block as documented below.
        :param bool auto_cancel: . Defaults to `true`.
        :param Sequence['BuildDefinitionPullRequestTriggerOverridePathFilterArgs'] path_filters: Specify file paths to include or exclude. Note that the wildcard syntax is different between branches/tags and file paths.
        """
        pulumi.set(__self__, "branch_filters", branch_filters)
        if auto_cancel is not None:
            pulumi.set(__self__, "auto_cancel", auto_cancel)
        if path_filters is not None:
            pulumi.set(__self__, "path_filters", path_filters)

    @property
    @pulumi.getter(name="branchFilters")
    def branch_filters(self) -> Sequence['outputs.BuildDefinitionPullRequestTriggerOverrideBranchFilter']:
        """
        The branches to include and exclude from the trigger. A `branch_filter` block as documented below.
        """
        return pulumi.get(self, "branch_filters")

    @property
    @pulumi.getter(name="autoCancel")
    def auto_cancel(self) -> Optional[bool]:
        """
        . Defaults to `true`.
        """
        return pulumi.get(self, "auto_cancel")

    @property
    @pulumi.getter(name="pathFilters")
    def path_filters(self) -> Optional[Sequence['outputs.BuildDefinitionPullRequestTriggerOverridePathFilter']]:
        """
        Specify file paths to include or exclude. Note that the wildcard syntax is different between branches/tags and file paths.
        """
        return pulumi.get(self, "path_filters")


@pulumi.output_type
class BuildDefinitionPullRequestTriggerOverrideBranchFilter(dict):
    def __init__(__self__, *,
                 excludes: Optional[Sequence[str]] = None,
                 includes: Optional[Sequence[str]] = None):
        """
        :param Sequence[str] excludes: List of branch patterns to exclude.
        :param Sequence[str] includes: List of branch patterns to include.
        """
        if excludes is not None:
            pulumi.set(__self__, "excludes", excludes)
        if includes is not None:
            pulumi.set(__self__, "includes", includes)

    @property
    @pulumi.getter
    def excludes(self) -> Optional[Sequence[str]]:
        """
        List of branch patterns to exclude.
        """
        return pulumi.get(self, "excludes")

    @property
    @pulumi.getter
    def includes(self) -> Optional[Sequence[str]]:
        """
        List of branch patterns to include.
        """
        return pulumi.get(self, "includes")


@pulumi.output_type
class BuildDefinitionPullRequestTriggerOverridePathFilter(dict):
    def __init__(__self__, *,
                 excludes: Optional[Sequence[str]] = None,
                 includes: Optional[Sequence[str]] = None):
        """
        :param Sequence[str] excludes: List of path patterns to exclude.
        :param Sequence[str] includes: List of path patterns to include.
        """
        if excludes is not None:
            pulumi.set(__self__, "excludes", excludes)
        if includes is not None:
            pulumi.set(__self__, "includes", includes)

    @property
    @pulumi.getter
    def excludes(self) -> Optional[Sequence[str]]:
        """
        List of path patterns to exclude.
        """
        return pulumi.get(self, "excludes")

    @property
    @pulumi.getter
    def includes(self) -> Optional[Sequence[str]]:
        """
        List of path patterns to include.
        """
        return pulumi.get(self, "includes")


@pulumi.output_type
class BuildDefinitionRepository(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "repoId":
            suggest = "repo_id"
        elif key == "repoType":
            suggest = "repo_type"
        elif key == "ymlPath":
            suggest = "yml_path"
        elif key == "branchName":
            suggest = "branch_name"
        elif key == "githubEnterpriseUrl":
            suggest = "github_enterprise_url"
        elif key == "reportBuildStatus":
            suggest = "report_build_status"
        elif key == "serviceConnectionId":
            suggest = "service_connection_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BuildDefinitionRepository. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BuildDefinitionRepository.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BuildDefinitionRepository.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 repo_id: str,
                 repo_type: str,
                 yml_path: str,
                 branch_name: Optional[str] = None,
                 github_enterprise_url: Optional[str] = None,
                 report_build_status: Optional[bool] = None,
                 service_connection_id: Optional[str] = None):
        """
        :param str repo_id: The id of the repository. For `TfsGit` repos, this is simply the ID of the repository. For `Github` repos, this will take the form of `<GitHub Org>/<Repo Name>`. For `Bitbucket` repos, this will take the form of `<Workspace ID>/<Repo Name>`.
        :param str repo_type: The repository type. Valid values: `GitHub` or `TfsGit` or `Bitbucket` or `GitHub Enterprise`. Defaults to `GitHub`. If `repo_type` is `GitHubEnterprise`, must use existing project and GitHub Enterprise service connection.
        :param str yml_path: The path of the Yaml file describing the build definition.
        :param str branch_name: The branch name for which builds are triggered. Defaults to `master`.
        :param str github_enterprise_url: The Github Enterprise URL. Used if `repo_type` is `GithubEnterprise`.
        :param bool report_build_status: Report build status. Default is true.
        :param str service_connection_id: The service connection ID. Used if the `repo_type` is `GitHub` or `GitHubEnterprise`.
        """
        pulumi.set(__self__, "repo_id", repo_id)
        pulumi.set(__self__, "repo_type", repo_type)
        pulumi.set(__self__, "yml_path", yml_path)
        if branch_name is not None:
            pulumi.set(__self__, "branch_name", branch_name)
        if github_enterprise_url is not None:
            pulumi.set(__self__, "github_enterprise_url", github_enterprise_url)
        if report_build_status is not None:
            pulumi.set(__self__, "report_build_status", report_build_status)
        if service_connection_id is not None:
            pulumi.set(__self__, "service_connection_id", service_connection_id)

    @property
    @pulumi.getter(name="repoId")
    def repo_id(self) -> str:
        """
        The id of the repository. For `TfsGit` repos, this is simply the ID of the repository. For `Github` repos, this will take the form of `<GitHub Org>/<Repo Name>`. For `Bitbucket` repos, this will take the form of `<Workspace ID>/<Repo Name>`.
        """
        return pulumi.get(self, "repo_id")

    @property
    @pulumi.getter(name="repoType")
    def repo_type(self) -> str:
        """
        The repository type. Valid values: `GitHub` or `TfsGit` or `Bitbucket` or `GitHub Enterprise`. Defaults to `GitHub`. If `repo_type` is `GitHubEnterprise`, must use existing project and GitHub Enterprise service connection.
        """
        return pulumi.get(self, "repo_type")

    @property
    @pulumi.getter(name="ymlPath")
    def yml_path(self) -> str:
        """
        The path of the Yaml file describing the build definition.
        """
        return pulumi.get(self, "yml_path")

    @property
    @pulumi.getter(name="branchName")
    def branch_name(self) -> Optional[str]:
        """
        The branch name for which builds are triggered. Defaults to `master`.
        """
        return pulumi.get(self, "branch_name")

    @property
    @pulumi.getter(name="githubEnterpriseUrl")
    def github_enterprise_url(self) -> Optional[str]:
        """
        The Github Enterprise URL. Used if `repo_type` is `GithubEnterprise`.
        """
        return pulumi.get(self, "github_enterprise_url")

    @property
    @pulumi.getter(name="reportBuildStatus")
    def report_build_status(self) -> Optional[bool]:
        """
        Report build status. Default is true.
        """
        return pulumi.get(self, "report_build_status")

    @property
    @pulumi.getter(name="serviceConnectionId")
    def service_connection_id(self) -> Optional[str]:
        """
        The service connection ID. Used if the `repo_type` is `GitHub` or `GitHubEnterprise`.
        """
        return pulumi.get(self, "service_connection_id")


@pulumi.output_type
class BuildDefinitionSchedule(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "branchFilters":
            suggest = "branch_filters"
        elif key == "daysToBuilds":
            suggest = "days_to_builds"
        elif key == "scheduleJobId":
            suggest = "schedule_job_id"
        elif key == "scheduleOnlyWithChanges":
            suggest = "schedule_only_with_changes"
        elif key == "startHours":
            suggest = "start_hours"
        elif key == "startMinutes":
            suggest = "start_minutes"
        elif key == "timeZone":
            suggest = "time_zone"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BuildDefinitionSchedule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BuildDefinitionSchedule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BuildDefinitionSchedule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 branch_filters: Sequence['outputs.BuildDefinitionScheduleBranchFilter'],
                 days_to_builds: Sequence[str],
                 schedule_job_id: Optional[str] = None,
                 schedule_only_with_changes: Optional[bool] = None,
                 start_hours: Optional[int] = None,
                 start_minutes: Optional[int] = None,
                 time_zone: Optional[str] = None):
        """
        :param Sequence['BuildDefinitionScheduleBranchFilterArgs'] branch_filters: block supports the following:
        :param Sequence[str] days_to_builds: When to build. Valid values: `Mon`, `Tue`, `Wed`, `Thu`, `Fri`, `Sat`, `Sun`.
        :param str schedule_job_id: The ID of the schedule job
        :param bool schedule_only_with_changes: Schedule builds if the source or pipeline has changed. Defaults to `true`.
        :param int start_hours: Build start hour. Defaults to `0`. Valid values: `0 ~ 23`.
        :param int start_minutes: Build start minute. Defaults to `0`. Valid values: `0 ~ 59`.
        :param str time_zone: Build time zone. Defaults to `(UTC) Coordinated Universal Time`. Valid values: 
               `(UTC-12:00) International Date Line West`,
               `(UTC-11:00) Coordinated Universal Time-11`,
               `(UTC-10:00) Aleutian Islands`,
               `(UTC-10:00) Hawaii`,
               `(UTC-09:30) Marquesas Islands`,
               `(UTC-09:00) Alaska`,
               `(UTC-09:00) Coordinated Universal Time-09`,
               `(UTC-08:00) Baja California`,
               `(UTC-08:00) Coordinated Universal Time-08`,
               `(UTC-08:00) Pacific Time (US &Canada)`,
               `(UTC-07:00) Arizona`,
               `(UTC-07:00) Chihuahua, La Paz, Mazatlan`,
               `(UTC-07:00) Mountain Time (US &Canada)`,
               `(UTC-07:00) Yukon`,
               `(UTC-06:00) Central America`,
               `(UTC-06:00) Central Time (US &Canada)`,
               `(UTC-06:00) Easter Island`,
               `(UTC-06:00) Guadalajara, Mexico City, Monterrey`,
               `(UTC-06:00) Saskatchewan`,
               `(UTC-05:00) Bogota, Lima, Quito, Rio Branco`,
               `(UTC-05:00) Chetumal`,
               `(UTC-05:00) Eastern Time (US &Canada)`,
               `(UTC-05:00) Haiti`,
               `(UTC-05:00) Havana`,
               `(UTC-05:00) Indiana (East)`,
               `(UTC-05:00) Turks and Caicos`,
               `(UTC-04:00) Asuncion`,
               `(UTC-04:00) Atlantic Time (Canada)`,
               `(UTC-04:00) Caracas`,
               `(UTC-04:00) Cuiaba`,
               `(UTC-04:00) Georgetown, La Paz, Manaus, San Juan`,
               `(UTC-04:00) Santiago`,
               `(UTC-03:30) Newfoundland`,
               `(UTC-03:00) Araguaina`,
               `(UTC-03:00) Brasilia`,
               `(UTC-03:00) Cayenne, Fortaleza`,
               `(UTC-03:00) City of Buenos Aires`,
               `(UTC-03:00) Greenland`,
               `(UTC-03:00) Montevideo`,
               `(UTC-03:00) Punta Arenas`,
               `(UTC-03:00) Saint Pierre and Miquelon`,
               `(UTC-03:00) Salvador`,
               `(UTC-02:00) Coordinated Universal Time-02`,
               `(UTC-02:00) Mid-Atlantic - Old`,
               `(UTC-01:00) Azores`,
               `(UTC-01:00) Cabo Verde Is.`,
               `(UTC) Coordinated Universal Time`,
               `(UTC+00:00) Dublin, Edinburgh, Lisbon, London`,
               `(UTC+00:00) Monrovia, Reykjavik`,
               `(UTC+00:00) Sao Tome`,
               `(UTC+01:00) Casablanca`,
               `(UTC+01:00) Amsterdam, Berlin, Bern, Rome, Stockholm, Vienna`,
               `(UTC+01:00) Belgrade, Bratislava, Budapest, Ljubljana, Prague`,
               `(UTC+01:00) Brussels, Copenhagen, Madrid, Paris`,
               `(UTC+01:00) Sarajevo, Skopje, Warsaw, Zagreb`,
               `(UTC+01:00) West Central Africa`,
               `(UTC+02:00) Amman`,
               `(UTC+02:00) Athens, Bucharest`,
               `(UTC+02:00) Beirut`,
               `(UTC+02:00) Cairo`,
               `(UTC+02:00) Chisinau`,
               `(UTC+02:00) Damascus`,
               `(UTC+02:00) Gaza, Hebron`,
               `(UTC+02:00) Harare, Pretoria`,
               `(UTC+02:00) Helsinki, Kyiv, Riga, Sofia, Tallinn, Vilnius`,
               `(UTC+02:00) Jerusalem`,
               `(UTC+02:00) Juba`,
               `(UTC+02:00) Kaliningrad`,
               `(UTC+02:00) Khartoum`,
               `(UTC+02:00) Tripoli`,
               `(UTC+02:00) Windhoek`,
               `(UTC+03:00) Baghdad`,
               `(UTC+03:00) Istanbul`,
               `(UTC+03:00) Kuwait, Riyadh`,
               `(UTC+03:00) Minsk`,
               `(UTC+03:00) Moscow, St. Petersburg`,
               `(UTC+03:00) Nairobi`,
               `(UTC+03:00) Volgograd`,
               `(UTC+03:30) Tehran`,
               `(UTC+04:00) Abu Dhabi, Muscat`,
               `(UTC+04:00) Astrakhan, Ulyanovsk`,
               `(UTC+04:00) Baku`,
               `(UTC+04:00) Izhevsk, Samara`,
               `(UTC+04:00) Port Louis`,
               `(UTC+04:00) Saratov`,
               `(UTC+04:00) Tbilisi`,
               `(UTC+04:00) Yerevan`,
               `(UTC+04:30) Kabul`,
               `(UTC+05:00) Ashgabat, Tashkent`,
               `(UTC+05:00) Ekaterinburg`,
               `(UTC+05:00) Islamabad, Karachi`,
               `(UTC+05:00) Qyzylorda`,
               `(UTC+05:30) Chennai, Kolkata, Mumbai, New Delhi`,
               `(UTC+05:30) Sri Jayawardenepura`,
               `(UTC+05:45) Kathmandu`,
               `(UTC+06:00) Astana`,
               `(UTC+06:00) Dhaka`,
               `(UTC+06:00) Omsk`,
               `(UTC+06:30) Yangon (Rangoon)`,
               `(UTC+07:00) Bangkok, Hanoi, Jakarta`,
               `(UTC+07:00) Barnaul, Gorno-Altaysk`,
               `(UTC+07:00) Hovd`,
               `(UTC+07:00) Krasnoyarsk`,
               `(UTC+07:00) Novosibirsk`,
               `(UTC+07:00) Tomsk`,
               `(UTC+08:00) Beijing, Chongqing, Hong Kong, Urumqi`,
               `(UTC+08:00) Irkutsk`,
               `(UTC+08:00) Kuala Lumpur, Singapore`,
               `(UTC+08:00) Perth`,
               `(UTC+08:00) Taipei`,
               `(UTC+08:00) Ulaanbaatar`,
               `(UTC+08:45) Eucla`,
               `(UTC+09:00) Chita`,
               `(UTC+09:00) Osaka, Sapporo, Tokyo`,
               `(UTC+09:00) Pyongyang`,
               `(UTC+09:00) Seoul`,
               `(UTC+09:00) Yakutsk`,
               `(UTC+09:30) Adelaide`,
               `(UTC+09:30) Darwin`,
               `(UTC+10:00) Brisbane`,
               `(UTC+10:00) Canberra, Melbourne, Sydney`,
               `(UTC+10:00) Guam, Port Moresby`,
               `(UTC+10:00) Hobart`,
               `(UTC+10:00) Vladivostok`,
               `(UTC+10:30) Lord Howe Island`,
               `(UTC+11:00) Bougainville Island`,
               `(UTC+11:00) Chokurdakh`,
               `(UTC+11:00) Magadan`,
               `(UTC+11:00) Norfolk Island`,
               `(UTC+11:00) Sakhalin`,
               `(UTC+11:00) Solomon Is., New Caledonia`,
               `(UTC+12:00) Anadyr, Petropavlovsk-Kamchatsky`,
               `(UTC+12:00) Auckland, Wellington`,
               `(UTC+12:00) Coordinated Universal Time+12`,
               `(UTC+12:00) Fiji`,
               `(UTC+12:00) Petropavlovsk-Kamchatsky - Old`,
               `(UTC+12:45) Chatham Islands`,
               `(UTC+13:00) Coordinated Universal Time+13`,
               `(UTC+13:00) Nuku'alofa`,
               `(UTC+13:00) Samoa`,
               `(UTC+14:00) Kiritimati Island`.
        """
        pulumi.set(__self__, "branch_filters", branch_filters)
        pulumi.set(__self__, "days_to_builds", days_to_builds)
        if schedule_job_id is not None:
            pulumi.set(__self__, "schedule_job_id", schedule_job_id)
        if schedule_only_with_changes is not None:
            pulumi.set(__self__, "schedule_only_with_changes", schedule_only_with_changes)
        if start_hours is not None:
            pulumi.set(__self__, "start_hours", start_hours)
        if start_minutes is not None:
            pulumi.set(__self__, "start_minutes", start_minutes)
        if time_zone is not None:
            pulumi.set(__self__, "time_zone", time_zone)

    @property
    @pulumi.getter(name="branchFilters")
    def branch_filters(self) -> Sequence['outputs.BuildDefinitionScheduleBranchFilter']:
        """
        block supports the following:
        """
        return pulumi.get(self, "branch_filters")

    @property
    @pulumi.getter(name="daysToBuilds")
    def days_to_builds(self) -> Sequence[str]:
        """
        When to build. Valid values: `Mon`, `Tue`, `Wed`, `Thu`, `Fri`, `Sat`, `Sun`.
        """
        return pulumi.get(self, "days_to_builds")

    @property
    @pulumi.getter(name="scheduleJobId")
    def schedule_job_id(self) -> Optional[str]:
        """
        The ID of the schedule job
        """
        return pulumi.get(self, "schedule_job_id")

    @property
    @pulumi.getter(name="scheduleOnlyWithChanges")
    def schedule_only_with_changes(self) -> Optional[bool]:
        """
        Schedule builds if the source or pipeline has changed. Defaults to `true`.
        """
        return pulumi.get(self, "schedule_only_with_changes")

    @property
    @pulumi.getter(name="startHours")
    def start_hours(self) -> Optional[int]:
        """
        Build start hour. Defaults to `0`. Valid values: `0 ~ 23`.
        """
        return pulumi.get(self, "start_hours")

    @property
    @pulumi.getter(name="startMinutes")
    def start_minutes(self) -> Optional[int]:
        """
        Build start minute. Defaults to `0`. Valid values: `0 ~ 59`.
        """
        return pulumi.get(self, "start_minutes")

    @property
    @pulumi.getter(name="timeZone")
    def time_zone(self) -> Optional[str]:
        """
        Build time zone. Defaults to `(UTC) Coordinated Universal Time`. Valid values: 
        `(UTC-12:00) International Date Line West`,
        `(UTC-11:00) Coordinated Universal Time-11`,
        `(UTC-10:00) Aleutian Islands`,
        `(UTC-10:00) Hawaii`,
        `(UTC-09:30) Marquesas Islands`,
        `(UTC-09:00) Alaska`,
        `(UTC-09:00) Coordinated Universal Time-09`,
        `(UTC-08:00) Baja California`,
        `(UTC-08:00) Coordinated Universal Time-08`,
        `(UTC-08:00) Pacific Time (US &Canada)`,
        `(UTC-07:00) Arizona`,
        `(UTC-07:00) Chihuahua, La Paz, Mazatlan`,
        `(UTC-07:00) Mountain Time (US &Canada)`,
        `(UTC-07:00) Yukon`,
        `(UTC-06:00) Central America`,
        `(UTC-06:00) Central Time (US &Canada)`,
        `(UTC-06:00) Easter Island`,
        `(UTC-06:00) Guadalajara, Mexico City, Monterrey`,
        `(UTC-06:00) Saskatchewan`,
        `(UTC-05:00) Bogota, Lima, Quito, Rio Branco`,
        `(UTC-05:00) Chetumal`,
        `(UTC-05:00) Eastern Time (US &Canada)`,
        `(UTC-05:00) Haiti`,
        `(UTC-05:00) Havana`,
        `(UTC-05:00) Indiana (East)`,
        `(UTC-05:00) Turks and Caicos`,
        `(UTC-04:00) Asuncion`,
        `(UTC-04:00) Atlantic Time (Canada)`,
        `(UTC-04:00) Caracas`,
        `(UTC-04:00) Cuiaba`,
        `(UTC-04:00) Georgetown, La Paz, Manaus, San Juan`,
        `(UTC-04:00) Santiago`,
        `(UTC-03:30) Newfoundland`,
        `(UTC-03:00) Araguaina`,
        `(UTC-03:00) Brasilia`,
        `(UTC-03:00) Cayenne, Fortaleza`,
        `(UTC-03:00) City of Buenos Aires`,
        `(UTC-03:00) Greenland`,
        `(UTC-03:00) Montevideo`,
        `(UTC-03:00) Punta Arenas`,
        `(UTC-03:00) Saint Pierre and Miquelon`,
        `(UTC-03:00) Salvador`,
        `(UTC-02:00) Coordinated Universal Time-02`,
        `(UTC-02:00) Mid-Atlantic - Old`,
        `(UTC-01:00) Azores`,
        `(UTC-01:00) Cabo Verde Is.`,
        `(UTC) Coordinated Universal Time`,
        `(UTC+00:00) Dublin, Edinburgh, Lisbon, London`,
        `(UTC+00:00) Monrovia, Reykjavik`,
        `(UTC+00:00) Sao Tome`,
        `(UTC+01:00) Casablanca`,
        `(UTC+01:00) Amsterdam, Berlin, Bern, Rome, Stockholm, Vienna`,
        `(UTC+01:00) Belgrade, Bratislava, Budapest, Ljubljana, Prague`,
        `(UTC+01:00) Brussels, Copenhagen, Madrid, Paris`,
        `(UTC+01:00) Sarajevo, Skopje, Warsaw, Zagreb`,
        `(UTC+01:00) West Central Africa`,
        `(UTC+02:00) Amman`,
        `(UTC+02:00) Athens, Bucharest`,
        `(UTC+02:00) Beirut`,
        `(UTC+02:00) Cairo`,
        `(UTC+02:00) Chisinau`,
        `(UTC+02:00) Damascus`,
        `(UTC+02:00) Gaza, Hebron`,
        `(UTC+02:00) Harare, Pretoria`,
        `(UTC+02:00) Helsinki, Kyiv, Riga, Sofia, Tallinn, Vilnius`,
        `(UTC+02:00) Jerusalem`,
        `(UTC+02:00) Juba`,
        `(UTC+02:00) Kaliningrad`,
        `(UTC+02:00) Khartoum`,
        `(UTC+02:00) Tripoli`,
        `(UTC+02:00) Windhoek`,
        `(UTC+03:00) Baghdad`,
        `(UTC+03:00) Istanbul`,
        `(UTC+03:00) Kuwait, Riyadh`,
        `(UTC+03:00) Minsk`,
        `(UTC+03:00) Moscow, St. Petersburg`,
        `(UTC+03:00) Nairobi`,
        `(UTC+03:00) Volgograd`,
        `(UTC+03:30) Tehran`,
        `(UTC+04:00) Abu Dhabi, Muscat`,
        `(UTC+04:00) Astrakhan, Ulyanovsk`,
        `(UTC+04:00) Baku`,
        `(UTC+04:00) Izhevsk, Samara`,
        `(UTC+04:00) Port Louis`,
        `(UTC+04:00) Saratov`,
        `(UTC+04:00) Tbilisi`,
        `(UTC+04:00) Yerevan`,
        `(UTC+04:30) Kabul`,
        `(UTC+05:00) Ashgabat, Tashkent`,
        `(UTC+05:00) Ekaterinburg`,
        `(UTC+05:00) Islamabad, Karachi`,
        `(UTC+05:00) Qyzylorda`,
        `(UTC+05:30) Chennai, Kolkata, Mumbai, New Delhi`,
        `(UTC+05:30) Sri Jayawardenepura`,
        `(UTC+05:45) Kathmandu`,
        `(UTC+06:00) Astana`,
        `(UTC+06:00) Dhaka`,
        `(UTC+06:00) Omsk`,
        `(UTC+06:30) Yangon (Rangoon)`,
        `(UTC+07:00) Bangkok, Hanoi, Jakarta`,
        `(UTC+07:00) Barnaul, Gorno-Altaysk`,
        `(UTC+07:00) Hovd`,
        `(UTC+07:00) Krasnoyarsk`,
        `(UTC+07:00) Novosibirsk`,
        `(UTC+07:00) Tomsk`,
        `(UTC+08:00) Beijing, Chongqing, Hong Kong, Urumqi`,
        `(UTC+08:00) Irkutsk`,
        `(UTC+08:00) Kuala Lumpur, Singapore`,
        `(UTC+08:00) Perth`,
        `(UTC+08:00) Taipei`,
        `(UTC+08:00) Ulaanbaatar`,
        `(UTC+08:45) Eucla`,
        `(UTC+09:00) Chita`,
        `(UTC+09:00) Osaka, Sapporo, Tokyo`,
        `(UTC+09:00) Pyongyang`,
        `(UTC+09:00) Seoul`,
        `(UTC+09:00) Yakutsk`,
        `(UTC+09:30) Adelaide`,
        `(UTC+09:30) Darwin`,
        `(UTC+10:00) Brisbane`,
        `(UTC+10:00) Canberra, Melbourne, Sydney`,
        `(UTC+10:00) Guam, Port Moresby`,
        `(UTC+10:00) Hobart`,
        `(UTC+10:00) Vladivostok`,
        `(UTC+10:30) Lord Howe Island`,
        `(UTC+11:00) Bougainville Island`,
        `(UTC+11:00) Chokurdakh`,
        `(UTC+11:00) Magadan`,
        `(UTC+11:00) Norfolk Island`,
        `(UTC+11:00) Sakhalin`,
        `(UTC+11:00) Solomon Is., New Caledonia`,
        `(UTC+12:00) Anadyr, Petropavlovsk-Kamchatsky`,
        `(UTC+12:00) Auckland, Wellington`,
        `(UTC+12:00) Coordinated Universal Time+12`,
        `(UTC+12:00) Fiji`,
        `(UTC+12:00) Petropavlovsk-Kamchatsky - Old`,
        `(UTC+12:45) Chatham Islands`,
        `(UTC+13:00) Coordinated Universal Time+13`,
        `(UTC+13:00) Nuku'alofa`,
        `(UTC+13:00) Samoa`,
        `(UTC+14:00) Kiritimati Island`.
        """
        return pulumi.get(self, "time_zone")


@pulumi.output_type
class BuildDefinitionScheduleBranchFilter(dict):
    def __init__(__self__, *,
                 excludes: Optional[Sequence[str]] = None,
                 includes: Optional[Sequence[str]] = None):
        """
        :param Sequence[str] excludes: List of branch patterns to exclude.
        :param Sequence[str] includes: List of branch patterns to include.
        """
        if excludes is not None:
            pulumi.set(__self__, "excludes", excludes)
        if includes is not None:
            pulumi.set(__self__, "includes", includes)

    @property
    @pulumi.getter
    def excludes(self) -> Optional[Sequence[str]]:
        """
        List of branch patterns to exclude.
        """
        return pulumi.get(self, "excludes")

    @property
    @pulumi.getter
    def includes(self) -> Optional[Sequence[str]]:
        """
        List of branch patterns to include.
        """
        return pulumi.get(self, "includes")


@pulumi.output_type
class BuildDefinitionVariable(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "allowOverride":
            suggest = "allow_override"
        elif key == "isSecret":
            suggest = "is_secret"
        elif key == "secretValue":
            suggest = "secret_value"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BuildDefinitionVariable. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BuildDefinitionVariable.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BuildDefinitionVariable.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: str,
                 allow_override: Optional[bool] = None,
                 is_secret: Optional[bool] = None,
                 secret_value: Optional[str] = None,
                 value: Optional[str] = None):
        """
        :param str name: The name of the variable.
        :param bool allow_override: True if the variable can be overridden. Defaults to `true`.
        :param bool is_secret: True if the variable is a secret. Defaults to `false`.
        :param str secret_value: The secret value of the variable. Used when `is_secret` set to `true`.
        :param str value: The value of the variable.
        """
        pulumi.set(__self__, "name", name)
        if allow_override is not None:
            pulumi.set(__self__, "allow_override", allow_override)
        if is_secret is not None:
            pulumi.set(__self__, "is_secret", is_secret)
        if secret_value is not None:
            pulumi.set(__self__, "secret_value", secret_value)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the variable.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="allowOverride")
    def allow_override(self) -> Optional[bool]:
        """
        True if the variable can be overridden. Defaults to `true`.
        """
        return pulumi.get(self, "allow_override")

    @property
    @pulumi.getter(name="isSecret")
    def is_secret(self) -> Optional[bool]:
        """
        True if the variable is a secret. Defaults to `false`.
        """
        return pulumi.get(self, "is_secret")

    @property
    @pulumi.getter(name="secretValue")
    def secret_value(self) -> Optional[str]:
        """
        The secret value of the variable. Used when `is_secret` set to `true`.
        """
        return pulumi.get(self, "secret_value")

    @property
    @pulumi.getter
    def value(self) -> Optional[str]:
        """
        The value of the variable.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class CheckRequiredTemplateRequiredTemplate(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "repositoryName":
            suggest = "repository_name"
        elif key == "repositoryRef":
            suggest = "repository_ref"
        elif key == "templatePath":
            suggest = "template_path"
        elif key == "repositoryType":
            suggest = "repository_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CheckRequiredTemplateRequiredTemplate. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CheckRequiredTemplateRequiredTemplate.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CheckRequiredTemplateRequiredTemplate.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 repository_name: str,
                 repository_ref: str,
                 template_path: str,
                 repository_type: Optional[str] = None):
        """
        :param str repository_name: The name of the repository storing the template.
        :param str repository_ref: The branch in which the template will be referenced.
        :param str template_path: The path to the template yaml.
        :param str repository_type: The type of the repository storing the template. Valid values: `azuregit`, `github`, `githubenterprise`, `bitbucket`. Defaults to `azuregit`.
        """
        pulumi.set(__self__, "repository_name", repository_name)
        pulumi.set(__self__, "repository_ref", repository_ref)
        pulumi.set(__self__, "template_path", template_path)
        if repository_type is not None:
            pulumi.set(__self__, "repository_type", repository_type)

    @property
    @pulumi.getter(name="repositoryName")
    def repository_name(self) -> str:
        """
        The name of the repository storing the template.
        """
        return pulumi.get(self, "repository_name")

    @property
    @pulumi.getter(name="repositoryRef")
    def repository_ref(self) -> str:
        """
        The branch in which the template will be referenced.
        """
        return pulumi.get(self, "repository_ref")

    @property
    @pulumi.getter(name="templatePath")
    def template_path(self) -> str:
        """
        The path to the template yaml.
        """
        return pulumi.get(self, "template_path")

    @property
    @pulumi.getter(name="repositoryType")
    def repository_type(self) -> Optional[str]:
        """
        The type of the repository storing the template. Valid values: `azuregit`, `github`, `githubenterprise`, `bitbucket`. Defaults to `azuregit`.
        """
        return pulumi.get(self, "repository_type")


@pulumi.output_type
class FeedFeature(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "permanentDelete":
            suggest = "permanent_delete"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FeedFeature. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FeedFeature.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FeedFeature.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 permanent_delete: Optional[bool] = None,
                 restore: Optional[bool] = None):
        """
        :param bool permanent_delete: Determines if Feed should be Permanently removed, Defaults to `false`
        :param bool restore: Determines if Feed should be Restored during creation (if possible), Defaults to `false`
        """
        if permanent_delete is not None:
            pulumi.set(__self__, "permanent_delete", permanent_delete)
        if restore is not None:
            pulumi.set(__self__, "restore", restore)

    @property
    @pulumi.getter(name="permanentDelete")
    def permanent_delete(self) -> Optional[bool]:
        """
        Determines if Feed should be Permanently removed, Defaults to `false`
        """
        return pulumi.get(self, "permanent_delete")

    @property
    @pulumi.getter
    def restore(self) -> Optional[bool]:
        """
        Determines if Feed should be Restored during creation (if possible), Defaults to `false`
        """
        return pulumi.get(self, "restore")


@pulumi.output_type
class GitInitialization(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "initType":
            suggest = "init_type"
        elif key == "serviceConnectionId":
            suggest = "service_connection_id"
        elif key == "sourceType":
            suggest = "source_type"
        elif key == "sourceUrl":
            suggest = "source_url"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GitInitialization. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GitInitialization.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GitInitialization.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 init_type: str,
                 password: Optional[str] = None,
                 service_connection_id: Optional[str] = None,
                 source_type: Optional[str] = None,
                 source_url: Optional[str] = None,
                 username: Optional[str] = None):
        """
        :param str init_type: The type of repository to create. Valid values: `Uninitialized`, `Clean` or `Import`.
        :param str password: The password used to authenticate to a private repository for import initialization. Conflicts with `service_connection_id`.
               
               ~>**Note**
               At least `service_connection_id` or `username/password` needs to be set to import private repository.
        :param str service_connection_id: The ID of service connection used to authenticate to a private repository for import initialization. Conflicts with `username` and `password`.
        :param str source_type: Type of the source repository. Used if the `init_type` is `Import`. Valid values: `Git`.
        :param str source_url: The URL of the source repository. Used if the `init_type` is `Import`.
        :param str username: The username used to authenticate to a private repository for import initialization. Conflicts with `service_connection_id`.
        """
        pulumi.set(__self__, "init_type", init_type)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if service_connection_id is not None:
            pulumi.set(__self__, "service_connection_id", service_connection_id)
        if source_type is not None:
            pulumi.set(__self__, "source_type", source_type)
        if source_url is not None:
            pulumi.set(__self__, "source_url", source_url)
        if username is not None:
            pulumi.set(__self__, "username", username)

    @property
    @pulumi.getter(name="initType")
    def init_type(self) -> str:
        """
        The type of repository to create. Valid values: `Uninitialized`, `Clean` or `Import`.
        """
        return pulumi.get(self, "init_type")

    @property
    @pulumi.getter
    def password(self) -> Optional[str]:
        """
        The password used to authenticate to a private repository for import initialization. Conflicts with `service_connection_id`.

        ~>**Note**
        At least `service_connection_id` or `username/password` needs to be set to import private repository.
        """
        return pulumi.get(self, "password")

    @property
    @pulumi.getter(name="serviceConnectionId")
    def service_connection_id(self) -> Optional[str]:
        """
        The ID of service connection used to authenticate to a private repository for import initialization. Conflicts with `username` and `password`.
        """
        return pulumi.get(self, "service_connection_id")

    @property
    @pulumi.getter(name="sourceType")
    def source_type(self) -> Optional[str]:
        """
        Type of the source repository. Used if the `init_type` is `Import`. Valid values: `Git`.
        """
        return pulumi.get(self, "source_type")

    @property
    @pulumi.getter(name="sourceUrl")
    def source_url(self) -> Optional[str]:
        """
        The URL of the source repository. Used if the `init_type` is `Import`.
        """
        return pulumi.get(self, "source_url")

    @property
    @pulumi.getter
    def username(self) -> Optional[str]:
        """
        The username used to authenticate to a private repository for import initialization. Conflicts with `service_connection_id`.
        """
        return pulumi.get(self, "username")


@pulumi.output_type
class ServiceEndpointArtifactoryAuthenticationBasic(dict):
    def __init__(__self__, *,
                 password: str,
                 username: str):
        """
        :param str password: The Artifactory password.
        :param str username: The Artifactory user name.
        """
        pulumi.set(__self__, "password", password)
        pulumi.set(__self__, "username", username)

    @property
    @pulumi.getter
    def password(self) -> str:
        """
        The Artifactory password.
        """
        return pulumi.get(self, "password")

    @property
    @pulumi.getter
    def username(self) -> str:
        """
        The Artifactory user name.
        """
        return pulumi.get(self, "username")


@pulumi.output_type
class ServiceEndpointArtifactoryAuthenticationToken(dict):
    def __init__(__self__, *,
                 token: str):
        """
        :param str token: The Artifactory access token.
        """
        pulumi.set(__self__, "token", token)

    @property
    @pulumi.getter
    def token(self) -> str:
        """
        The Artifactory access token.
        """
        return pulumi.get(self, "token")


@pulumi.output_type
class ServiceEndpointAzureEcrCredentials(dict):
    def __init__(__self__, *,
                 serviceprincipalid: str):
        """
        :param str serviceprincipalid: The service principal application Id
        """
        pulumi.set(__self__, "serviceprincipalid", serviceprincipalid)

    @property
    @pulumi.getter
    def serviceprincipalid(self) -> str:
        """
        The service principal application Id
        """
        return pulumi.get(self, "serviceprincipalid")


@pulumi.output_type
class ServiceEndpointAzureRMCredentials(dict):
    def __init__(__self__, *,
                 serviceprincipalid: str,
                 serviceprincipalcertificate: Optional[str] = None,
                 serviceprincipalkey: Optional[str] = None):
        """
        :param str serviceprincipalid: The service principal application ID
        :param str serviceprincipalcertificate: The service principal certificate. This not required if `service_endpoint_authentication_scheme` is set to `WorkloadIdentityFederation`.
        :param str serviceprincipalkey: The service principal secret. This not required if `service_endpoint_authentication_scheme` is set to `WorkloadIdentityFederation`.
        """
        pulumi.set(__self__, "serviceprincipalid", serviceprincipalid)
        if serviceprincipalcertificate is not None:
            pulumi.set(__self__, "serviceprincipalcertificate", serviceprincipalcertificate)
        if serviceprincipalkey is not None:
            pulumi.set(__self__, "serviceprincipalkey", serviceprincipalkey)

    @property
    @pulumi.getter
    def serviceprincipalid(self) -> str:
        """
        The service principal application ID
        """
        return pulumi.get(self, "serviceprincipalid")

    @property
    @pulumi.getter
    def serviceprincipalcertificate(self) -> Optional[str]:
        """
        The service principal certificate. This not required if `service_endpoint_authentication_scheme` is set to `WorkloadIdentityFederation`.
        """
        return pulumi.get(self, "serviceprincipalcertificate")

    @property
    @pulumi.getter
    def serviceprincipalkey(self) -> Optional[str]:
        """
        The service principal secret. This not required if `service_endpoint_authentication_scheme` is set to `WorkloadIdentityFederation`.
        """
        return pulumi.get(self, "serviceprincipalkey")


@pulumi.output_type
class ServiceEndpointAzureRMFeatures(dict):
    def __init__(__self__, *,
                 validate: Optional[bool] = None):
        """
        :param bool validate: Whether or not to validate connection with Azure after create or update operations. Defaults to `false`
        """
        if validate is not None:
            pulumi.set(__self__, "validate", validate)

    @property
    @pulumi.getter
    def validate(self) -> Optional[bool]:
        """
        Whether or not to validate connection with Azure after create or update operations. Defaults to `false`
        """
        return pulumi.get(self, "validate")


@pulumi.output_type
class ServiceEndpointGitHubAuthOauth(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "oauthConfigurationId":
            suggest = "oauth_configuration_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceEndpointGitHubAuthOauth. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceEndpointGitHubAuthOauth.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceEndpointGitHubAuthOauth.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 oauth_configuration_id: str):
        pulumi.set(__self__, "oauth_configuration_id", oauth_configuration_id)

    @property
    @pulumi.getter(name="oauthConfigurationId")
    def oauth_configuration_id(self) -> str:
        return pulumi.get(self, "oauth_configuration_id")


@pulumi.output_type
class ServiceEndpointGitHubAuthPersonal(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "personalAccessToken":
            suggest = "personal_access_token"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceEndpointGitHubAuthPersonal. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceEndpointGitHubAuthPersonal.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceEndpointGitHubAuthPersonal.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 personal_access_token: str):
        """
        :param str personal_access_token: The Personal Access Token for GitHub.
        """
        pulumi.set(__self__, "personal_access_token", personal_access_token)

    @property
    @pulumi.getter(name="personalAccessToken")
    def personal_access_token(self) -> str:
        """
        The Personal Access Token for GitHub.
        """
        return pulumi.get(self, "personal_access_token")


@pulumi.output_type
class ServiceEndpointGitHubEnterpriseAuthPersonal(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "personalAccessToken":
            suggest = "personal_access_token"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceEndpointGitHubEnterpriseAuthPersonal. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceEndpointGitHubEnterpriseAuthPersonal.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceEndpointGitHubEnterpriseAuthPersonal.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 personal_access_token: str):
        """
        :param str personal_access_token: The Personal Access Token for GitHub.
        """
        pulumi.set(__self__, "personal_access_token", personal_access_token)

    @property
    @pulumi.getter(name="personalAccessToken")
    def personal_access_token(self) -> str:
        """
        The Personal Access Token for GitHub.
        """
        return pulumi.get(self, "personal_access_token")


@pulumi.output_type
class ServiceEndpointKubernetesAzureSubscription(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "clusterName":
            suggest = "cluster_name"
        elif key == "resourcegroupId":
            suggest = "resourcegroup_id"
        elif key == "subscriptionId":
            suggest = "subscription_id"
        elif key == "subscriptionName":
            suggest = "subscription_name"
        elif key == "tenantId":
            suggest = "tenant_id"
        elif key == "azureEnvironment":
            suggest = "azure_environment"
        elif key == "clusterAdmin":
            suggest = "cluster_admin"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceEndpointKubernetesAzureSubscription. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceEndpointKubernetesAzureSubscription.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceEndpointKubernetesAzureSubscription.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cluster_name: str,
                 resourcegroup_id: str,
                 subscription_id: str,
                 subscription_name: str,
                 tenant_id: str,
                 azure_environment: Optional[str] = None,
                 cluster_admin: Optional[bool] = None,
                 namespace: Optional[str] = None):
        """
        :param str cluster_name: The name of the Kubernetes cluster.
        :param str resourcegroup_id: The resource group name, to which the Kubernetes cluster is deployed.
        :param str subscription_id: The id of the Azure subscription.
        :param str subscription_name: The name of the Azure subscription.
        :param str tenant_id: The id of the tenant used by the subscription.
        :param str azure_environment: Azure environment refers to whether the public cloud offering or domestic (government) clouds are being used. Currently, only the public cloud is supported. The value must be AzureCloud. This is also the default-value.
        :param bool cluster_admin: Set this option to allow use cluster admin credentials.
        :param str namespace: The Kubernetes namespace. Default value is "default".
        """
        pulumi.set(__self__, "cluster_name", cluster_name)
        pulumi.set(__self__, "resourcegroup_id", resourcegroup_id)
        pulumi.set(__self__, "subscription_id", subscription_id)
        pulumi.set(__self__, "subscription_name", subscription_name)
        pulumi.set(__self__, "tenant_id", tenant_id)
        if azure_environment is not None:
            pulumi.set(__self__, "azure_environment", azure_environment)
        if cluster_admin is not None:
            pulumi.set(__self__, "cluster_admin", cluster_admin)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)

    @property
    @pulumi.getter(name="clusterName")
    def cluster_name(self) -> str:
        """
        The name of the Kubernetes cluster.
        """
        return pulumi.get(self, "cluster_name")

    @property
    @pulumi.getter(name="resourcegroupId")
    def resourcegroup_id(self) -> str:
        """
        The resource group name, to which the Kubernetes cluster is deployed.
        """
        return pulumi.get(self, "resourcegroup_id")

    @property
    @pulumi.getter(name="subscriptionId")
    def subscription_id(self) -> str:
        """
        The id of the Azure subscription.
        """
        return pulumi.get(self, "subscription_id")

    @property
    @pulumi.getter(name="subscriptionName")
    def subscription_name(self) -> str:
        """
        The name of the Azure subscription.
        """
        return pulumi.get(self, "subscription_name")

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> str:
        """
        The id of the tenant used by the subscription.
        """
        return pulumi.get(self, "tenant_id")

    @property
    @pulumi.getter(name="azureEnvironment")
    def azure_environment(self) -> Optional[str]:
        """
        Azure environment refers to whether the public cloud offering or domestic (government) clouds are being used. Currently, only the public cloud is supported. The value must be AzureCloud. This is also the default-value.
        """
        return pulumi.get(self, "azure_environment")

    @property
    @pulumi.getter(name="clusterAdmin")
    def cluster_admin(self) -> Optional[bool]:
        """
        Set this option to allow use cluster admin credentials.
        """
        return pulumi.get(self, "cluster_admin")

    @property
    @pulumi.getter
    def namespace(self) -> Optional[str]:
        """
        The Kubernetes namespace. Default value is "default".
        """
        return pulumi.get(self, "namespace")


@pulumi.output_type
class ServiceEndpointKubernetesKubeconfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "kubeConfig":
            suggest = "kube_config"
        elif key == "acceptUntrustedCerts":
            suggest = "accept_untrusted_certs"
        elif key == "clusterContext":
            suggest = "cluster_context"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceEndpointKubernetesKubeconfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceEndpointKubernetesKubeconfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceEndpointKubernetesKubeconfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 kube_config: str,
                 accept_untrusted_certs: Optional[bool] = None,
                 cluster_context: Optional[str] = None):
        """
        :param str kube_config: The content of the kubeconfig in yaml notation to be used to communicate with the API-Server of Kubernetes.
        :param bool accept_untrusted_certs: Set this option to allow clients to accept a self-signed certificate.
        :param str cluster_context: Context within the kubeconfig file that is to be used for identifying the cluster. Default value is the current-context set in kubeconfig.
        """
        pulumi.set(__self__, "kube_config", kube_config)
        if accept_untrusted_certs is not None:
            pulumi.set(__self__, "accept_untrusted_certs", accept_untrusted_certs)
        if cluster_context is not None:
            pulumi.set(__self__, "cluster_context", cluster_context)

    @property
    @pulumi.getter(name="kubeConfig")
    def kube_config(self) -> str:
        """
        The content of the kubeconfig in yaml notation to be used to communicate with the API-Server of Kubernetes.
        """
        return pulumi.get(self, "kube_config")

    @property
    @pulumi.getter(name="acceptUntrustedCerts")
    def accept_untrusted_certs(self) -> Optional[bool]:
        """
        Set this option to allow clients to accept a self-signed certificate.
        """
        return pulumi.get(self, "accept_untrusted_certs")

    @property
    @pulumi.getter(name="clusterContext")
    def cluster_context(self) -> Optional[str]:
        """
        Context within the kubeconfig file that is to be used for identifying the cluster. Default value is the current-context set in kubeconfig.
        """
        return pulumi.get(self, "cluster_context")


@pulumi.output_type
class ServiceEndpointKubernetesServiceAccount(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "caCert":
            suggest = "ca_cert"
        elif key == "acceptUntrustedCerts":
            suggest = "accept_untrusted_certs"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceEndpointKubernetesServiceAccount. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceEndpointKubernetesServiceAccount.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceEndpointKubernetesServiceAccount.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 ca_cert: str,
                 token: str,
                 accept_untrusted_certs: Optional[bool] = None):
        """
        :param str ca_cert: The certificate from a Kubernetes secret object.
        :param str token: The token from a Kubernetes secret object.
        :param bool accept_untrusted_certs: Set this option to allow clients to accept a self-signed certificate. Defaults to `false`.
        """
        pulumi.set(__self__, "ca_cert", ca_cert)
        pulumi.set(__self__, "token", token)
        if accept_untrusted_certs is not None:
            pulumi.set(__self__, "accept_untrusted_certs", accept_untrusted_certs)

    @property
    @pulumi.getter(name="caCert")
    def ca_cert(self) -> str:
        """
        The certificate from a Kubernetes secret object.
        """
        return pulumi.get(self, "ca_cert")

    @property
    @pulumi.getter
    def token(self) -> str:
        """
        The token from a Kubernetes secret object.
        """
        return pulumi.get(self, "token")

    @property
    @pulumi.getter(name="acceptUntrustedCerts")
    def accept_untrusted_certs(self) -> Optional[bool]:
        """
        Set this option to allow clients to accept a self-signed certificate. Defaults to `false`.
        """
        return pulumi.get(self, "accept_untrusted_certs")


@pulumi.output_type
class ServiceEndpointPipelineAuthPersonal(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "personalAccessToken":
            suggest = "personal_access_token"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceEndpointPipelineAuthPersonal. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceEndpointPipelineAuthPersonal.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceEndpointPipelineAuthPersonal.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 personal_access_token: str):
        """
        :param str personal_access_token: The Personal Access Token for Azure DevOps Pipeline. It also can be set with AZDO_PERSONAL_ACCESS_TOKEN environment variable.
        """
        pulumi.set(__self__, "personal_access_token", personal_access_token)

    @property
    @pulumi.getter(name="personalAccessToken")
    def personal_access_token(self) -> str:
        """
        The Personal Access Token for Azure DevOps Pipeline. It also can be set with AZDO_PERSONAL_ACCESS_TOKEN environment variable.
        """
        return pulumi.get(self, "personal_access_token")


@pulumi.output_type
class ServiceEndpointServiceFabricAzureActiveDirectory(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "serverCertificateLookup":
            suggest = "server_certificate_lookup"
        elif key == "serverCertificateCommonName":
            suggest = "server_certificate_common_name"
        elif key == "serverCertificateThumbprint":
            suggest = "server_certificate_thumbprint"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceEndpointServiceFabricAzureActiveDirectory. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceEndpointServiceFabricAzureActiveDirectory.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceEndpointServiceFabricAzureActiveDirectory.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 password: str,
                 server_certificate_lookup: str,
                 username: str,
                 server_certificate_common_name: Optional[str] = None,
                 server_certificate_thumbprint: Optional[str] = None):
        """
        :param str password: Password for the Azure Active Directory account.
        :param str server_certificate_lookup: Verification mode for the cluster. Possible values include `Thumbprint` or `CommonName`.
        :param str username: Specify an Azure Active Directory account.
        :param str server_certificate_common_name: The common name(s) of the cluster's certificate(s). This is used to verify the identity of the cluster. This value overrides the publish profile. Separate multiple common names with a comma (',')
        :param str server_certificate_thumbprint: The thumbprint(s) of the cluster's certificate(s). This is used to verify the identity of the cluster. This value overrides the publish profile. Separate multiple thumbprints with a comma (',')
        """
        pulumi.set(__self__, "password", password)
        pulumi.set(__self__, "server_certificate_lookup", server_certificate_lookup)
        pulumi.set(__self__, "username", username)
        if server_certificate_common_name is not None:
            pulumi.set(__self__, "server_certificate_common_name", server_certificate_common_name)
        if server_certificate_thumbprint is not None:
            pulumi.set(__self__, "server_certificate_thumbprint", server_certificate_thumbprint)

    @property
    @pulumi.getter
    def password(self) -> str:
        """
        Password for the Azure Active Directory account.
        """
        return pulumi.get(self, "password")

    @property
    @pulumi.getter(name="serverCertificateLookup")
    def server_certificate_lookup(self) -> str:
        """
        Verification mode for the cluster. Possible values include `Thumbprint` or `CommonName`.
        """
        return pulumi.get(self, "server_certificate_lookup")

    @property
    @pulumi.getter
    def username(self) -> str:
        """
        Specify an Azure Active Directory account.
        """
        return pulumi.get(self, "username")

    @property
    @pulumi.getter(name="serverCertificateCommonName")
    def server_certificate_common_name(self) -> Optional[str]:
        """
        The common name(s) of the cluster's certificate(s). This is used to verify the identity of the cluster. This value overrides the publish profile. Separate multiple common names with a comma (',')
        """
        return pulumi.get(self, "server_certificate_common_name")

    @property
    @pulumi.getter(name="serverCertificateThumbprint")
    def server_certificate_thumbprint(self) -> Optional[str]:
        """
        The thumbprint(s) of the cluster's certificate(s). This is used to verify the identity of the cluster. This value overrides the publish profile. Separate multiple thumbprints with a comma (',')
        """
        return pulumi.get(self, "server_certificate_thumbprint")


@pulumi.output_type
class ServiceEndpointServiceFabricCertificate(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "clientCertificate":
            suggest = "client_certificate"
        elif key == "serverCertificateLookup":
            suggest = "server_certificate_lookup"
        elif key == "clientCertificatePassword":
            suggest = "client_certificate_password"
        elif key == "serverCertificateCommonName":
            suggest = "server_certificate_common_name"
        elif key == "serverCertificateThumbprint":
            suggest = "server_certificate_thumbprint"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceEndpointServiceFabricCertificate. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceEndpointServiceFabricCertificate.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceEndpointServiceFabricCertificate.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 client_certificate: str,
                 server_certificate_lookup: str,
                 client_certificate_password: Optional[str] = None,
                 server_certificate_common_name: Optional[str] = None,
                 server_certificate_thumbprint: Optional[str] = None):
        """
        :param str client_certificate: Base64 encoding of the cluster's client certificate file.
        :param str server_certificate_lookup: Verification mode for the cluster. Possible values include `Thumbprint` or `CommonName`.
        :param str client_certificate_password: Password for the certificate.
        :param str server_certificate_common_name: The common name(s) of the cluster's certificate(s). This is used to verify the identity of the cluster. This value overrides the publish profile. Separate multiple common names with a comma (',')
        :param str server_certificate_thumbprint: The thumbprint(s) of the cluster's certificate(s). This is used to verify the identity of the cluster. This value overrides the publish profile. Separate multiple thumbprints with a comma (',')
        """
        pulumi.set(__self__, "client_certificate", client_certificate)
        pulumi.set(__self__, "server_certificate_lookup", server_certificate_lookup)
        if client_certificate_password is not None:
            pulumi.set(__self__, "client_certificate_password", client_certificate_password)
        if server_certificate_common_name is not None:
            pulumi.set(__self__, "server_certificate_common_name", server_certificate_common_name)
        if server_certificate_thumbprint is not None:
            pulumi.set(__self__, "server_certificate_thumbprint", server_certificate_thumbprint)

    @property
    @pulumi.getter(name="clientCertificate")
    def client_certificate(self) -> str:
        """
        Base64 encoding of the cluster's client certificate file.
        """
        return pulumi.get(self, "client_certificate")

    @property
    @pulumi.getter(name="serverCertificateLookup")
    def server_certificate_lookup(self) -> str:
        """
        Verification mode for the cluster. Possible values include `Thumbprint` or `CommonName`.
        """
        return pulumi.get(self, "server_certificate_lookup")

    @property
    @pulumi.getter(name="clientCertificatePassword")
    def client_certificate_password(self) -> Optional[str]:
        """
        Password for the certificate.
        """
        return pulumi.get(self, "client_certificate_password")

    @property
    @pulumi.getter(name="serverCertificateCommonName")
    def server_certificate_common_name(self) -> Optional[str]:
        """
        The common name(s) of the cluster's certificate(s). This is used to verify the identity of the cluster. This value overrides the publish profile. Separate multiple common names with a comma (',')
        """
        return pulumi.get(self, "server_certificate_common_name")

    @property
    @pulumi.getter(name="serverCertificateThumbprint")
    def server_certificate_thumbprint(self) -> Optional[str]:
        """
        The thumbprint(s) of the cluster's certificate(s). This is used to verify the identity of the cluster. This value overrides the publish profile. Separate multiple thumbprints with a comma (',')
        """
        return pulumi.get(self, "server_certificate_thumbprint")


@pulumi.output_type
class ServiceEndpointServiceFabricNone(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "clusterSpn":
            suggest = "cluster_spn"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceEndpointServiceFabricNone. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceEndpointServiceFabricNone.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceEndpointServiceFabricNone.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cluster_spn: Optional[str] = None,
                 unsecured: Optional[bool] = None):
        """
        :param str cluster_spn: Fully qualified domain SPN for gMSA account. This is applicable only if `unsecured` option is disabled.
        :param bool unsecured: Skip using windows security for authentication.
        """
        if cluster_spn is not None:
            pulumi.set(__self__, "cluster_spn", cluster_spn)
        if unsecured is not None:
            pulumi.set(__self__, "unsecured", unsecured)

    @property
    @pulumi.getter(name="clusterSpn")
    def cluster_spn(self) -> Optional[str]:
        """
        Fully qualified domain SPN for gMSA account. This is applicable only if `unsecured` option is disabled.
        """
        return pulumi.get(self, "cluster_spn")

    @property
    @pulumi.getter
    def unsecured(self) -> Optional[bool]:
        """
        Skip using windows security for authentication.
        """
        return pulumi.get(self, "unsecured")


@pulumi.output_type
class ServiceendpointArgocdAuthenticationBasic(dict):
    def __init__(__self__, *,
                 password: str,
                 username: str):
        """
        :param str password: ArgoCD Password.
        :param str username: ArgoCD Username.
        """
        pulumi.set(__self__, "password", password)
        pulumi.set(__self__, "username", username)

    @property
    @pulumi.getter
    def password(self) -> str:
        """
        ArgoCD Password.
        """
        return pulumi.get(self, "password")

    @property
    @pulumi.getter
    def username(self) -> str:
        """
        ArgoCD Username.
        """
        return pulumi.get(self, "username")


@pulumi.output_type
class ServiceendpointArgocdAuthenticationToken(dict):
    def __init__(__self__, *,
                 token: str):
        """
        :param str token: Authentication Token generated through ArgoCD.
        """
        pulumi.set(__self__, "token", token)

    @property
    @pulumi.getter
    def token(self) -> str:
        """
        Authentication Token generated through ArgoCD.
        """
        return pulumi.get(self, "token")


@pulumi.output_type
class ServiceendpointExternaltfsAuthPersonal(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "personalAccessToken":
            suggest = "personal_access_token"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceendpointExternaltfsAuthPersonal. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceendpointExternaltfsAuthPersonal.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceendpointExternaltfsAuthPersonal.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 personal_access_token: str):
        """
        :param str personal_access_token: The Personal Access Token for Azure DevOps Organization.
        """
        pulumi.set(__self__, "personal_access_token", personal_access_token)

    @property
    @pulumi.getter(name="personalAccessToken")
    def personal_access_token(self) -> str:
        """
        The Personal Access Token for Azure DevOps Organization.
        """
        return pulumi.get(self, "personal_access_token")


@pulumi.output_type
class ServiceendpointJfrogArtifactoryV2AuthenticationBasic(dict):
    def __init__(__self__, *,
                 password: str,
                 username: str):
        """
        :param str password: Artifactory Password.
        :param str username: Artifactory Username.
        """
        pulumi.set(__self__, "password", password)
        pulumi.set(__self__, "username", username)

    @property
    @pulumi.getter
    def password(self) -> str:
        """
        Artifactory Password.
        """
        return pulumi.get(self, "password")

    @property
    @pulumi.getter
    def username(self) -> str:
        """
        Artifactory Username.
        """
        return pulumi.get(self, "username")


@pulumi.output_type
class ServiceendpointJfrogArtifactoryV2AuthenticationToken(dict):
    def __init__(__self__, *,
                 token: str):
        """
        :param str token: Authentication Token generated through Artifactory.
        """
        pulumi.set(__self__, "token", token)

    @property
    @pulumi.getter
    def token(self) -> str:
        """
        Authentication Token generated through Artifactory.
        """
        return pulumi.get(self, "token")


@pulumi.output_type
class ServiceendpointJfrogDistributionV2AuthenticationBasic(dict):
    def __init__(__self__, *,
                 password: str,
                 username: str):
        """
        :param str password: Artifactory Password.
        :param str username: Artifactory Username.
        """
        pulumi.set(__self__, "password", password)
        pulumi.set(__self__, "username", username)

    @property
    @pulumi.getter
    def password(self) -> str:
        """
        Artifactory Password.
        """
        return pulumi.get(self, "password")

    @property
    @pulumi.getter
    def username(self) -> str:
        """
        Artifactory Username.
        """
        return pulumi.get(self, "username")


@pulumi.output_type
class ServiceendpointJfrogDistributionV2AuthenticationToken(dict):
    def __init__(__self__, *,
                 token: str):
        """
        :param str token: Authentication Token generated through Artifactory.
        """
        pulumi.set(__self__, "token", token)

    @property
    @pulumi.getter
    def token(self) -> str:
        """
        Authentication Token generated through Artifactory.
        """
        return pulumi.get(self, "token")


@pulumi.output_type
class ServiceendpointJfrogPlatformV2AuthenticationBasic(dict):
    def __init__(__self__, *,
                 password: str,
                 username: str):
        """
        :param str password: Artifactory Password.
        :param str username: Artifactory Username.
        """
        pulumi.set(__self__, "password", password)
        pulumi.set(__self__, "username", username)

    @property
    @pulumi.getter
    def password(self) -> str:
        """
        Artifactory Password.
        """
        return pulumi.get(self, "password")

    @property
    @pulumi.getter
    def username(self) -> str:
        """
        Artifactory Username.
        """
        return pulumi.get(self, "username")


@pulumi.output_type
class ServiceendpointJfrogPlatformV2AuthenticationToken(dict):
    def __init__(__self__, *,
                 token: str):
        """
        :param str token: Authentication Token generated through Artifactory.
        """
        pulumi.set(__self__, "token", token)

    @property
    @pulumi.getter
    def token(self) -> str:
        """
        Authentication Token generated through Artifactory.
        """
        return pulumi.get(self, "token")


@pulumi.output_type
class ServiceendpointJfrogXrayV2AuthenticationBasic(dict):
    def __init__(__self__, *,
                 password: str,
                 username: str):
        """
        :param str password: Artifactory Password.
        :param str username: Artifactory Username.
        """
        pulumi.set(__self__, "password", password)
        pulumi.set(__self__, "username", username)

    @property
    @pulumi.getter
    def password(self) -> str:
        """
        Artifactory Password.
        """
        return pulumi.get(self, "password")

    @property
    @pulumi.getter
    def username(self) -> str:
        """
        Artifactory Username.
        """
        return pulumi.get(self, "username")


@pulumi.output_type
class ServiceendpointJfrogXrayV2AuthenticationToken(dict):
    def __init__(__self__, *,
                 token: str):
        """
        :param str token: Authentication Token generated through Artifactory.
        """
        pulumi.set(__self__, "token", token)

    @property
    @pulumi.getter
    def token(self) -> str:
        """
        Authentication Token generated through Artifactory.
        """
        return pulumi.get(self, "token")


@pulumi.output_type
class ServiceendpointMavenAuthenticationBasic(dict):
    def __init__(__self__, *,
                 password: str,
                 username: str):
        """
        :param str password: The password Maven Repository.
        :param str username: The Username of the Maven Repository.
        """
        pulumi.set(__self__, "password", password)
        pulumi.set(__self__, "username", username)

    @property
    @pulumi.getter
    def password(self) -> str:
        """
        The password Maven Repository.
        """
        return pulumi.get(self, "password")

    @property
    @pulumi.getter
    def username(self) -> str:
        """
        The Username of the Maven Repository.
        """
        return pulumi.get(self, "username")


@pulumi.output_type
class ServiceendpointMavenAuthenticationToken(dict):
    def __init__(__self__, *,
                 token: str):
        """
        :param str token: Authentication Token generated through maven repository.
        """
        pulumi.set(__self__, "token", token)

    @property
    @pulumi.getter
    def token(self) -> str:
        """
        Authentication Token generated through maven repository.
        """
        return pulumi.get(self, "token")


@pulumi.output_type
class ServiceendpointVisualstudiomarketplaceAuthenticationBasic(dict):
    def __init__(__self__, *,
                 password: str,
                 username: str):
        """
        :param str password: The password of the marketplace.
        :param str username: The username of the marketplace.
        """
        pulumi.set(__self__, "password", password)
        pulumi.set(__self__, "username", username)

    @property
    @pulumi.getter
    def password(self) -> str:
        """
        The password of the marketplace.
        """
        return pulumi.get(self, "password")

    @property
    @pulumi.getter
    def username(self) -> str:
        """
        The username of the marketplace.
        """
        return pulumi.get(self, "username")


@pulumi.output_type
class ServiceendpointVisualstudiomarketplaceAuthenticationToken(dict):
    def __init__(__self__, *,
                 token: str):
        """
        :param str token: The Personal Access Token.
        """
        pulumi.set(__self__, "token", token)

    @property
    @pulumi.getter
    def token(self) -> str:
        """
        The Personal Access Token.
        """
        return pulumi.get(self, "token")


@pulumi.output_type
class ServicehookStorageQueuePipelinesRunStateChangedEvent(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "pipelineId":
            suggest = "pipeline_id"
        elif key == "runResultFilter":
            suggest = "run_result_filter"
        elif key == "runStateFilter":
            suggest = "run_state_filter"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServicehookStorageQueuePipelinesRunStateChangedEvent. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServicehookStorageQueuePipelinesRunStateChangedEvent.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServicehookStorageQueuePipelinesRunStateChangedEvent.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 pipeline_id: Optional[str] = None,
                 run_result_filter: Optional[str] = None,
                 run_state_filter: Optional[str] = None):
        """
        :param str pipeline_id: The pipeline ID that will generate an event. If not specified, all pipelines in the project will trigger the event.
        :param str run_result_filter: Which run result should generate an event. Only valid if published_event is `RunStateChanged`. If not specified, all results will trigger the event.
        :param str run_state_filter: Which run state should generate an event. Only valid if published_event is `RunStateChanged`. If not specified, all states will trigger the event.
        """
        if pipeline_id is not None:
            pulumi.set(__self__, "pipeline_id", pipeline_id)
        if run_result_filter is not None:
            pulumi.set(__self__, "run_result_filter", run_result_filter)
        if run_state_filter is not None:
            pulumi.set(__self__, "run_state_filter", run_state_filter)

    @property
    @pulumi.getter(name="pipelineId")
    def pipeline_id(self) -> Optional[str]:
        """
        The pipeline ID that will generate an event. If not specified, all pipelines in the project will trigger the event.
        """
        return pulumi.get(self, "pipeline_id")

    @property
    @pulumi.getter(name="runResultFilter")
    def run_result_filter(self) -> Optional[str]:
        """
        Which run result should generate an event. Only valid if published_event is `RunStateChanged`. If not specified, all results will trigger the event.
        """
        return pulumi.get(self, "run_result_filter")

    @property
    @pulumi.getter(name="runStateFilter")
    def run_state_filter(self) -> Optional[str]:
        """
        Which run state should generate an event. Only valid if published_event is `RunStateChanged`. If not specified, all states will trigger the event.
        """
        return pulumi.get(self, "run_state_filter")


@pulumi.output_type
class ServicehookStorageQueuePipelinesStageStateChangedEvent(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "pipelineId":
            suggest = "pipeline_id"
        elif key == "stageName":
            suggest = "stage_name"
        elif key == "stageResultFilter":
            suggest = "stage_result_filter"
        elif key == "stageStateFilter":
            suggest = "stage_state_filter"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServicehookStorageQueuePipelinesStageStateChangedEvent. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServicehookStorageQueuePipelinesStageStateChangedEvent.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServicehookStorageQueuePipelinesStageStateChangedEvent.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 pipeline_id: Optional[str] = None,
                 stage_name: Optional[str] = None,
                 stage_result_filter: Optional[str] = None,
                 stage_state_filter: Optional[str] = None):
        """
        :param str pipeline_id: The pipeline ID that will generate an event.
        :param str stage_name: Which stage should generate an event. Only valid if published_event is `StageStateChanged`. If not specified, all stages will trigger the event.
        :param str stage_result_filter: Which stage result should generate an event. Only valid if published_event is `StageStateChanged`. If not specified, all results will trigger the event.
        :param str stage_state_filter: Which stage state should generate an event. Only valid if published_event is `StageStateChanged`. If not specified, all states will trigger the event.
        """
        if pipeline_id is not None:
            pulumi.set(__self__, "pipeline_id", pipeline_id)
        if stage_name is not None:
            pulumi.set(__self__, "stage_name", stage_name)
        if stage_result_filter is not None:
            pulumi.set(__self__, "stage_result_filter", stage_result_filter)
        if stage_state_filter is not None:
            pulumi.set(__self__, "stage_state_filter", stage_state_filter)

    @property
    @pulumi.getter(name="pipelineId")
    def pipeline_id(self) -> Optional[str]:
        """
        The pipeline ID that will generate an event.
        """
        return pulumi.get(self, "pipeline_id")

    @property
    @pulumi.getter(name="stageName")
    def stage_name(self) -> Optional[str]:
        """
        Which stage should generate an event. Only valid if published_event is `StageStateChanged`. If not specified, all stages will trigger the event.
        """
        return pulumi.get(self, "stage_name")

    @property
    @pulumi.getter(name="stageResultFilter")
    def stage_result_filter(self) -> Optional[str]:
        """
        Which stage result should generate an event. Only valid if published_event is `StageStateChanged`. If not specified, all results will trigger the event.
        """
        return pulumi.get(self, "stage_result_filter")

    @property
    @pulumi.getter(name="stageStateFilter")
    def stage_state_filter(self) -> Optional[str]:
        """
        Which stage state should generate an event. Only valid if published_event is `StageStateChanged`. If not specified, all states will trigger the event.
        """
        return pulumi.get(self, "stage_state_filter")


@pulumi.output_type
class VariableGroupKeyVault(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "serviceEndpointId":
            suggest = "service_endpoint_id"
        elif key == "searchDepth":
            suggest = "search_depth"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VariableGroupKeyVault. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VariableGroupKeyVault.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VariableGroupKeyVault.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: str,
                 service_endpoint_id: str,
                 search_depth: Optional[int] = None):
        """
        :param str name: The name of the Azure key vault to link secrets from as variables.
        :param str service_endpoint_id: The id of the Azure subscription endpoint to access the key vault.
        :param int search_depth: Set the Azure Key Vault Secret search depth. Defaults to `20`.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "service_endpoint_id", service_endpoint_id)
        if search_depth is not None:
            pulumi.set(__self__, "search_depth", search_depth)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the Azure key vault to link secrets from as variables.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="serviceEndpointId")
    def service_endpoint_id(self) -> str:
        """
        The id of the Azure subscription endpoint to access the key vault.
        """
        return pulumi.get(self, "service_endpoint_id")

    @property
    @pulumi.getter(name="searchDepth")
    def search_depth(self) -> Optional[int]:
        """
        Set the Azure Key Vault Secret search depth. Defaults to `20`.
        """
        return pulumi.get(self, "search_depth")


@pulumi.output_type
class VariableGroupVariable(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "contentType":
            suggest = "content_type"
        elif key == "isSecret":
            suggest = "is_secret"
        elif key == "secretValue":
            suggest = "secret_value"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VariableGroupVariable. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VariableGroupVariable.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VariableGroupVariable.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: str,
                 content_type: Optional[str] = None,
                 enabled: Optional[bool] = None,
                 expires: Optional[str] = None,
                 is_secret: Optional[bool] = None,
                 secret_value: Optional[str] = None,
                 value: Optional[str] = None):
        """
        :param str name: The key value used for the variable. Must be unique within the Variable Group.
        :param bool is_secret: A boolean flag describing if the variable value is sensitive. Defaults to `false`.
        :param str secret_value: The secret value of the variable. If omitted, it will default to empty string. Used when `is_secret` set to `true`.
        :param str value: The value of the variable. If omitted, it will default to empty string.
        """
        pulumi.set(__self__, "name", name)
        if content_type is not None:
            pulumi.set(__self__, "content_type", content_type)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if expires is not None:
            pulumi.set(__self__, "expires", expires)
        if is_secret is not None:
            pulumi.set(__self__, "is_secret", is_secret)
        if secret_value is not None:
            pulumi.set(__self__, "secret_value", secret_value)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The key value used for the variable. Must be unique within the Variable Group.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="contentType")
    def content_type(self) -> Optional[str]:
        return pulumi.get(self, "content_type")

    @property
    @pulumi.getter
    def enabled(self) -> Optional[bool]:
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter
    def expires(self) -> Optional[str]:
        return pulumi.get(self, "expires")

    @property
    @pulumi.getter(name="isSecret")
    def is_secret(self) -> Optional[bool]:
        """
        A boolean flag describing if the variable value is sensitive. Defaults to `false`.
        """
        return pulumi.get(self, "is_secret")

    @property
    @pulumi.getter(name="secretValue")
    def secret_value(self) -> Optional[str]:
        """
        The secret value of the variable. If omitted, it will default to empty string. Used when `is_secret` set to `true`.
        """
        return pulumi.get(self, "secret_value")

    @property
    @pulumi.getter
    def value(self) -> Optional[str]:
        """
        The value of the variable. If omitted, it will default to empty string.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class GetAreaChildrenResult(dict):
    def __init__(__self__, *,
                 has_children: bool,
                 id: str,
                 name: str,
                 path: str,
                 project_id: str):
        """
        :param bool has_children: Indicator if the child Area node has child nodes
        :param str id: The id of the child Area node
        :param str name: The name of the child Area node
        :param str path: The path to the Area; _Format_: URL relative; if omitted, or value `"/"` is used, the root Area will be returned
        :param str project_id: The project ID.
        """
        pulumi.set(__self__, "has_children", has_children)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "path", path)
        pulumi.set(__self__, "project_id", project_id)

    @property
    @pulumi.getter(name="hasChildren")
    def has_children(self) -> bool:
        """
        Indicator if the child Area node has child nodes
        """
        return pulumi.get(self, "has_children")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The id of the child Area node
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the child Area node
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def path(self) -> str:
        """
        The path to the Area; _Format_: URL relative; if omitted, or value `"/"` is used, the root Area will be returned
        """
        return pulumi.get(self, "path")

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> str:
        """
        The project ID.
        """
        return pulumi.get(self, "project_id")


@pulumi.output_type
class GetBuildDefinitionCiTriggerResult(dict):
    def __init__(__self__, *,
                 overrides: Sequence['outputs.GetBuildDefinitionCiTriggerOverrideResult'],
                 use_yaml: bool):
        """
        :param Sequence['GetBuildDefinitionCiTriggerOverrideArgs'] overrides: A `override` block as defined below.
        :param bool use_yaml: Use the azure-pipeline file for the build configuration.
        """
        pulumi.set(__self__, "overrides", overrides)
        pulumi.set(__self__, "use_yaml", use_yaml)

    @property
    @pulumi.getter
    def overrides(self) -> Sequence['outputs.GetBuildDefinitionCiTriggerOverrideResult']:
        """
        A `override` block as defined below.
        """
        return pulumi.get(self, "overrides")

    @property
    @pulumi.getter(name="useYaml")
    def use_yaml(self) -> bool:
        """
        Use the azure-pipeline file for the build configuration.
        """
        return pulumi.get(self, "use_yaml")


@pulumi.output_type
class GetBuildDefinitionCiTriggerOverrideResult(dict):
    def __init__(__self__, *,
                 batch: bool,
                 branch_filters: Sequence['outputs.GetBuildDefinitionCiTriggerOverrideBranchFilterResult'],
                 max_concurrent_builds_per_branch: int,
                 path_filters: Sequence['outputs.GetBuildDefinitionCiTriggerOverridePathFilterResult'],
                 polling_interval: int,
                 polling_job_id: str):
        """
        :param bool batch: If batch is true, when a pipeline is running, the system waits until the run is completed, then starts another run with all changes that have not yet been built.
        :param Sequence['GetBuildDefinitionCiTriggerOverrideBranchFilterArgs'] branch_filters: A `branch_filter` block as defined above.
        :param int max_concurrent_builds_per_branch: The number of max builds per branch.
        :param Sequence['GetBuildDefinitionCiTriggerOverridePathFilterArgs'] path_filters: block supports the following:
        :param int polling_interval: How often the external repository is polled.
        :param str polling_job_id: This is the ID of the polling job that polls the external repository. Once the build definition is saved/updated, this value is set.
        """
        pulumi.set(__self__, "batch", batch)
        pulumi.set(__self__, "branch_filters", branch_filters)
        pulumi.set(__self__, "max_concurrent_builds_per_branch", max_concurrent_builds_per_branch)
        pulumi.set(__self__, "path_filters", path_filters)
        pulumi.set(__self__, "polling_interval", polling_interval)
        pulumi.set(__self__, "polling_job_id", polling_job_id)

    @property
    @pulumi.getter
    def batch(self) -> bool:
        """
        If batch is true, when a pipeline is running, the system waits until the run is completed, then starts another run with all changes that have not yet been built.
        """
        return pulumi.get(self, "batch")

    @property
    @pulumi.getter(name="branchFilters")
    def branch_filters(self) -> Sequence['outputs.GetBuildDefinitionCiTriggerOverrideBranchFilterResult']:
        """
        A `branch_filter` block as defined above.
        """
        return pulumi.get(self, "branch_filters")

    @property
    @pulumi.getter(name="maxConcurrentBuildsPerBranch")
    def max_concurrent_builds_per_branch(self) -> int:
        """
        The number of max builds per branch.
        """
        return pulumi.get(self, "max_concurrent_builds_per_branch")

    @property
    @pulumi.getter(name="pathFilters")
    def path_filters(self) -> Sequence['outputs.GetBuildDefinitionCiTriggerOverridePathFilterResult']:
        """
        block supports the following:
        """
        return pulumi.get(self, "path_filters")

    @property
    @pulumi.getter(name="pollingInterval")
    def polling_interval(self) -> int:
        """
        How often the external repository is polled.
        """
        return pulumi.get(self, "polling_interval")

    @property
    @pulumi.getter(name="pollingJobId")
    def polling_job_id(self) -> str:
        """
        This is the ID of the polling job that polls the external repository. Once the build definition is saved/updated, this value is set.
        """
        return pulumi.get(self, "polling_job_id")


@pulumi.output_type
class GetBuildDefinitionCiTriggerOverrideBranchFilterResult(dict):
    def __init__(__self__, *,
                 excludes: Sequence[str],
                 includes: Sequence[str]):
        """
        :param Sequence[str] excludes: (Optional) List of path patterns to exclude.
        :param Sequence[str] includes: (Optional) List of path patterns to include.
        """
        pulumi.set(__self__, "excludes", excludes)
        pulumi.set(__self__, "includes", includes)

    @property
    @pulumi.getter
    def excludes(self) -> Sequence[str]:
        """
        (Optional) List of path patterns to exclude.
        """
        return pulumi.get(self, "excludes")

    @property
    @pulumi.getter
    def includes(self) -> Sequence[str]:
        """
        (Optional) List of path patterns to include.
        """
        return pulumi.get(self, "includes")


@pulumi.output_type
class GetBuildDefinitionCiTriggerOverridePathFilterResult(dict):
    def __init__(__self__, *,
                 excludes: Sequence[str],
                 includes: Sequence[str]):
        """
        :param Sequence[str] excludes: (Optional) List of path patterns to exclude.
        :param Sequence[str] includes: (Optional) List of path patterns to include.
        """
        pulumi.set(__self__, "excludes", excludes)
        pulumi.set(__self__, "includes", includes)

    @property
    @pulumi.getter
    def excludes(self) -> Sequence[str]:
        """
        (Optional) List of path patterns to exclude.
        """
        return pulumi.get(self, "excludes")

    @property
    @pulumi.getter
    def includes(self) -> Sequence[str]:
        """
        (Optional) List of path patterns to include.
        """
        return pulumi.get(self, "includes")


@pulumi.output_type
class GetBuildDefinitionPullRequestTriggerResult(dict):
    def __init__(__self__, *,
                 comment_required: str,
                 forks: Sequence['outputs.GetBuildDefinitionPullRequestTriggerForkResult'],
                 initial_branch: str,
                 overrides: Sequence['outputs.GetBuildDefinitionPullRequestTriggerOverrideResult'],
                 use_yaml: bool):
        """
        :param str comment_required: Is a comment required on the PR?
        :param Sequence['GetBuildDefinitionPullRequestTriggerForkArgs'] forks: A `forks` block as defined above.
        :param str initial_branch: When use_yaml is true set this to the name of the branch that the azure-pipelines.yml exists on.
        :param Sequence['GetBuildDefinitionPullRequestTriggerOverrideArgs'] overrides: A `override` block as defined below.
        :param bool use_yaml: Use the azure-pipeline file for the build configuration.
        """
        pulumi.set(__self__, "comment_required", comment_required)
        pulumi.set(__self__, "forks", forks)
        pulumi.set(__self__, "initial_branch", initial_branch)
        pulumi.set(__self__, "overrides", overrides)
        pulumi.set(__self__, "use_yaml", use_yaml)

    @property
    @pulumi.getter(name="commentRequired")
    def comment_required(self) -> str:
        """
        Is a comment required on the PR?
        """
        return pulumi.get(self, "comment_required")

    @property
    @pulumi.getter
    def forks(self) -> Sequence['outputs.GetBuildDefinitionPullRequestTriggerForkResult']:
        """
        A `forks` block as defined above.
        """
        return pulumi.get(self, "forks")

    @property
    @pulumi.getter(name="initialBranch")
    def initial_branch(self) -> str:
        """
        When use_yaml is true set this to the name of the branch that the azure-pipelines.yml exists on.
        """
        return pulumi.get(self, "initial_branch")

    @property
    @pulumi.getter
    def overrides(self) -> Sequence['outputs.GetBuildDefinitionPullRequestTriggerOverrideResult']:
        """
        A `override` block as defined below.
        """
        return pulumi.get(self, "overrides")

    @property
    @pulumi.getter(name="useYaml")
    def use_yaml(self) -> bool:
        """
        Use the azure-pipeline file for the build configuration.
        """
        return pulumi.get(self, "use_yaml")


@pulumi.output_type
class GetBuildDefinitionPullRequestTriggerForkResult(dict):
    def __init__(__self__, *,
                 enabled: bool,
                 share_secrets: bool):
        """
        :param bool enabled: Build pull requests from forks of this repository.
        :param bool share_secrets: Make secrets available to builds of forks.
        """
        pulumi.set(__self__, "enabled", enabled)
        pulumi.set(__self__, "share_secrets", share_secrets)

    @property
    @pulumi.getter
    def enabled(self) -> bool:
        """
        Build pull requests from forks of this repository.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter(name="shareSecrets")
    def share_secrets(self) -> bool:
        """
        Make secrets available to builds of forks.
        """
        return pulumi.get(self, "share_secrets")


@pulumi.output_type
class GetBuildDefinitionPullRequestTriggerOverrideResult(dict):
    def __init__(__self__, *,
                 auto_cancel: bool,
                 branch_filters: Sequence['outputs.GetBuildDefinitionPullRequestTriggerOverrideBranchFilterResult'],
                 path_filters: Sequence['outputs.GetBuildDefinitionPullRequestTriggerOverridePathFilterResult']):
        """
        :param bool auto_cancel: Should further updates to a PR cancel an in progress validation?
        :param Sequence['GetBuildDefinitionPullRequestTriggerOverrideBranchFilterArgs'] branch_filters: A `branch_filter` block as defined above.
        :param Sequence['GetBuildDefinitionPullRequestTriggerOverridePathFilterArgs'] path_filters: block supports the following:
        """
        pulumi.set(__self__, "auto_cancel", auto_cancel)
        pulumi.set(__self__, "branch_filters", branch_filters)
        pulumi.set(__self__, "path_filters", path_filters)

    @property
    @pulumi.getter(name="autoCancel")
    def auto_cancel(self) -> bool:
        """
        Should further updates to a PR cancel an in progress validation?
        """
        return pulumi.get(self, "auto_cancel")

    @property
    @pulumi.getter(name="branchFilters")
    def branch_filters(self) -> Sequence['outputs.GetBuildDefinitionPullRequestTriggerOverrideBranchFilterResult']:
        """
        A `branch_filter` block as defined above.
        """
        return pulumi.get(self, "branch_filters")

    @property
    @pulumi.getter(name="pathFilters")
    def path_filters(self) -> Sequence['outputs.GetBuildDefinitionPullRequestTriggerOverridePathFilterResult']:
        """
        block supports the following:
        """
        return pulumi.get(self, "path_filters")


@pulumi.output_type
class GetBuildDefinitionPullRequestTriggerOverrideBranchFilterResult(dict):
    def __init__(__self__, *,
                 excludes: Sequence[str],
                 includes: Sequence[str]):
        """
        :param Sequence[str] excludes: (Optional) List of path patterns to exclude.
        :param Sequence[str] includes: (Optional) List of path patterns to include.
        """
        pulumi.set(__self__, "excludes", excludes)
        pulumi.set(__self__, "includes", includes)

    @property
    @pulumi.getter
    def excludes(self) -> Sequence[str]:
        """
        (Optional) List of path patterns to exclude.
        """
        return pulumi.get(self, "excludes")

    @property
    @pulumi.getter
    def includes(self) -> Sequence[str]:
        """
        (Optional) List of path patterns to include.
        """
        return pulumi.get(self, "includes")


@pulumi.output_type
class GetBuildDefinitionPullRequestTriggerOverridePathFilterResult(dict):
    def __init__(__self__, *,
                 excludes: Sequence[str],
                 includes: Sequence[str]):
        """
        :param Sequence[str] excludes: (Optional) List of path patterns to exclude.
        :param Sequence[str] includes: (Optional) List of path patterns to include.
        """
        pulumi.set(__self__, "excludes", excludes)
        pulumi.set(__self__, "includes", includes)

    @property
    @pulumi.getter
    def excludes(self) -> Sequence[str]:
        """
        (Optional) List of path patterns to exclude.
        """
        return pulumi.get(self, "excludes")

    @property
    @pulumi.getter
    def includes(self) -> Sequence[str]:
        """
        (Optional) List of path patterns to include.
        """
        return pulumi.get(self, "includes")


@pulumi.output_type
class GetBuildDefinitionRepositoryResult(dict):
    def __init__(__self__, *,
                 branch_name: str,
                 github_enterprise_url: str,
                 repo_id: str,
                 repo_type: str,
                 report_build_status: bool,
                 service_connection_id: str,
                 yml_path: str):
        """
        :param str branch_name: The branch name for which builds are triggered.
        :param str github_enterprise_url: The Github Enterprise URL.
        :param str repo_id: The id of the repository.
        :param str repo_type: The repository type.
        :param bool report_build_status: Report build status.
        :param str service_connection_id: The service connection ID.
        :param str yml_path: The path of the Yaml file describing the build definition.
        """
        pulumi.set(__self__, "branch_name", branch_name)
        pulumi.set(__self__, "github_enterprise_url", github_enterprise_url)
        pulumi.set(__self__, "repo_id", repo_id)
        pulumi.set(__self__, "repo_type", repo_type)
        pulumi.set(__self__, "report_build_status", report_build_status)
        pulumi.set(__self__, "service_connection_id", service_connection_id)
        pulumi.set(__self__, "yml_path", yml_path)

    @property
    @pulumi.getter(name="branchName")
    def branch_name(self) -> str:
        """
        The branch name for which builds are triggered.
        """
        return pulumi.get(self, "branch_name")

    @property
    @pulumi.getter(name="githubEnterpriseUrl")
    def github_enterprise_url(self) -> str:
        """
        The Github Enterprise URL.
        """
        return pulumi.get(self, "github_enterprise_url")

    @property
    @pulumi.getter(name="repoId")
    def repo_id(self) -> str:
        """
        The id of the repository.
        """
        return pulumi.get(self, "repo_id")

    @property
    @pulumi.getter(name="repoType")
    def repo_type(self) -> str:
        """
        The repository type.
        """
        return pulumi.get(self, "repo_type")

    @property
    @pulumi.getter(name="reportBuildStatus")
    def report_build_status(self) -> bool:
        """
        Report build status.
        """
        return pulumi.get(self, "report_build_status")

    @property
    @pulumi.getter(name="serviceConnectionId")
    def service_connection_id(self) -> str:
        """
        The service connection ID.
        """
        return pulumi.get(self, "service_connection_id")

    @property
    @pulumi.getter(name="ymlPath")
    def yml_path(self) -> str:
        """
        The path of the Yaml file describing the build definition.
        """
        return pulumi.get(self, "yml_path")


@pulumi.output_type
class GetBuildDefinitionScheduleResult(dict):
    def __init__(__self__, *,
                 branch_filters: Sequence['outputs.GetBuildDefinitionScheduleBranchFilterResult'],
                 days_to_builds: Sequence[str],
                 schedule_job_id: str,
                 schedule_only_with_changes: bool,
                 start_hours: int,
                 start_minutes: int,
                 time_zone: str):
        """
        :param Sequence['GetBuildDefinitionScheduleBranchFilterArgs'] branch_filters: A `branch_filter` block as defined above.
        :param Sequence[str] days_to_builds: A list of days to build on.
        :param str schedule_job_id: The ID of the schedule job.
        :param bool schedule_only_with_changes: Schedule builds if the source or pipeline has changed.
        :param int start_hours: Build start hour.
        :param int start_minutes: Build start minute.
        :param str time_zone: Build time zone.
        """
        pulumi.set(__self__, "branch_filters", branch_filters)
        pulumi.set(__self__, "days_to_builds", days_to_builds)
        pulumi.set(__self__, "schedule_job_id", schedule_job_id)
        pulumi.set(__self__, "schedule_only_with_changes", schedule_only_with_changes)
        pulumi.set(__self__, "start_hours", start_hours)
        pulumi.set(__self__, "start_minutes", start_minutes)
        pulumi.set(__self__, "time_zone", time_zone)

    @property
    @pulumi.getter(name="branchFilters")
    def branch_filters(self) -> Sequence['outputs.GetBuildDefinitionScheduleBranchFilterResult']:
        """
        A `branch_filter` block as defined above.
        """
        return pulumi.get(self, "branch_filters")

    @property
    @pulumi.getter(name="daysToBuilds")
    def days_to_builds(self) -> Sequence[str]:
        """
        A list of days to build on.
        """
        return pulumi.get(self, "days_to_builds")

    @property
    @pulumi.getter(name="scheduleJobId")
    def schedule_job_id(self) -> str:
        """
        The ID of the schedule job.
        """
        return pulumi.get(self, "schedule_job_id")

    @property
    @pulumi.getter(name="scheduleOnlyWithChanges")
    def schedule_only_with_changes(self) -> bool:
        """
        Schedule builds if the source or pipeline has changed.
        """
        return pulumi.get(self, "schedule_only_with_changes")

    @property
    @pulumi.getter(name="startHours")
    def start_hours(self) -> int:
        """
        Build start hour.
        """
        return pulumi.get(self, "start_hours")

    @property
    @pulumi.getter(name="startMinutes")
    def start_minutes(self) -> int:
        """
        Build start minute.
        """
        return pulumi.get(self, "start_minutes")

    @property
    @pulumi.getter(name="timeZone")
    def time_zone(self) -> str:
        """
        Build time zone.
        """
        return pulumi.get(self, "time_zone")


@pulumi.output_type
class GetBuildDefinitionScheduleBranchFilterResult(dict):
    def __init__(__self__, *,
                 excludes: Sequence[str],
                 includes: Sequence[str]):
        """
        :param Sequence[str] excludes: (Optional) List of path patterns to exclude.
        :param Sequence[str] includes: (Optional) List of path patterns to include.
        """
        pulumi.set(__self__, "excludes", excludes)
        pulumi.set(__self__, "includes", includes)

    @property
    @pulumi.getter
    def excludes(self) -> Sequence[str]:
        """
        (Optional) List of path patterns to exclude.
        """
        return pulumi.get(self, "excludes")

    @property
    @pulumi.getter
    def includes(self) -> Sequence[str]:
        """
        (Optional) List of path patterns to include.
        """
        return pulumi.get(self, "includes")


@pulumi.output_type
class GetBuildDefinitionVariableResult(dict):
    def __init__(__self__, *,
                 allow_override: bool,
                 is_secret: bool,
                 name: str,
                 secret_value: str,
                 value: str):
        """
        :param bool allow_override: `true` if the variable can be overridden.
        :param bool is_secret: `true` if the variable is a secret.
        :param str name: The name of this Build Definition.
        :param str secret_value: The secret value of the variable.
        :param str value: The value of the variable.
        """
        pulumi.set(__self__, "allow_override", allow_override)
        pulumi.set(__self__, "is_secret", is_secret)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "secret_value", secret_value)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter(name="allowOverride")
    def allow_override(self) -> bool:
        """
        `true` if the variable can be overridden.
        """
        return pulumi.get(self, "allow_override")

    @property
    @pulumi.getter(name="isSecret")
    def is_secret(self) -> bool:
        """
        `true` if the variable is a secret.
        """
        return pulumi.get(self, "is_secret")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of this Build Definition.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="secretValue")
    def secret_value(self) -> str:
        """
        The secret value of the variable.
        """
        return pulumi.get(self, "secret_value")

    @property
    @pulumi.getter
    def value(self) -> str:
        """
        The value of the variable.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class GetGroupsGroupResult(dict):
    def __init__(__self__, *,
                 descriptor: str,
                 domain: str,
                 id: str,
                 origin: str,
                 principal_name: str,
                 url: str,
                 description: Optional[str] = None,
                 display_name: Optional[str] = None,
                 mail_address: Optional[str] = None,
                 origin_id: Optional[str] = None):
        """
        :param str descriptor: The descriptor is the primary way to reference the graph subject while the system is running. This field will uniquely identify the same graph subject across both Accounts and Organizations.
        :param str domain: This represents the name of the container of origin for a graph member. (For MSA this is "Windows Live ID", for AD the name of the domain, for AAD the tenantID of the directory, for VSTS groups the ScopeId, etc)
        :param str id: The group ID.
        :param str origin: The type of source provider for the origin identifier (ex:AD, AAD, MSA)
        :param str principal_name: This is the PrincipalName of this graph member from the source provider. The source provider may change this field over time and it is not guaranteed to be immutable for the life of the graph member by VSTS.
        :param str url: This url is the full route to the source resource of this graph subject.
        :param str description: A short phrase to help human readers disambiguate groups with similar names
        :param str display_name: This is the non-unique display name of the graph subject. To change this field, you must alter its value in the source provider.
        :param str mail_address: The email address of record for a given graph member. This may be different than the principal name.
        :param str origin_id: The unique identifier from the system of origin. Typically a sid, object id or Guid. Linking and unlinking operations can cause this value to change for a user because the user is not backed by a different provider and has a different unique id in the new provider.
        """
        pulumi.set(__self__, "descriptor", descriptor)
        pulumi.set(__self__, "domain", domain)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "origin", origin)
        pulumi.set(__self__, "principal_name", principal_name)
        pulumi.set(__self__, "url", url)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if mail_address is not None:
            pulumi.set(__self__, "mail_address", mail_address)
        if origin_id is not None:
            pulumi.set(__self__, "origin_id", origin_id)

    @property
    @pulumi.getter
    def descriptor(self) -> str:
        """
        The descriptor is the primary way to reference the graph subject while the system is running. This field will uniquely identify the same graph subject across both Accounts and Organizations.
        """
        return pulumi.get(self, "descriptor")

    @property
    @pulumi.getter
    def domain(self) -> str:
        """
        This represents the name of the container of origin for a graph member. (For MSA this is "Windows Live ID", for AD the name of the domain, for AAD the tenantID of the directory, for VSTS groups the ScopeId, etc)
        """
        return pulumi.get(self, "domain")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The group ID.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def origin(self) -> str:
        """
        The type of source provider for the origin identifier (ex:AD, AAD, MSA)
        """
        return pulumi.get(self, "origin")

    @property
    @pulumi.getter(name="principalName")
    def principal_name(self) -> str:
        """
        This is the PrincipalName of this graph member from the source provider. The source provider may change this field over time and it is not guaranteed to be immutable for the life of the graph member by VSTS.
        """
        return pulumi.get(self, "principal_name")

    @property
    @pulumi.getter
    def url(self) -> str:
        """
        This url is the full route to the source resource of this graph subject.
        """
        return pulumi.get(self, "url")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        A short phrase to help human readers disambiguate groups with similar names
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[str]:
        """
        This is the non-unique display name of the graph subject. To change this field, you must alter its value in the source provider.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="mailAddress")
    def mail_address(self) -> Optional[str]:
        """
        The email address of record for a given graph member. This may be different than the principal name.
        """
        return pulumi.get(self, "mail_address")

    @property
    @pulumi.getter(name="originId")
    def origin_id(self) -> Optional[str]:
        """
        The unique identifier from the system of origin. Typically a sid, object id or Guid. Linking and unlinking operations can cause this value to change for a user because the user is not backed by a different provider and has a different unique id in the new provider.
        """
        return pulumi.get(self, "origin_id")


@pulumi.output_type
class GetIdentityGroupsGroupResult(dict):
    def __init__(__self__, *,
                 id: str,
                 name: str):
        """
        :param str name: This is the non-unique display name of the identity subject. To change this field, you must alter its value in the source provider.
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def id(self) -> str:
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        This is the non-unique display name of the identity subject. To change this field, you must alter its value in the source provider.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class GetIterationChildrenResult(dict):
    def __init__(__self__, *,
                 has_children: bool,
                 id: str,
                 name: str,
                 path: str,
                 project_id: str):
        """
        :param bool has_children: Indicator if the child Iteration node has child nodes
        :param str id: The id of the child Iteration node
        :param str name: The name of the child Iteration node
        :param str path: The path to the Iteration, _Format_: URL relative; if omitted, or value `"/"` is used, the root Iteration will be returned
        :param str project_id: The project ID.
        """
        pulumi.set(__self__, "has_children", has_children)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "path", path)
        pulumi.set(__self__, "project_id", project_id)

    @property
    @pulumi.getter(name="hasChildren")
    def has_children(self) -> bool:
        """
        Indicator if the child Iteration node has child nodes
        """
        return pulumi.get(self, "has_children")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The id of the child Iteration node
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the child Iteration node
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def path(self) -> str:
        """
        The path to the Iteration, _Format_: URL relative; if omitted, or value `"/"` is used, the root Iteration will be returned
        """
        return pulumi.get(self, "path")

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> str:
        """
        The project ID.
        """
        return pulumi.get(self, "project_id")


@pulumi.output_type
class GetPoolsAgentPoolResult(dict):
    def __init__(__self__, *,
                 auto_provision: bool,
                 auto_update: bool,
                 id: int,
                 name: str,
                 pool_type: str):
        """
        :param bool auto_provision: Specifies whether or not a queue should be automatically provisioned for each project collection.
        :param bool auto_update: Specifies whether or not agents within the pool should be automatically updated.
        :param str name: The name of the agent pool
        :param str pool_type: Specifies whether the agent pool type is Automation or Deployment.
        """
        pulumi.set(__self__, "auto_provision", auto_provision)
        pulumi.set(__self__, "auto_update", auto_update)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "pool_type", pool_type)

    @property
    @pulumi.getter(name="autoProvision")
    def auto_provision(self) -> bool:
        """
        Specifies whether or not a queue should be automatically provisioned for each project collection.
        """
        return pulumi.get(self, "auto_provision")

    @property
    @pulumi.getter(name="autoUpdate")
    def auto_update(self) -> bool:
        """
        Specifies whether or not agents within the pool should be automatically updated.
        """
        return pulumi.get(self, "auto_update")

    @property
    @pulumi.getter
    def id(self) -> int:
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the agent pool
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="poolType")
    def pool_type(self) -> str:
        """
        Specifies whether the agent pool type is Automation or Deployment.
        """
        return pulumi.get(self, "pool_type")


@pulumi.output_type
class GetProjectsProjectResult(dict):
    def __init__(__self__, *,
                 name: str,
                 project_id: str,
                 project_url: str,
                 state: str):
        """
        :param str name: Name of the Project, if not specified all projects will be returned.
        :param str project_id: The ID of the Project.
        :param str project_url: Url to the full version of the object.
        :param str state: State of the Project, if not specified all projects will be returned. Valid values are `all`, `deleting`, `new`, `wellFormed`, `createPending`, `unchanged`,`deleted`.
               
               DataSource without specifying any arguments will return all projects.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "project_id", project_id)
        pulumi.set(__self__, "project_url", project_url)
        pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Name of the Project, if not specified all projects will be returned.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> str:
        """
        The ID of the Project.
        """
        return pulumi.get(self, "project_id")

    @property
    @pulumi.getter(name="projectUrl")
    def project_url(self) -> str:
        """
        Url to the full version of the object.
        """
        return pulumi.get(self, "project_url")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        State of the Project, if not specified all projects will be returned. Valid values are `all`, `deleting`, `new`, `wellFormed`, `createPending`, `unchanged`,`deleted`.

        DataSource without specifying any arguments will return all projects.
        """
        return pulumi.get(self, "state")


@pulumi.output_type
class GetRepositoriesRepositoryResult(dict):
    def __init__(__self__, *,
                 default_branch: str,
                 disabled: bool,
                 id: str,
                 name: str,
                 project_id: str,
                 remote_url: str,
                 size: int,
                 ssh_url: str,
                 url: str,
                 web_url: str):
        """
        :param str default_branch: The ref of the default branch.
        :param bool disabled: Is the repository disabled?
        :param str id: Git repository identifier.
        :param str name: Name of the Git repository to retrieve; requires `project_id` to be specified as well
        :param str project_id: ID of project to list Git repositories
        :param str remote_url: HTTPS Url to clone the Git repository
        :param int size: Compressed size (bytes) of the repository.
        :param str ssh_url: SSH Url to clone the Git repository
        :param str url: Details REST API endpoint for the Git Repository.
        :param str web_url: Url of the Git repository web view
        """
        pulumi.set(__self__, "default_branch", default_branch)
        pulumi.set(__self__, "disabled", disabled)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "project_id", project_id)
        pulumi.set(__self__, "remote_url", remote_url)
        pulumi.set(__self__, "size", size)
        pulumi.set(__self__, "ssh_url", ssh_url)
        pulumi.set(__self__, "url", url)
        pulumi.set(__self__, "web_url", web_url)

    @property
    @pulumi.getter(name="defaultBranch")
    def default_branch(self) -> str:
        """
        The ref of the default branch.
        """
        return pulumi.get(self, "default_branch")

    @property
    @pulumi.getter
    def disabled(self) -> bool:
        """
        Is the repository disabled?
        """
        return pulumi.get(self, "disabled")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Git repository identifier.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Name of the Git repository to retrieve; requires `project_id` to be specified as well
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> str:
        """
        ID of project to list Git repositories
        """
        return pulumi.get(self, "project_id")

    @property
    @pulumi.getter(name="remoteUrl")
    def remote_url(self) -> str:
        """
        HTTPS Url to clone the Git repository
        """
        return pulumi.get(self, "remote_url")

    @property
    @pulumi.getter
    def size(self) -> int:
        """
        Compressed size (bytes) of the repository.
        """
        return pulumi.get(self, "size")

    @property
    @pulumi.getter(name="sshUrl")
    def ssh_url(self) -> str:
        """
        SSH Url to clone the Git repository
        """
        return pulumi.get(self, "ssh_url")

    @property
    @pulumi.getter
    def url(self) -> str:
        """
        Details REST API endpoint for the Git Repository.
        """
        return pulumi.get(self, "url")

    @property
    @pulumi.getter(name="webUrl")
    def web_url(self) -> str:
        """
        Url of the Git repository web view
        """
        return pulumi.get(self, "web_url")


@pulumi.output_type
class GetSecurityroleDefinitionsDefinitionResult(dict):
    def __init__(__self__, *,
                 allow_permissions: int,
                 description: str,
                 display_name: str,
                 identifier: str,
                 name: str,
                 scope: str,
                 deny_permissions: Optional[int] = None):
        """
        :param int allow_permissions: The mask of allowed permissions of the Security Role Definition.
        :param str description: The description of the Security Role Definition.
        :param str display_name: The display name of the Security Role Definition.
        :param str identifier: The identifier of the Security Role Definition.
        :param str name: The name of the Security Role Definition.
        :param str scope: Name of the Scope for which Security Role Definitions will be returned.
               
               DataSource without specifying any arguments will return all projects.
        :param int deny_permissions: The mask of the denied permissions of the Security Role Definition.
        """
        pulumi.set(__self__, "allow_permissions", allow_permissions)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "identifier", identifier)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "scope", scope)
        if deny_permissions is not None:
            pulumi.set(__self__, "deny_permissions", deny_permissions)

    @property
    @pulumi.getter(name="allowPermissions")
    def allow_permissions(self) -> int:
        """
        The mask of allowed permissions of the Security Role Definition.
        """
        return pulumi.get(self, "allow_permissions")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        The description of the Security Role Definition.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        The display name of the Security Role Definition.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def identifier(self) -> str:
        """
        The identifier of the Security Role Definition.
        """
        return pulumi.get(self, "identifier")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the Security Role Definition.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def scope(self) -> str:
        """
        Name of the Scope for which Security Role Definitions will be returned.

        DataSource without specifying any arguments will return all projects.
        """
        return pulumi.get(self, "scope")

    @property
    @pulumi.getter(name="denyPermissions")
    def deny_permissions(self) -> Optional[int]:
        """
        The mask of the denied permissions of the Security Role Definition.
        """
        return pulumi.get(self, "deny_permissions")


@pulumi.output_type
class GetTeamsTeamResult(dict):
    def __init__(__self__, *,
                 administrators: Sequence[str],
                 description: str,
                 id: str,
                 members: Sequence[str],
                 name: str,
                 project_id: str):
        """
        :param Sequence[str] administrators: List of subject descriptors for `administrators` of the team.
        :param str description: Team description.
        :param Sequence[str] members: List of subject descriptors for `members` of the team.
        :param str name: Team name.
        :param str project_id: The Project ID. If no project ID all teams of the organization will be returned.
        """
        pulumi.set(__self__, "administrators", administrators)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "members", members)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "project_id", project_id)

    @property
    @pulumi.getter
    def administrators(self) -> Sequence[str]:
        """
        List of subject descriptors for `administrators` of the team.
        """
        return pulumi.get(self, "administrators")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        Team description.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def id(self) -> str:
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def members(self) -> Sequence[str]:
        """
        List of subject descriptors for `members` of the team.
        """
        return pulumi.get(self, "members")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Team name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> str:
        """
        The Project ID. If no project ID all teams of the organization will be returned.
        """
        return pulumi.get(self, "project_id")


@pulumi.output_type
class GetUsersFeaturesResult(dict):
    def __init__(__self__, *,
                 concurrent_workers: Optional[int] = None):
        """
        :param int concurrent_workers: Number of workers to process user data concurrently.
               
               > **Note** Setting `concurrent_workers` to a value greater than 1 can greatly decrease the time it takes to read the data source.
        """
        if concurrent_workers is not None:
            pulumi.set(__self__, "concurrent_workers", concurrent_workers)

    @property
    @pulumi.getter(name="concurrentWorkers")
    def concurrent_workers(self) -> Optional[int]:
        """
        Number of workers to process user data concurrently.

        > **Note** Setting `concurrent_workers` to a value greater than 1 can greatly decrease the time it takes to read the data source.
        """
        return pulumi.get(self, "concurrent_workers")


@pulumi.output_type
class GetUsersUserResult(dict):
    def __init__(__self__, *,
                 descriptor: str,
                 display_name: str,
                 id: str,
                 mail_address: str,
                 origin: str,
                 principal_name: str,
                 origin_id: Optional[str] = None):
        """
        :param str descriptor: The descriptor is the primary way to reference the graph subject while the system is running. This field will uniquely identify the same graph subject across both Accounts and Organizations.
        :param str display_name: This is the non-unique display name of the graph subject. To change this field, you must alter its value in the source provider.
        :param str id: The user ID.
        :param str mail_address: The email address of record for a given graph member. This may be different than the principal name.
        :param str origin: The type of source provider for the `origin_id` parameter (ex:AD, AAD, MSA) The supported origins are listed below.
        :param str principal_name: The PrincipalName of this graph member from the source provider.
        :param str origin_id: The unique identifier from the system of origin.
        """
        pulumi.set(__self__, "descriptor", descriptor)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "mail_address", mail_address)
        pulumi.set(__self__, "origin", origin)
        pulumi.set(__self__, "principal_name", principal_name)
        if origin_id is not None:
            pulumi.set(__self__, "origin_id", origin_id)

    @property
    @pulumi.getter
    def descriptor(self) -> str:
        """
        The descriptor is the primary way to reference the graph subject while the system is running. This field will uniquely identify the same graph subject across both Accounts and Organizations.
        """
        return pulumi.get(self, "descriptor")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        This is the non-unique display name of the graph subject. To change this field, you must alter its value in the source provider.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The user ID.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="mailAddress")
    def mail_address(self) -> str:
        """
        The email address of record for a given graph member. This may be different than the principal name.
        """
        return pulumi.get(self, "mail_address")

    @property
    @pulumi.getter
    def origin(self) -> str:
        """
        The type of source provider for the `origin_id` parameter (ex:AD, AAD, MSA) The supported origins are listed below.
        """
        return pulumi.get(self, "origin")

    @property
    @pulumi.getter(name="principalName")
    def principal_name(self) -> str:
        """
        The PrincipalName of this graph member from the source provider.
        """
        return pulumi.get(self, "principal_name")

    @property
    @pulumi.getter(name="originId")
    def origin_id(self) -> Optional[str]:
        """
        The unique identifier from the system of origin.
        """
        return pulumi.get(self, "origin_id")


@pulumi.output_type
class GetVariableGroupKeyVaultResult(dict):
    def __init__(__self__, *,
                 name: str,
                 service_endpoint_id: str):
        """
        :param str name: The name of the Variable Group to retrieve.
        :param str service_endpoint_id: The id of the Azure subscription endpoint to access the key vault.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "service_endpoint_id", service_endpoint_id)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the Variable Group to retrieve.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="serviceEndpointId")
    def service_endpoint_id(self) -> str:
        """
        The id of the Azure subscription endpoint to access the key vault.
        """
        return pulumi.get(self, "service_endpoint_id")


@pulumi.output_type
class GetVariableGroupVariableResult(dict):
    def __init__(__self__, *,
                 content_type: str,
                 enabled: bool,
                 expires: str,
                 is_secret: bool,
                 name: str,
                 secret_value: str,
                 value: str):
        """
        :param bool is_secret: A boolean flag describing if the variable value is sensitive.
        :param str name: The name of the Variable Group to retrieve.
        :param str secret_value: The secret value of the variable.
        :param str value: The value of the variable.
        """
        pulumi.set(__self__, "content_type", content_type)
        pulumi.set(__self__, "enabled", enabled)
        pulumi.set(__self__, "expires", expires)
        pulumi.set(__self__, "is_secret", is_secret)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "secret_value", secret_value)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter(name="contentType")
    def content_type(self) -> str:
        return pulumi.get(self, "content_type")

    @property
    @pulumi.getter
    def enabled(self) -> bool:
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter
    def expires(self) -> str:
        return pulumi.get(self, "expires")

    @property
    @pulumi.getter(name="isSecret")
    def is_secret(self) -> bool:
        """
        A boolean flag describing if the variable value is sensitive.
        """
        return pulumi.get(self, "is_secret")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the Variable Group to retrieve.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="secretValue")
    def secret_value(self) -> str:
        """
        The secret value of the variable.
        """
        return pulumi.get(self, "secret_value")

    @property
    @pulumi.getter
    def value(self) -> str:
        """
        The value of the variable.
        """
        return pulumi.get(self, "value")


