# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ServiceEndpointAzureEcrArgs', 'ServiceEndpointAzureEcr']

@pulumi.input_type
class ServiceEndpointAzureEcrArgs:
    def __init__(__self__, *,
                 azurecr_name: pulumi.Input[str],
                 azurecr_spn_tenantid: pulumi.Input[str],
                 azurecr_subscription_id: pulumi.Input[str],
                 azurecr_subscription_name: pulumi.Input[str],
                 project_id: pulumi.Input[str],
                 service_endpoint_name: pulumi.Input[str],
                 authorization: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 credentials: Optional[pulumi.Input['ServiceEndpointAzureEcrCredentialsArgs']] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 resource_group: Optional[pulumi.Input[str]] = None,
                 service_endpoint_authentication_scheme: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a ServiceEndpointAzureEcr resource.
        :param pulumi.Input[str] azurecr_name: The Azure container registry name.
        :param pulumi.Input[str] azurecr_spn_tenantid: The tenant id of the service principal.
        :param pulumi.Input[str] azurecr_subscription_id: The subscription id of the Azure targets.
        :param pulumi.Input[str] azurecr_subscription_name: The subscription name of the Azure targets.
        :param pulumi.Input[str] project_id: The ID of the project.
        :param pulumi.Input[str] service_endpoint_name: The name you will use to refer to this service connection in task inputs.
        :param pulumi.Input['ServiceEndpointAzureEcrCredentialsArgs'] credentials: A `credentials` block.
        :param pulumi.Input[str] resource_group: The resource group to which the container registry belongs.
        :param pulumi.Input[str] service_endpoint_authentication_scheme: Specifies the type of azurerm endpoint, either `WorkloadIdentityFederation`, `ManagedServiceIdentity` or `ServicePrincipal`. Defaults to `ServicePrincipal` for backwards compatibility. `ManagedServiceIdentity` has not yet been implemented for this resource.
        """
        pulumi.set(__self__, "azurecr_name", azurecr_name)
        pulumi.set(__self__, "azurecr_spn_tenantid", azurecr_spn_tenantid)
        pulumi.set(__self__, "azurecr_subscription_id", azurecr_subscription_id)
        pulumi.set(__self__, "azurecr_subscription_name", azurecr_subscription_name)
        pulumi.set(__self__, "project_id", project_id)
        pulumi.set(__self__, "service_endpoint_name", service_endpoint_name)
        if authorization is not None:
            pulumi.set(__self__, "authorization", authorization)
        if credentials is not None:
            pulumi.set(__self__, "credentials", credentials)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if resource_group is not None:
            pulumi.set(__self__, "resource_group", resource_group)
        if service_endpoint_authentication_scheme is not None:
            pulumi.set(__self__, "service_endpoint_authentication_scheme", service_endpoint_authentication_scheme)

    @property
    @pulumi.getter(name="azurecrName")
    def azurecr_name(self) -> pulumi.Input[str]:
        """
        The Azure container registry name.
        """
        return pulumi.get(self, "azurecr_name")

    @azurecr_name.setter
    def azurecr_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "azurecr_name", value)

    @property
    @pulumi.getter(name="azurecrSpnTenantid")
    def azurecr_spn_tenantid(self) -> pulumi.Input[str]:
        """
        The tenant id of the service principal.
        """
        return pulumi.get(self, "azurecr_spn_tenantid")

    @azurecr_spn_tenantid.setter
    def azurecr_spn_tenantid(self, value: pulumi.Input[str]):
        pulumi.set(self, "azurecr_spn_tenantid", value)

    @property
    @pulumi.getter(name="azurecrSubscriptionId")
    def azurecr_subscription_id(self) -> pulumi.Input[str]:
        """
        The subscription id of the Azure targets.
        """
        return pulumi.get(self, "azurecr_subscription_id")

    @azurecr_subscription_id.setter
    def azurecr_subscription_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "azurecr_subscription_id", value)

    @property
    @pulumi.getter(name="azurecrSubscriptionName")
    def azurecr_subscription_name(self) -> pulumi.Input[str]:
        """
        The subscription name of the Azure targets.
        """
        return pulumi.get(self, "azurecr_subscription_name")

    @azurecr_subscription_name.setter
    def azurecr_subscription_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "azurecr_subscription_name", value)

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Input[str]:
        """
        The ID of the project.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "project_id", value)

    @property
    @pulumi.getter(name="serviceEndpointName")
    def service_endpoint_name(self) -> pulumi.Input[str]:
        """
        The name you will use to refer to this service connection in task inputs.
        """
        return pulumi.get(self, "service_endpoint_name")

    @service_endpoint_name.setter
    def service_endpoint_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "service_endpoint_name", value)

    @property
    @pulumi.getter
    def authorization(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        return pulumi.get(self, "authorization")

    @authorization.setter
    def authorization(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "authorization", value)

    @property
    @pulumi.getter
    def credentials(self) -> Optional[pulumi.Input['ServiceEndpointAzureEcrCredentialsArgs']]:
        """
        A `credentials` block.
        """
        return pulumi.get(self, "credentials")

    @credentials.setter
    def credentials(self, value: Optional[pulumi.Input['ServiceEndpointAzureEcrCredentialsArgs']]):
        pulumi.set(self, "credentials", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="resourceGroup")
    def resource_group(self) -> Optional[pulumi.Input[str]]:
        """
        The resource group to which the container registry belongs.
        """
        return pulumi.get(self, "resource_group")

    @resource_group.setter
    def resource_group(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "resource_group", value)

    @property
    @pulumi.getter(name="serviceEndpointAuthenticationScheme")
    def service_endpoint_authentication_scheme(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the type of azurerm endpoint, either `WorkloadIdentityFederation`, `ManagedServiceIdentity` or `ServicePrincipal`. Defaults to `ServicePrincipal` for backwards compatibility. `ManagedServiceIdentity` has not yet been implemented for this resource.
        """
        return pulumi.get(self, "service_endpoint_authentication_scheme")

    @service_endpoint_authentication_scheme.setter
    def service_endpoint_authentication_scheme(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "service_endpoint_authentication_scheme", value)


@pulumi.input_type
class _ServiceEndpointAzureEcrState:
    def __init__(__self__, *,
                 app_object_id: Optional[pulumi.Input[str]] = None,
                 authorization: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 az_spn_role_assignment_id: Optional[pulumi.Input[str]] = None,
                 az_spn_role_permissions: Optional[pulumi.Input[str]] = None,
                 azurecr_name: Optional[pulumi.Input[str]] = None,
                 azurecr_spn_tenantid: Optional[pulumi.Input[str]] = None,
                 azurecr_subscription_id: Optional[pulumi.Input[str]] = None,
                 azurecr_subscription_name: Optional[pulumi.Input[str]] = None,
                 credentials: Optional[pulumi.Input['ServiceEndpointAzureEcrCredentialsArgs']] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 project_id: Optional[pulumi.Input[str]] = None,
                 resource_group: Optional[pulumi.Input[str]] = None,
                 service_endpoint_authentication_scheme: Optional[pulumi.Input[str]] = None,
                 service_endpoint_name: Optional[pulumi.Input[str]] = None,
                 service_principal_id: Optional[pulumi.Input[str]] = None,
                 spn_object_id: Optional[pulumi.Input[str]] = None,
                 workload_identity_federation_issuer: Optional[pulumi.Input[str]] = None,
                 workload_identity_federation_subject: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering ServiceEndpointAzureEcr resources.
        :param pulumi.Input[str] azurecr_name: The Azure container registry name.
        :param pulumi.Input[str] azurecr_spn_tenantid: The tenant id of the service principal.
        :param pulumi.Input[str] azurecr_subscription_id: The subscription id of the Azure targets.
        :param pulumi.Input[str] azurecr_subscription_name: The subscription name of the Azure targets.
        :param pulumi.Input['ServiceEndpointAzureEcrCredentialsArgs'] credentials: A `credentials` block.
        :param pulumi.Input[str] project_id: The ID of the project.
        :param pulumi.Input[str] resource_group: The resource group to which the container registry belongs.
        :param pulumi.Input[str] service_endpoint_authentication_scheme: Specifies the type of azurerm endpoint, either `WorkloadIdentityFederation`, `ManagedServiceIdentity` or `ServicePrincipal`. Defaults to `ServicePrincipal` for backwards compatibility. `ManagedServiceIdentity` has not yet been implemented for this resource.
        :param pulumi.Input[str] service_endpoint_name: The name you will use to refer to this service connection in task inputs.
        :param pulumi.Input[str] service_principal_id: The service principal ID.
        :param pulumi.Input[str] workload_identity_federation_issuer: The issuer of the workload identity federation service principal.
        :param pulumi.Input[str] workload_identity_federation_subject: The subject of the workload identity federation service principal.
        """
        if app_object_id is not None:
            pulumi.set(__self__, "app_object_id", app_object_id)
        if authorization is not None:
            pulumi.set(__self__, "authorization", authorization)
        if az_spn_role_assignment_id is not None:
            pulumi.set(__self__, "az_spn_role_assignment_id", az_spn_role_assignment_id)
        if az_spn_role_permissions is not None:
            pulumi.set(__self__, "az_spn_role_permissions", az_spn_role_permissions)
        if azurecr_name is not None:
            pulumi.set(__self__, "azurecr_name", azurecr_name)
        if azurecr_spn_tenantid is not None:
            pulumi.set(__self__, "azurecr_spn_tenantid", azurecr_spn_tenantid)
        if azurecr_subscription_id is not None:
            pulumi.set(__self__, "azurecr_subscription_id", azurecr_subscription_id)
        if azurecr_subscription_name is not None:
            pulumi.set(__self__, "azurecr_subscription_name", azurecr_subscription_name)
        if credentials is not None:
            pulumi.set(__self__, "credentials", credentials)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if resource_group is not None:
            pulumi.set(__self__, "resource_group", resource_group)
        if service_endpoint_authentication_scheme is not None:
            pulumi.set(__self__, "service_endpoint_authentication_scheme", service_endpoint_authentication_scheme)
        if service_endpoint_name is not None:
            pulumi.set(__self__, "service_endpoint_name", service_endpoint_name)
        if service_principal_id is not None:
            pulumi.set(__self__, "service_principal_id", service_principal_id)
        if spn_object_id is not None:
            pulumi.set(__self__, "spn_object_id", spn_object_id)
        if workload_identity_federation_issuer is not None:
            pulumi.set(__self__, "workload_identity_federation_issuer", workload_identity_federation_issuer)
        if workload_identity_federation_subject is not None:
            pulumi.set(__self__, "workload_identity_federation_subject", workload_identity_federation_subject)

    @property
    @pulumi.getter(name="appObjectId")
    def app_object_id(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "app_object_id")

    @app_object_id.setter
    def app_object_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "app_object_id", value)

    @property
    @pulumi.getter
    def authorization(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        return pulumi.get(self, "authorization")

    @authorization.setter
    def authorization(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "authorization", value)

    @property
    @pulumi.getter(name="azSpnRoleAssignmentId")
    def az_spn_role_assignment_id(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "az_spn_role_assignment_id")

    @az_spn_role_assignment_id.setter
    def az_spn_role_assignment_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "az_spn_role_assignment_id", value)

    @property
    @pulumi.getter(name="azSpnRolePermissions")
    def az_spn_role_permissions(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "az_spn_role_permissions")

    @az_spn_role_permissions.setter
    def az_spn_role_permissions(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "az_spn_role_permissions", value)

    @property
    @pulumi.getter(name="azurecrName")
    def azurecr_name(self) -> Optional[pulumi.Input[str]]:
        """
        The Azure container registry name.
        """
        return pulumi.get(self, "azurecr_name")

    @azurecr_name.setter
    def azurecr_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "azurecr_name", value)

    @property
    @pulumi.getter(name="azurecrSpnTenantid")
    def azurecr_spn_tenantid(self) -> Optional[pulumi.Input[str]]:
        """
        The tenant id of the service principal.
        """
        return pulumi.get(self, "azurecr_spn_tenantid")

    @azurecr_spn_tenantid.setter
    def azurecr_spn_tenantid(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "azurecr_spn_tenantid", value)

    @property
    @pulumi.getter(name="azurecrSubscriptionId")
    def azurecr_subscription_id(self) -> Optional[pulumi.Input[str]]:
        """
        The subscription id of the Azure targets.
        """
        return pulumi.get(self, "azurecr_subscription_id")

    @azurecr_subscription_id.setter
    def azurecr_subscription_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "azurecr_subscription_id", value)

    @property
    @pulumi.getter(name="azurecrSubscriptionName")
    def azurecr_subscription_name(self) -> Optional[pulumi.Input[str]]:
        """
        The subscription name of the Azure targets.
        """
        return pulumi.get(self, "azurecr_subscription_name")

    @azurecr_subscription_name.setter
    def azurecr_subscription_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "azurecr_subscription_name", value)

    @property
    @pulumi.getter
    def credentials(self) -> Optional[pulumi.Input['ServiceEndpointAzureEcrCredentialsArgs']]:
        """
        A `credentials` block.
        """
        return pulumi.get(self, "credentials")

    @credentials.setter
    def credentials(self, value: Optional[pulumi.Input['ServiceEndpointAzureEcrCredentialsArgs']]):
        pulumi.set(self, "credentials", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the project.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project_id", value)

    @property
    @pulumi.getter(name="resourceGroup")
    def resource_group(self) -> Optional[pulumi.Input[str]]:
        """
        The resource group to which the container registry belongs.
        """
        return pulumi.get(self, "resource_group")

    @resource_group.setter
    def resource_group(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "resource_group", value)

    @property
    @pulumi.getter(name="serviceEndpointAuthenticationScheme")
    def service_endpoint_authentication_scheme(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the type of azurerm endpoint, either `WorkloadIdentityFederation`, `ManagedServiceIdentity` or `ServicePrincipal`. Defaults to `ServicePrincipal` for backwards compatibility. `ManagedServiceIdentity` has not yet been implemented for this resource.
        """
        return pulumi.get(self, "service_endpoint_authentication_scheme")

    @service_endpoint_authentication_scheme.setter
    def service_endpoint_authentication_scheme(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "service_endpoint_authentication_scheme", value)

    @property
    @pulumi.getter(name="serviceEndpointName")
    def service_endpoint_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name you will use to refer to this service connection in task inputs.
        """
        return pulumi.get(self, "service_endpoint_name")

    @service_endpoint_name.setter
    def service_endpoint_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "service_endpoint_name", value)

    @property
    @pulumi.getter(name="servicePrincipalId")
    def service_principal_id(self) -> Optional[pulumi.Input[str]]:
        """
        The service principal ID.
        """
        return pulumi.get(self, "service_principal_id")

    @service_principal_id.setter
    def service_principal_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "service_principal_id", value)

    @property
    @pulumi.getter(name="spnObjectId")
    def spn_object_id(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "spn_object_id")

    @spn_object_id.setter
    def spn_object_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "spn_object_id", value)

    @property
    @pulumi.getter(name="workloadIdentityFederationIssuer")
    def workload_identity_federation_issuer(self) -> Optional[pulumi.Input[str]]:
        """
        The issuer of the workload identity federation service principal.
        """
        return pulumi.get(self, "workload_identity_federation_issuer")

    @workload_identity_federation_issuer.setter
    def workload_identity_federation_issuer(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "workload_identity_federation_issuer", value)

    @property
    @pulumi.getter(name="workloadIdentityFederationSubject")
    def workload_identity_federation_subject(self) -> Optional[pulumi.Input[str]]:
        """
        The subject of the workload identity federation service principal.
        """
        return pulumi.get(self, "workload_identity_federation_subject")

    @workload_identity_federation_subject.setter
    def workload_identity_federation_subject(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "workload_identity_federation_subject", value)


class ServiceEndpointAzureEcr(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 authorization: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 azurecr_name: Optional[pulumi.Input[str]] = None,
                 azurecr_spn_tenantid: Optional[pulumi.Input[str]] = None,
                 azurecr_subscription_id: Optional[pulumi.Input[str]] = None,
                 azurecr_subscription_name: Optional[pulumi.Input[str]] = None,
                 credentials: Optional[pulumi.Input[Union['ServiceEndpointAzureEcrCredentialsArgs', 'ServiceEndpointAzureEcrCredentialsArgsDict']]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 project_id: Optional[pulumi.Input[str]] = None,
                 resource_group: Optional[pulumi.Input[str]] = None,
                 service_endpoint_authentication_scheme: Optional[pulumi.Input[str]] = None,
                 service_endpoint_name: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Manages a Azure Container Registry service endpoint within Azure DevOps.

        ## Example Usage

        ### Service Principal

        ```python
        import pulumi
        import pulumi_azuredevops as azuredevops

        example = azuredevops.Project("example",
            name="Example Project",
            visibility="private",
            version_control="Git",
            work_item_template="Agile",
            description="Managed by Pulumi")
        # azure container registry service connection
        example_service_endpoint_azure_ecr = azuredevops.ServiceEndpointAzureEcr("example",
            project_id=example.id,
            service_endpoint_name="Example AzureCR",
            resource_group="example-rg",
            azurecr_spn_tenantid="00000000-0000-0000-0000-000000000000",
            azurecr_name="ExampleAcr",
            azurecr_subscription_id="00000000-0000-0000-0000-000000000000",
            azurecr_subscription_name="subscription name")
        ```

        ### WorkloadIdentityFederation

        ```python
        import pulumi
        import pulumi_azure as azure
        import pulumi_azuredevops as azuredevops

        example = azuredevops.Project("example",
            name="Example Project",
            visibility="private",
            version_control="Git",
            work_item_template="Agile",
            description="Managed by Pulumi")
        identity = azure.core.ResourceGroup("identity",
            name="identity",
            location="UK South")
        example_user_assigned_identity = azure.authorization.UserAssignedIdentity("example",
            location=identity.location,
            name="example-identity",
            resource_group_name=identity.name)
        # azure container registry service connection
        example_service_endpoint_azure_ecr = azuredevops.ServiceEndpointAzureEcr("example",
            project_id=example.id,
            resource_group="Example AzureCR ResourceGroup",
            service_endpoint_name="Example AzureCR",
            service_endpoint_authentication_scheme="WorkloadIdentityFederation",
            azurecr_spn_tenantid="00000000-0000-0000-0000-000000000000",
            azurecr_name="ExampleAcr",
            azurecr_subscription_id="00000000-0000-0000-0000-000000000000",
            azurecr_subscription_name="subscription name",
            credentials={
                "serviceprincipalid": example_user_assigned_identity.client_id,
            })
        example_federated_identity_credential = azure.armmsi.FederatedIdentityCredential("example",
            name="example-federated-credential",
            resource_group_name=identity.name,
            parent_id=example_user_assigned_identity.id,
            audience="api://AzureADTokenExchange",
            issuer=example_service_endpoint_azure_ecr.workload_identity_federation_issuer,
            subject=example_service_endpoint_azure_ecr.workload_identity_federation_subject)
        ```

        ## Relevant Links

        - [Azure DevOps Service REST API 7.0 - Service Endpoints](https://docs.microsoft.com/en-us/rest/api/azure/devops/serviceendpoint/endpoints?view=azure-devops-rest-7.0)
        - [Azure Container Registry REST API](https://docs.microsoft.com/en-us/rest/api/containerregistry/)

        ## Import

        Azure DevOps Service Endpoint Azure Container Registry can be imported using **projectID/serviceEndpointID** or **projectName/serviceEndpointID**

        ```sh
        $ pulumi import azuredevops:index/serviceEndpointAzureEcr:ServiceEndpointAzureEcr example 00000000-0000-0000-0000-000000000000/00000000-0000-0000-0000-000000000000
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] azurecr_name: The Azure container registry name.
        :param pulumi.Input[str] azurecr_spn_tenantid: The tenant id of the service principal.
        :param pulumi.Input[str] azurecr_subscription_id: The subscription id of the Azure targets.
        :param pulumi.Input[str] azurecr_subscription_name: The subscription name of the Azure targets.
        :param pulumi.Input[Union['ServiceEndpointAzureEcrCredentialsArgs', 'ServiceEndpointAzureEcrCredentialsArgsDict']] credentials: A `credentials` block.
        :param pulumi.Input[str] project_id: The ID of the project.
        :param pulumi.Input[str] resource_group: The resource group to which the container registry belongs.
        :param pulumi.Input[str] service_endpoint_authentication_scheme: Specifies the type of azurerm endpoint, either `WorkloadIdentityFederation`, `ManagedServiceIdentity` or `ServicePrincipal`. Defaults to `ServicePrincipal` for backwards compatibility. `ManagedServiceIdentity` has not yet been implemented for this resource.
        :param pulumi.Input[str] service_endpoint_name: The name you will use to refer to this service connection in task inputs.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ServiceEndpointAzureEcrArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a Azure Container Registry service endpoint within Azure DevOps.

        ## Example Usage

        ### Service Principal

        ```python
        import pulumi
        import pulumi_azuredevops as azuredevops

        example = azuredevops.Project("example",
            name="Example Project",
            visibility="private",
            version_control="Git",
            work_item_template="Agile",
            description="Managed by Pulumi")
        # azure container registry service connection
        example_service_endpoint_azure_ecr = azuredevops.ServiceEndpointAzureEcr("example",
            project_id=example.id,
            service_endpoint_name="Example AzureCR",
            resource_group="example-rg",
            azurecr_spn_tenantid="00000000-0000-0000-0000-000000000000",
            azurecr_name="ExampleAcr",
            azurecr_subscription_id="00000000-0000-0000-0000-000000000000",
            azurecr_subscription_name="subscription name")
        ```

        ### WorkloadIdentityFederation

        ```python
        import pulumi
        import pulumi_azure as azure
        import pulumi_azuredevops as azuredevops

        example = azuredevops.Project("example",
            name="Example Project",
            visibility="private",
            version_control="Git",
            work_item_template="Agile",
            description="Managed by Pulumi")
        identity = azure.core.ResourceGroup("identity",
            name="identity",
            location="UK South")
        example_user_assigned_identity = azure.authorization.UserAssignedIdentity("example",
            location=identity.location,
            name="example-identity",
            resource_group_name=identity.name)
        # azure container registry service connection
        example_service_endpoint_azure_ecr = azuredevops.ServiceEndpointAzureEcr("example",
            project_id=example.id,
            resource_group="Example AzureCR ResourceGroup",
            service_endpoint_name="Example AzureCR",
            service_endpoint_authentication_scheme="WorkloadIdentityFederation",
            azurecr_spn_tenantid="00000000-0000-0000-0000-000000000000",
            azurecr_name="ExampleAcr",
            azurecr_subscription_id="00000000-0000-0000-0000-000000000000",
            azurecr_subscription_name="subscription name",
            credentials={
                "serviceprincipalid": example_user_assigned_identity.client_id,
            })
        example_federated_identity_credential = azure.armmsi.FederatedIdentityCredential("example",
            name="example-federated-credential",
            resource_group_name=identity.name,
            parent_id=example_user_assigned_identity.id,
            audience="api://AzureADTokenExchange",
            issuer=example_service_endpoint_azure_ecr.workload_identity_federation_issuer,
            subject=example_service_endpoint_azure_ecr.workload_identity_federation_subject)
        ```

        ## Relevant Links

        - [Azure DevOps Service REST API 7.0 - Service Endpoints](https://docs.microsoft.com/en-us/rest/api/azure/devops/serviceendpoint/endpoints?view=azure-devops-rest-7.0)
        - [Azure Container Registry REST API](https://docs.microsoft.com/en-us/rest/api/containerregistry/)

        ## Import

        Azure DevOps Service Endpoint Azure Container Registry can be imported using **projectID/serviceEndpointID** or **projectName/serviceEndpointID**

        ```sh
        $ pulumi import azuredevops:index/serviceEndpointAzureEcr:ServiceEndpointAzureEcr example 00000000-0000-0000-0000-000000000000/00000000-0000-0000-0000-000000000000
        ```

        :param str resource_name: The name of the resource.
        :param ServiceEndpointAzureEcrArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ServiceEndpointAzureEcrArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 authorization: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 azurecr_name: Optional[pulumi.Input[str]] = None,
                 azurecr_spn_tenantid: Optional[pulumi.Input[str]] = None,
                 azurecr_subscription_id: Optional[pulumi.Input[str]] = None,
                 azurecr_subscription_name: Optional[pulumi.Input[str]] = None,
                 credentials: Optional[pulumi.Input[Union['ServiceEndpointAzureEcrCredentialsArgs', 'ServiceEndpointAzureEcrCredentialsArgsDict']]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 project_id: Optional[pulumi.Input[str]] = None,
                 resource_group: Optional[pulumi.Input[str]] = None,
                 service_endpoint_authentication_scheme: Optional[pulumi.Input[str]] = None,
                 service_endpoint_name: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ServiceEndpointAzureEcrArgs.__new__(ServiceEndpointAzureEcrArgs)

            __props__.__dict__["authorization"] = authorization
            if azurecr_name is None and not opts.urn:
                raise TypeError("Missing required property 'azurecr_name'")
            __props__.__dict__["azurecr_name"] = azurecr_name
            if azurecr_spn_tenantid is None and not opts.urn:
                raise TypeError("Missing required property 'azurecr_spn_tenantid'")
            __props__.__dict__["azurecr_spn_tenantid"] = azurecr_spn_tenantid
            if azurecr_subscription_id is None and not opts.urn:
                raise TypeError("Missing required property 'azurecr_subscription_id'")
            __props__.__dict__["azurecr_subscription_id"] = azurecr_subscription_id
            if azurecr_subscription_name is None and not opts.urn:
                raise TypeError("Missing required property 'azurecr_subscription_name'")
            __props__.__dict__["azurecr_subscription_name"] = azurecr_subscription_name
            __props__.__dict__["credentials"] = credentials
            __props__.__dict__["description"] = description
            if project_id is None and not opts.urn:
                raise TypeError("Missing required property 'project_id'")
            __props__.__dict__["project_id"] = project_id
            __props__.__dict__["resource_group"] = resource_group
            __props__.__dict__["service_endpoint_authentication_scheme"] = service_endpoint_authentication_scheme
            if service_endpoint_name is None and not opts.urn:
                raise TypeError("Missing required property 'service_endpoint_name'")
            __props__.__dict__["service_endpoint_name"] = service_endpoint_name
            __props__.__dict__["app_object_id"] = None
            __props__.__dict__["az_spn_role_assignment_id"] = None
            __props__.__dict__["az_spn_role_permissions"] = None
            __props__.__dict__["service_principal_id"] = None
            __props__.__dict__["spn_object_id"] = None
            __props__.__dict__["workload_identity_federation_issuer"] = None
            __props__.__dict__["workload_identity_federation_subject"] = None
        super(ServiceEndpointAzureEcr, __self__).__init__(
            'azuredevops:index/serviceEndpointAzureEcr:ServiceEndpointAzureEcr',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            app_object_id: Optional[pulumi.Input[str]] = None,
            authorization: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            az_spn_role_assignment_id: Optional[pulumi.Input[str]] = None,
            az_spn_role_permissions: Optional[pulumi.Input[str]] = None,
            azurecr_name: Optional[pulumi.Input[str]] = None,
            azurecr_spn_tenantid: Optional[pulumi.Input[str]] = None,
            azurecr_subscription_id: Optional[pulumi.Input[str]] = None,
            azurecr_subscription_name: Optional[pulumi.Input[str]] = None,
            credentials: Optional[pulumi.Input[Union['ServiceEndpointAzureEcrCredentialsArgs', 'ServiceEndpointAzureEcrCredentialsArgsDict']]] = None,
            description: Optional[pulumi.Input[str]] = None,
            project_id: Optional[pulumi.Input[str]] = None,
            resource_group: Optional[pulumi.Input[str]] = None,
            service_endpoint_authentication_scheme: Optional[pulumi.Input[str]] = None,
            service_endpoint_name: Optional[pulumi.Input[str]] = None,
            service_principal_id: Optional[pulumi.Input[str]] = None,
            spn_object_id: Optional[pulumi.Input[str]] = None,
            workload_identity_federation_issuer: Optional[pulumi.Input[str]] = None,
            workload_identity_federation_subject: Optional[pulumi.Input[str]] = None) -> 'ServiceEndpointAzureEcr':
        """
        Get an existing ServiceEndpointAzureEcr resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] azurecr_name: The Azure container registry name.
        :param pulumi.Input[str] azurecr_spn_tenantid: The tenant id of the service principal.
        :param pulumi.Input[str] azurecr_subscription_id: The subscription id of the Azure targets.
        :param pulumi.Input[str] azurecr_subscription_name: The subscription name of the Azure targets.
        :param pulumi.Input[Union['ServiceEndpointAzureEcrCredentialsArgs', 'ServiceEndpointAzureEcrCredentialsArgsDict']] credentials: A `credentials` block.
        :param pulumi.Input[str] project_id: The ID of the project.
        :param pulumi.Input[str] resource_group: The resource group to which the container registry belongs.
        :param pulumi.Input[str] service_endpoint_authentication_scheme: Specifies the type of azurerm endpoint, either `WorkloadIdentityFederation`, `ManagedServiceIdentity` or `ServicePrincipal`. Defaults to `ServicePrincipal` for backwards compatibility. `ManagedServiceIdentity` has not yet been implemented for this resource.
        :param pulumi.Input[str] service_endpoint_name: The name you will use to refer to this service connection in task inputs.
        :param pulumi.Input[str] service_principal_id: The service principal ID.
        :param pulumi.Input[str] workload_identity_federation_issuer: The issuer of the workload identity federation service principal.
        :param pulumi.Input[str] workload_identity_federation_subject: The subject of the workload identity federation service principal.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ServiceEndpointAzureEcrState.__new__(_ServiceEndpointAzureEcrState)

        __props__.__dict__["app_object_id"] = app_object_id
        __props__.__dict__["authorization"] = authorization
        __props__.__dict__["az_spn_role_assignment_id"] = az_spn_role_assignment_id
        __props__.__dict__["az_spn_role_permissions"] = az_spn_role_permissions
        __props__.__dict__["azurecr_name"] = azurecr_name
        __props__.__dict__["azurecr_spn_tenantid"] = azurecr_spn_tenantid
        __props__.__dict__["azurecr_subscription_id"] = azurecr_subscription_id
        __props__.__dict__["azurecr_subscription_name"] = azurecr_subscription_name
        __props__.__dict__["credentials"] = credentials
        __props__.__dict__["description"] = description
        __props__.__dict__["project_id"] = project_id
        __props__.__dict__["resource_group"] = resource_group
        __props__.__dict__["service_endpoint_authentication_scheme"] = service_endpoint_authentication_scheme
        __props__.__dict__["service_endpoint_name"] = service_endpoint_name
        __props__.__dict__["service_principal_id"] = service_principal_id
        __props__.__dict__["spn_object_id"] = spn_object_id
        __props__.__dict__["workload_identity_federation_issuer"] = workload_identity_federation_issuer
        __props__.__dict__["workload_identity_federation_subject"] = workload_identity_federation_subject
        return ServiceEndpointAzureEcr(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="appObjectId")
    def app_object_id(self) -> pulumi.Output[str]:
        return pulumi.get(self, "app_object_id")

    @property
    @pulumi.getter
    def authorization(self) -> pulumi.Output[Mapping[str, str]]:
        return pulumi.get(self, "authorization")

    @property
    @pulumi.getter(name="azSpnRoleAssignmentId")
    def az_spn_role_assignment_id(self) -> pulumi.Output[str]:
        return pulumi.get(self, "az_spn_role_assignment_id")

    @property
    @pulumi.getter(name="azSpnRolePermissions")
    def az_spn_role_permissions(self) -> pulumi.Output[str]:
        return pulumi.get(self, "az_spn_role_permissions")

    @property
    @pulumi.getter(name="azurecrName")
    def azurecr_name(self) -> pulumi.Output[str]:
        """
        The Azure container registry name.
        """
        return pulumi.get(self, "azurecr_name")

    @property
    @pulumi.getter(name="azurecrSpnTenantid")
    def azurecr_spn_tenantid(self) -> pulumi.Output[str]:
        """
        The tenant id of the service principal.
        """
        return pulumi.get(self, "azurecr_spn_tenantid")

    @property
    @pulumi.getter(name="azurecrSubscriptionId")
    def azurecr_subscription_id(self) -> pulumi.Output[str]:
        """
        The subscription id of the Azure targets.
        """
        return pulumi.get(self, "azurecr_subscription_id")

    @property
    @pulumi.getter(name="azurecrSubscriptionName")
    def azurecr_subscription_name(self) -> pulumi.Output[str]:
        """
        The subscription name of the Azure targets.
        """
        return pulumi.get(self, "azurecr_subscription_name")

    @property
    @pulumi.getter
    def credentials(self) -> pulumi.Output[Optional['outputs.ServiceEndpointAzureEcrCredentials']]:
        """
        A `credentials` block.
        """
        return pulumi.get(self, "credentials")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Output[str]:
        """
        The ID of the project.
        """
        return pulumi.get(self, "project_id")

    @property
    @pulumi.getter(name="resourceGroup")
    def resource_group(self) -> pulumi.Output[Optional[str]]:
        """
        The resource group to which the container registry belongs.
        """
        return pulumi.get(self, "resource_group")

    @property
    @pulumi.getter(name="serviceEndpointAuthenticationScheme")
    def service_endpoint_authentication_scheme(self) -> pulumi.Output[Optional[str]]:
        """
        Specifies the type of azurerm endpoint, either `WorkloadIdentityFederation`, `ManagedServiceIdentity` or `ServicePrincipal`. Defaults to `ServicePrincipal` for backwards compatibility. `ManagedServiceIdentity` has not yet been implemented for this resource.
        """
        return pulumi.get(self, "service_endpoint_authentication_scheme")

    @property
    @pulumi.getter(name="serviceEndpointName")
    def service_endpoint_name(self) -> pulumi.Output[str]:
        """
        The name you will use to refer to this service connection in task inputs.
        """
        return pulumi.get(self, "service_endpoint_name")

    @property
    @pulumi.getter(name="servicePrincipalId")
    def service_principal_id(self) -> pulumi.Output[str]:
        """
        The service principal ID.
        """
        return pulumi.get(self, "service_principal_id")

    @property
    @pulumi.getter(name="spnObjectId")
    def spn_object_id(self) -> pulumi.Output[str]:
        return pulumi.get(self, "spn_object_id")

    @property
    @pulumi.getter(name="workloadIdentityFederationIssuer")
    def workload_identity_federation_issuer(self) -> pulumi.Output[str]:
        """
        The issuer of the workload identity federation service principal.
        """
        return pulumi.get(self, "workload_identity_federation_issuer")

    @property
    @pulumi.getter(name="workloadIdentityFederationSubject")
    def workload_identity_federation_subject(self) -> pulumi.Output[str]:
        """
        The subject of the workload identity federation service principal.
        """
        return pulumi.get(self, "workload_identity_federation_subject")

