# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['TeamArgs', 'Team']

@pulumi.input_type
class TeamArgs:
    def __init__(__self__, *,
                 project_id: pulumi.Input[str],
                 administrators: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 members: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 name: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a Team resource.
        :param pulumi.Input[str] project_id: The Project ID.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] administrators: List of subject descriptors to define administrators of the team.
               
               > NOTE: It's possible to define team administrators both within the
               > `Team` resource via the `administrators` block and by using the
               > `TeamAdministrators` resource. However it's not possible to use
               > both methods to manage team administrators, since there'll be conflicts.
        :param pulumi.Input[str] description: The description of the Team.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] members: List of subject descriptors to define members of the team.
               
               > NOTE: It's possible to define team members both within the
               > `Team` resource via the `members` block and by using the
               > `TeamMembers` resource. However it's not possible to use
               > both methods to manage team members, since there'll be conflicts.
        :param pulumi.Input[str] name: The name of the Team.
        """
        pulumi.set(__self__, "project_id", project_id)
        if administrators is not None:
            pulumi.set(__self__, "administrators", administrators)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if members is not None:
            pulumi.set(__self__, "members", members)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Input[str]:
        """
        The Project ID.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "project_id", value)

    @property
    @pulumi.getter
    def administrators(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of subject descriptors to define administrators of the team.

        > NOTE: It's possible to define team administrators both within the
        > `Team` resource via the `administrators` block and by using the
        > `TeamAdministrators` resource. However it's not possible to use
        > both methods to manage team administrators, since there'll be conflicts.
        """
        return pulumi.get(self, "administrators")

    @administrators.setter
    def administrators(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "administrators", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The description of the Team.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def members(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of subject descriptors to define members of the team.

        > NOTE: It's possible to define team members both within the
        > `Team` resource via the `members` block and by using the
        > `TeamMembers` resource. However it's not possible to use
        > both methods to manage team members, since there'll be conflicts.
        """
        return pulumi.get(self, "members")

    @members.setter
    def members(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "members", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the Team.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class _TeamState:
    def __init__(__self__, *,
                 administrators: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 descriptor: Optional[pulumi.Input[str]] = None,
                 members: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 project_id: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering Team resources.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] administrators: List of subject descriptors to define administrators of the team.
               
               > NOTE: It's possible to define team administrators both within the
               > `Team` resource via the `administrators` block and by using the
               > `TeamAdministrators` resource. However it's not possible to use
               > both methods to manage team administrators, since there'll be conflicts.
        :param pulumi.Input[str] description: The description of the Team.
        :param pulumi.Input[str] descriptor: The descriptor of the Team.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] members: List of subject descriptors to define members of the team.
               
               > NOTE: It's possible to define team members both within the
               > `Team` resource via the `members` block and by using the
               > `TeamMembers` resource. However it's not possible to use
               > both methods to manage team members, since there'll be conflicts.
        :param pulumi.Input[str] name: The name of the Team.
        :param pulumi.Input[str] project_id: The Project ID.
        """
        if administrators is not None:
            pulumi.set(__self__, "administrators", administrators)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if descriptor is not None:
            pulumi.set(__self__, "descriptor", descriptor)
        if members is not None:
            pulumi.set(__self__, "members", members)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)

    @property
    @pulumi.getter
    def administrators(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of subject descriptors to define administrators of the team.

        > NOTE: It's possible to define team administrators both within the
        > `Team` resource via the `administrators` block and by using the
        > `TeamAdministrators` resource. However it's not possible to use
        > both methods to manage team administrators, since there'll be conflicts.
        """
        return pulumi.get(self, "administrators")

    @administrators.setter
    def administrators(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "administrators", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The description of the Team.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def descriptor(self) -> Optional[pulumi.Input[str]]:
        """
        The descriptor of the Team.
        """
        return pulumi.get(self, "descriptor")

    @descriptor.setter
    def descriptor(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "descriptor", value)

    @property
    @pulumi.getter
    def members(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of subject descriptors to define members of the team.

        > NOTE: It's possible to define team members both within the
        > `Team` resource via the `members` block and by using the
        > `TeamMembers` resource. However it's not possible to use
        > both methods to manage team members, since there'll be conflicts.
        """
        return pulumi.get(self, "members")

    @members.setter
    def members(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "members", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the Team.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[str]]:
        """
        The Project ID.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project_id", value)


class Team(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 administrators: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 members: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 project_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Manages a team within a project in a Azure DevOps organization.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azuredevops as azuredevops

        example = azuredevops.Project("example",
            name="Example Project",
            work_item_template="Agile",
            version_control="Git",
            visibility="private",
            description="Managed by Pulumi")
        example_project_contributors = azuredevops.get_group_output(project_id=example.id,
            name="Contributors")
        example_project_readers = azuredevops.get_group_output(project_id=example.id,
            name="Readers")
        example_team = azuredevops.Team("example",
            project_id=example.id,
            name="Example Team",
            administrators=[example_project_contributors.descriptor],
            members=[example_project_readers.descriptor])
        ```

        ## Relevant Links

        - [Azure DevOps Service REST API 7.0 - Teams - Create](https://docs.microsoft.com/en-us/rest/api/azure/devops/core/teams/create?view=azure-devops-rest-7.0)

        ## PAT Permissions Required

        - **vso.project_manage**:	Grants the ability to create, read, update, and delete projects and teams.

        ## Import

        Azure DevOps teams can be imported using the complete resource id `<project_id>/<team_id>` e.g.

        ```sh
        $ pulumi import azuredevops:index/team:Team example 00000000-0000-0000-0000-000000000000/00000000-0000-0000-0000-000000000000
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] administrators: List of subject descriptors to define administrators of the team.
               
               > NOTE: It's possible to define team administrators both within the
               > `Team` resource via the `administrators` block and by using the
               > `TeamAdministrators` resource. However it's not possible to use
               > both methods to manage team administrators, since there'll be conflicts.
        :param pulumi.Input[str] description: The description of the Team.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] members: List of subject descriptors to define members of the team.
               
               > NOTE: It's possible to define team members both within the
               > `Team` resource via the `members` block and by using the
               > `TeamMembers` resource. However it's not possible to use
               > both methods to manage team members, since there'll be conflicts.
        :param pulumi.Input[str] name: The name of the Team.
        :param pulumi.Input[str] project_id: The Project ID.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: TeamArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a team within a project in a Azure DevOps organization.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azuredevops as azuredevops

        example = azuredevops.Project("example",
            name="Example Project",
            work_item_template="Agile",
            version_control="Git",
            visibility="private",
            description="Managed by Pulumi")
        example_project_contributors = azuredevops.get_group_output(project_id=example.id,
            name="Contributors")
        example_project_readers = azuredevops.get_group_output(project_id=example.id,
            name="Readers")
        example_team = azuredevops.Team("example",
            project_id=example.id,
            name="Example Team",
            administrators=[example_project_contributors.descriptor],
            members=[example_project_readers.descriptor])
        ```

        ## Relevant Links

        - [Azure DevOps Service REST API 7.0 - Teams - Create](https://docs.microsoft.com/en-us/rest/api/azure/devops/core/teams/create?view=azure-devops-rest-7.0)

        ## PAT Permissions Required

        - **vso.project_manage**:	Grants the ability to create, read, update, and delete projects and teams.

        ## Import

        Azure DevOps teams can be imported using the complete resource id `<project_id>/<team_id>` e.g.

        ```sh
        $ pulumi import azuredevops:index/team:Team example 00000000-0000-0000-0000-000000000000/00000000-0000-0000-0000-000000000000
        ```

        :param str resource_name: The name of the resource.
        :param TeamArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(TeamArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 administrators: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 members: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 project_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = TeamArgs.__new__(TeamArgs)

            __props__.__dict__["administrators"] = administrators
            __props__.__dict__["description"] = description
            __props__.__dict__["members"] = members
            __props__.__dict__["name"] = name
            if project_id is None and not opts.urn:
                raise TypeError("Missing required property 'project_id'")
            __props__.__dict__["project_id"] = project_id
            __props__.__dict__["descriptor"] = None
        super(Team, __self__).__init__(
            'azuredevops:index/team:Team',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            administrators: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            description: Optional[pulumi.Input[str]] = None,
            descriptor: Optional[pulumi.Input[str]] = None,
            members: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            name: Optional[pulumi.Input[str]] = None,
            project_id: Optional[pulumi.Input[str]] = None) -> 'Team':
        """
        Get an existing Team resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] administrators: List of subject descriptors to define administrators of the team.
               
               > NOTE: It's possible to define team administrators both within the
               > `Team` resource via the `administrators` block and by using the
               > `TeamAdministrators` resource. However it's not possible to use
               > both methods to manage team administrators, since there'll be conflicts.
        :param pulumi.Input[str] description: The description of the Team.
        :param pulumi.Input[str] descriptor: The descriptor of the Team.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] members: List of subject descriptors to define members of the team.
               
               > NOTE: It's possible to define team members both within the
               > `Team` resource via the `members` block and by using the
               > `TeamMembers` resource. However it's not possible to use
               > both methods to manage team members, since there'll be conflicts.
        :param pulumi.Input[str] name: The name of the Team.
        :param pulumi.Input[str] project_id: The Project ID.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _TeamState.__new__(_TeamState)

        __props__.__dict__["administrators"] = administrators
        __props__.__dict__["description"] = description
        __props__.__dict__["descriptor"] = descriptor
        __props__.__dict__["members"] = members
        __props__.__dict__["name"] = name
        __props__.__dict__["project_id"] = project_id
        return Team(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def administrators(self) -> pulumi.Output[Sequence[str]]:
        """
        List of subject descriptors to define administrators of the team.

        > NOTE: It's possible to define team administrators both within the
        > `Team` resource via the `administrators` block and by using the
        > `TeamAdministrators` resource. However it's not possible to use
        > both methods to manage team administrators, since there'll be conflicts.
        """
        return pulumi.get(self, "administrators")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        The description of the Team.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def descriptor(self) -> pulumi.Output[str]:
        """
        The descriptor of the Team.
        """
        return pulumi.get(self, "descriptor")

    @property
    @pulumi.getter
    def members(self) -> pulumi.Output[Sequence[str]]:
        """
        List of subject descriptors to define members of the team.

        > NOTE: It's possible to define team members both within the
        > `Team` resource via the `members` block and by using the
        > `TeamMembers` resource. However it's not possible to use
        > both methods to manage team members, since there'll be conflicts.
        """
        return pulumi.get(self, "members")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The name of the Team.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Output[str]:
        """
        The Project ID.
        """
        return pulumi.get(self, "project_id")

