# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['WorkitemArgs', 'Workitem']

@pulumi.input_type
class WorkitemArgs:
    def __init__(__self__, *,
                 project_id: pulumi.Input[str],
                 title: pulumi.Input[str],
                 type: pulumi.Input[str],
                 area_path: Optional[pulumi.Input[str]] = None,
                 custom_fields: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 iteration_path: Optional[pulumi.Input[str]] = None,
                 state: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        The set of arguments for constructing a Workitem resource.
        :param pulumi.Input[str] project_id: The ID of the Project.
        :param pulumi.Input[str] title: The Title of the Work Item.
        :param pulumi.Input[str] type: The Type of the Work Item. The work item type varies depending on the process used when creating the project(`Agile`, `Basic`, `Scrum`, `Scrum`). See [Work Item Types](https://learn.microsoft.com/en-us/azure/devops/boards/work-items/about-work-items?view=azure-devops) for more details.
        :param pulumi.Input[str] area_path: Specifies the area where the Work Item is used.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] custom_fields: Specifies a list with Custom Fields for the Work Item.
        :param pulumi.Input[str] iteration_path: Specifies the iteration in which the Work Item is used.
        :param pulumi.Input[str] state: The state of the Work Item. The four main states that are defined for the User Story (`Agile`) are `New`, `Active`, `Resolved`, and `Closed`. See [Workflow states](https://learn.microsoft.com/en-us/azure/devops/boards/work-items/workflow-and-state-categories?view=azure-devops&tabs=agile-process#workflow-states) for more details.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] tags: Specifies a list of Tags.
        """
        pulumi.set(__self__, "project_id", project_id)
        pulumi.set(__self__, "title", title)
        pulumi.set(__self__, "type", type)
        if area_path is not None:
            pulumi.set(__self__, "area_path", area_path)
        if custom_fields is not None:
            pulumi.set(__self__, "custom_fields", custom_fields)
        if iteration_path is not None:
            pulumi.set(__self__, "iteration_path", iteration_path)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Input[str]:
        """
        The ID of the Project.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "project_id", value)

    @property
    @pulumi.getter
    def title(self) -> pulumi.Input[str]:
        """
        The Title of the Work Item.
        """
        return pulumi.get(self, "title")

    @title.setter
    def title(self, value: pulumi.Input[str]):
        pulumi.set(self, "title", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        The Type of the Work Item. The work item type varies depending on the process used when creating the project(`Agile`, `Basic`, `Scrum`, `Scrum`). See [Work Item Types](https://learn.microsoft.com/en-us/azure/devops/boards/work-items/about-work-items?view=azure-devops) for more details.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="areaPath")
    def area_path(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the area where the Work Item is used.
        """
        return pulumi.get(self, "area_path")

    @area_path.setter
    def area_path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "area_path", value)

    @property
    @pulumi.getter(name="customFields")
    def custom_fields(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Specifies a list with Custom Fields for the Work Item.
        """
        return pulumi.get(self, "custom_fields")

    @custom_fields.setter
    def custom_fields(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "custom_fields", value)

    @property
    @pulumi.getter(name="iterationPath")
    def iteration_path(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the iteration in which the Work Item is used.
        """
        return pulumi.get(self, "iteration_path")

    @iteration_path.setter
    def iteration_path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "iteration_path", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[str]]:
        """
        The state of the Work Item. The four main states that are defined for the User Story (`Agile`) are `New`, `Active`, `Resolved`, and `Closed`. See [Workflow states](https://learn.microsoft.com/en-us/azure/devops/boards/work-items/workflow-and-state-categories?view=azure-devops&tabs=agile-process#workflow-states) for more details.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Specifies a list of Tags.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _WorkitemState:
    def __init__(__self__, *,
                 area_path: Optional[pulumi.Input[str]] = None,
                 custom_fields: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 iteration_path: Optional[pulumi.Input[str]] = None,
                 project_id: Optional[pulumi.Input[str]] = None,
                 state: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 title: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering Workitem resources.
        :param pulumi.Input[str] area_path: Specifies the area where the Work Item is used.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] custom_fields: Specifies a list with Custom Fields for the Work Item.
        :param pulumi.Input[str] iteration_path: Specifies the iteration in which the Work Item is used.
        :param pulumi.Input[str] project_id: The ID of the Project.
        :param pulumi.Input[str] state: The state of the Work Item. The four main states that are defined for the User Story (`Agile`) are `New`, `Active`, `Resolved`, and `Closed`. See [Workflow states](https://learn.microsoft.com/en-us/azure/devops/boards/work-items/workflow-and-state-categories?view=azure-devops&tabs=agile-process#workflow-states) for more details.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] tags: Specifies a list of Tags.
        :param pulumi.Input[str] title: The Title of the Work Item.
        :param pulumi.Input[str] type: The Type of the Work Item. The work item type varies depending on the process used when creating the project(`Agile`, `Basic`, `Scrum`, `Scrum`). See [Work Item Types](https://learn.microsoft.com/en-us/azure/devops/boards/work-items/about-work-items?view=azure-devops) for more details.
        """
        if area_path is not None:
            pulumi.set(__self__, "area_path", area_path)
        if custom_fields is not None:
            pulumi.set(__self__, "custom_fields", custom_fields)
        if iteration_path is not None:
            pulumi.set(__self__, "iteration_path", iteration_path)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if title is not None:
            pulumi.set(__self__, "title", title)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="areaPath")
    def area_path(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the area where the Work Item is used.
        """
        return pulumi.get(self, "area_path")

    @area_path.setter
    def area_path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "area_path", value)

    @property
    @pulumi.getter(name="customFields")
    def custom_fields(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Specifies a list with Custom Fields for the Work Item.
        """
        return pulumi.get(self, "custom_fields")

    @custom_fields.setter
    def custom_fields(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "custom_fields", value)

    @property
    @pulumi.getter(name="iterationPath")
    def iteration_path(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the iteration in which the Work Item is used.
        """
        return pulumi.get(self, "iteration_path")

    @iteration_path.setter
    def iteration_path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "iteration_path", value)

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the Project.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project_id", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[str]]:
        """
        The state of the Work Item. The four main states that are defined for the User Story (`Agile`) are `New`, `Active`, `Resolved`, and `Closed`. See [Workflow states](https://learn.microsoft.com/en-us/azure/devops/boards/work-items/workflow-and-state-categories?view=azure-devops&tabs=agile-process#workflow-states) for more details.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Specifies a list of Tags.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter
    def title(self) -> Optional[pulumi.Input[str]]:
        """
        The Title of the Work Item.
        """
        return pulumi.get(self, "title")

    @title.setter
    def title(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "title", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        The Type of the Work Item. The work item type varies depending on the process used when creating the project(`Agile`, `Basic`, `Scrum`, `Scrum`). See [Work Item Types](https://learn.microsoft.com/en-us/azure/devops/boards/work-items/about-work-items?view=azure-devops) for more details.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)


class Workitem(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 area_path: Optional[pulumi.Input[str]] = None,
                 custom_fields: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 iteration_path: Optional[pulumi.Input[str]] = None,
                 project_id: Optional[pulumi.Input[str]] = None,
                 state: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 title: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Manages a Work Item in Azure Devops.

        ## Example Usage

        ### Basic usage

        ```python
        import pulumi
        import pulumi_azuredevops as azuredevops

        example = azuredevops.Project("example",
            name="Example Project",
            work_item_template="Agile",
            version_control="Git",
            visibility="private",
            description="Managed by Pulumi")
        example_workitem = azuredevops.Workitem("example",
            project_id=example_azuredevops_project["id"],
            title="Example Work Item",
            type="Issue",
            state="Active",
            tags=["Tag"])
        ```

        ### With custom fields

        ```python
        import pulumi
        import pulumi_azuredevops as azuredevops

        example = azuredevops.Project("example",
            name="Example Project",
            work_item_template="Agile",
            version_control="Git",
            visibility="private",
            description="Managed by Pulumi")
        example_workitem = azuredevops.Workitem("example",
            project_id=example_azuredevops_project["id"],
            title="Example Work Item",
            type="Issue",
            state="Active",
            tags=["Tag"],
            custom_fields={
                "example": "example",
            })
        ```

        ## Import

        Work Item resource does not support import.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] area_path: Specifies the area where the Work Item is used.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] custom_fields: Specifies a list with Custom Fields for the Work Item.
        :param pulumi.Input[str] iteration_path: Specifies the iteration in which the Work Item is used.
        :param pulumi.Input[str] project_id: The ID of the Project.
        :param pulumi.Input[str] state: The state of the Work Item. The four main states that are defined for the User Story (`Agile`) are `New`, `Active`, `Resolved`, and `Closed`. See [Workflow states](https://learn.microsoft.com/en-us/azure/devops/boards/work-items/workflow-and-state-categories?view=azure-devops&tabs=agile-process#workflow-states) for more details.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] tags: Specifies a list of Tags.
        :param pulumi.Input[str] title: The Title of the Work Item.
        :param pulumi.Input[str] type: The Type of the Work Item. The work item type varies depending on the process used when creating the project(`Agile`, `Basic`, `Scrum`, `Scrum`). See [Work Item Types](https://learn.microsoft.com/en-us/azure/devops/boards/work-items/about-work-items?view=azure-devops) for more details.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: WorkitemArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a Work Item in Azure Devops.

        ## Example Usage

        ### Basic usage

        ```python
        import pulumi
        import pulumi_azuredevops as azuredevops

        example = azuredevops.Project("example",
            name="Example Project",
            work_item_template="Agile",
            version_control="Git",
            visibility="private",
            description="Managed by Pulumi")
        example_workitem = azuredevops.Workitem("example",
            project_id=example_azuredevops_project["id"],
            title="Example Work Item",
            type="Issue",
            state="Active",
            tags=["Tag"])
        ```

        ### With custom fields

        ```python
        import pulumi
        import pulumi_azuredevops as azuredevops

        example = azuredevops.Project("example",
            name="Example Project",
            work_item_template="Agile",
            version_control="Git",
            visibility="private",
            description="Managed by Pulumi")
        example_workitem = azuredevops.Workitem("example",
            project_id=example_azuredevops_project["id"],
            title="Example Work Item",
            type="Issue",
            state="Active",
            tags=["Tag"],
            custom_fields={
                "example": "example",
            })
        ```

        ## Import

        Work Item resource does not support import.

        :param str resource_name: The name of the resource.
        :param WorkitemArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(WorkitemArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 area_path: Optional[pulumi.Input[str]] = None,
                 custom_fields: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 iteration_path: Optional[pulumi.Input[str]] = None,
                 project_id: Optional[pulumi.Input[str]] = None,
                 state: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 title: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = WorkitemArgs.__new__(WorkitemArgs)

            __props__.__dict__["area_path"] = area_path
            __props__.__dict__["custom_fields"] = custom_fields
            __props__.__dict__["iteration_path"] = iteration_path
            if project_id is None and not opts.urn:
                raise TypeError("Missing required property 'project_id'")
            __props__.__dict__["project_id"] = project_id
            __props__.__dict__["state"] = state
            __props__.__dict__["tags"] = tags
            if title is None and not opts.urn:
                raise TypeError("Missing required property 'title'")
            __props__.__dict__["title"] = title
            if type is None and not opts.urn:
                raise TypeError("Missing required property 'type'")
            __props__.__dict__["type"] = type
        super(Workitem, __self__).__init__(
            'azuredevops:index/workitem:Workitem',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            area_path: Optional[pulumi.Input[str]] = None,
            custom_fields: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            iteration_path: Optional[pulumi.Input[str]] = None,
            project_id: Optional[pulumi.Input[str]] = None,
            state: Optional[pulumi.Input[str]] = None,
            tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            title: Optional[pulumi.Input[str]] = None,
            type: Optional[pulumi.Input[str]] = None) -> 'Workitem':
        """
        Get an existing Workitem resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] area_path: Specifies the area where the Work Item is used.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] custom_fields: Specifies a list with Custom Fields for the Work Item.
        :param pulumi.Input[str] iteration_path: Specifies the iteration in which the Work Item is used.
        :param pulumi.Input[str] project_id: The ID of the Project.
        :param pulumi.Input[str] state: The state of the Work Item. The four main states that are defined for the User Story (`Agile`) are `New`, `Active`, `Resolved`, and `Closed`. See [Workflow states](https://learn.microsoft.com/en-us/azure/devops/boards/work-items/workflow-and-state-categories?view=azure-devops&tabs=agile-process#workflow-states) for more details.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] tags: Specifies a list of Tags.
        :param pulumi.Input[str] title: The Title of the Work Item.
        :param pulumi.Input[str] type: The Type of the Work Item. The work item type varies depending on the process used when creating the project(`Agile`, `Basic`, `Scrum`, `Scrum`). See [Work Item Types](https://learn.microsoft.com/en-us/azure/devops/boards/work-items/about-work-items?view=azure-devops) for more details.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _WorkitemState.__new__(_WorkitemState)

        __props__.__dict__["area_path"] = area_path
        __props__.__dict__["custom_fields"] = custom_fields
        __props__.__dict__["iteration_path"] = iteration_path
        __props__.__dict__["project_id"] = project_id
        __props__.__dict__["state"] = state
        __props__.__dict__["tags"] = tags
        __props__.__dict__["title"] = title
        __props__.__dict__["type"] = type
        return Workitem(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="areaPath")
    def area_path(self) -> pulumi.Output[str]:
        """
        Specifies the area where the Work Item is used.
        """
        return pulumi.get(self, "area_path")

    @property
    @pulumi.getter(name="customFields")
    def custom_fields(self) -> pulumi.Output[Optional[Mapping[str, str]]]:
        """
        Specifies a list with Custom Fields for the Work Item.
        """
        return pulumi.get(self, "custom_fields")

    @property
    @pulumi.getter(name="iterationPath")
    def iteration_path(self) -> pulumi.Output[str]:
        """
        Specifies the iteration in which the Work Item is used.
        """
        return pulumi.get(self, "iteration_path")

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Output[str]:
        """
        The ID of the Project.
        """
        return pulumi.get(self, "project_id")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[str]:
        """
        The state of the Work Item. The four main states that are defined for the User Story (`Agile`) are `New`, `Active`, `Resolved`, and `Closed`. See [Workflow states](https://learn.microsoft.com/en-us/azure/devops/boards/work-items/workflow-and-state-categories?view=azure-devops&tabs=agile-process#workflow-states) for more details.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        Specifies a list of Tags.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter
    def title(self) -> pulumi.Output[str]:
        """
        The Title of the Work Item.
        """
        return pulumi.get(self, "title")

    @property
    @pulumi.getter
    def type(self) -> pulumi.Output[str]:
        """
        The Type of the Work Item. The work item type varies depending on the process used when creating the project(`Agile`, `Basic`, `Scrum`, `Scrum`). See [Work Item Types](https://learn.microsoft.com/en-us/azure/devops/boards/work-items/about-work-items?view=azure-devops) for more details.
        """
        return pulumi.get(self, "type")

