# Changelog

All notable changes to this project will be documented in this file.

The format is based on [Keep a Changelog](https://keepachangelog.com/en/1.0.0/),
and this project adheres to [Semantic Versioning](https://semver.org/spec/v2.0.0.html).

## [1.0.0] - 2025-09-30

### Added
- Initial release of pop-wrapper
- Complete implementation of all 63+ Popcat API endpoints
- Modular package structure with 7 main modules
- Comprehensive error handling with descriptive messages
- Full type hints support for better IDE integration
- Extensive documentation with examples for every function
- Unit tests with mocking for all major endpoints
- CodeClient class for syntax-highlighted code paste creation
- Shortener class for URL shortening with custom extensions
- Rate limiting helpers and best practices
- PyPI package configuration with proper metadata
- Read the Docs documentation setup
- MIT License

### Features by Category

#### Image Manipulation (14 functions)
- jail, blur, invert, greyscale, drip, clown, colorify, wanted, gun, ad, uncover, communism, jokeoverhead, mnm

#### Meme Generation (18 functions)  
- drake, pooh, ship, supreme, oogway, biden, pikachu, sadcat, opinion, discord_message, quote, happysad, unforgivable, couldread, lulcat, facts, alert, caution

#### Data & Information APIs (11 functions)
- weather, github, npm, steam, imdb, country, periodic_table, colorinfo, randomcolor, subreddit, itunes

#### Text Utilities (7 functions)
- translate, reverse, mock, doublestruck, texttomorse, encode, decode

#### Random Content (7 functions)
- joke, fact, randommeme, car, showerthought, wouldyourather, eightball/_8ball

#### Utilities (4 functions)
- lyrics, screenshot, chatbot, welcomecard

#### Specialized Classes (2 classes)
- CodeClient with 40+ themes and 50+ programming languages
- Shortener for URL shortening with custom extensions

## [Unreleased]

### Planned
- Additional theme support for CodeClient
- Batch processing utilities
- Caching mechanism for API responses
- Async/await support
- CLI tool for command-line usage
- More comprehensive examples
- Performance optimizations
