"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.RunTask = exports.LaunchType = exports.PlatformVersion = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const constructs_1 = require("constructs");
/**
 * Fargate platform version
 */
var PlatformVersion;
(function (PlatformVersion) {
    PlatformVersion["V1_3_0"] = "1.3.0";
    PlatformVersion["V1_4_0"] = "1.4.0";
    PlatformVersion["LATEST"] = "LATEST";
})(PlatformVersion = exports.PlatformVersion || (exports.PlatformVersion = {}));
var LaunchType;
(function (LaunchType) {
    LaunchType["FARGATE"] = "FARGATE";
    LaunchType["EXTERNAL"] = "EXTERNAL";
})(LaunchType = exports.LaunchType || (exports.LaunchType = {}));
class RunTask extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        const vpc = (props.vpc ?? props.cluster) ? props.cluster.vpc : getOrCreateVpc(this);
        const cluster = props.cluster ?? new aws_cdk_lib_1.aws_ecs.Cluster(this, 'Cluster', {
            vpc,
            enableFargateCapacityProviders: true,
        });
        const task = props.task;
        this.vpc = vpc;
        this.cluster = cluster;
        this.securityGroup = props.securityGroup ?? new aws_cdk_lib_1.aws_ec2.SecurityGroup(this, 'FargateSecurityGroup', { vpc });
        this.connections = new aws_cdk_lib_1.aws_ec2.Connections({ securityGroups: [this.securityGroup] });
        if (props.schedule) {
            new aws_cdk_lib_1.aws_events.Rule(this, 'ScheduleRule', {
                schedule: props.schedule,
                targets: [
                    new aws_cdk_lib_1.aws_events_targets.EcsTask({
                        cluster,
                        taskDefinition: task,
                    }),
                ],
            });
        }
        // run it once by default with custom resource
        if (props.runAtOnce !== false) {
            const onEvent = {
                service: 'ECS',
                action: 'runTask',
                parameters: {
                    cluster: cluster.clusterName,
                    taskDefinition: task.taskDefinitionArn,
                    capacityProviderStrategy: props.capacityProviderStrategy,
                    launchType: props.launchType ?? (props.capacityProviderStrategy ? undefined : LaunchType.FARGATE),
                    platformVersion: props.fargatePlatformVersion,
                    // networkConfiguration is not required with the `EXTERNAL` launch type
                    networkConfiguration: props.launchType === LaunchType.EXTERNAL ? undefined : {
                        awsvpcConfiguration: {
                            assignPublicIp: 'DISABLED',
                            subnets: vpc.selectSubnets(props.vpcSubnets ?? {
                                subnetType: aws_cdk_lib_1.aws_ec2.SubnetType.PRIVATE_WITH_NAT,
                            }).subnetIds,
                            securityGroups: [this.securityGroup.securityGroupId],
                        },
                    },
                },
                physicalResourceId: aws_cdk_lib_1.custom_resources.PhysicalResourceId.of(task.taskDefinitionArn),
            };
            const runTaskResource = new aws_cdk_lib_1.custom_resources.AwsCustomResource(this, 'EcsRunTask', {
                onCreate: onEvent,
                onUpdate: props.runOnResourceUpdate ? onEvent : undefined,
                policy: aws_cdk_lib_1.custom_resources.AwsCustomResourcePolicy.fromSdkCalls({ resources: [task.taskDefinitionArn] }),
                logRetention: props.logRetention ?? aws_cdk_lib_1.aws_logs.RetentionDays.ONE_WEEK,
                resourceType: 'Custom::RunTask',
            });
            this.runOnceResource = runTaskResource;
            // allow lambda from custom resource to iam:PassRole on the ecs task role and execution role
            task.taskRole.grantPassRole(runTaskResource.grantPrincipal);
            if (task.executionRole)
                task.executionRole.grantPassRole(runTaskResource.grantPrincipal);
        }
    }
}
exports.RunTask = RunTask;
_a = JSII_RTTI_SYMBOL_1;
RunTask[_a] = { fqn: "cdk-fargate-run-task.RunTask", version: "2.0.196" };
function getOrCreateVpc(scope) {
    // use an existing vpc or create a new one
    return scope.node.tryGetContext('use_default_vpc') === '1' ?
        aws_cdk_lib_1.aws_ec2.Vpc.fromLookup(scope, 'Vpc', { isDefault: true }) :
        scope.node.tryGetContext('use_vpc_id') ?
            aws_cdk_lib_1.aws_ec2.Vpc.fromLookup(scope, 'Vpc', { vpcId: scope.node.tryGetContext('use_vpc_id') }) :
            new aws_cdk_lib_1.aws_ec2.Vpc(scope, 'Vpc', { maxAzs: 3, natGateways: 1 });
}
//# sourceMappingURL=data:application/json;base64,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