from traitlets import (
    Unicode, Dict, Bool,
)
from ..basewidget import BaseWidget


class Aria(BaseWidget):
    """ 
:warning: **Autogenerated class**

The W3C has developed the [WAI-ARIA](https://www.w3.org/WAI/intro/aria), the Accessible Rich Internet Applications Suite, which is dedicated to making web content and web applications accessible. Apache ECharts 4 complies with this specification by supporting the automatic generation of intelligent descriptions based on chart configuration items, allowing blind people to understand the chart content with the help of a reading device, making the chart accessible to a wider audience. In addition, Apache ECharts 5 adds support for applique textures as an auxiliary expression of color to further differentiate the data.


It is turned off by default and needs to be turned on by setting [aria.enabled](#aria.enabled) to `true`.



    """

    def __init__(self, **kwargs):

        super().__init__(**kwargs)  
    
    _model_name = Unicode("AriaModel").tag(sync=True)
    
    enabled = Bool(None, allow_none=True, help="""Whether or not aria is turned on. If not, the `label` or `decal` effect is not applied.""").tag(sync=True)
    
    label = Dict(default_value=None, allow_none=True, help="""If [aria.enabled](#aria.enabled) is set to `true`, `label` is enabled by default. When enabled, the description of the chart will be automatically and intelligently generated based on the chart, data, title, etc. Users can also modify the description through the configuration item.


**Example:**



```
option = {
    aria: {
        // The following lines can be omitted because label.enabled defaults to true.
        // label: {
        // enabled: true
        // },
        enabled: true
    },
    title: {
        text: 'User access sources for a site',
        x: 'center'
    },
    series: [
        {
            name: 'access source',
            type: 'pie',
            data: [
                { value: 335, name: 'Direct Access' },
                { value: 310, name: 'Email Marketing' },
                { value: 234, name: 'Affiliate Ads' },
                { value: 135, name: 'Video Ads' },
                { value: 1548, name: 'Search Engine' }
            ]
        }
    ]
};

```


On the generated chart DOM, there is an `aria-label` attribute that allows the blind to understand the chart with the help of a reading device. Its value is.



> This is a chart of "Source of user access to a site." The chart type is a pie chart that indicates the source of the visit. The data is - direct access data is 335, mail marketing data is 310, union ad data is 234, video ad data is 135, search engine data is 1548.


The basic process for generating the description is that if [aria.enabled](#aria.enabled) is set to `true` (not the default) and [aria.label.enabled](#aria.label.enabled) is set to `true` (the default), then the accessibility description is generated. Otherwise it is not generated. If [aria.label.description](#aria.label.description) is defined, it is used as the full description of the chart, otherwise the description is generated according to the template stitching. We provide a default algorithm for generating descriptions, and only if the generated descriptions are not quite right, you need to modify these templates, or even override them completely with `aria.label.description`.


When using the template, whether [title.text](#title.text) is used along with [aria.label.general.withTitle](option.html#aria.label.general.withTitle) while [aria.label.general.withoutTitle](option.html#aria.label.general.withoutTitle) is used if there is no title text. `aria.general.withTitle` supports a template `'{title}'`, which will be replaced with chart title. This means, if `aria.general.withTitle` is set to be `'The chart title is {title}.'` and the chart title is `Price Distribution`, it will be interpreted into `'The chart title is Price Distribution.'`


After generating the title, the description of the series ([aria.label.series](option.html#aria.label.series)) and the description of the data for each series ([aria.label.data](option.html#aria.label.data)) are generated in turn. The following is an example of a template. Likewise, each template may include template variables to replace actual values.


The complete description generation process is:


![](documents/asset/img/echarts-aria.jpg)""").tag(sync=True)
    
    decal = Dict(default_value=None, allow_none=True, help="""Decal patterns are added to series data as an additional hint other than colors to help differentiate the data. It is easy to enabled the default decal patterns by enabling it:



```
aria: {
    enabled: true,
    decal: {
        show: true
    }
}

```

Most series types are supported, including: `'line'`, `'bar'`, `'pie'`, `'radar'`, `'treemap'`, `'sunburst'`, `'boxplot'`, `'sankey'`, `'funnel'`, `'gauge'`, `'pictorialBar'`, `'themeRiver'`, `'custom'` and so on. Among them, some series have no filling color by default (such as `'line'`, `'radar'`, `'boxplot'`), which take effect only if the `'areaStyle'` is set.""").tag(sync=True)
    
        
