from traitlets import (
    Unicode, Dict, Float, Bool, Any,
)
from ..basewidget import BaseWidget


class AxisPointer(BaseWidget):
    """ 
:warning: **Autogenerated class**

This is the global configurations of axisPointer.




---


`axisPointer` is a tool for displaying reference line and axis value under mouse pointer.


For example:



In the demo above, [axisPointer.link](#axisPointer.link) is used to link axisPointer from different coordinate systems.


`axisPointer` can also be used on touch device, where user can drag the button to move the reference line and label.



In the cases that more than one axis exist, axisPointer helps to look inside the data.






---



> **Notice:**
> Generally, axisPointers is configured in each axes who need them (for example [xAxis.axisPointer](#xAxis.axisPointer)), or configured in `tooltip` (for example [tooltip.axisPointer](#tooltip.axisPointer)).



> But these configurations can only be configured in global axisPointer:
> [axisPointer.triggerOn](#axisPointer.triggerOn), [axisPointer.link](#axisPointer.link).




---




---


**How to display axisPointer:**


In [cartesian (grid)](#grid) and [polar](~polar) and (single axis](#single), each axis has its own axisPointer.


Those axisPointer will not be displayed by default, utill configured as follows:


- Set `someAxis.axisPointer.show` (like [xAxis.axisPointer.show](#xAxis.axisPointer.show)) as `true`. Then axisPointer of this axis will be displayed.
- Set [tooltip.trigger](#tooltip.trigger) as `'axis'`, or set [tooltip.axisPointer.type](#tooltip.axisPointer.type) as `'cross'`. Then coordinate system will automatically chose the axes who will display their axisPointers. ([tooltip.axisPointer.axis](#tooltip.axisPointer.axis) can be used to change the choice.) Notice, `axis.axisPointer` will override `tooltip.axisPointer` settings.




---


**How to display the label of axisPointer:**


The label of axisPointer will not be displayed by default(namely, only reference line will be displayed by default), utill configured as follows:


- Set `someAxis.axisPointer.label.show` (for example [xAxis.axisPointer.label.show](#xAxis.axisPointer.show)) as `true`. Then the label of the axisPointer will be displayed.
- Set [tooltip.axisPointer.type](#tooltip.axisPointer.type) as `'cross'`. Then the label of the crossed axisPointers will be displayed.




---


**How to configure axisPointer on touch device:**


Set `someAxis.axisPointer.handle.show` (for example [xAxis.axisPointer.handle.show](#xAxis.axisPointer.handle.show) as `true`. Then the button for dragging will be displayed. (This feature is not supported on polar).


**Notice:**
If tooltip does not work well in this case, try to set[tooltip.triggerOn](#tooltip.triggerOn) as `'none'` (for the effect: show tooltip when finger holding on the button, and hide tooltip after finger left the button), or set [tooltip.alwaysShowContent](#tooltip.alwaysShowContent) as `true` (then tooltip will always be displayed).


See the [example](https://echarts.apache.org/examples/en/editor.html?c=line-tooltip-touch&edit=1&reset=1).




---


**Snap to point**


In value axis and time axis, if [snap](#xAxis.axisPointer.snap) is set as true, axisPointer will snap to point automatically.




---




---



    """

    def __init__(self, **kwargs):

        super().__init__(**kwargs)  
    
    _model_name = Unicode("AxisPointerModel").tag(sync=True)
    
    id = Unicode(None, allow_none=True, help="""Component ID, not specified by default. If specified, it can be used to refer the component in option or API.""").tag(sync=True)
    
    show = Bool(None, allow_none=True, help="""axisPointer will not be displayed by default. But if [tooltip.trigger](#tooltip.trigger) is set as `'axis'` or [tooltip.axisPointer.type](#tooltip.axisPointer.type) is set as `'cross'`, axisPointer will be displayed automatically. Each coordinate system will automatically chose the axes whose will display its axisPointer. [tooltip.axisPointer.axis](#tooltip.axisPointer.axis) can be used to change the choice.""").tag(sync=True)
    
    type = Unicode(None, allow_none=True, help="""Indicator type.


Options:


* `'line'` line indicator.
* `'shadow'` shadow crosshair indicator.
* `'none'` no indicator displayed.""").tag(sync=True)
    
    snap = Bool(None, allow_none=True, help="""Whether snap to point automatically. The default value is auto determined.


This feature usually makes sense in value axis and time axis, where tiny points can be seeked automatically.""").tag(sync=True)
    
    z = Float(None, allow_none=True, help="""z value, which controls order of drawing graphical components. Components with smaller `z` values may be overwritten by those with larger `z` values.""").tag(sync=True)
    
    label = Dict(default_value=None, allow_none=True, help="""label of axisPointer""").tag(sync=True)
    
    lineStyle = Dict(default_value=None, allow_none=True, help="""It is valid when [axisPointer.type](#tooltip.axisPointer.type) is `'line'`.""").tag(sync=True)
    
    shadowStyle = Dict(default_value=None, allow_none=True, help="""It is valid when [axisPointer.type](#tooltip.axisPointer.type) is `'shadow'`.""").tag(sync=True)
    
    triggerEmphasis = Bool(None, allow_none=True, help="""> Since `v5.4.3`


Whether to trigger emphasis of series.""").tag(sync=True)
    
    triggerTooltip = Bool(None, allow_none=True, help="""Whether to trigger tooltip.""").tag(sync=True)
    
    value = Float(None, allow_none=True, help="""current value. When using [axisPointer.handle](xAxisPointer.handle), `value` can be set to define the initial position of axisPointer.""").tag(sync=True)
    
    status = Bool(None, allow_none=True, help="""Current status, can be `'show'` 和 `'hide'`.""").tag(sync=True)
    
    handle = Dict(default_value=None, allow_none=True, help="""A button used to drag axisPointer. This feature is applicable in touch device. See [example](https://echarts.apache.org/examples/en/editor.html?c=line-tooltip-touch&edit=1&reset=1).""").tag(sync=True)
    
    link = Any(None, allow_none=True, help="""axisPointers can be linked to each other. The term "link" represents that axes are synchronized and move together. Axes are linked according to the value of axisPointer.


See [sampleA](https://echarts.apache.org/examples/en/view.html?c=candlestick-brush&edit=1&reset=1) and [sampleB](https://echarts.apache.org/examples/en/view.html?c=scatter-nutrients-matrix&edit=1&reset=1).


link is an array, where each item represents a "link group". Axes will be linked when they are referred in the same link group. For example:



```
link: [
    {
        // All axes with xAxisIndex 0, 3, 4 and yAxisName 'sameName' will be linked.
        xAxisIndex: [0, 3, 4],
        yAxisName: 'someName'
    },
    {
        // All axes with xAxisId 'aa', 'cc' and all angleAxis will be linked.
        xAxisId: ['aa', 'cc'],
        angleAxis: 'all'
    },
    ...
]

```

As illustrated above, axes can be referred in these approaches in a link group:



```
{
    // 'some' represent the dimension name of a axis, namely, 'x', 'y', 'radius', 'angle', 'single'
    someAxisIndex: [...], // can be an array or a value or 'all'
    someAxisName: [...],  // can be an array or a value or 'all'
    someAxisId: [...],    // can be an array or a value or 'all'
}

```



---




---


**How to link axes with different [axis.type](#xAxis.type)?**


For example, the type of axisA is 'category', and the type of axisB type is 'time', we can write conversion function (mapper) in link group to convert values from an axis to another axis. For example:



```
link: [{
    xAxisIndex: [0, 1],
    yAxisName: ['yy'],
    mapper: function (sourceVal, sourceAxisInfo, targetAxisInfo) {
        if (sourceAxisInfo.axisName === 'yy') {
            // from timestamp to '2012-02-05'
            return echarts.time.format('yyyy-MM-dd', sourceVal);
        }
        else if (targetAxisInfo.axisName === 'yy') {
            // from '2012-02-05' to date
            return echarts.time.parse(dates[sourceVal]);
        }
        else {
            return sourceVal;
        }
    }
}]

```

Input parameters of mapper:


`{number}` sourceVal


`{Object}` sourceAxisInfo Including {axisDim, axisId, axisName, axisIndex, ...}


`{Object}` targetAxisInfo Including {axisDim, axisId, axisName, axisIndex, ...}


Return of mapper:


`{number}` The result of conversion.""").tag(sync=True)
    
    triggerOn = Unicode(None, allow_none=True, help="""Conditions to trigger tooltip. Options:


* `'mousemove'`


 Trigger when mouse moves.
* `'click'`


 Trigger when mouse clicks.
* `'mousemove|click'`


 Trigger when mouse clicks and moves.
* `'none'`


 Do not triggered by `'mousemove'` and `'click'`""").tag(sync=True)
    
        
