from traitlets import (
    Unicode, Dict, Float, Bool, Union, Any,
)
from ..basewidget import BaseWidget


class Brush(BaseWidget):
    """ 
:warning: **Autogenerated class**

`brush` is an area-selecting component, with which user can select part of data from a chart to display in detail, or do calculations with them.


  





---


**Brush type and triggering button**


Currently, supported `brush` types include: `scatter`, `bar`, `candlestick`. (Note that `parallel` contains brush function by itself, which is not provided by brush component.)


Click the button in `toolbox` to enable operations like *area selecting*, or *canceling selecting*.


  

Example of `horizontal brush`: (Click the button in `toolbox` to enable brushing.)



  

Example of `brush` in `bar` charts:



Button for `brush` can be assigned in [`toolbox`](#toolbox.feature.brush.type) or [`brush` configuration](#brush.toolbox).


The following types of brushes are supported: `rect`, `polygon`, `lineX`, `lineY`. See [brush.toolbox](#brush.toolbox) for more information.


`keep` button can be used to toggle a single or multiple selections.


- Only one select box is available in single selection mode, and the select-box can be removed by clicking on the blank area.
- Multiple select boxes are available in multiple selection mode, and the select-boxes cannot be removed by click on the blank area. Instead, you need to click the *clear* button.


  





---


**Relationship between brush-selecting and coordinates**


`brush` can be set to be *global*, or *belonging to a particular coordinate*.


**Global brushes**


Selecting is enabled for everywhere in ECharts's instance in this case. This is the default situation, when brush is not set to be global.


**Coordinate brushes**


Selecting is enabled only in the assigned coordinates in this case. Selecting-box will be altered according to scaling and translating of coordinate (see `roam` and `dataZoom`).


In practice, you may often find coordinate brush to be a more frequently made choice, particularly in `geo` charts.


By assigning [brush.geoIndex](#brush.geoIndex), or [brush.xAxisIndex](#brush.xAxisIndex), or [brush.yAxisIndex](#brush.yAxisIndex), brush selecting axes can be assigned, whose value can be:


- `'all'`: for all axes;
- `number`: like `0`, for a particular coordinate with that index;
- `Array`: like `[0, 4, 2]`, for coordinates with those indexes;
- `'none'`, or `null`, or `undefined`: for not assigning.


Example:



```
option = {
    geo: {
        ...
    },
    brush: {
        geoIndex: 'all', // brush selecting is enabled only in all geo charts above
        ...
    }
};

```

Example:



```
option = {
    grid: [
        {...}, // grid 0
        {...}  // grid 1
    ],
    xAxis: [
        {gridIndex: 1, ...}, // xAxis 0 for grid 1
        {gridIndex: 0, ...}  // xAxis 1 for grid 0
    ],
    yAxis: [
        {gridIndex: 1, ...}, // yAxis 0 for grid 1
        {gridIndex: 0, ...}  // yAxis 1 for grid 0
    ],
    brush: {
        xAxisIndex: [0, 1], // brush selecting is enabled only in coordinates with xAxisIndex as `0` or `1`
        ...
    }
};

```

  





---


**Control select-box with API**


`dispatchAction` can be used to render select-box programmatically. For example:



```
myChart.dispatchAction({
    type: 'brush',
    areas: [
        {
            geoIndex: 0,
            // Assign select-box type
            brushType: 'polygon',
            // Assign select-box shape
            coordRange: [[119.72,34.85],[119.68,34.85],[119.5,34.84],[119.19,34.77]]
        }
    ]
});

```

Please refer to [action.brush](api.html#action.brush) for more information.


  





---


**brushLink**


Links interaction between selected items in different series.


Following is an example of enabling selected effect for `scatter` and `parallel` charts once a scatter chart is selected.


`brushLink` is an array of `seriesIndex`es, which assigns the series that can be interacted. For example, it can be:


- `[3, 4, 5]` for interacting series with seriesIndex as `3`, `4`, or `5`;
- `'all'` for interacting all series;
- `'none'`, or `null`, or `undefined` for disabling `brushLink`.


**Attention**


`brushLink` is a mapping of `dataIndex`. So **`data` of every series with `brushLink` should be guaranteed to correspond to the other**.


Example:



```
option = {
    brush: {
        brushLink: [0, 1]
    },
    series: [
        {
            type: 'bar'
            data: [232,    4434,    545,      654]     // data has 4 items
        },
        {
            type: 'parallel',
            data: [[4, 5], [3, 5], [66, 33], [99, 66]] // data also has 4 items, which correspond to the data above
        }
    ]
};

```

Please refer to [brush.brushLink](#brush.brushLink).


  





---


**throttle / debounce**


By default, `brushSelected` is always triggered when selection-box is selected or moved, to tell the outside about the event.


But efficiency problems may occur when events are triggered too frequently, or the animation result may be affected. So brush components provides [brush.throttleType](#brush.throttleType) and [brush.throttleDelay](#brush.throttleDelay) to solve this problem.


Valid `throttleType` values can be:


- `'debounce'`: for triggering events only when the action has been stopped (no action after some duration). Time threshold can be assigned with [brush.throttleDelay](#brush.throttleDelay);
- `'fixRate'`: for triggering event with a certain frequency. The frequency can be assigned with [brush.throttleDelay](#brush.throttleDelay).


In this [example](https://echarts.apache.org/examples/en/view.html?c=scatter-map-brush&edit=1&reset=1), `debounce` is used to make sure the bar chart is updated only when the user has stopped action. In other cases, the animation result may not be so good.


  





---


**Visual configurations of selected and unselected items**


Refer to [brush.inBrush](#brush.inBrush) and [brush.outOfBrush](#brush.outOfBrush).


  





---


Here is the configuration in detail.



    """

    def __init__(self, **kwargs):

        super().__init__(**kwargs)  
    
    _model_name = Unicode("BrushModel").tag(sync=True)
    
    id = Unicode(None, allow_none=True, help="""Component ID, not specified by default. If specified, it can be used to refer the component in option or API.""").tag(sync=True)
    
    toolbox = Any(None, allow_none=True, help="""Use the buttons in toolbox.


Buttons in toolbox that is related to brush includes:


* `'rect'`: for selection-box in rectangle shape;
* `'polygon'`: for selection-box in polygon shape;
* `'lineX'`: for horizontal selection-box;
* `'lineY'`: for vertical selection-box;
* `'keep'`: for setting mode between `single` and `multiple` selection, the former of which supports clearing selection on click, and the latter selecting multiple areas;
* `'clear'`: for clearing all selections.""").tag(sync=True)
    
    brushLink = Union([Any(default_value=None, allow_none=True),Unicode(default_value=None, allow_none=True),], default_value=None, allow_none=True, help="""Links interaction between selected items in different series.


Following is an example of enabling selected effect for `scatter` and `parallel` charts once a scatter chart is selected.


`brushLink` is an array of `seriesIndex`es, which assigns the series that can be interacted. For example, it can be:


* `[3, 4, 5]` for interacting series with seriesIndex as `3`, `4`, or `5`;
* `'all'` for interacting all series;
* `'none'`, or `null`, or `undefined` for disabling `brushLink`.


**Attention**


`brushLink` is a mapping of `dataIndex`. So **`data` of every series with `brushLink` should be guaranteed to correspond to the other**.


Example:



```
option = {
    brush: {
        brushLink: [0, 1]
    },
    series: [
        {
            type: 'bar'
            data: [232,    4434,    545,      654]     // data has 4 items
        },
        {
            type: 'parallel',
            data: [[4, 5], [3, 5], [66, 33], [99, 66]] // data also has 4 items, which correspond to the data above
        }
    ]
};

```""").tag(sync=True)
    
    seriesIndex = Union([Any(default_value=None, allow_none=True),Float(default_value=None, allow_none=True),Unicode(default_value=None, allow_none=True),], default_value=None, allow_none=True, help="""Assigns which of the series can use brush selecting, whose value can be:


* `'all'`: all series;
* `'Array'`: series index array;
* `'number'`: certain series index.""").tag(sync=True)
    
    geoIndex = Union([Any(default_value=None, allow_none=True),Float(default_value=None, allow_none=True),Unicode(default_value=None, allow_none=True),], default_value=None, allow_none=True, help="""Assigns which of the geo can use brush selecting.


`brush` can be set to be *global*, or *belonging to a particular coordinate*.


**Global brushes**


Selecting is enabled for everywhere in ECharts's instance in this case. This is the default situation, when brush is not set to be global.


**Coordinate brushes**


Selecting is enabled only in the assigned coordinates in this case. Selecting-box will be altered according to scaling and translating of coordinate (see `roam` and `dataZoom`).


In practice, you may often find coordinate brush to be a more frequently made choice, particularly in `geo` charts.


By assigning [brush.geoIndex](#brush.geoIndex), or [brush.xAxisIndex](#brush.xAxisIndex), or [brush.yAxisIndex](#brush.yAxisIndex), brush selecting axes can be assigned, whose value can be:


* `'all'`: for all axes;
* `number`: like `0`, for a particular coordinate with that index;
* `Array`: like `[0, 4, 2]`, for coordinates with those indexes;
* `'none'`, or `null`, or `undefined`: for not assigning.


Example:



```
option = {
    geo: {
        ...
    },
    brush: {
        geoIndex: 'all', // brush selecting is enabled only in all geo charts above
        ...
    }
};

```

Example:



```
option = {
    grid: [
        {...}, // grid 0
        {...}  // grid 1
    ],
    xAxis: [
        {gridIndex: 1, ...}, // xAxis 0 for grid 1
        {gridIndex: 0, ...}  // xAxis 1 for grid 0
    ],
    yAxis: [
        {gridIndex: 1, ...}, // yAxis 0 for grid 1
        {gridIndex: 0, ...}  // yAxis 1 for grid 0
    ],
    brush: {
        xAxisIndex: [0, 1], // brush selecting is enabled only in coordinates with xAxisIndex as `0` or `1`
        ...
    }
};

```""").tag(sync=True)
    
    xAxisIndex = Union([Any(default_value=None, allow_none=True),Float(default_value=None, allow_none=True),Unicode(default_value=None, allow_none=True),], default_value=None, allow_none=True, help="""Assigns which of the xAxisIndex can use brush selecting.


`brush` can be set to be *global*, or *belonging to a particular coordinate*.


**Global brushes**


Selecting is enabled for everywhere in ECharts's instance in this case. This is the default situation, when brush is not set to be global.


**Coordinate brushes**


Selecting is enabled only in the assigned coordinates in this case. Selecting-box will be altered according to scaling and translating of coordinate (see `roam` and `dataZoom`).


In practice, you may often find coordinate brush to be a more frequently made choice, particularly in `geo` charts.


By assigning [brush.geoIndex](#brush.geoIndex), or [brush.xAxisIndex](#brush.xAxisIndex), or [brush.yAxisIndex](#brush.yAxisIndex), brush selecting axes can be assigned, whose value can be:


* `'all'`: for all axes;
* `number`: like `0`, for a particular coordinate with that index;
* `Array`: like `[0, 4, 2]`, for coordinates with those indexes;
* `'none'`, or `null`, or `undefined`: for not assigning.


Example:



```
option = {
    geo: {
        ...
    },
    brush: {
        geoIndex: 'all', // brush selecting is enabled only in all geo charts above
        ...
    }
};

```

Example:



```
option = {
    grid: [
        {...}, // grid 0
        {...}  // grid 1
    ],
    xAxis: [
        {gridIndex: 1, ...}, // xAxis 0 for grid 1
        {gridIndex: 0, ...}  // xAxis 1 for grid 0
    ],
    yAxis: [
        {gridIndex: 1, ...}, // yAxis 0 for grid 1
        {gridIndex: 0, ...}  // yAxis 1 for grid 0
    ],
    brush: {
        xAxisIndex: [0, 1], // brush selecting is enabled only in coordinates with xAxisIndex as `0` or `1`
        ...
    }
};

```""").tag(sync=True)
    
    yAxisIndex = Union([Any(default_value=None, allow_none=True),Float(default_value=None, allow_none=True),Unicode(default_value=None, allow_none=True),], default_value=None, allow_none=True, help="""Assigns which of the yAxisIndex can use brush selecting.


`brush` can be set to be *global*, or *belonging to a particular coordinate*.


**Global brushes**


Selecting is enabled for everywhere in ECharts's instance in this case. This is the default situation, when brush is not set to be global.


**Coordinate brushes**


Selecting is enabled only in the assigned coordinates in this case. Selecting-box will be altered according to scaling and translating of coordinate (see `roam` and `dataZoom`).


In practice, you may often find coordinate brush to be a more frequently made choice, particularly in `geo` charts.


By assigning [brush.geoIndex](#brush.geoIndex), or [brush.xAxisIndex](#brush.xAxisIndex), or [brush.yAxisIndex](#brush.yAxisIndex), brush selecting axes can be assigned, whose value can be:


* `'all'`: for all axes;
* `number`: like `0`, for a particular coordinate with that index;
* `Array`: like `[0, 4, 2]`, for coordinates with those indexes;
* `'none'`, or `null`, or `undefined`: for not assigning.


Example:



```
option = {
    geo: {
        ...
    },
    brush: {
        geoIndex: 'all', // brush selecting is enabled only in all geo charts above
        ...
    }
};

```

Example:



```
option = {
    grid: [
        {...}, // grid 0
        {...}  // grid 1
    ],
    xAxis: [
        {gridIndex: 1, ...}, // xAxis 0 for grid 1
        {gridIndex: 0, ...}  // xAxis 1 for grid 0
    ],
    yAxis: [
        {gridIndex: 1, ...}, // yAxis 0 for grid 1
        {gridIndex: 0, ...}  // yAxis 1 for grid 0
    ],
    brush: {
        xAxisIndex: [0, 1], // brush selecting is enabled only in coordinates with xAxisIndex as `0` or `1`
        ...
    }
};

```""").tag(sync=True)
    
    brushType = Unicode(None, allow_none=True, help="""Default type of brush.


* `'rect'`: for selection-box in rectangle shape;
* `'polygon'`: for selection-box in polygon shape;
* `'lineX'`: for horizontal selection-box;
* `'lineY'`: for vertical selection-box;""").tag(sync=True)
    
    brushMode = Unicode(None, allow_none=True, help="""Default brush mode, whose value can be:


* `'single'`: for single selection;
* `'multiple'`: for multiple selection.""").tag(sync=True)
    
    transformable = Bool(None, allow_none=True, help="""Determines whether a selected box can be changed in shape or translated.""").tag(sync=True)
    
    brushStyle = Dict(default_value=None, allow_none=True, help="""Default brush style, whose value is:



```
{
    borderWidth: 1,
    color: 'rgba(120,140,180,0.3)',
    borderColor: 'rgba(120,140,180,0.8)'
},

```""").tag(sync=True)
    
    throttleType = Unicode(None, allow_none=True, help="""By default, `brushSelected` is always triggered when selection-box is selected or moved, to tell the outside about the event.


But efficiency problems may occur when events are triggered too frequently, or the animation result may be affected. So brush components provides [brush.throttleType](#brush.throttleType) and [brush.throttleDelay](#brush.throttleDelay) to solve this problem.


Valid `throttleType` values can be:


* `'debounce'`: for triggering events only when the action has been stopped (no action after some duration). Time threshold can be assigned with [brush.throttleDelay](#brush.throttleDelay);
* `'fixRate'`: for triggering event with a certain frequency. The frequency can be assigned with [brush.throttleDelay](#brush.throttleDelay).


In this [example](https://echarts.apache.org/examples/en/view.html?c=scatter-map-brush&edit=1&reset=1), `debounce` is used to make sure the bar chart is updated only when the user has stopped action. In other cases, the animation result may not be so good.""").tag(sync=True)
    
    throttleDelay = Float(None, allow_none=True, help="""`0` for disabling throttle.


By default, `brushSelected` is always triggered when selection-box is selected or moved, to tell the outside about the event.


But efficiency problems may occur when events are triggered too frequently, or the animation result may be affected. So brush components provides [brush.throttleType](#brush.throttleType) and [brush.throttleDelay](#brush.throttleDelay) to solve this problem.


Valid `throttleType` values can be:


* `'debounce'`: for triggering events only when the action has been stopped (no action after some duration). Time threshold can be assigned with [brush.throttleDelay](#brush.throttleDelay);
* `'fixRate'`: for triggering event with a certain frequency. The frequency can be assigned with [brush.throttleDelay](#brush.throttleDelay).


In this [example](https://echarts.apache.org/examples/en/view.html?c=scatter-map-brush&edit=1&reset=1), `debounce` is used to make sure the bar chart is updated only when the user has stopped action. In other cases, the animation result may not be so good.""").tag(sync=True)
    
    removeOnClick = Bool(None, allow_none=True, help="""Defined whether *clearing all select-boxes on click* is enabled when [brush.brushMode](#brush.brushMode) is `'single'`.""").tag(sync=True)
    
    inBrush = Dict(default_value=None, allow_none=True, help="""Defines visual effects of items in selection.


Available visual effects include:


* `symbol`: Type of symbol.
* `symbolSize`: Symbol size.
* `color`: Symbol color.
* `colorAlpha`: Symbol alpha channel.
* `opacity`: Opacity of symbol and others (like labels).
* `colorLightness`: Lightness in [HSL](https://en.wikipedia.org/wiki/HSL_and_HSV).
* `colorSaturation`: Saturation in [HSL](https://en.wikipedia.org/wiki/HSL_and_HSV).
* `colorHue`: Hue in [HSL](https://en.wikipedia.org/wiki/HSL_and_HSV).


In most cases, inBrush can be left unassigned, in which case default visual configuration remains.""").tag(sync=True)
    
    outOfBrush = Dict(default_value=None, allow_none=True, help="""Defines visual effects of items out of selection.


Available visual effects include:


* `symbol`: Type of symbol.
* `symbolSize`: Symbol size.
* `color`: Symbol color.
* `colorAlpha`: Symbol alpha channel.
* `opacity`: Opacity of symbol and others (like labels).
* `colorLightness`: Lightness in [HSL](https://en.wikipedia.org/wiki/HSL_and_HSV).
* `colorSaturation`: Saturation in [HSL](https://en.wikipedia.org/wiki/HSL_and_HSV).
* `colorHue`: Hue in [HSL](https://en.wikipedia.org/wiki/HSL_and_HSV).


**Note:** If `outOfBrush` is not assigned, `color` will be set to be `'#ddd'` by default. If the color is not desired, you can use:



```
brush: {
    ...,
    outOfBrush: {
        colorAlpha: 0.1
    }
}

```""").tag(sync=True)
    
    z = Float(None, allow_none=True, help="""z-index of brush cover box. It can be adjusted when incorrect overlap occurs.""").tag(sync=True)
    
        
