from traitlets import (
    Unicode, Dict, Float, Bool, Union, Any,
)
from ..basewidget import BaseWidget


class Calendar(BaseWidget):
    """ 
:warning: **Autogenerated class**

Calendar coordinates.


In ECharts, we are very creative to achieve the calendar chart, by using the calendar coordinates to achieve the calendar chart,
as shown in the following example, we can use calendar coordinates in heatmap, scatter, effectScatter, and graph.


Example of using heatmap in calendar coordinates:



Example of using effectScatter in calendar coordinates:



Example of using graph in calendar coordinates:



By combining calendar coordinate system and charts, you may be able to create more wonderful effects.


[Display Text in Calendar](https://echarts.apache.org/examples/en/editor.html?c=calendar-lunar&edit=1&reset=1),
[Display Pies in Calendar](https://echarts.apache.org/examples/en/editor.html?c=calendar-pie&edit=1&reset=1)




---


**Calendar layout**


Calendar coordinate system can be placed horizontally or vertically. By convention, the heatmap calendar is horizontal. But if we need bigger cell size in other cases, the total width may be too wide. So [calendar.orient](#calendar.orient) can help in this case.




---


**Adapt to container size**


Calendar coordinate system can be configured to adapt to container size, which is useful when page size is not sure. First of all, like other components, those location and size configurations can be specified on canlendar: [left](#calendar.left) [right](#calendar.right) [top](#calendar.top) <bottom> [width](#calendar.width) [height](#calendar.height), which make calendar possible to modify its size according to container size. Besides, [cellSize](#calendar.cellSize) can be specified to fix the size of each cell of calendar.




---



    """

    def __init__(self, **kwargs):

        super().__init__(**kwargs)  
    
    _model_name = Unicode("CalendarModel").tag(sync=True)
    
    id = Unicode(None, allow_none=True, help="""Component ID, not specified by default. If specified, it can be used to refer the component in option or API.""").tag(sync=True)
    
    zlevel = Float(None, allow_none=True, help="""`zlevel` value of all graphical elements in .


`zlevel` is used to make layers with Canvas. Graphical elements with different `zlevel` values will be placed in different Canvases, which is a common optimization technique. We can put those frequently changed elements (like those with animations) to a separate `zlevel`. Notice that too many Canvases will increase memory cost, and should be used carefully on mobile phones to avoid crash.


Canvases with bigger `zlevel` will be placed on Canvases with smaller `zlevel`.""").tag(sync=True)
    
    z = Float(None, allow_none=True, help="""`z` value of all graphical elements in , which controls order of drawing graphical components. Components with smaller `z` values may be overwritten by those with larger `z` values.


`z` has a lower priority to `zlevel`, and will not create new Canvas.""").tag(sync=True)
    
    left = Union([Unicode(default_value=None, allow_none=True),Float(default_value=None, allow_none=True),], default_value=None, allow_none=True, help="""Distance between calendar component and the left side of the container.


`left` can be a pixel value like `20`; it can also be a percentage value relative to container width like `'20%'`; and it can also be `'left'`, `'center'`, or `'right'`.


If the `left` value is set to be `'left'`, `'center'`, or `'right'`, then the component will be aligned automatically based on position.""").tag(sync=True)
    
    top = Union([Unicode(default_value=None, allow_none=True),Float(default_value=None, allow_none=True),], default_value=None, allow_none=True, help="""Distance between calendar component and the top side of the container.


`top` can be a pixel value like `20`; it can also be a percentage value relative to container width like `'20%'`; and it can also be `'top'`, `'middle'`, or `'bottom'`.


If the `top` value is set to be `'top'`, `'middle'`, or `'bottom'`, then the component will be aligned automatically based on position.""").tag(sync=True)
    
    right = Union([Unicode(default_value=None, allow_none=True),Float(default_value=None, allow_none=True),], default_value=None, allow_none=True, help="""Distance between calendar component and the right side of the container.


`right` can be a pixel value like `20`; it can also be a percentage value relative to container width like `'20%'`.


Adaptive by default.""").tag(sync=True)
    
    bottom = Union([Unicode(default_value=None, allow_none=True),Float(default_value=None, allow_none=True),], default_value=None, allow_none=True, help="""Distance between calendar component and the bottom side of the container.


`bottom` can be a pixel value like `20`; it can also be a percentage value relative to container width like `'20%'`.


Adaptive by default.""").tag(sync=True)
    
    width = Union([Float(default_value=None, allow_none=True),Unicode(default_value=None, allow_none=True),], default_value=None, allow_none=True, help="""The height of calendar coordinates.


Note: `cellSize` is 20 by default. If `width` is set,
 `cellSize[0]` will be forced to `auto`;""").tag(sync=True)
    
    height = Union([Float(default_value=None, allow_none=True),Unicode(default_value=None, allow_none=True),], default_value=None, allow_none=True, help="""The height of calendar coordinates.


Note: `cellSize` is 20 by default. If `height` is set,
 `cellSize[1]` will be forced to `auto`;""").tag(sync=True)
    
    range = Union([Float(default_value=None, allow_none=True),Unicode(default_value=None, allow_none=True),Any(default_value=None, allow_none=True),], default_value=None, allow_none=True, help="""Required, range of Calendar coordinates, support multiple formats.


Examples:



```

// one year
range: 2017

// one month
range: '2017-02'

//  a range
range: ['2017-01-02', '2017-02-23']

// note: they will be identified as ['2017-01-01', '2017-02-01']
range: ['2017-01', '2017-02']


```""").tag(sync=True)
    
    cellSize = Union([Float(default_value=None, allow_none=True),Any(default_value=None, allow_none=True),], default_value=None, allow_none=True, help="""The size of each rect of calendar coordinates, can be set to a single value or array, the first element is width and the second element is height.


Support setting self-adaptation: `auto`, the default width and height to be 20.


Examples:



```

// Set the width and height to be 20
cellSize: 20

// Set the width to be 20, and height to be 40
cellSize: [20, 40]

// Set width and height to be self-adaptation
cellSize: [40]

// Set the width and height to be 20
cellSize: 'auto'

// Set the width to be self-adaptation, and height to be 40
cellSize: ['auto', 40]


```""").tag(sync=True)
    
    orient = Unicode(None, allow_none=True, help="""The layout orientation of calendar.


Options:


* 'horizontal'
* 'vertical'""").tag(sync=True)
    
    splitLine = Dict(default_value=None, allow_none=True, help="""Calendar coordinates splitLine style.""").tag(sync=True)
    
    itemStyle = Dict(default_value=None, allow_none=True, help="""Every rect style in calendar coordinates.""").tag(sync=True)
    
    dayLabel = Dict(default_value=None, allow_none=True, help="""Day style in calendar coordinates.""").tag(sync=True)
    
    monthLabel = Dict(default_value=None, allow_none=True, help="""Month label in calendar coordinates.""").tag(sync=True)
    
    yearLabel = Dict(default_value=None, allow_none=True, help="""Year label in calendar coordinates.""").tag(sync=True)
    
    silent = Bool(None, allow_none=True, help="""Whether to ignore mouse events. Default value is false, for triggering and responding to mouse events.""").tag(sync=True)
    
        
