from traitlets import (
    Unicode, Float, Bool, Union, Any,
)
from ..basewidget import BaseWidget


class Dataset(BaseWidget):
    """ 
:warning: **Autogenerated class**

`dataset` component is published since ECharts 4. `dataset` brings convenience in data management separated with styles and enables data reuse by different series. More importantly, it enables data encoding from data to visual, which brings convenience in some scenarios.


More details about `dataset` can be checked in the [tutorial](https://echarts.apache.org/handbook/en/concepts/dataset/).



    """

    def __init__(self, **kwargs):

        super().__init__(**kwargs)  
    
    _model_name = Unicode("DatasetModel").tag(sync=True)
    
    id = Unicode(None, allow_none=True, help="""Component ID, not specified by default. If specified, it can be used to refer the component in option or API.""").tag(sync=True)
    
    source = Union([Any(default_value=None, allow_none=True),Any(default_value=None, allow_none=True),], default_value=None, allow_none=True, help="""Source data. Generally speaking, a source data describe a table, where these format below can be applied:


2d array, where [dimension names](#dataset.dimensions) can be provided in the first row/column, or do not provide, only data.



```
[
    ['product', '2015', '2016', '2017'],
    ['Matcha Latte', 43.3, 85.8, 93.7],
    ['Milk Tea', 83.1, 73.4, 55.1],
    ['Cheese Cocoa', 86.4, 65.2, 82.5],
    ['Walnut Brownie', 72.4, 53.9, 39.1]
]

```

Row based key-value format (object array), where the keys indicate [dimension names](#dataset.dimensions).



```
[
    {product: 'Matcha Latte', count: 823, score: 95.8},
    {product: 'Milk Tea', count: 235, score: 81.4},
    {product: 'Cheese Cocoa', count: 1042, score: 91.2},
    {product: 'Walnut Brownie', count: 988, score: 76.9}
]

```

Column based key-value format, where each value represents a column of a table.



```
{
    'product': ['Matcha Latte', 'Milk Tea', 'Cheese Cocoa', 'Walnut Brownie'],
    'count': [823, 235, 1042, 988],
    'score': [95.8, 81.4, 91.2, 76.9]
}

```

More details about `dataset` can be checked in the [tutorial](https://echarts.apache.org/handbook/en/concepts/dataset/).""").tag(sync=True)
    
    dimensions = Any(None, allow_none=True, help="""`dimensions` can be used to define dimension info for `series.data` or `dataset.source`.


Notice: if [dataset](#dataset) is used, we can definite dimensions in [dataset.dimensions](#dataset.dimensions), or provide dimension names in the first column/row of [dataset.source](#dataset.source), and not need to specify `dimensions` here. But if `dimensions` is specified here, it will be used despite the dimension definitions in dataset.


For example:



```
option = {
    dataset: {
        source: [
            // 'date', 'open', 'close', 'highest', 'lowest'
            [12, 44, 55, 66, 2],
            [23, 6, 16, 23, 1],
            ...
        ]
    },
    series: {
        type: 'xxx',
        // Specify name for each dimensions, which will be displayed in tooltip.
        dimensions: ['date', 'open', 'close', 'highest', 'lowest']
    }
}

```


```
series: {
    type: 'xxx',
    dimensions: [
        null,                // If you do not intent to defined this dimension, use null is fine.
        {type: 'ordinal'},   // Specify type of this dimension.
                             // 'ordinal' is always used in string.
                             // If type is not specified, echarts will guess type by data.
        {name: 'good', type: 'number'},
        'bad'                // Equals to {name: 'bad'}.
    ]
}

```

Each data item of `dimensions` can be:


* `string`, for example, `'someName'`, which equals to `{name: 'someName'}`.
* `Object`, where the attributes can be:
	+ name: `string`.
	+ type: `string`, supports:
		- `number`
		- `float`, that is, [Float64Array](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Float64Array)
		- `int`, that is, [Int32Array](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Int32Array)
		- `ordinal`, discrete value, which represents string generally.
		- `time`, time value, see [data](#series.data) to check the format of time value.
	+ displayName: `string`, generally used in tooltip for dimension display. If not specified, use `name` by default.


When `dimensions` is specified, the default `tooltip` will be displayed vertically, which is better to show dimension names. Otherwise, `tooltip` will displayed only value horizontally.""").tag(sync=True)
    
    sourceHeader = Union([Bool(default_value=None, allow_none=True),Float(default_value=None, allow_none=True),], default_value=None, allow_none=True, help="""Whether the first row/column of `dataset.source` represents [dimension names](#dataset.dimensions). Optional values:


* `null/undefined/'auto'`: means auto detect whether the first row/column is dimension names or data.
* `true`: the first row/column is dimension names.
* `false`: data start from the first row/column.
* `number`: means the row/column count of the dimension names, that is, the start index of data row/column. e.g. `sourceHeader: 2` means the front two rows/columns are dimension names, the back ones are data.


Note: ***the first row/column*** means that if [series.seriesLayoutBy](#series.seriesLayoutBy) is set as `'column'`, pick the first row, otherwise, if it is set as `'row'`, pick the first column.""").tag(sync=True)
    
    transform = Union([Any(default_value=None, allow_none=True),Any(default_value=None, allow_none=True),Any(default_value=None, allow_none=True),Any(default_value=None, allow_none=True),Any(default_value=None, allow_none=True),], default_value=None, allow_none=True, help="""See the tutorial of [data transform](tutorial.html#Data%20Transform).""").tag(sync=True)
    
    fromDatasetIndex = Float(None, allow_none=True, help="""Specify the input dataset for [dataset.transform](#dataset.transform).
If [dataset.transform](#dataset.transform) specified but both `fromDatasetIndex` and `fromDatasetId` are not specified, `fromDatasetIndex: 0` will be used by default.


See the tutorial of [data transform](tutorial.html#Data%20Transform).""").tag(sync=True)
    
    fromDatasetId = Unicode(None, allow_none=True, help="""Specify the input dataset for [dataset.transform](#dataset.transform).


See the tutorial of [data transform](tutorial.html#Data%20Transform).""").tag(sync=True)
    
    fromTransformResult = Float(None, allow_none=True, help="""If a [dataset.transform](#dataset.transform) produces more than one result, we can use `fromTransformResult` to retrieve some certain result.


In most cases, `fromTransformResult` do not need to be specified because most transforms only produce one result. If `fromTransformResult` is not specified, we use `fromTransformResult: 0` by default.


See the tutorial of [data transform](tutorial.html#Data%20Transform).""").tag(sync=True)
    
        
