from traitlets import (
    Unicode, Dict, Float, Bool, Union, Any,
)
from ..basewidget import BaseWidget


class Slider(BaseWidget):
    """ 
:warning: **Autogenerated class**

Slider type dataZoom component provides functions like data thumbnail, zoom, brush to select, drag to move, click to locate.


The followling picture shows areas to interact.


![](documents/asset/img/dataZoom-zone.png)



    """

    def __init__(self, **kwargs):

        super().__init__(**kwargs)  
    
    _model_name = Unicode("SliderModel").tag(sync=True)
    
    type = Unicode("slider", allow_none=True, ).tag(sync=True)
    
    id = Unicode(None, allow_none=True, help="""Component ID, not specified by default. If specified, it can be used to refer the component in option or API.""").tag(sync=True)
    
    show = Bool(None, allow_none=True, help="""Whether to show the component. If is set to be `false`, it will not show, but its data filtering function still works.""").tag(sync=True)
    
    backgroundColor = Any(None, allow_none=True, help="""The background color of the component.""").tag(sync=True)
    
    dataBackground = Dict(default_value=None, allow_none=True, help="""The style of data shadow.""").tag(sync=True)
    
    selectedDataBackground = Dict(default_value=None, allow_none=True, help="""> Since `v5.0.0`


Styles of selected data shadow.""").tag(sync=True)
    
    fillerColor = Any(None, allow_none=True, help="""The color to fill selected area.""").tag(sync=True)
    
    borderColor = Any(None, allow_none=True, help="""The color of border.""").tag(sync=True)
    
    borderRadius = Union([Float(default_value=None, allow_none=True),Any(default_value=None, allow_none=True),], default_value=None, allow_none=True, help="""The radius of rounded corner. Its unit is px. And it supports use array to respectively specify the 4 corner radiuses.


For example:



```
borderRadius: 5, // consistently set the size of 4 rounded corners
borderRadius: [5, 5, 0, 0] // (clockwise upper left, upper right, bottom right and bottom left)

```""").tag(sync=True)
    
    handleIcon = Unicode(None, allow_none=True, help="""Icon shape of handle, which supports path string. Its default value is:



```
'M8.2,13.6V3.9H6.3v9.7H3.1v14.9h3.3v9.7h1.8v-9.7h3.3V13.6H8.2z M9.7,24.4H4.8v-1.4h4.9V24.4z M9.7,19.1H4.8v-1.4h4.9V19.1z'

```

It can be set to an image with `'image://url'` , in which URL is the link to an image, or `dataURI` of an image.


An image URL example:



```
'image://http://example.website/a/b.png'

```
A `dataURI` example:



```
'image://data:image/gif;base64,R0lGODlhEAAQAMQAAORHHOVSKudfOulrSOp3WOyDZu6QdvCchPGolfO0o/XBs/fNwfjZ0frl3/zy7////wAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACH5BAkAABAALAAAAAAQABAAAAVVICSOZGlCQAosJ6mu7fiyZeKqNKToQGDsM8hBADgUXoGAiqhSvp5QAnQKGIgUhwFUYLCVDFCrKUE1lBavAViFIDlTImbKC5Gm2hB0SlBCBMQiB0UjIQA7'

```
Icons can be set to arbitrary vector path via `'path://'` in ECharts. As compared with a raster image, vector paths prevent jagging and blurring when scaled, and have better control over changing colors. The size of the vector icon will be adapted automatically. Refer to [SVG PathData](http://www.w3.org/TR/SVG/paths.html#PathData) for more information about the format of the path. You may export vector paths from tools like Adobe 


For example:



```
'path://M30.9,53.2C16.8,53.2,5.3,41.7,5.3,27.6S16.8,2,30.9,2C45,2,56.4,13.5,56.4,27.6S45,53.2,30.9,53.2z M30.9,3.5C17.6,3.5,6.8,14.4,6.8,27.6c0,13.3,10.8,24.1,24.101,24.1C44.2,51.7,55,40.9,55,27.6C54.9,14.4,44.1,3.5,30.9,3.5z M36.9,35.8c0,0.601-0.4,1-0.9,1h-1.3c-0.5,0-0.9-0.399-0.9-1V19.5c0-0.6,0.4-1,0.9-1H36c0.5,0,0.9,0.4,0.9,1V35.8z M27.8,35.8 c0,0.601-0.4,1-0.9,1h-1.3c-0.5,0-0.9-0.399-0.9-1V19.5c0-0.6,0.4-1,0.9-1H27c0.5,0,0.9,0.4,0.9,1L27.8,35.8L27.8,35.8z'

```""").tag(sync=True)
    
    handleSize = Union([Float(default_value=None, allow_none=True),Unicode(default_value=None, allow_none=True),], default_value=None, allow_none=True, help="""The size of control handle. It can be in pixels, or in percentage relative to the width of dataZoom component. By default, it's the same as the width of dataZoom component.""").tag(sync=True)
    
    handleStyle = Dict(default_value=None, allow_none=True, help="""Style of handle. Please refer to [area-simple example](https://echarts.apache.org/examples/en/editor.html?c=area-simple).""").tag(sync=True)
    
    moveHandleIcon = Unicode(None, allow_none=True, help="""> Since `v5.0.0`


Icon of move handle.



```
'M-320.9-50L-320.9-50c18.1,0,27.1,9,27.1,27.1V85.7c0,18.1-9,27.1-27.1,27.1l0,0c-18.1,0-27.1-9-27.1-27.1V-22.9C-348-41-339-50-320.9-50z M-212.3-50L-212.3-50c18.1,0,27.1,9,27.1,27.1V85.7c0,18.1-9,27.1-27.1,27.1l0,0c-18.1,0-27.1-9-27.1-27.1V-22.9C-239.4-41-230.4-50-212.3-50z M-103.7-50L-103.7-50c18.1,0,27.1,9,27.1,27.1V85.7c0,18.1-9,27.1-27.1,27.1l0,0c-18.1,0-27.1-9-27.1-27.1V-22.9C-130.9-41-121.8-50-103.7-50z'

```

It can be set to an image with `'image://url'` , in which URL is the link to an image, or `dataURI` of an image.


An image URL example:



```
'image://http://example.website/a/b.png'

```
A `dataURI` example:



```
'image://data:image/gif;base64,R0lGODlhEAAQAMQAAORHHOVSKudfOulrSOp3WOyDZu6QdvCchPGolfO0o/XBs/fNwfjZ0frl3/zy7////wAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACH5BAkAABAALAAAAAAQABAAAAVVICSOZGlCQAosJ6mu7fiyZeKqNKToQGDsM8hBADgUXoGAiqhSvp5QAnQKGIgUhwFUYLCVDFCrKUE1lBavAViFIDlTImbKC5Gm2hB0SlBCBMQiB0UjIQA7'

```
Icons can be set to arbitrary vector path via `'path://'` in ECharts. As compared with a raster image, vector paths prevent jagging and blurring when scaled, and have better control over changing colors. The size of the vector icon will be adapted automatically. Refer to [SVG PathData](http://www.w3.org/TR/SVG/paths.html#PathData) for more information about the format of the path. You may export vector paths from tools like Adobe 


For example:



```
'path://M30.9,53.2C16.8,53.2,5.3,41.7,5.3,27.6S16.8,2,30.9,2C45,2,56.4,13.5,56.4,27.6S45,53.2,30.9,53.2z M30.9,3.5C17.6,3.5,6.8,14.4,6.8,27.6c0,13.3,10.8,24.1,24.101,24.1C44.2,51.7,55,40.9,55,27.6C54.9,14.4,44.1,3.5,30.9,3.5z M36.9,35.8c0,0.601-0.4,1-0.9,1h-1.3c-0.5,0-0.9-0.399-0.9-1V19.5c0-0.6,0.4-1,0.9-1H36c0.5,0,0.9,0.4,0.9,1V35.8z M27.8,35.8 c0,0.601-0.4,1-0.9,1h-1.3c-0.5,0-0.9-0.399-0.9-1V19.5c0-0.6,0.4-1,0.9-1H27c0.5,0,0.9,0.4,0.9,1L27.8,35.8L27.8,35.8z'

```""").tag(sync=True)
    
    moveHandleSize = Float(None, allow_none=True, help="""> Since `v5.0.0`


Size of move handle.""").tag(sync=True)
    
    moveHandleStyle = Dict(default_value=None, allow_none=True, help="""> Since `v5.0.0`


Style of move handle.""").tag(sync=True)
    
    labelPrecision = Union([Float(default_value=None, allow_none=True),Unicode(default_value=None, allow_none=True),], default_value=None, allow_none=True, help="""Precision of label if in number form. By default, it is decided based on the number of data.""").tag(sync=True)
    
    labelFormatter = Union([Unicode(default_value=None, allow_none=True),Any(default_value=None, allow_none=True),], default_value=None, allow_none=True, help="""The formatter tool for the label.


* It is a template if in `string`. For instance, `aaaa{value}bbbb`, where `{value}` will be replaced by the value of actual data value.
* It is a callback function if in `Function`. For example:



```
/**
 * @param {*} value If axis.type is 'category', `value` is the index of axis.data.
 *                  else `value` is current value.
 * @param {strign} valueStr Inner formatted string.
 * @return {string} Returns the label formatted.
 */
labelFormatter: function (value, valueStr) {
    return 'aaa' + value + 'bbb';
}

```""").tag(sync=True)
    
    showDetail = Bool(None, allow_none=True, help="""Whether to show detail, that is, show the detailed data information when dragging.""").tag(sync=True)
    
    showDataShadow = Unicode(None, allow_none=True, help="""Whether to show data shadow in `dataZoom-silder` component, to indicate the data tendency in brief.""").tag(sync=True)
    
    realtime = Bool(None, allow_none=True, help="""Whether to update view while dragging. If it is set as `false`, the view will be updated only at the end of dragging.""").tag(sync=True)
    
    textStyle = Dict(default_value=None, allow_none=True, ).tag(sync=True)
    
    xAxisIndex = Union([Float(default_value=None, allow_none=True),Any(default_value=None, allow_none=True),], default_value=None, allow_none=True, help="""Specify which [xAxis](#xAxis) is/are controlled by the `dataZoom-slider` when [catesian coordinate system](#grid) is used.


By default the first `xAxis` that parallel to `dataZoom` are controlled when [dataZoom-slider.orient](#dataZoom-slider.orient) is set as `'horizontal'`. But it is recommended to specify it explicitly but not use default value.


If it is set as a single `number`, one axis is controlled, while if it is set as an `Array` , multiple axes are controlled.


For example:



```
option: {
    xAxis: [
        {...}, // The first xAxis
        {...}, // The second xAxis
        {...}, // The third xAxis
        {...}  // The fourth xAxis
    ],
    dataZoom: [
        { // The first dataZoom component
            xAxisIndex: [0, 2] // Indicates that this dataZoom component
                                     // controls the first and the third xAxis
        },
        { // The second dataZoom component
            xAxisIndex: 3      // indicates that this dataZoom component
                                     // controls the fourth xAxis
        }
    ]
}

```""").tag(sync=True)
    
    yAxisIndex = Union([Float(default_value=None, allow_none=True),Any(default_value=None, allow_none=True),], default_value=None, allow_none=True, help="""Specify which [yAxis](#yAxis) is/are controlled by the `dataZoom-slider` when [catesian coordinate system](#grid) is used.


By default the first `yAxis` that parallel to `dataZoom` are controlled when [dataZoom-slider.orient](#dataZoom-slider.orient) is set as `'vertical'`. But it is recommended to specify it explicitly but not use default value.


If it is set as a single `number`, one axis is controlled, while if it is set as an `Array` , multiple axes are controlled.


For example:



```
option: {
    yAxis: [
        {...}, // The first yAxis
        {...}, // The second yAxis
        {...}, // The third yAxis
        {...}  // The fourth yAxis
    ],
    dataZoom: [
        { // The first dataZoom component
            yAxisIndex: [0, 2] // Indicates that this dataZoom component
                                     // controls the first and the third yAxis
        },
        { // The second dataZoom component
            yAxisIndex: 3      // indicates that this dataZoom component
                                     // controls the fourth yAxis
        }
    ]
}

```""").tag(sync=True)
    
    radiusAxisIndex = Union([Float(default_value=None, allow_none=True),Any(default_value=None, allow_none=True),], default_value=None, allow_none=True, help="""Specify which [radiusAxis](#radiusAxis) is/are controlled by the `dataZoom-slider` when [polar coordinate system](#polar) is used.


If it is set as a single `number`, one axis is controlled, while if it is set as an `Array` , multiple axes are controlled.


For example:



```
option: {
    radiusAxis: [
        {...}, // The first radiusAxis
        {...}, // The second radiusAxis
        {...}, // The third radiusAxis
        {...}  // The fourth radiusAxis
    ],
    dataZoom: [
        { // The first dataZoom component
            radiusAxisIndex: [0, 2] // Indicates that this dataZoom component
                                     // controls the first and the third radiusAxis
        },
        { // The second dataZoom component
            radiusAxisIndex: 3      // indicates that this dataZoom component
                                     // controls the fourth radiusAxis
        }
    ]
}

```""").tag(sync=True)
    
    angleAxisIndex = Union([Float(default_value=None, allow_none=True),Any(default_value=None, allow_none=True),], default_value=None, allow_none=True, help="""Specify which [angleAxis](#angleAxis) is/are controlled by the `dataZoom-slider` when [polar coordinate system](#polar) is used.


If it is set as a single `number`, one axis is controlled, while if it is set as an `Array` , multiple axes are controlled.


For example:



```
option: {
    angleAxis: [
        {...}, // The first angleAxis
        {...}, // The second angleAxis
        {...}, // The third angleAxis
        {...}  // The fourth angleAxis
    ],
    dataZoom: [
        { // The first dataZoom component
            angleAxisIndex: [0, 2] // Indicates that this dataZoom component
                                     // controls the first and the third angleAxis
        },
        { // The second dataZoom component
            angleAxisIndex: 3      // indicates that this dataZoom component
                                     // controls the fourth angleAxis
        }
    ]
}

```""").tag(sync=True)
    
    filterMode = Unicode(None, allow_none=True, help="""Generally `dataZoom` component zoom or roam coordinate system through data filtering and set the windows of axes internally.


Its behaviours vary according to filtering mode settings ([dataZoom.filterMode](#dataZoom.filterMode)).


Possible values:


* 'filter': data that outside the window will be **filtered**, which may lead to some changes of windows of other axes. For each data item, it will be filtered if one of the relevant dimensions is out of the window.
* 'weakFilter': data that outside the window will be **filtered**, which may lead to some changes of windows of other axes. For each data item, it will be filtered only if all of the relevant dimensions are out of the same side of the window.
* 'empty': data that outside the window will be **set to NaN**, which will not lead to changes of windows of other axes.
* 'none': Do not filter data.


How to set `filterMode` is up to users, depending on the requirements and scenarios. Expirically:


* If only `xAxis` or only `yAxis` is controlled by `dataZoom`, `filterMode: 'filter'` is typically used, which enable the other axis auto adapte its window to the extent of the filtered data.
* If both `xAxis` and `yAxis` are operated by `dataZoom`:


	+ If `xAxis` and `yAxis` should not effect mutually (e.g. a scatter chart with both axes on the type of `'value'`), they should be set to be `filterMode: 'empty'`.
	+ If `xAxis` is the main axis and `yAxis` is the auxiliary axis (or vise versa) (e.g., in a bar chart, when dragging `dataZoomX` to change the window of xAxis, we need the yAxis to adapt to the clipped data, but when dragging `dataZoomY` to change the window of yAxis, we need the xAxis not to be changed), in this case, `xAxis` should be set to be `filterMode: 'filter'`, while `yAxis` should be set to be `filterMode: 'empty'`.


It can be demonstrated by the sample:



```
option = {
    dataZoom: [
        {
            id: 'dataZoomX',
            type: 'slider',
            xAxisIndex: [0],
            filterMode: 'filter'
        },
        {
            id: 'dataZoomY',
            type: 'slider',
            yAxisIndex: [0],
            filterMode: 'empty'
        }
    ],
    xAxis: {type: 'value'},
    yAxis: {type: 'value'},
    series{
        type: 'bar',
        data: [
            // The first column corresponds to xAxis,
            // and the second column corresponds to yAxis.
            [12, 24, 36],
            [90, 80, 70],
            [3, 9, 27],
            [1, 11, 111]
        ]
    }
}

```

In the sample above, `dataZoomX` is set as `filterMode: 'filter'`. When use drags `dataZoomX` (do not touch `dataZoomY`) and the valueWindow of `xAxis` is changed to `[2, 50]` consequently, `dataZoomX` travel the first column of series.data and filter items that out of the window. The series.data turns out to be:



```
[
    [12, 24, 36],
    // [90, 80, 70] This item is filtered, as 90 is out of the window.
    [3, 9, 27]
    // [1, 11, 111] This item is filtered, as 1 is out of the window.
]

```

Before filtering, the second column, which corresponds to yAxis, has values `24`, `80`, `9`, `11`. After filtering, only `24` and `9` are left. Then the extent of `yAxis` is adjusted to adapt the two values (if `yAxis.min` and `yAxis.max` are not set).


So `filterMode: 'filter'` can be used to enable the other axis to auto adapt the filtered data.


Then let's review the sample from the beginning, `dataZoomY` is set as `filterMode: 'empty'`. So if user drags `dataZoomY` (do not touch `dataZoomX`) and its window is changed to `[10, 60]` consequently, `dataZoomY` travels the second column of series.data and set NaN to all of the values that outside the window (NaN cause the graphical elements, i.e., bar elements, do not show, but still hold the place). The series.data turns out to be:



```
[
    [12, 24, 36],
    [90, NaN, 70], // Set to NaN
    [3, NaN, 27],  // Set to NaN
    [1, 11, 111]
]

```

In this case, the first column (i.e., `12`, `90`, `3`, `1`, which corresponds to `xAxis`), will not be changed at all. So dragging `yAxis` will not change extent of `xAxis`, which is good for requirements like outlier filtering.


See this example:""").tag(sync=True)
    
    start = Float(None, allow_none=True, help="""The start percentage of the window out of the data extent, in the range of 0 ~ 100.


[dataZoom-slider.start](#dataZoom-slider.start) and [dataZoom-slider.end](#dataZoom-slider.end) define the window of the data in **percent** form.


More info about the relationship between `dataZoom-slider.start` and axis extent can be checked in [dataZoom-slider.rangeMode](#dataZoom-slider.rangeMode).""").tag(sync=True)
    
    end = Float(None, allow_none=True, help="""The end percentage of the window out of the data extent, in the range of 0 ~ 100.


[dataZoom-slider.start](#dataZoom-slider.start) and [dataZoom-slider.end](#dataZoom-slider.end) define the window of the data in **percent** form.


More info about the relationship between `dataZoom-slider.end` and axis extent can be checked in [dataZoom-slider.rangeMode](#dataZoom-slider.rangeMode).""").tag(sync=True)
    
    startValue = Union([Float(default_value=None, allow_none=True),Unicode(default_value=None, allow_none=True),Any(default_value=None, allow_none=True),], default_value=None, allow_none=True, help="""The start absolute value of the window, not works when [dataZoom-slider.start](#dataZoom-slider.start) is set.


[dataZoom-slider.startValue](#dataZoom-slider.startValue) and [dataZoom-slider.endValue](#dataZoom-slider.endValue) define the window of the data window in **absolute value** form.


Notice, if an axis is set to be `category`, `startValue` could be set as `index` of the array of `axis.data` or as the array value itself. In the latter case, it will internally and automatically translate to the index of array.


More info about the relationship between `dataZoom-slider.startValue` and axis extent can be checked in [dataZoom-slider.rangeMode](#dataZoom-slider.rangeMode).""").tag(sync=True)
    
    endValue = Union([Float(default_value=None, allow_none=True),Unicode(default_value=None, allow_none=True),Any(default_value=None, allow_none=True),], default_value=None, allow_none=True, help="""The end absolute value of the window, doesn't work when [dataZoom-slider.end](#dataZoom-slider.end) is set.


[dataZoom-slider.startValue](#dataZoom-slider.startValue) and [dataZoom-slider.endValue](#dataZoom-slider.endValue) define the window of the data window in **absolute value** form.


Notice, if an axis is set to be `category`, `startValue` could be set as `index` of the array of `axis.data` or as the array value itself. In the latter case, it will internally and automatically translate to the index of array.


More info about the relationship between `dataZoom-slider.endValue` and axis extent can be checked in [dataZoom-slider.rangeMode](#dataZoom-slider.rangeMode).""").tag(sync=True)
    
    minSpan = Float(None, allow_none=True, help="""Used to restrict minimal window size, in percent, which value is in the range of [0, 100].


If [dataZoom-slider.minValueSpan](#dataZoom-slider.minValueSpan) is set, `minSpan` does not work any more.""").tag(sync=True)
    
    maxSpan = Float(None, allow_none=True, help="""Used to restrict maximal window size, in percent, which value is in the range of [0, 100].


If [dataZoom-slider.maxValueSpan](#dataZoom-slider.maxValueSpan) is set, `maxSpan` does not work any more.""").tag(sync=True)
    
    minValueSpan = Union([Float(default_value=None, allow_none=True),Unicode(default_value=None, allow_none=True),Any(default_value=None, allow_none=True),], default_value=None, allow_none=True, help="""Used to restrict minimal window size.


For example:
In time axis it can be set as `3600 * 24 * 1000 * 5` to represent "5 day".
In category axis it can be set as `5` to represent 5 categories.""").tag(sync=True)
    
    maxValueSpan = Union([Float(default_value=None, allow_none=True),Unicode(default_value=None, allow_none=True),Any(default_value=None, allow_none=True),], default_value=None, allow_none=True, help="""Used to restrict maximal window size.


For example:
In time axis it can be set as `3600 * 24 * 1000 * 5` to represent "5 day".
In category axis it can be set as `5` to represent 5 categories.""").tag(sync=True)
    
    orient = Unicode(None, allow_none=True, help="""Specify whether the layout of `dataZoom` component is horizontal or vertical. What's more, it indicates whether the horizontal axis or vertical axis is controlled by default in catesian coordinate system.


Valid values:


* `'horizontal'`: horizontal.
* `'vertical'`: vertical.""").tag(sync=True)
    
    zoomLock = Bool(None, allow_none=True, help="""Specify whether to lock the size of window (selected area).


When set as `true`, the size of window is locked, that is, only the translation (by mouse drag or touch drag) is available but zoom is not.""").tag(sync=True)
    
    throttle = Float(None, allow_none=True, help="""Specify the frame rate of views refreshing, with unit millisecond (ms).


If [animation](#animation) set as `true` and [animationDurationUpdate](#animationDurationUpdate) set as bigger than `0`, you can keep `throttle` as the default value `100` (or set it as a value bigger than `0`), otherwise it might be not smooth when dragging.


If [animation](#animation) set as `false` or [animationDurationUpdate](#animationDurationUpdate) set as `0`, and data size is not very large, and it seems to be not smooth when dragging, you can set `throttle` as `0` to improve that.""").tag(sync=True)
    
    rangeMode = Any(None, allow_none=True, help="""The format is `[rangeModeForStart, rangeModeForEnd]`.


For example `rangeMode: ['value', 'percent']` means that use absolute value in `start` and percent value in `end`.


Optional value for each item: `'value'`, `'percent'`.


* `'value'` mode: the axis extent will always only be determined by `dataZoom.startValue` and `dataZoom.endValue`, despite how data like and how `axis.min` and `axis.max` are.
* `'percent'` mode: `100` represents 100% of the `[dMin, dMax]`, where `dMin` is `axis.min` if `axis.min` specified, otherwise `data.extent[0]`, and `dMax` is `axis.max` if `axis.max` specified, otherwise `data.extent[1]`. Axis extent will only be determined by the result of the percent of `[dMin, dMax]`.


`rangeMode` are auto determined by whether `option.start`/`option.end` are specified (represents `'percent'` mode) or `option.startValue`/`option.endValue` specified (represents `'value'` mode). And when user behavior trigger the changing of the view, the `rangeMode` would be modified automatically. For example, if triggered by `toolbox.dataZoom`, it will be modefied to `'value'`, and if triggered by `dataZoom-inside` or `dataZoom-slider`, it will be modified to `'percent'`.


If we specify `rangeMode` manually in `option`, it only works when both `start` and `startValue` specified or both `end` and `endValue` specified. So usually we do not need to specify `dataZoom.rangeMode` manually.


Take a scenario as an example. When we are using dynamic data (update data periodically via `setOption`), if in `'value`' mode, the window will be kept in a fixed value range despite how data are appended, while if in `'percent'` mode, whe window range will be changed alone with the appended data (suppose `axis.min` and `axis.max` are not specified).""").tag(sync=True)
    
    zlevel = Float(None, allow_none=True, help="""`zlevel` value of all graphical elements in .


`zlevel` is used to make layers with Canvas. Graphical elements with different `zlevel` values will be placed in different Canvases, which is a common optimization technique. We can put those frequently changed elements (like those with animations) to a separate `zlevel`. Notice that too many Canvases will increase memory cost, and should be used carefully on mobile phones to avoid crash.


Canvases with bigger `zlevel` will be placed on Canvases with smaller `zlevel`.""").tag(sync=True)
    
    z = Float(None, allow_none=True, help="""`z` value of all graphical elements in , which controls order of drawing graphical components. Components with smaller `z` values may be overwritten by those with larger `z` values.


`z` has a lower priority to `zlevel`, and will not create new Canvas.""").tag(sync=True)
    
    left = Union([Unicode(default_value=None, allow_none=True),Float(default_value=None, allow_none=True),], default_value=None, allow_none=True, help="""Distance between dataZoom-slider component and the left side of the container.


`left` can be a pixel value like `20`; it can also be a percentage value relative to container width like `'20%'`; and it can also be `'left'`, `'center'`, or `'right'`.


If the `left` value is set to be `'left'`, `'center'`, or `'right'`, then the component will be aligned automatically based on position.""").tag(sync=True)
    
    top = Union([Unicode(default_value=None, allow_none=True),Float(default_value=None, allow_none=True),], default_value=None, allow_none=True, help="""Distance between dataZoom-slider component and the top side of the container.


`top` can be a pixel value like `20`; it can also be a percentage value relative to container width like `'20%'`; and it can also be `'top'`, `'middle'`, or `'bottom'`.


If the `top` value is set to be `'top'`, `'middle'`, or `'bottom'`, then the component will be aligned automatically based on position.""").tag(sync=True)
    
    right = Union([Unicode(default_value=None, allow_none=True),Float(default_value=None, allow_none=True),], default_value=None, allow_none=True, help="""Distance between dataZoom-slider component and the right side of the container.


`right` can be a pixel value like `20`; it can also be a percentage value relative to container width like `'20%'`.


Adaptive by default.""").tag(sync=True)
    
    bottom = Union([Unicode(default_value=None, allow_none=True),Float(default_value=None, allow_none=True),], default_value=None, allow_none=True, help="""Distance between dataZoom-slider component and the bottom side of the container.


`bottom` can be a pixel value like `20`; it can also be a percentage value relative to container width like `'20%'`.


Adaptive by default.""").tag(sync=True)
    
    width = Union([Unicode(default_value=None, allow_none=True),Float(default_value=None, allow_none=True),], default_value=None, allow_none=True, help="""Width of dataZoom-slider component. Default to 30 when vertical, adaptive when horizontal.


Has higher priority than `left` and `right`.""").tag(sync=True)
    
    height = Union([Unicode(default_value=None, allow_none=True),Float(default_value=None, allow_none=True),], default_value=None, allow_none=True, help="""Height of dataZoom-slider component. Default to 30 when horizontal, adaptive when vertical.


Has higher priority than `top` and `bottom`.""").tag(sync=True)
    
    brushSelect = Bool(None, allow_none=True, help="""> Since `v5.0.0`


Whether to enable brush to select.""").tag(sync=True)
    
    brushStyle = Dict(default_value=None, allow_none=True, help="""> Since `v5.0.0`


Style of brushing area.""").tag(sync=True)
    
    emphasis = Dict(default_value=None, allow_none=True, help="""> Since `v5.0.0`


Style when highlighted.""").tag(sync=True)
    
        
