from traitlets import (
    Unicode, Dict, Float, Bool, Union, Any,
)
from ..basewidget import BaseWidget


class Geo3D(BaseWidget):
    """ 
:warning: **Autogenerated class**

A 3D geographic coordinate system component. The component can draw a 3D GeoJSON and coordinate system. Developers can display 3D Scatter, 3D Bubble, 3D Bar, 3D Lines on it.



    """

    def __init__(self, **kwargs):

        super().__init__(**kwargs)  
    
    _model_name = Unicode("Geo3DModel").tag(sync=True)
    
    show = Bool(None, allow_none=True, help="""Whether to display 3D geographic coordinate system components.""").tag(sync=True)
    
    map = Unicode(None, allow_none=True, help="""The map type. The map type used in ECharts-gl is the same as the [geo](https://echarts.apache.org/en/option.html#geo.map) component.


EChart provides map data in two formats. One is the JS file that can be imported directly through the script tag. After it is introduced, the map name and data will be automatically registered. Another is the JSON file that needs to be registered manually after loaded asynchronously by AJAX.


Here are two types of use examples:


 **JavaScript Introduction Example** 



```
<script src="echarts.js"></script>
<script src="map/js/china.js"></script>
<script>
var chart = echarts.init(document.getElementById('main'));
chart.setOption({
    series: [{
        type: 'map',
        map: 'china'
    }]
});
</script>

```

 **JSON Introduction Example** 



```
$.get('map/json/china.json', function (chinaJson) {
    echarts.registerMap('china', chinaJson);
    var chart = echarts.init(document.getElementById('main'));
    chart.setOption({
        series: [{
            type: 'map',
            map: 'china'
        }]
    });
});

```

ECharts uses the data in [geoJSON] (<http://geojson.org/>) format as the outline of the map. In addition, you can also obtain data in [geoJSON] (<http://geojson.org/>) format of the map by other means and register it in ECharts.""").tag(sync=True)
    
    boxWidth = Float(None, allow_none=True, help="""A 3D geographic coordinate system component width in a 3D scene. With [viewControl.distance](#geo3D.viewControl.distance) you can get the most appropriate display size.


The following image is a schematic diagram of `boxWidth`, `boxHeight`, `boxDepth`, `regionHeight` in A 3D geographic coordinate system component.


![](documents/asset/gl/img/geo-size.png)""").tag(sync=True)
    
    boxHeight = Float(None, allow_none=True, help="""A 3D geographic coordinate system component height in a 3D scene.


Component height. This height contains the height of the bar and scatter on a 3D map.""").tag(sync=True)
    
    boxDepth = Float(None, allow_none=True, help="""A 3D geographic coordinate system component depth in a 3D scene.


The component depth defaults to automatic, ensuring that the scale of the 3D component is the same as the ratio of the input GeoJSON.""").tag(sync=True)
    
    regionHeight = Float(None, allow_none=True, help="""The height of each area of the 3D map. This height is the height of the model, less than [boxHeight](#geo3D.boxHeight). `boxHeight - regionHeight` will be used for the display of 3D bar, 3D scatter, and etc.""").tag(sync=True)
    
    environment = Unicode(None, allow_none=True, help="""Environment map. Support for solid colors, gradual colors, URL of panoramic texture. The default is `'auto'`, which is used as the environment texture when [light.ambientCubemap.texture](#geo3D.light.ambientCubemap.texture) is configured. Otherwise, the environment texture is not displayed.


Example:



```
// Configure as a panoramic texture
environment: 'asset/starfield.jpg'
// Configured as a solid black background
environment: '#000'
// Configured as a background with a vertical gradient
environment: new echarts.graphic.LinearGradient(0, 0, 0, 1, [{
  offset: 0, color: '#00aaff' // Sky color
}, {
  offset: 0.7, color: '#998866' // Ground color
}, {
  offset: 1, color: '#998866' // Ground color
}], false)


```""").tag(sync=True)
    
    groundPlane = Dict(default_value=None, allow_none=True, help="""The ground allows the entire assembly to be “placed” to make the entire scene look more realistic.


 `groundPlane` supports setting up separate `realisticMaterial`, `colorMaterial`, `lambertMaterial` and other materials. If not set, the material parameters of the component are taken by default.""").tag(sync=True)
    
    instancing = Bool(None, allow_none=True, help="""`instancing` will merge all the [geometry](http://geojson.org/geojson-spec.html#geometry-objects) in GeoJSON into one. When GeoJSON has a lot of (thousands) [geometry](http://geojson.org/geojson-spec.html#geometry-objects), it can effectively improve drawing efficiency.""").tag(sync=True)
    
    label = Dict(default_value=None, allow_none=True, help="""The setting of the label.""").tag(sync=True)
    
    itemStyle = Dict(default_value=None, allow_none=True, help="""Visual properties of 3D graphics in A 3D geographic coordinate system component, including color, transparency, strokes, etc.""").tag(sync=True)
    
    emphasis = Dict(default_value=None, allow_none=True, help="""Graphic and label styles when mouse hover is highlighted.""").tag(sync=True)
    
    regions = Any(None, allow_none=True, help="""The setting of the map area.""").tag(sync=True)
    
    shading = Unicode(None, allow_none=True, help="""The coloring effect of 3D graphics in A 3D geographic coordinate system component. The following three coloring methods are supported in echarts-gl:


* `'color'`
Only display colors, not affected by other factors such as lighting.
* `'lambert'`
Through the classic [lambert] coloring, can express the light and dark that the light shows.
* `'realistic'`
Realistic rendering, combined with [light.ambientCubemap](#globe.light.ambientCubemap) and [postEffect](#globe.postEffect), can improve the quality and texture of the display. [Physical Based Rendering (PBR)] (<https://www.marmoset.co/posts/physically-based-rendering-and-you-can-too/>) is used in ECharts GL to represent realistic materials.""").tag(sync=True)
    
    realisticMaterial = Dict(default_value=None, allow_none=True, help="""The configuration item of the realistic material is valid when [shading](#geo3D.shading) is `'realistic'`.""").tag(sync=True)
    
    lambertMaterial = Dict(default_value=None, allow_none=True, help="""The configuration item of the lambert material is valid when [shading](#geo3D.shading) is `'lambert'`.""").tag(sync=True)
    
    colorMaterial = Dict(default_value=None, allow_none=True, help="""The color material related configuration item is valid when [shading](#geo3D.shading) is `'color'`.""").tag(sync=True)
    
    light = Dict(default_value=None, allow_none=True, help="""Light related settings. Invalid when [shading](#geo3D.shading) is 'color'.


The lighting settings affect the components and all the charts on the component's coordinate system.


A reasonable lighting setting can make the brightness and darkness of the whole scene richer and more layered.""").tag(sync=True)
    
    postEffect = Dict(default_value=None, allow_none=True, help="""Post-processing effects related configuration. It can add effects such as highlights, depth of field, screen space ambient occlusion (SSAO), toning to the picture. And it can make the whole picture more textured.


The following are the differences between closing `postEffect` and opening `postEffect`.



![](documents/asset/gl/img/globe-posteffect-disable.png "Disable")
![](documents/asset/gl/img/globe-posteffect-enable.png "Enable")

Note that when postEffect is enable, [temporalSuperSampling](#geo3D.temporalSuperSampling) is enable by default. After the picture is still, the picture will continue to be enhanced, including anti-aliasing, depth of field, SSAO, shadows, etc.""").tag(sync=True)
    
    temporalSuperSampling = Dict(default_value=None, allow_none=True, help="""Temporal supersampling. After opening [postEffect](#geo3D.postEffect), WebGL's default MSAA (MultiSampling Anti-Aliasing) will not work, so we need to solve the problem of sampling.


Temporal supersampling is an anti-aliasing method. After the picture is still, it will continue to sample multiple times and taken at several instances inside the pixel and an average color value is calculated, thus achieving anti-aliasing effect.
And in this process, ECharts-gl also progressively enhances some of the effects in [postEffect](#geo3D.postEffect) that require sampled guarantees. For example [SSAO](#geo3D.postEffect.SSAO), [Depth of Field](#geo3D.postEffect.depthOfField), and shadow.


The following is the difference between not opening `temporalSuperSampling` and opening `temporalSuperSampling`.



![](documents/asset/gl/img/surface-no-taa.png "No AA")
![](documents/asset/gl/img/surface-taa.png "AA")""").tag(sync=True)
    
    viewControl = Dict(default_value=None, allow_none=True, help="""`viewControl` is used for mouse rotation, zooming, and other perspective control.""").tag(sync=True)
    
    zlevel = Float(None, allow_none=True, help="""The layer in which the component is located.


`zlevel` is used to make layers with Canvas. Graphical elements with different `zlevel` values will be placed in different Canvases, which is a common optimization technique. We can put those frequently changed elements (like those with animations) to a separate `zlevel`. Notice that too many Canvases will increase memory cost, and should be used carefully on mobile phones to avoid the crash.


Canvases with bigger `zlevel` will be placed on Canvases with smaller `zlevel`.


**Note:** The layers of the components in echarts-gl need to be separated from the layers of the components in echarts. The same `zlevel` cannot be used for both WebGL and Canvas drawing at the same time.""").tag(sync=True)
    
    left = Union([Unicode(default_value=None, allow_none=True),Float(default_value=None, allow_none=True),], default_value=None, allow_none=True, help="""Distance between component and the left side of the container.


`left` value can be instant pixel value like `20`; it can also be a percentage value relative to container width like `'20%'`; and it can also be `'left'`, `'center'`, or `'right'`.


If the `left` value is set to be `'left'`, `'center'`, or `'right'`, then the component will be aligned automatically based on position.""").tag(sync=True)
    
    top = Union([Unicode(default_value=None, allow_none=True),Float(default_value=None, allow_none=True),], default_value=None, allow_none=True, help="""Distance between component and the top side of the container.


`top` value can be instant pixel value like `20`; it can also be a percentage value relative to container width like `'20%'`; and it can also be `'top'`, `'middle'`, or `'bottom'`.


If the `top` value is set to be `'top'`, `'middle'`, or `'bottom'`, then the component will be aligned automatically based on position.""").tag(sync=True)
    
    right = Union([Unicode(default_value=None, allow_none=True),Float(default_value=None, allow_none=True),], default_value=None, allow_none=True, help="""Distance between component and the right side of the container.


`right` value can be instant pixel value like `20`; it can also be a percentage value relative to container width like `'20%'`.


 Adaptive by default.""").tag(sync=True)
    
    bottom = Union([Unicode(default_value=None, allow_none=True),Float(default_value=None, allow_none=True),], default_value=None, allow_none=True, help="""Distance between component and the bottom side of the container.


`bottom` value can be instant pixel value like `20`; it can also be a percentage value relative to container width like `'20%'`.


 Adaptive by default.""").tag(sync=True)
    
    width = Union([Unicode(default_value=None, allow_none=True),Float(default_value=None, allow_none=True),], default_value=None, allow_none=True, help="""The width of the view of the component.""").tag(sync=True)
    
    height = Union([Unicode(default_value=None, allow_none=True),Float(default_value=None, allow_none=True),], default_value=None, allow_none=True, help="""The height of the view of the component.""").tag(sync=True)
    
        
