from traitlets import (
    Unicode, Dict, Float, Bool, Union, Any,
)
from ..basewidget import BaseWidget


class Globe(BaseWidget):
    """ 
:warning: **Autogenerated class**

Globe component. The component provides the drawing of the Earth and the coordinate system. The developer can display 3D Scatter, 3D Bubble, 3D Bar, 3D Lines on it.



    """

    def __init__(self, **kwargs):

        super().__init__(**kwargs)  
    
    _model_name = Unicode("GlobeModel").tag(sync=True)
    
    show = Bool(None, allow_none=True, help="""Whether to show the globe component.""").tag(sync=True)
    
    zlevel = Float(None, allow_none=True, help="""The layer in which the component is located.


`zlevel` is used to make layers with Canvas. Graphical elements with different `zlevel` values will be placed in different Canvases, which is a common optimization technique. We can put those frequently changed elements (like those with animations) to a separate `zlevel`. Notice that too many Canvases will increase memory cost, and should be used carefully on mobile phones to avoid the crash.


Canvases with bigger `zlevel` will be placed on Canvases with smaller `zlevel`.


**Note:** The layers of the components in echarts-gl need to be separated from the layers of the components in echarts. The same `zlevel` cannot be used for both WebGL and Canvas drawing at the same time.""").tag(sync=True)
    
    left = Union([Unicode(default_value=None, allow_none=True),Float(default_value=None, allow_none=True),], default_value=None, allow_none=True, help="""Distance between component and the left side of the container.


`left` value can be instant pixel value like `20`; it can also be a percentage value relative to container width like `'20%'`; and it can also be `'left'`, `'center'`, or `'right'`.


If the `left` value is set to be `'left'`, `'center'`, or `'right'`, then the component will be aligned automatically based on position.""").tag(sync=True)
    
    top = Union([Unicode(default_value=None, allow_none=True),Float(default_value=None, allow_none=True),], default_value=None, allow_none=True, help="""Distance between component and the top side of the container.


`top` value can be instant pixel value like `20`; it can also be a percentage value relative to container width like `'20%'`; and it can also be `'top'`, `'middle'`, or `'bottom'`.


If the `top` value is set to be `'top'`, `'middle'`, or `'bottom'`, then the component will be aligned automatically based on position.""").tag(sync=True)
    
    right = Union([Unicode(default_value=None, allow_none=True),Float(default_value=None, allow_none=True),], default_value=None, allow_none=True, help="""Distance between component and the right side of the container.


`right` value can be instant pixel value like `20`; it can also be a percentage value relative to container width like `'20%'`.


 Adaptive by default.""").tag(sync=True)
    
    bottom = Union([Unicode(default_value=None, allow_none=True),Float(default_value=None, allow_none=True),], default_value=None, allow_none=True, help="""Distance between component and the bottom side of the container.


`bottom` value can be instant pixel value like `20`; it can also be a percentage value relative to container width like `'20%'`.


 Adaptive by default.""").tag(sync=True)
    
    width = Union([Unicode(default_value=None, allow_none=True),Float(default_value=None, allow_none=True),], default_value=None, allow_none=True, help="""The width of the view of the component.""").tag(sync=True)
    
    height = Union([Unicode(default_value=None, allow_none=True),Float(default_value=None, allow_none=True),], default_value=None, allow_none=True, help="""The height of the view of the component.""").tag(sync=True)
    
    globeRadius = Float(None, allow_none=True, help="""The radius of the globe. The unit is relative to the three-dimensional space, related to [viewControl.distance](#globe.viewControl.distance).""").tag(sync=True)
    
    globeOuterRadius = Float(None, allow_none=True, help="""The outer radius of the globe. This area between `globeRadius` and `globeOuterRadius` will be used to display 3D histograms, scatter plots, etc.""").tag(sync=True)
    
    environment = Unicode(None, allow_none=True, help="""Environment map. Support for solid colors, gradual colors, URL of panoramic texture. The default is `'auto'`, which is used as the environment texture when [light.ambientCubemap.texture](#.light.ambientCubemap.texture) is configured. Otherwise, the environment texture is not displayed.


Example:



```
// Configure as a panoramic texture
environment: 'asset/starfield.jpg'
// Configured as a solid black background
environment: '#000'
// Configured as a background with a vertical gradient
environment: new echarts.graphic.LinearGradient(0, 0, 0, 1, [{
  offset: 0, color: '#00aaff' // Sky color
}, {
  offset: 0.7, color: '#998866' // Ground color
}, {
  offset: 1, color: '#998866' // Ground color
}], false)


```""").tag(sync=True)
    
    baseTexture = Union([Unicode(default_value=None, allow_none=True),Any(default_value=None, allow_none=True),Any(default_value=None, allow_none=True),Any(default_value=None, allow_none=True),], default_value=None, allow_none=True, help="""The texture of the globe. Support for the string of image paths, images object or Canvas objects.


It also supports to use an echarts example as a texture directly, in which case mouse actions on Earth will be linked to the echarts instance used on the texture.


Example:



```
// Use the globe's texture image
baseTexture: 'asset/earth.jpg'

// Use the world map example of echarts as a texture.
var canvas = document.createElement('canvas');
var mapChart = echarts.init(canvas, null, {
    width: 4096, height: 2048
});
mapChart.setOption({
    series : [
        {
            type: 'map',
            map: 'world',
            // Draw full size echarts example
            top: 0, left: 0,
            right: 0, bottom: 0,
            boundingCoords: [[-180, 90], [180, -90]]
        }
    ]
});
...
baseTexture: mapChart


```""").tag(sync=True)
    
    heightTexture = Union([Unicode(default_value=None, allow_none=True),Any(default_value=None, allow_none=True),Any(default_value=None, allow_none=True),], default_value=None, allow_none=True, help="""The high texture of the globe. High textures can be used to match [Bump Map](https://zh.wikipedia.org/wiki/%E5%87%B9%E5%87%B8%E8%B4%B4%E5%9B%BE) to show the light and dark details of the Earth's surface.
The following two images show the difference between using `heightTexture` and not using `heightTexuture`.


![](documents/asset/gl/img/heightmap-enable.png)


![](documents/asset/gl/img/heightmap-disable.png)""").tag(sync=True)
    
    displacementTexture = Union([Unicode(default_value=None, allow_none=True),Any(default_value=None, allow_none=True),Any(default_value=None, allow_none=True),], default_value=None, allow_none=True, help="""The displacement texture of the vertices of the globe, the default is the same as a heightTexture


Compared to bump maps, The displacement of the vertex is to directly shift the vertices according to the texture. Valid when [displaymentScale](#globe.displaymentScale) is greater than 0.""").tag(sync=True)
    
    displacementScale = Float(None, allow_none=True, help="""The displacement map of the globe's vertex. The default is 0, which means no displacement.
The following two images show the effects of setting different `displacementScale`.



![](documents/asset/gl/img/displacement-disable.png "Scale: 0")
![](documents/asset/gl/img/displacement-enable.png "Scale: 0.1")""").tag(sync=True)
    
    displacementQuality = Unicode(None, allow_none=True, help="""The quality of the globe's vertex displacement. Support for `'low'`, `'medium'`, `'high'`, `'ultra'` settings.Higher quality can show more ground height detail.
The following two images show the effects of different `displacementQuality`.



![](documents/asset/gl/img/displacement-low.png "Low")
![](documents/asset/gl/img/displacement-ultra.png "Ultra")""").tag(sync=True)
    
    shading = Unicode(None, allow_none=True, help="""The coloring effect of 3D graphics in 地球. The following three coloring methods are supported in echarts-gl:


* `'color'`
Only display colors, not affected by other factors such as lighting.
* `'lambert'`
Through the classic [lambert] coloring, can express the light and dark that the light shows.
* `'realistic'`
Realistic rendering, combined with [light.ambientCubemap](#globe.light.ambientCubemap) and [postEffect](#globe.postEffect), can improve the quality and texture of the display. [Physical Based Rendering (PBR)] (<https://www.marmoset.co/posts/physically-based-rendering-and-you-can-too/>) is used in ECharts GL to represent realistic materials.


Here are the differences between different coloring effects.


![](documents/asset/gl/img/globe-shading-color.png)
![](documents/asset/gl/img/globe-shading-lambert.png)
![](documents/asset/gl/img/globe-shading-realistic.png)""").tag(sync=True)
    
    realisticMaterial = Dict(default_value=None, allow_none=True, help="""The configuration item of the realistic material is valid when [shading](#globe.shading) is `'realistic'`.""").tag(sync=True)
    
    lambertMaterial = Dict(default_value=None, allow_none=True, help="""The configuration item of the lambert material is valid when [shading](#globe.shading) is `'lambert'`.""").tag(sync=True)
    
    colorMaterial = Dict(default_value=None, allow_none=True, help="""The color material related configuration item is valid when [shading](#globe.shading) is `'color'`.""").tag(sync=True)
    
    light = Dict(default_value=None, allow_none=True, help="""Light related settings. Invalid when [shading](#globe.shading) is 'color'.


The lighting settings affect the components and all the charts on the component's coordinate system.


A reasonable lighting setting can make the brightness and darkness of the whole scene richer and more layered.""").tag(sync=True)
    
    atmosphere = Dict(default_value=None, allow_none=True, help="""`atmosphere`is used for settings related to the outer atmosphere of the earth。""").tag(sync=True)
    
    postEffect = Dict(default_value=None, allow_none=True, help="""Post-processing effects related configuration. It can add effects such as highlights, depth of field, screen space ambient occlusion (SSAO), toning to the picture. And it can make the whole picture more textured.


The following are the differences between closing `postEffect` and opening `postEffect`.



![](documents/asset/gl/img/globe-posteffect-disable.png "Disable")
![](documents/asset/gl/img/globe-posteffect-enable.png "Enable")

Note that when postEffect is enable, [temporalSuperSampling](#globe.temporalSuperSampling) is enable by default. After the picture is still, the picture will continue to be enhanced, including anti-aliasing, depth of field, SSAO, shadows, etc.""").tag(sync=True)
    
    temporalSuperSampling = Dict(default_value=None, allow_none=True, help="""Temporal supersampling. After opening [postEffect](#globe.postEffect), WebGL's default MSAA (MultiSampling Anti-Aliasing) will not work, so we need to solve the problem of sampling.


Temporal supersampling is an anti-aliasing method. After the picture is still, it will continue to sample multiple times and taken at several instances inside the pixel and an average color value is calculated, thus achieving anti-aliasing effect.
And in this process, ECharts-gl also progressively enhances some of the effects in [postEffect](#globe.postEffect) that require sampled guarantees. For example [SSAO](#globe.postEffect.SSAO), [Depth of Field](#globe.postEffect.depthOfField), and shadow.


The following is the difference between not opening `temporalSuperSampling` and opening `temporalSuperSampling`.



![](documents/asset/gl/img/surface-no-taa.png "No AA")
![](documents/asset/gl/img/surface-taa.png "AA")""").tag(sync=True)
    
    viewControl = Dict(default_value=None, allow_none=True, help="""`viewControl` is used for mouse rotation, zooming, and other perspective control.""").tag(sync=True)
    
    layers = Any(None, allow_none=True, help="""Configuration of the Earth's Surface Layer.
You can use this configuration item to add clouds, or to supplement [baseTexture](#globe. baseTexture) to draw the outline of the country, and so on.""").tag(sync=True)
    
        
