from traitlets import (
    Unicode, Dict, Float, Bool, Union, Any,
)
from ..basewidget import BaseWidget


class Grid(BaseWidget):
    """ 
:warning: **Autogenerated class**

Drawing grid in rectangular coordinate. In a single grid, at most two X and Y axes each is allowed. [Line chart](#series-line), [bar chart](#series-bar), and [scatter chart (bubble chart)](#series-scatter) can be drawn in grid.


In ECharts 2.x, there could only be one single grid component at most in a single echarts instance. But in ECharts 3, there is no limitation.


**Following is an example of Anscombe Quartet:**




    """

    def __init__(self, **kwargs):

        super().__init__(**kwargs)  
    
    _model_name = Unicode("GridModel").tag(sync=True)
    
    id = Unicode(None, allow_none=True, help="""Component ID, not specified by default. If specified, it can be used to refer the component in option or API.""").tag(sync=True)
    
    show = Bool(None, allow_none=True, help="""Whether to show the grid in rectangular coordinate.""").tag(sync=True)
    
    zlevel = Float(None, allow_none=True, help="""`zlevel` value of all graphical elements in .


`zlevel` is used to make layers with Canvas. Graphical elements with different `zlevel` values will be placed in different Canvases, which is a common optimization technique. We can put those frequently changed elements (like those with animations) to a separate `zlevel`. Notice that too many Canvases will increase memory cost, and should be used carefully on mobile phones to avoid crash.


Canvases with bigger `zlevel` will be placed on Canvases with smaller `zlevel`.""").tag(sync=True)
    
    z = Float(None, allow_none=True, help="""`z` value of all graphical elements in , which controls order of drawing graphical components. Components with smaller `z` values may be overwritten by those with larger `z` values.


`z` has a lower priority to `zlevel`, and will not create new Canvas.""").tag(sync=True)
    
    left = Union([Unicode(default_value=None, allow_none=True),Float(default_value=None, allow_none=True),], default_value=None, allow_none=True, help="""Distance between grid component and the left side of the container.


`left` can be a pixel value like `20`; it can also be a percentage value relative to container width like `'20%'`; and it can also be `'left'`, `'center'`, or `'right'`.


If the `left` value is set to be `'left'`, `'center'`, or `'right'`, then the component will be aligned automatically based on position.""").tag(sync=True)
    
    top = Union([Unicode(default_value=None, allow_none=True),Float(default_value=None, allow_none=True),], default_value=None, allow_none=True, help="""Distance between grid component and the top side of the container.


`top` can be a pixel value like `20`; it can also be a percentage value relative to container width like `'20%'`; and it can also be `'top'`, `'middle'`, or `'bottom'`.


If the `top` value is set to be `'top'`, `'middle'`, or `'bottom'`, then the component will be aligned automatically based on position.""").tag(sync=True)
    
    right = Union([Unicode(default_value=None, allow_none=True),Float(default_value=None, allow_none=True),], default_value=None, allow_none=True, help="""Distance between grid component and the right side of the container.


`right` can be a pixel value like `20`; it can also be a percentage value relative to container width like `'20%'`.""").tag(sync=True)
    
    bottom = Union([Unicode(default_value=None, allow_none=True),Float(default_value=None, allow_none=True),], default_value=None, allow_none=True, help="""Distance between grid component and the bottom side of the container.


`bottom` can be a pixel value like `20`; it can also be a percentage value relative to container width like `'20%'`.""").tag(sync=True)
    
    width = Union([Unicode(default_value=None, allow_none=True),Float(default_value=None, allow_none=True),], default_value=None, allow_none=True, help="""Width of grid component. Adaptive by default.""").tag(sync=True)
    
    height = Union([Unicode(default_value=None, allow_none=True),Float(default_value=None, allow_none=True),], default_value=None, allow_none=True, help="""Height of grid component. Adaptive by default.""").tag(sync=True)
    
    containLabel = Bool(None, allow_none=True, help="""Whether the grid region contains [axis tick label](#yAxis.axisLabel) of axis.


* When containLabel is `false`:
	+ `grid.left` `grid.right` `grid.top` `grid.bottom` `grid.width` `grid.height` decide the location and size of the rectangle that is made of by xAxis and yAxis.
	+ Setting to `false` will help when multiple grids need to be aligned at their axes.
* When containLabel is `true`:
	+ `grid.left` `grid.right` `grid.top` `grid.bottom` `grid.width` `grid.height` decide the location and size of the rectangle that contains the axes and the labels of the axes.
	+ Setting to `true` will help when the length of axis labels is dynamic and is hard to approximate. This will avoid labels from overflowing the container or overlapping other components.""").tag(sync=True)
    
    backgroundColor = Any(None, allow_none=True, help="""Background color of grid, which is transparent by default.



> Color can be represented in RGB, for example `'rgb(128, 128, 128)'`. RGBA can be used when you need alpha channel, for example `'rgba(128, 128, 128, 0.5)'`. You may also use hexadecimal format, for example `'#ccc'`.


**Attention**: Works only if `show: true` is set.""").tag(sync=True)
    
    borderColor = Any(None, allow_none=True, help="""Border color of grid. Support the same color format as backgroundColor.


**Attention**: Works only if `show: true` is set.""").tag(sync=True)
    
    borderWidth = Float(None, allow_none=True, help="""Border width of grid.


**Attention**: Works only if `show: true` is set.""").tag(sync=True)
    
    shadowBlur = Float(None, allow_none=True, help="""Size of shadow blur. This attribute should be used along with `shadowColor`,`shadowOffsetX`, `shadowOffsetY` to set shadow to component.


For example:



```
{
    shadowColor: 'rgba(0, 0, 0, 0.5)',
    shadowBlur: 10
}

```

**Attention**: This property works only if `show: true` is configured and `backgroundColor` is defined other than `transparent`.""").tag(sync=True)
    
    shadowColor = Any(None, allow_none=True, help="""Shadow color. Support same format as `color`.


**Attention**: This property works only if `show: true` configured.""").tag(sync=True)
    
    shadowOffsetX = Float(None, allow_none=True, help="""Offset distance on the horizontal direction of shadow.


**Attention**: This property works only if `show: true` configured.""").tag(sync=True)
    
    shadowOffsetY = Float(None, allow_none=True, help="""Offset distance on the vertical direction of shadow.


**Attention**: This property works only if `show: true` configured.""").tag(sync=True)
    
    tooltip = Dict(default_value=None, allow_none=True, help="""tooltip settings in the coordinate system component.


**General Introduction:**


tooltip can be configured on different places:


* Configured on global: [tooltip](#tooltip)
* Configured in a coordinate system: [grid.tooltip](#grid.tooltip), [polar.tooltip](#polar.tooltip), [single.tooltip](#single.tooltip)
* Configured in a series: [series.tooltip](#series.tooltip)
* Configured in each item of `series.data`: [series.data.tooltip](#series.data.tooltip)""").tag(sync=True)
    
        
