from traitlets import (
    Unicode, Dict, Float, Bool, Union,
)
from ..basewidget import BaseWidget


class Grid3D(BaseWidget):
    """ 
:warning: **Autogenerated class**

3D cartesian coordinate system component. It requires [xAxis3D](#xAxis3D), [yAxis3D](#yAxis3D)and [zAxis3D](#zAxis3D) axis components to be used together.


You can draw [3D Lines](#series-line3D), [3D Bar](#series-bar3D), [3D Scatter](#series-scatter3D), [surface](#series-surface) on the 3D Cartesian coordinate system.


You can set the [postEffect](#grid3D.postEffect), [light](#grid3D.light) and other configuration items to improve the display of 3D charts in `grid3D`.


Below is a description of the axis configuration items in grid3D. 


![](documents/asset/gl/img/grid3D.png)




---


**Note：** The [axisLine](#xAxis3D.axisLine), [axisTick](#xAxis3D.axisTick), [axisLabel](#xAxis3D.axisLabel), [splitLine](#xAxis3D.splitLine), [splitArea](#xAxis3D.splitArea), [axisPointer](#xAxis3D.axisPointer) set separately on [xAxis3D](#xAxis3D), [yAxis3D](#yAxis3D), [zAxis3D](#zAxis3D) will cover the corresponding configuration items under [grid3D](#grid3D).



    """

    def __init__(self, **kwargs):

        super().__init__(**kwargs)  
    
    _model_name = Unicode("Grid3DModel").tag(sync=True)
    
    show = Bool(None, allow_none=True, help="""Whether to display a 3D cartesian coordinate system component.""").tag(sync=True)
    
    boxWidth = Float(None, allow_none=True, help="""3D cartesian coordinate system width in a 3D scene. With [viewControl.distance](#grid3D.viewControl.distance) you can get the most appropriate display size.""").tag(sync=True)
    
    boxHeight = Float(None, allow_none=True, help="""3D cartesian coordinate system height in a 3D scene.""").tag(sync=True)
    
    boxDepth = Float(None, allow_none=True, help="""3D cartesian coordinate system depth in a 3D scene.""").tag(sync=True)
    
    axisLine = Dict(default_value=None, allow_none=True, help="""Settings related to axis line.""").tag(sync=True)
    
    axisLabel = Dict(default_value=None, allow_none=True, help="""Settings related to axis label.""").tag(sync=True)
    
    axisTick = Dict(default_value=None, allow_none=True, help="""Settings related to axis tick.""").tag(sync=True)
    
    splitLine = Dict(default_value=None, allow_none=True, help="""Settings related to axis line.""").tag(sync=True)
    
    splitArea = Dict(default_value=None, allow_none=True, help="""Split area of axis in [grid](#grid) area.""").tag(sync=True)
    
    axisPointer = Dict(default_value=None, allow_none=True, help="""Configurations for axis pointer.""").tag(sync=True)
    
    environment = Unicode(None, allow_none=True, help="""Environment map. Support for solid colors, gradual colors, URL of panoramic texture. The default is `'auto'`, which is used as the environment texture when [light.ambientCubemap.texture](#grid3D.light.ambientCubemap.texture) is configured. Otherwise, the environment texture is not displayed.


Example:



```
// Configure as a panoramic texture
environment: 'asset/starfield.jpg'
// Configured as a solid black background
environment: '#000'
// Configured as a background with a vertical gradient
environment: new echarts.graphic.LinearGradient(0, 0, 0, 1, [{
  offset: 0, color: '#00aaff' // Sky color
}, {
  offset: 0.7, color: '#998866' // Ground color
}, {
  offset: 1, color: '#998866' // Ground color
}], false)


```""").tag(sync=True)
    
    light = Dict(default_value=None, allow_none=True, help="""Light related settings. Invalid when [shading](#grid3D.shading) is 'color'.


The lighting settings affect the components and all the charts on the component's coordinate system.


A reasonable lighting setting can make the brightness and darkness of the whole scene richer and more layered.""").tag(sync=True)
    
    postEffect = Dict(default_value=None, allow_none=True, help="""Post-processing effects related configuration. It can add effects such as highlights, depth of field, screen space ambient occlusion (SSAO), toning to the picture. And it can make the whole picture more textured.


The following are the differences between closing `postEffect` and opening `postEffect`.



![](documents/asset/gl/img/globe-posteffect-disable.png "Disable")
![](documents/asset/gl/img/globe-posteffect-enable.png "Enable")

Note that when postEffect is enable, [temporalSuperSampling](#grid3D.temporalSuperSampling) is enable by default. After the picture is still, the picture will continue to be enhanced, including anti-aliasing, depth of field, SSAO, shadows, etc.""").tag(sync=True)
    
    temporalSuperSampling = Dict(default_value=None, allow_none=True, help="""Temporal supersampling. After opening [postEffect](#grid3D.postEffect), WebGL's default MSAA (MultiSampling Anti-Aliasing) will not work, so we need to solve the problem of sampling.


Temporal supersampling is an anti-aliasing method. After the picture is still, it will continue to sample multiple times and taken at several instances inside the pixel and an average color value is calculated, thus achieving anti-aliasing effect.
And in this process, ECharts-gl also progressively enhances some of the effects in [postEffect](#grid3D.postEffect) that require sampled guarantees. For example [SSAO](#grid3D.postEffect.SSAO), [Depth of Field](#grid3D.postEffect.depthOfField), and shadow.


The following is the difference between not opening `temporalSuperSampling` and opening `temporalSuperSampling`.



![](documents/asset/gl/img/surface-no-taa.png "No AA")
![](documents/asset/gl/img/surface-taa.png "AA")""").tag(sync=True)
    
    viewControl = Dict(default_value=None, allow_none=True, help="""`viewControl` is used for mouse rotation, zooming, and other perspective control.""").tag(sync=True)
    
    zlevel = Float(None, allow_none=True, help="""The layer in which the component is located.


`zlevel` is used to make layers with Canvas. Graphical elements with different `zlevel` values will be placed in different Canvases, which is a common optimization technique. We can put those frequently changed elements (like those with animations) to a separate `zlevel`. Notice that too many Canvases will increase memory cost, and should be used carefully on mobile phones to avoid the crash.


Canvases with bigger `zlevel` will be placed on Canvases with smaller `zlevel`.


**Note:** The layers of the components in echarts-gl need to be separated from the layers of the components in echarts. The same `zlevel` cannot be used for both WebGL and Canvas drawing at the same time.""").tag(sync=True)
    
    left = Union([Unicode(default_value=None, allow_none=True),Float(default_value=None, allow_none=True),], default_value=None, allow_none=True, help="""Distance between component and the left side of the container.


`left` value can be instant pixel value like `20`; it can also be a percentage value relative to container width like `'20%'`; and it can also be `'left'`, `'center'`, or `'right'`.


If the `left` value is set to be `'left'`, `'center'`, or `'right'`, then the component will be aligned automatically based on position.""").tag(sync=True)
    
    top = Union([Unicode(default_value=None, allow_none=True),Float(default_value=None, allow_none=True),], default_value=None, allow_none=True, help="""Distance between component and the top side of the container.


`top` value can be instant pixel value like `20`; it can also be a percentage value relative to container width like `'20%'`; and it can also be `'top'`, `'middle'`, or `'bottom'`.


If the `top` value is set to be `'top'`, `'middle'`, or `'bottom'`, then the component will be aligned automatically based on position.""").tag(sync=True)
    
    right = Union([Unicode(default_value=None, allow_none=True),Float(default_value=None, allow_none=True),], default_value=None, allow_none=True, help="""Distance between component and the right side of the container.


`right` value can be instant pixel value like `20`; it can also be a percentage value relative to container width like `'20%'`.


 Adaptive by default.""").tag(sync=True)
    
    bottom = Union([Unicode(default_value=None, allow_none=True),Float(default_value=None, allow_none=True),], default_value=None, allow_none=True, help="""Distance between component and the bottom side of the container.


`bottom` value can be instant pixel value like `20`; it can also be a percentage value relative to container width like `'20%'`.


 Adaptive by default.""").tag(sync=True)
    
    width = Union([Unicode(default_value=None, allow_none=True),Float(default_value=None, allow_none=True),], default_value=None, allow_none=True, help="""The width of the view of the component.""").tag(sync=True)
    
    height = Union([Unicode(default_value=None, allow_none=True),Float(default_value=None, allow_none=True),], default_value=None, allow_none=True, help="""The height of the view of the component.""").tag(sync=True)
    
        
