from traitlets import (
    Unicode, Dict, Float, Bool, Union, Any,
)
from ..basewidget import BaseWidget


class Legend(BaseWidget):
    """ 
:warning: **Autogenerated class**

Legend component.


Legend component shows symbol, color and name of different series. You can click legends to toggle displaying series in the chart.


In ECharts 3, a single echarts instance may contain multiple legend components, which makes it easier for the layout of multiple legend components.


If there have to be too many legend items, [vertically scrollable legend](https://echarts.apache.org/examples/en/editor.html?c=pie-legend&edit=1&reset=1) or [horizontally scrollable legend](https://echarts.apache.org/examples/en/editor.html?c=radar2&edit=1&reset=1) are options to paginate them. Check [legend.type](#legend.type) please.



    """

    def __init__(self, **kwargs):

        super().__init__(**kwargs)  
    
    _model_name = Unicode("LegendModel").tag(sync=True)
    
    type = Unicode(None, allow_none=True, help="""Type of legend. Optional values:


* `'plain'`: Simple legend. (default)
* `'scroll'`: Scrollable legend. It helps when too many legend items needed to be shown.


See [vertically scrollable legend](https://echarts.apache.org/examples/en/editor.html?c=pie-legend&edit=1&reset=1) or [horizontally scrollable legend](https://echarts.apache.org/examples/en/editor.html?c=radar2&edit=1&reset=1).


When `'scroll'` used, these options below can be used for detailed configuration:


* [legend.scrollDataIndex](#legend.scrollDataIndex)
* [legend.pageButtonItemGap](#legend.pageButtonItemGap)
* [legend.pageButtonGap](#legend.pageButtonGap)
* [legend.pageButtonPosition](#legend.pageButtonPosition)
* [legend.pageFormatter](#legend.pageFormatter)
* [legend.pageIcons](#legend.pageIcons)
* [legend.pageIconColor](#legend.pageIconColor)
* [legend.pageIconInactiveColor](#legend.pageIconInactiveColor)
* [legend.pageIconSize](#legend.pageIconSize)
* [legend.pageTextStyle](#legend.pageTextStyle)
* [legend.animation](#legend.animation)
* [legend.animationDurationUpdate](#legend.animationDurationUpdate)""").tag(sync=True)
    
    id = Unicode(None, allow_none=True, help="""Component ID, not specified by default. If specified, it can be used to refer the component in option or API.""").tag(sync=True)
    
    show = Bool(None, allow_none=True, ).tag(sync=True)
    
    zlevel = Float(None, allow_none=True, help="""`zlevel` value of all graphical elements in .


`zlevel` is used to make layers with Canvas. Graphical elements with different `zlevel` values will be placed in different Canvases, which is a common optimization technique. We can put those frequently changed elements (like those with animations) to a separate `zlevel`. Notice that too many Canvases will increase memory cost, and should be used carefully on mobile phones to avoid crash.


Canvases with bigger `zlevel` will be placed on Canvases with smaller `zlevel`.""").tag(sync=True)
    
    z = Float(None, allow_none=True, help="""`z` value of all graphical elements in , which controls order of drawing graphical components. Components with smaller `z` values may be overwritten by those with larger `z` values.


`z` has a lower priority to `zlevel`, and will not create new Canvas.""").tag(sync=True)
    
    left = Union([Unicode(default_value=None, allow_none=True),Float(default_value=None, allow_none=True),], default_value=None, allow_none=True, help="""Distance between legend component and the left side of the container.


`left` can be a pixel value like `20`; it can also be a percentage value relative to container width like `'20%'`; and it can also be `'left'`, `'center'`, or `'right'`.


If the `left` value is set to be `'left'`, `'center'`, or `'right'`, then the component will be aligned automatically based on position.""").tag(sync=True)
    
    top = Union([Unicode(default_value=None, allow_none=True),Float(default_value=None, allow_none=True),], default_value=None, allow_none=True, help="""Distance between legend component and the top side of the container.


`top` can be a pixel value like `20`; it can also be a percentage value relative to container width like `'20%'`; and it can also be `'top'`, `'middle'`, or `'bottom'`.


If the `top` value is set to be `'top'`, `'middle'`, or `'bottom'`, then the component will be aligned automatically based on position.""").tag(sync=True)
    
    right = Union([Unicode(default_value=None, allow_none=True),Float(default_value=None, allow_none=True),], default_value=None, allow_none=True, help="""Distance between legend component and the right side of the container.


`right` can be a pixel value like `20`; it can also be a percentage value relative to container width like `'20%'`.


Adaptive by default.""").tag(sync=True)
    
    bottom = Union([Unicode(default_value=None, allow_none=True),Float(default_value=None, allow_none=True),], default_value=None, allow_none=True, help="""Distance between legend component and the bottom side of the container.


`bottom` can be a pixel value like `20`; it can also be a percentage value relative to container width like `'20%'`.


Adaptive by default.""").tag(sync=True)
    
    width = Union([Unicode(default_value=None, allow_none=True),Float(default_value=None, allow_none=True),], default_value=None, allow_none=True, help="""Width of legend component. Adaptive by default.""").tag(sync=True)
    
    height = Union([Unicode(default_value=None, allow_none=True),Float(default_value=None, allow_none=True),], default_value=None, allow_none=True, help="""Height of legend component. Adaptive by default.""").tag(sync=True)
    
    orient = Unicode(None, allow_none=True, help="""The layout orientation of legend.


Options:


* 'horizontal'
* 'vertical'""").tag(sync=True)
    
    align = Unicode(None, allow_none=True, help="""Legend marker and text aligning. By default, it automatically calculates from component location and orientation. When [left](#legend.left) value of this component is 'right', and the vertical layout ([orient](#legend.orient) is 'vertical'), it would be aligned to 'right'.


Option:


* 'auto'
* 'left'
* 'right'""").tag(sync=True)
    
    padding = Union([Float(default_value=None, allow_none=True),Any(default_value=None, allow_none=True),], default_value=None, allow_none=True, help="""legend space around content. The unit is px. Default values for each position are 5. And they can be set to different values with left, right, top, and bottom.


Examples:



```
// Set padding to be 5
padding: 5
// Set the top and bottom paddings to be 5, and left and right paddings to be 10
padding: [5, 10]
// Set each of the four paddings separately
padding: [
    5,  // up
    10, // right
    5,  // down
    10, // left
]

```""").tag(sync=True)
    
    itemGap = Float(None, allow_none=True, help="""The distance between each legend, horizontal distance in horizontal layout, and vertical distance in vertical layout.""").tag(sync=True)
    
    itemWidth = Float(None, allow_none=True, help="""Image width of legend symbol.""").tag(sync=True)
    
    itemHeight = Float(None, allow_none=True, help="""Image height of legend symbol.""").tag(sync=True)
    
    itemStyle = Dict(default_value=None, allow_none=True, help="""Legend item style. If its children have values as `'inherit'`, the values are inherited from corresponding series options.""").tag(sync=True)
    
    lineStyle = Dict(default_value=None, allow_none=True, help="""Legend line style. If its children have values as `'inherit'`, the values are inherited from corresponding series options.""").tag(sync=True)
    
    symbolRotate = Union([Float(default_value=None, allow_none=True),Unicode(default_value=None, allow_none=True),], default_value=None, allow_none=True, help="""Rotation of the symbol, which can be `number | 'inherit'`. If it's `'inherit'`, `symbolRotate` of the series will be used.""").tag(sync=True)
    
    formatter = Union([Unicode(default_value=None, allow_none=True),Any(default_value=None, allow_none=True),], default_value=None, allow_none=True, help="""Formatter is used to format label of legend, which supports string template and callback function.


Example:



```
// using string template, the template variable is legend name {name}
formatter: 'Legend {name}'
// using callback function
formatter: function (name) {
    return 'Legend ' + name;
}

```""").tag(sync=True)
    
    selectedMode = Union([Unicode(default_value=None, allow_none=True),Bool(default_value=None, allow_none=True),], default_value=None, allow_none=True, help="""Selected mode of legend, which controls whether series can be toggled displaying by clicking legends. It is enabled by default, and you may set it to be `false` to disable it.


Besides, it can be set to `'single'` or `'multiple'`, for single selection and multiple selection.""").tag(sync=True)
    
    inactiveColor = Any(None, allow_none=True, help="""Legend color when not selected.""").tag(sync=True)
    
    inactiveBorderColor = Any(None, allow_none=True, help="""Legend border color when not selected.""").tag(sync=True)
    
    inactiveBorderWidth = Union([Float(default_value=None, allow_none=True),Unicode(default_value=None, allow_none=True),], default_value=None, allow_none=True, help="""Legend border width when not selected.


If it is `'auto'`, the border width is set to be 2 if there is border width in the series, 0 elsewise.


If it is `'inherit'`, it always takes the border width of the series.""").tag(sync=True)
    
    selected = Dict(default_value=None, allow_none=True, help="""State table of selected legend.


example:



```
selected: {
    // selected'series 1'
    'series 1': true,
    // unselected'series 2'
    'series 2': false
}

```""").tag(sync=True)
    
    textStyle = Dict(default_value=None, allow_none=True, help="""Legend text style.""").tag(sync=True)
    
    tooltip = Dict(default_value=None, allow_none=True, help="""Tooltip configuration for legend tooltip, which is similar to [tooltip](#tooltip).""").tag(sync=True)
    
    icon = Unicode(None, allow_none=True, help="""Icon of the legend items.


Icon types provided by ECharts includes


`'circle'`, `'rect'`, `'roundRect'`, `'triangle'`, `'diamond'`, `'pin'`, `'arrow'`, `'none'`


It can be set to an image with `'image://url'` , in which URL is the link to an image, or `dataURI` of an image.


An image URL example:



```
'image://http://example.website/a/b.png'

```
A `dataURI` example:



```
'image://data:image/gif;base64,R0lGODlhEAAQAMQAAORHHOVSKudfOulrSOp3WOyDZu6QdvCchPGolfO0o/XBs/fNwfjZ0frl3/zy7////wAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACH5BAkAABAALAAAAAAQABAAAAVVICSOZGlCQAosJ6mu7fiyZeKqNKToQGDsM8hBADgUXoGAiqhSvp5QAnQKGIgUhwFUYLCVDFCrKUE1lBavAViFIDlTImbKC5Gm2hB0SlBCBMQiB0UjIQA7'

```
Icons can be set to arbitrary vector path via `'path://'` in ECharts. As compared with a raster image, vector paths prevent jagging and blurring when scaled, and have better control over changing colors. The size of the vector icon will be adapted automatically. Refer to [SVG PathData](http://www.w3.org/TR/SVG/paths.html#PathData) for more information about the format of the path. You may export vector paths from tools like Adobe 


For example:



```
'path://M30.9,53.2C16.8,53.2,5.3,41.7,5.3,27.6S16.8,2,30.9,2C45,2,56.4,13.5,56.4,27.6S45,53.2,30.9,53.2z M30.9,3.5C17.6,3.5,6.8,14.4,6.8,27.6c0,13.3,10.8,24.1,24.101,24.1C44.2,51.7,55,40.9,55,27.6C54.9,14.4,44.1,3.5,30.9,3.5z M36.9,35.8c0,0.601-0.4,1-0.9,1h-1.3c-0.5,0-0.9-0.399-0.9-1V19.5c0-0.6,0.4-1,0.9-1H36c0.5,0,0.9,0.4,0.9,1V35.8z M27.8,35.8 c0,0.601-0.4,1-0.9,1h-1.3c-0.5,0-0.9-0.399-0.9-1V19.5c0-0.6,0.4-1,0.9-1H27c0.5,0,0.9,0.4,0.9,1L27.8,35.8L27.8,35.8z'

```""").tag(sync=True)
    
    data = Any(None, allow_none=True, help="""Data array of legend. An array item is usually a `name` representing string. (If it is a [pie chart](#series-pie), it could also be the `name` of a single data in the pie chart) of a series. Legend component would automatically calculate the color and icon according to series. Special string `''` (null string) or `'\n'` (new line string) can be used for a new line.


If `data` is not specified, it will be auto collected from series. For most of series, it will be collected from [series.name](#series.name) or the dimension name specified by `seriesName` of [series.encode](#series.encode). For some types of series like [pie](#series-pie) and [funnel](#series-funnel), it will be collected from the name field of `series.data`.


If you need to set the style for a single item, you may also set the configuration of it. In this case, `name` attribute is used to represent name of `series`.


Example:



```
data: [{
    name: 'series 1',
    // compulsorily set icon as a circle
    icon: 'circle',
    // set up the text in red
    textStyle: {
        color: 'red'
    }
}]

```""").tag(sync=True)
    
    backgroundColor = Any(None, allow_none=True, help="""Background color of legend, which is transparent by default.



> Color can be represented in RGB, for example `'rgb(128, 128, 128)'`. RGBA can be used when you need alpha channel, for example `'rgba(128, 128, 128, 0.5)'`. You may also use hexadecimal format, for example `'#ccc'`.""").tag(sync=True)
    
    borderColor = Any(None, allow_none=True, help="""Border color of legend. Support the same color format as backgroundColor.""").tag(sync=True)
    
    borderWidth = Float(None, allow_none=True, help="""Border width of legend.""").tag(sync=True)
    
    borderRadius = Union([Float(default_value=None, allow_none=True),Any(default_value=None, allow_none=True),], default_value=None, allow_none=True, help="""The radius of rounded corner. Its unit is px. And it supports use array to respectively specify the 4 corner radiuses.


For example:



```
borderRadius: 5, // consistently set the size of 4 rounded corners
borderRadius: [5, 5, 0, 0] // (clockwise upper left, upper right, bottom right and bottom left)

```""").tag(sync=True)
    
    shadowBlur = Float(None, allow_none=True, help="""Size of shadow blur. This attribute should be used along with `shadowColor`,`shadowOffsetX`, `shadowOffsetY` to set shadow to component.


For example:



```
{
    shadowColor: 'rgba(0, 0, 0, 0.5)',
    shadowBlur: 10
}

```

**Attention**: This property works only if `show: true` is configured and `backgroundColor` is defined other than `transparent`.""").tag(sync=True)
    
    shadowColor = Any(None, allow_none=True, help="""Shadow color. Support same format as `color`.


**Attention**: This property works only if `show: true` configured.""").tag(sync=True)
    
    shadowOffsetX = Float(None, allow_none=True, help="""Offset distance on the horizontal direction of shadow.


**Attention**: This property works only if `show: true` configured.""").tag(sync=True)
    
    shadowOffsetY = Float(None, allow_none=True, help="""Offset distance on the vertical direction of shadow.


**Attention**: This property works only if `show: true` configured.""").tag(sync=True)
    
    scrollDataIndex = Float(None, allow_none=True, help="""It works when [legend.type](#legend.type) is `'scroll'`.


`dataIndex` of the left top most displayed item.


Although the scrolling of legend items can be controlled by calling `setOption` and specifying this property, we suggest that do not control legend in this way unless necessary (`setOption` might be time-consuming), but just use action [legendScroll](api.html#action.legend.legendScroll) to do that.


See [vertically scrollable legend](https://echarts.apache.org/examples/en/editor.html?c=pie-legend&edit=1&reset=1) or [horizontally scrollable legend](https://echarts.apache.org/examples/en/editor.html?c=radar2&edit=1&reset=1).""").tag(sync=True)
    
    pageButtonItemGap = Float(None, allow_none=True, help="""It works when [legend.type](#legend.type) is `'scroll'`.


The gap between page buttons and page info text.


See [vertically scrollable legend](https://echarts.apache.org/examples/en/editor.html?c=pie-legend&edit=1&reset=1) or [horizontally scrollable legend](https://echarts.apache.org/examples/en/editor.html?c=radar2&edit=1&reset=1).""").tag(sync=True)
    
    pageButtonGap = Float(None, allow_none=True, help="""It works when [legend.type](#legend.type) is `'scroll'`.


The gap between page buttons and legend items.


See [vertically scrollable legend](https://echarts.apache.org/examples/en/editor.html?c=pie-legend&edit=1&reset=1) or [horizontally scrollable legend](https://echarts.apache.org/examples/en/editor.html?c=radar2&edit=1&reset=1).""").tag(sync=True)
    
    pageButtonPosition = Unicode(None, allow_none=True, help="""It works when [legend.type](#legend.type) is `'scroll'`.


The position of page buttons and page info. Optional values:


* `'start'`: on the left or top.
* `'end'`: on the right or bottom.


See [vertically scrollable legend](https://echarts.apache.org/examples/en/editor.html?c=pie-legend&edit=1&reset=1) or [horizontally scrollable legend](https://echarts.apache.org/examples/en/editor.html?c=radar2&edit=1&reset=1).""").tag(sync=True)
    
    pageFormatter = Union([Unicode(default_value=None, allow_none=True),Any(default_value=None, allow_none=True),], default_value=None, allow_none=True, help="""It works when [legend.type](#legend.type) is `'scroll'`.


Page info formatter. It is `'{current}/{total}'` by default, where `{current}` is current page number (start from 1), and `{total}` is the total page number.


If `pageFormatter` is a function, it should return a string. The parameters is:



```
{
    current: number
    total: number
}

```

See [vertically scrollable legend](https://echarts.apache.org/examples/en/editor.html?c=pie-legend&edit=1&reset=1) or [horizontally scrollable legend](https://echarts.apache.org/examples/en/editor.html?c=radar2&edit=1&reset=1).""").tag(sync=True)
    
    pageIcons = Dict(default_value=None, allow_none=True, help="""It works when [legend.type](#legend.type) is `'scroll'`.


The icons of page buttons.""").tag(sync=True)
    
    pageIconColor = Unicode(None, allow_none=True, help="""It works when [legend.type](#legend.type) is `'scroll'`.


The color of page buttons.


See [vertically scrollable legend](https://echarts.apache.org/examples/en/editor.html?c=pie-legend&edit=1&reset=1) or [horizontally scrollable legend](https://echarts.apache.org/examples/en/editor.html?c=radar2&edit=1&reset=1).""").tag(sync=True)
    
    pageIconInactiveColor = Unicode(None, allow_none=True, help="""It works when [legend.type](#legend.type) is `'scroll'`.


The color of page buttons when they are inactive.


See [vertically scrollable legend](https://echarts.apache.org/examples/en/editor.html?c=pie-legend&edit=1&reset=1) or [horizontally scrollable legend](https://echarts.apache.org/examples/en/editor.html?c=radar2&edit=1&reset=1).""").tag(sync=True)
    
    pageIconSize = Union([Float(default_value=None, allow_none=True),Any(default_value=None, allow_none=True),], default_value=None, allow_none=True, help="""It works when [legend.type](#legend.type) is `'scroll'`.


The size of page buttons. It can be a number, or an array, like `[10, 3]`, represents `[width, height]`.


See [vertically scrollable legend](https://echarts.apache.org/examples/en/editor.html?c=pie-legend&edit=1&reset=1) or [horizontally scrollable legend](https://echarts.apache.org/examples/en/editor.html?c=radar2&edit=1&reset=1).""").tag(sync=True)
    
    pageTextStyle = Dict(default_value=None, allow_none=True, help="""It works when [legend.type](#legend.type) is `'scroll'`.


The text style of page info.""").tag(sync=True)
    
    animation = Bool(None, allow_none=True, help="""Whether to use animation when page scrolls.""").tag(sync=True)
    
    animationDurationUpdate = Float(None, allow_none=True, help="""Duration of the page scroll animation.""").tag(sync=True)
    
    emphasis = Dict(default_value=None, allow_none=True, ).tag(sync=True)
    
    selector = Union([Bool(default_value=None, allow_none=True),Any(default_value=None, allow_none=True),], default_value=None, allow_none=True, help="""> Since `v4.4.0`


The selector button in the legend component. Currently, there are two types of button:


* `all`: Select All
* `inverse`: Inverse Selection


The selector button doesn't display by default, you need to enable it manually as follows.



```
selector: [
    {
        type: 'all',
        // can be any title you like
        title: 'All'
    },
    {
        type: 'inverse',
        // can be any title you like
        title: 'Inv'
    }
]

// or
selector: true

// or
selector: ['all', 'inverse']

```""").tag(sync=True)
    
    selectorLabel = Dict(default_value=None, allow_none=True, help="""> Since `v4.4.0`


The text label style of the selector button, which is displayed by default.""").tag(sync=True)
    
    selectorPosition = Unicode(None, allow_none=True, help="""> Since `v4.4.0`


The position of the selector button, which can be placed at the end or start of the legend component, the corresponding values are `'end'` and `'start'`. By default, when the legend is laid out horizontally, the selector is placed at the end of it, and when the legend is laid out vertically, the selector is placed at the start of it.""").tag(sync=True)
    
    selectorItemGap = Float(None, allow_none=True, help="""> Since `v4.4.0`


The gap between the selector button.""").tag(sync=True)
    
    selectorButtonGap = Float(None, allow_none=True, help="""> Since `v4.4.0`


The gap between selector button and legend component.""").tag(sync=True)
    
        
