from traitlets import (
    Unicode, Dict, Float, Union, Any,
)
from ..basewidget import BaseWidget


class Mapbox3D(BaseWidget):
    """ 
:warning: **Autogenerated class**

A geographic component based on mapbox-gl-js. Support for drawing [3D Scatter](#series-scatter3D), [3D Lines](#series-lines3D), [3D Bar](#series-bar3D), [3D map](#series-map3D) on mapbox maps. You can take advantage of Mapbox's powerful map service and ECharts GL's rich visualization and rendering effects to achieve the visualization you want.


You need to introduce the official sdk of mapbox before using the mapbox component.



```
<script src='https://api.mapbox.com/mapbox-gl-js/v0.38.0/mapbox-gl.js'></script>
<link href='https://api.mapbox.com/mapbox-gl-js/v0.38.0/mapbox-gl.css' rel='stylesheet' />

```

Then get the token provided by mapbox and set it to `mapbox.accessToken`.



```
mapboxgl.accessToken = 'your token';

```

Then you can use the mapbox component just like any other component.



```
chart.setOption({
    mapbox: {
        style: 'mapbox://styles/mapbox/dark-v9'
    }
});

```

Go to <https://www.mapbox.com/mapbox-gl-js/api/> for more details on `mapbox-gl-js sdk`.



    """

    def __init__(self, **kwargs):

        super().__init__(**kwargs)  
    
    _model_name = Unicode("Mapbox3DModel").tag(sync=True)
    
    style = Union([Unicode(default_value=None, allow_none=True),Any(default_value=None, allow_none=True),], default_value=None, allow_none=True, help="""Sets the style of the Mapbox map. Same as <https://www.mapbox.com/mapbox-gl-js/style-spec/>.""").tag(sync=True)
    
    center = Any(None, allow_none=True, help="""Sets the longitude and latitude of the center of the map. Longitude and latitude are represented by arrays, for example:



```
mapbox3D: {
    center: [104.114129, 37.550339],
    zoom: 3
}

```""").tag(sync=True)
    
    zoom = Float(None, allow_none=True, help="""Sets the zoom level of the map. See <https://www.mapbox.com/mapbox-gl-js/style-spec/#root-zoom>""").tag(sync=True)
    
    bearing = Float(None, allow_none=True, help="""Sets the bearing angle of the map. See <https://www.mapbox.com/mapbox-gl-js/style-spec/#root-bearing>""").tag(sync=True)
    
    pitch = Float(None, allow_none=True, help="""Sets the pitch angle of the map. The default is `0` means perpendicular to the surface of the map. The greater value is `60`. See <https://www.mapbox.com/mapbox-gl-js/style-spec/#root-pitch>""").tag(sync=True)
    
    altitudeScale = Float(None, allow_none=True, help="""The zoom of the altitude Scale.""").tag(sync=True)
    
    shading = Unicode(None, allow_none=True, help="""The coloring effect of 3D graphics in mapbox3D. The following three coloring methods are supported in echarts-gl:


* `'color'`
Only display colors, not affected by other factors such as lighting.
* `'lambert'`
Through the classic [lambert] coloring, can express the light and dark that the light shows.
* `'realistic'`
Realistic rendering, combined with [light.ambientCubemap](#globe.light.ambientCubemap) and [postEffect](#globe.postEffect), can improve the quality and texture of the display. [Physical Based Rendering (PBR)] (<https://www.marmoset.co/posts/physically-based-rendering-and-you-can-too/>) is used in ECharts GL to represent realistic materials.""").tag(sync=True)
    
    realisticMaterial = Dict(default_value=None, allow_none=True, help="""The configuration item of the realistic material is valid when [shading](#mapbox3D.shading) is `'realistic'`.""").tag(sync=True)
    
    lambertMaterial = Dict(default_value=None, allow_none=True, help="""The configuration item of the lambert material is valid when [shading](#mapbox3D.shading) is `'lambert'`.""").tag(sync=True)
    
    colorMaterial = Dict(default_value=None, allow_none=True, help="""The color material related configuration item is valid when [shading](#mapbox3D.shading) is `'color'`.""").tag(sync=True)
    
    light = Dict(default_value=None, allow_none=True, help="""Light related settings. Invalid when [shading](#mapbox3D.shading) is 'color'.


The lighting settings affect the components and all the charts on the component's coordinate system.


A reasonable lighting setting can make the brightness and darkness of the whole scene richer and more layered.""").tag(sync=True)
    
    postEffect = Dict(default_value=None, allow_none=True, help="""Post-processing effects related configuration. It can add effects such as highlights, depth of field, screen space ambient occlusion (SSAO), toning to the picture. And it can make the whole picture more textured.


The following are the differences between closing `postEffect` and opening `postEffect`.



![](documents/asset/gl/img/globe-posteffect-disable.png "Disable")
![](documents/asset/gl/img/globe-posteffect-enable.png "Enable")

Note that when postEffect is enable, [temporalSuperSampling](#mapbox3D.temporalSuperSampling) is enable by default. After the picture is still, the picture will continue to be enhanced, including anti-aliasing, depth of field, SSAO, shadows, etc.""").tag(sync=True)
    
    temporalSuperSampling = Dict(default_value=None, allow_none=True, help="""Temporal supersampling. After opening [postEffect](#mapbox3D.postEffect), WebGL's default MSAA (MultiSampling Anti-Aliasing) will not work, so we need to solve the problem of sampling.


Temporal supersampling is an anti-aliasing method. After the picture is still, it will continue to sample multiple times and taken at several instances inside the pixel and an average color value is calculated, thus achieving anti-aliasing effect.
And in this process, ECharts-gl also progressively enhances some of the effects in [postEffect](#mapbox3D.postEffect) that require sampled guarantees. For example [SSAO](#mapbox3D.postEffect.SSAO), [Depth of Field](#mapbox3D.postEffect.depthOfField), and shadow.


The following is the difference between not opening `temporalSuperSampling` and opening `temporalSuperSampling`.



![](documents/asset/gl/img/surface-no-taa.png "No AA")
![](documents/asset/gl/img/surface-taa.png "AA")""").tag(sync=True)
    
        
