from ipywidgets import (
    widget_serialization
)
from traitlets import (
    Unicode, Instance, List, Float, Bool, Union, Any,
)
from ..basewidget import BaseWidget

from .title import Title
from .legend import Legend
from .grid import Grid
from .xaxis import XAxis
from .yaxis import YAxis
from .polar import Polar
from .radiusaxis import RadiusAxis
from .angleaxis import AngleAxis
from .radar import Radar
from .datazoomitems.inside import Inside
from .datazoomitems.slider import Slider
from .visualmapitems.continuous import Continuous
from .visualmapitems.piecewise import Piecewise
from .tooltip import Tooltip
from .axispointer import AxisPointer
from .toolbox import Toolbox
from .brush import Brush
from .geo import Geo
from .parallel import Parallel
from .parallelaxis import ParallelAxis
from .singleaxis import SingleAxis
from .timeline import Timeline
from .graphic import Graphic
from .calendar import Calendar
from .dataset import Dataset
from .aria import Aria
from .seriesitems.line import Line
from .seriesitems.bar import Bar
from .seriesitems.pie import Pie
from .seriesitems.scatter import Scatter
from .seriesitems.effectscatter import EffectScatter
from .seriesitems.seriesradar import SeriesRadar
from .seriesitems.tree import Tree
from .seriesitems.treemap import Treemap
from .seriesitems.sunburst import Sunburst
from .seriesitems.boxplot import Boxplot
from .seriesitems.candlestick import Candlestick
from .seriesitems.heatmap import Heatmap
from .seriesitems.map import Map
from .seriesitems.seriesparallel import SeriesParallel
from .seriesitems.lines import Lines
from .seriesitems.graph import Graph
from .seriesitems.sankey import Sankey
from .seriesitems.funnel import Funnel
from .seriesitems.gauge import Gauge
from .seriesitems.pictorialbar import PictorialBar
from .seriesitems.themeriver import ThemeRiver
from .seriesitems.custom import Custom
from .seriesitems.scatter3d import Scatter3D
from .seriesitems.bar3d import Bar3D
from .seriesitems.line3d import Line3D
from .seriesitems.lines3d import Lines3D
from .seriesitems.map3d import Map3D
from .seriesitems.surface import Surface
from .seriesitems.polygons3d import Polygons3D
from .seriesitems.scattergl import ScatterGL
from .seriesitems.graphgl import GraphGL
from .seriesitems.flowgl import FlowGL
from .textstyle import TextStyle
from .stateanimation import StateAnimation
from .mediaitems.mediaitem import MediaItem
from .globe import Globe
from .geo3d import Geo3D
from .mapbox3d import Mapbox3D
from .grid3d import Grid3D
from .xaxis3d import XAxis3D
from .yaxis3d import YAxis3D
from .zaxis3d import ZAxis3D

class Option(BaseWidget):
    """ 
:warning: **Autogenerated class**


    """

    def __init__(self, **kwargs):

        super().__init__(**kwargs)  
    
    _model_name = Unicode("OptionModel").tag(sync=True)
    
    title = Instance(Title, kw=None, args=None,allow_none=True).tag(sync=True, **widget_serialization)
    
    legend = Instance(Legend, kw=None, args=None,allow_none=True).tag(sync=True, **widget_serialization)
    
    grid = Instance(Grid, kw=None, args=None,allow_none=True).tag(sync=True, **widget_serialization)
    
    xAxis = Instance(XAxis, kw=None, args=None,allow_none=True).tag(sync=True, **widget_serialization)
    
    yAxis = Instance(YAxis, kw=None, args=None,allow_none=True).tag(sync=True, **widget_serialization)
    
    polar = Instance(Polar, kw=None, args=None,allow_none=True).tag(sync=True, **widget_serialization)
    
    radiusAxis = Instance(RadiusAxis, kw=None, args=None,allow_none=True).tag(sync=True, **widget_serialization)
    
    angleAxis = Instance(AngleAxis, kw=None, args=None,allow_none=True).tag(sync=True, **widget_serialization)
    
    radar = Instance(Radar, kw=None, args=None,allow_none=True).tag(sync=True, **widget_serialization)
    
    dataZoom = List(trait=Union([Instance(Inside, kw=None, args=None, allow_none=True).tag(sync=True, **widget_serialization),Instance(Slider, kw=None, args=None, allow_none=True).tag(sync=True, **widget_serialization),]), allow_none=True, default_value=None).tag(sync=True, **widget_serialization)
    
    visualMap = List(trait=Union([Instance(Continuous, kw=None, args=None, allow_none=True).tag(sync=True, **widget_serialization),Instance(Piecewise, kw=None, args=None, allow_none=True).tag(sync=True, **widget_serialization),]), allow_none=True, default_value=None).tag(sync=True, **widget_serialization)
    
    tooltip = Instance(Tooltip, kw=None, args=None,allow_none=True).tag(sync=True, **widget_serialization)
    
    axisPointer = Instance(AxisPointer, kw=None, args=None,allow_none=True).tag(sync=True, **widget_serialization)
    
    toolbox = Instance(Toolbox, kw=None, args=None,allow_none=True).tag(sync=True, **widget_serialization)
    
    brush = Instance(Brush, kw=None, args=None,allow_none=True).tag(sync=True, **widget_serialization)
    
    geo = Instance(Geo, kw=None, args=None,allow_none=True).tag(sync=True, **widget_serialization)
    
    parallel = Instance(Parallel, kw=None, args=None,allow_none=True).tag(sync=True, **widget_serialization)
    
    parallelAxis = Instance(ParallelAxis, kw=None, args=None,allow_none=True).tag(sync=True, **widget_serialization)
    
    singleAxis = Instance(SingleAxis, kw=None, args=None,allow_none=True).tag(sync=True, **widget_serialization)
    
    timeline = Instance(Timeline, kw=None, args=None,allow_none=True).tag(sync=True, **widget_serialization)
    
    graphic = Instance(Graphic, kw=None, args=None,allow_none=True).tag(sync=True, **widget_serialization)
    
    calendar = Instance(Calendar, kw=None, args=None,allow_none=True).tag(sync=True, **widget_serialization)
    
    dataset = Instance(Dataset, kw=None, args=None,allow_none=True).tag(sync=True, **widget_serialization)
    
    aria = Instance(Aria, kw=None, args=None,allow_none=True).tag(sync=True, **widget_serialization)
    
    series = List(trait=Union([Instance(Line, kw=None, args=None, allow_none=True).tag(sync=True, **widget_serialization),Instance(Bar, kw=None, args=None, allow_none=True).tag(sync=True, **widget_serialization),Instance(Pie, kw=None, args=None, allow_none=True).tag(sync=True, **widget_serialization),Instance(Scatter, kw=None, args=None, allow_none=True).tag(sync=True, **widget_serialization),Instance(EffectScatter, kw=None, args=None, allow_none=True).tag(sync=True, **widget_serialization),Instance(SeriesRadar, kw=None, args=None, allow_none=True).tag(sync=True, **widget_serialization),Instance(Tree, kw=None, args=None, allow_none=True).tag(sync=True, **widget_serialization),Instance(Treemap, kw=None, args=None, allow_none=True).tag(sync=True, **widget_serialization),Instance(Sunburst, kw=None, args=None, allow_none=True).tag(sync=True, **widget_serialization),Instance(Boxplot, kw=None, args=None, allow_none=True).tag(sync=True, **widget_serialization),Instance(Candlestick, kw=None, args=None, allow_none=True).tag(sync=True, **widget_serialization),Instance(Heatmap, kw=None, args=None, allow_none=True).tag(sync=True, **widget_serialization),Instance(Map, kw=None, args=None, allow_none=True).tag(sync=True, **widget_serialization),Instance(SeriesParallel, kw=None, args=None, allow_none=True).tag(sync=True, **widget_serialization),Instance(Lines, kw=None, args=None, allow_none=True).tag(sync=True, **widget_serialization),Instance(Graph, kw=None, args=None, allow_none=True).tag(sync=True, **widget_serialization),Instance(Sankey, kw=None, args=None, allow_none=True).tag(sync=True, **widget_serialization),Instance(Funnel, kw=None, args=None, allow_none=True).tag(sync=True, **widget_serialization),Instance(Gauge, kw=None, args=None, allow_none=True).tag(sync=True, **widget_serialization),Instance(PictorialBar, kw=None, args=None, allow_none=True).tag(sync=True, **widget_serialization),Instance(ThemeRiver, kw=None, args=None, allow_none=True).tag(sync=True, **widget_serialization),Instance(Custom, kw=None, args=None, allow_none=True).tag(sync=True, **widget_serialization),Instance(Scatter3D, kw=None, args=None, allow_none=True).tag(sync=True, **widget_serialization),Instance(Bar3D, kw=None, args=None, allow_none=True).tag(sync=True, **widget_serialization),Instance(Line3D, kw=None, args=None, allow_none=True).tag(sync=True, **widget_serialization),Instance(Lines3D, kw=None, args=None, allow_none=True).tag(sync=True, **widget_serialization),Instance(Map3D, kw=None, args=None, allow_none=True).tag(sync=True, **widget_serialization),Instance(Surface, kw=None, args=None, allow_none=True).tag(sync=True, **widget_serialization),Instance(Polygons3D, kw=None, args=None, allow_none=True).tag(sync=True, **widget_serialization),Instance(ScatterGL, kw=None, args=None, allow_none=True).tag(sync=True, **widget_serialization),Instance(GraphGL, kw=None, args=None, allow_none=True).tag(sync=True, **widget_serialization),Instance(FlowGL, kw=None, args=None, allow_none=True).tag(sync=True, **widget_serialization),]), allow_none=True, default_value=None).tag(sync=True, **widget_serialization)
    
    darkMode = Bool(None, allow_none=True, help="""To specify whether it's dark mode.


ECharts will automatically detect it via [backgroundColor](#backgroundColor) by default and adjust the text color accordingly.


This option is usually used in themes.""").tag(sync=True)
    
    color = List(trait=Any, default_value=None, allow_none=True).tag(sync=True)
    
    backgroundColor = Any(None, allow_none=True, help="""Background color. No background by default.



> Supports setting as solid color using `rgb(255,255,255)`, `rgba(255,255,255,1)`, `#fff`, etc. Also supports setting as gradient color and pattern fill, see [option.color](#color) for details""").tag(sync=True)
    
    textStyle = Instance(TextStyle, kw=None, args=None,allow_none=True).tag(sync=True, **widget_serialization)
    
    animation = Bool(None, allow_none=True, help="""Whether to enable animation.""").tag(sync=True)
    
    animationThreshold = Float(None, allow_none=True, help="""Whether to set graphic number threshold to animation. Animation will be disabled when graphic number is larger than threshold.""").tag(sync=True)
    
    animationDuration = Union([Float(default_value=None, allow_none=True),Any(default_value=None, allow_none=True),], default_value=None, allow_none=True, help="""Duration of the first animation, which supports callback function for different data to have different animation effect:



```
animationDuration: function (idx) {
    // delay for later data is larger
    return idx * 100;
}

```""").tag(sync=True)
    
    animationEasing = Unicode(None, allow_none=True, help="""Easing method used for the first animation. Varied easing effects can be found at [easing effect example](https://echarts.apache.org/examples/en/editor.html?c=line-easing).""").tag(sync=True)
    
    animationDelay = Union([Float(default_value=None, allow_none=True),Any(default_value=None, allow_none=True),], default_value=None, allow_none=True, help="""Delay before updating the first animation, which supports callback function for different data to have different animation effect.


For example:



```
animationDelay: function (idx) {
    // delay for later data is larger
    return idx * 100;
}

```

See [this example](https://echarts.apache.org/examples/en/editor.html?c=bar-animation-delay) for more information.""").tag(sync=True)
    
    animationDurationUpdate = Union([Float(default_value=None, allow_none=True),Any(default_value=None, allow_none=True),], default_value=None, allow_none=True, help="""Time for animation to complete, which supports callback function for different data to have different animation effect:



```
animationDurationUpdate: function (idx) {
    // delay for later data is larger
    return idx * 100;
}

```""").tag(sync=True)
    
    animationEasingUpdate = Unicode(None, allow_none=True, help="""Easing method used for animation.""").tag(sync=True)
    
    animationDelayUpdate = Union([Float(default_value=None, allow_none=True),Any(default_value=None, allow_none=True),], default_value=None, allow_none=True, help="""Delay before updating animation, which supports callback function for different data to have different animation effects.


For example:



```
animationDelayUpdate: function (idx) {
    // delay for later data is larger
    return idx * 100;
}

```

See [this example](https://echarts.apache.org/examples/en/editor.html?c=bar-animation-delay) for more information.""").tag(sync=True)
    
    stateAnimation = Instance(StateAnimation, kw=None, args=None,allow_none=True).tag(sync=True, **widget_serialization)
    
    blendMode = Unicode(None, allow_none=True, help="""Sets the type of compositing operation to apply when drawing a new shape. See the different type: <https://developer.mozilla.org/en-US/docs/Web/API/CanvasRenderingContext2D/globalCompositeOperation>.


The default is `'source-over'`. Support settings for each series.


`'lighter'` is also a common type of compositing operation. In this mode, the area where the number of graphics is concentrated is superimposed into a high-brightness color (white). It often used to highlight the effect of the area. See example [Global airline](https://echarts.apache.org/examples/en/editor.html?c=lines-airline)""").tag(sync=True)
    
    hoverLayerThreshold = Float(None, allow_none=True, help="""When the number of element of the whole chart is larger than `hoverLayerThreshold`, a separate hover layer is used to render hovered elements.


The separate hover layer is used to avoid re-painting the whole canvas when hovering on elements. Instead, the hovered elements are rendered in a separate layer so that other elements don't have to be rendered again.


ECharts 2 use separate layer for all cases. But it brings some problems like the hovered elements may not covering everything else correctly, or translucent elements may not overlay correctly to each other. And it brings extra member cost due to the extra canvas and may bring burden on mobile devices. So since ECharts 3, the hover layer is not used by default. Only when the element amount is large enough will the hover layer used.""").tag(sync=True)
    
    useUTC = Bool(None, allow_none=True, help="""Whether to use UTC in display.


* `true`: When `axis.type` is `'time'`, ticks is determined according to UTC, and `axisLabel` and `tooltip` use UTC by default.
* `false`: When `axis.type` is `'time'`, ticks is determined according to local time, and `axisLabel` and `tooltip` use local time by default.


The default value of `useUTC` is false, for sake of considering:


* In many cases, labels should be displayed in local time (whether the time is stored in server in local time or UTC).
* If user uses time string (like '2012-01-02') in data, it usually means local time if time zone is not specified. Time should be displayed in its original time zone by default.


Notice: the setting only affects "display time", not "parse time".
For how time value (like `1491339540396`, `'2013-01-04'`, ...) is parsed in echarts, see [the time part in date](#series-line.data).""").tag(sync=True)
    
    options = List(trait=Any, default_value=None, allow_none=True).tag(sync=True)
    
    media = List(trait=Instance(MediaItem), default_value=None, allow_none=True).tag(sync=True, **widget_serialization)
    
    globe = Instance(Globe, kw=None, args=None,allow_none=True).tag(sync=True, **widget_serialization)
    
    geo3D = Instance(Geo3D, kw=None, args=None,allow_none=True).tag(sync=True, **widget_serialization)
    
    mapbox3D = Instance(Mapbox3D, kw=None, args=None,allow_none=True).tag(sync=True, **widget_serialization)
    
    grid3D = Instance(Grid3D, kw=None, args=None,allow_none=True).tag(sync=True, **widget_serialization)
    
    xAxis3D = Instance(XAxis3D, kw=None, args=None,allow_none=True).tag(sync=True, **widget_serialization)
    
    yAxis3D = Instance(YAxis3D, kw=None, args=None,allow_none=True).tag(sync=True, **widget_serialization)
    
    zAxis3D = Instance(ZAxis3D, kw=None, args=None,allow_none=True).tag(sync=True, **widget_serialization)
    
        
