from traitlets import (
    Unicode, Dict, Float, Bool, Union,
)
from ..basewidget import BaseWidget


class Parallel(BaseWidget):
    """ 
:warning: **Autogenerated class**

**Introduction about Parallel coordinates**


[Parallel Coordinates](https://en.wikipedia.org/wiki/Parallel_coordinates) is a common way of visualizing high-dimensional geometry and analyzing multivariate data.


For example, [series-parallel.data](#series-parallel.data) is the following data:



```
[
    [1,  55,  9,   56,  0.46,  18,  6,  'good'],
    [2,  25,  11,  21,  0.65,  34,  9,  'excellent'],
    [3,  56,  7,   63,  0.3,   14,  5,  'good'],
    [4,  33,  7,   29,  0.33,  16,  6,  'excellent'],
    { // Data item can also be an Object, so that perticular settings of its line can be set here.
        value: [5,  42,  24,  44,  0.76,  40,  16, 'excellent']
        lineStyle: {...},
    }
    ...
]

```

In data above, each row is a "data item", and each column represents a "dimension". For example, the meanings of columns above are: "data", "AQI", "PM2.5", "PM10", "carbon monoxide level", "nitrogen dioxide level", and "sulfur dioxide level".


Parallel coordinates are often used to visualize multi-dimension data shown above. Each axis represents a dimension (namely, a column), and each line represents a data item. Data can be brush-selected on axes. For example:



**Brief about Configuration**


Basic configuration parallel coordinates is shown as follow:



```
option = {
    parallelAxis: [                     // Definitions of axes.
        {dim: 0, name: schema[0].text}, // Each axis has a 'dim' attribute, representing dimension index in data.
        {dim: 1, name: schema[1].text},
        {dim: 2, name: schema[2].text},
        {dim: 3, name: schema[3].text},
        {dim: 4, name: schema[4].text},
        {dim: 5, name: schema[5].text},
        {dim: 6, name: schema[6].text},
        {dim: 7, name: schema[7].text,
            type: 'category',           // Also supports category data.
            data: ['Excellent', 'good', 'light pollution', 'moderate pollution', 'heavy pollution', 'severe pollution']
        }
    ],
    parallel: {                         // Definition of a parallel coordinate system.
        left: '5%',                     // Location of parallel coordinate system.
        right: '13%',
        bottom: '10%',
        top: '20%',
        parallelAxisDefault: {          // A pattern for axis definition, which can avoid repeating in `parallelAxis`.
            type: 'value',
            nameLocation: 'end',
            nameGap: 20
        }
    },
    series: [                           // Here the three series sharing the same parallel coordinate system.
        {
            name: 'Beijing',
            type: 'parallel',           // The type of this series is 'parallel'
            data: [
                [1,  55,  9,   56,  0.46,  18,  6,  'good'],
                [2,  25,  11,  21,  0.65,  34,  9,  'excellent'],
                ...
            ]
        },
        {
            name: 'Shanghai',
            type: 'parallel',
            data: [
                [3,  56,  7,   63,  0.3,   14,  5,  'good'],
                [4,  33,  7,   29,  0.33,  16,  6,  'excellent'],
                ...
            ]
        },
        {
            name: 'Guangzhou',
            type: 'parallel',
            data: [
                [4,  33,  7,   29,  0.33,  16,  6,  'excellent'],
                [5,  42,  24,  44,  0.76,  40,  16, 'excellent'],
                ...
            ]
        }
    ]
};

```

Three components are involved here: [parallel](#parallel), [parallelAxis](#parallelAxis), [series-parallel](#series-parallel)


- [parallel](#parallel)


 This component is the coordinate system. One or more series (like "Beijing", "Shanghai", and "Guangzhou" in the above example) can share one coordinate system.


 Like other coordinate systems, multiple parallel coordinate systems can be created in one echarts instance.


 Position setting is also carried out here.
- [parallelAxis](#parallelAxis)


 This is axis configuration. Multiple axes are needed in parallel coordinates.


 [parallelAxis.parallelIndex](#parallelAxis.parallelIndex) is used to specify which coordinate system this axis belongs to. The first coordinate system is used by default.
- [series-parallel](#series-parallel)


 This is the definition of parallel series, which will be drawn on parallel coordinate system.


 [parallelAxis.parallelIndex](#parallelAxis.parallelIndex) is used to specify which coordinate system this axis belongs to. The first coordinate system is used by default.


**Notes and Best Practices**


When configuring multiple [parallelAxis](#parallelAxis), there might be some common attributes in each axis configuration. To avoid writing them repeatedly, they can be put under [parallel.parallelAxisDefault](#parallel.parallelAxisDefault). Before initializing axis, configurations in [parallel.parallelAxisDefault](#parallel.parallelAxisDefault) will be merged into [parallelAxis](#parallelAxis) to generate the final axis configuration.


**If data is too large and cause bad performance**


It is suggested to set [series-parallel.lineStyle.width](#series-parallel.lineStyle.width) to be `0.5` (or less), which may improve performance significantly.


**Display High-Dimension Data**


When dimension number is extremely large, say, more than 50 dimensions, there will be more than 50 axes, which may hardly display in a page.


In this case, you may use [parallel.axisExpandable](#parallel.axisExpandable) to improve the display. See this example:



  

  




    """

    def __init__(self, **kwargs):

        super().__init__(**kwargs)  
    
    _model_name = Unicode("ParallelModel").tag(sync=True)
    
    id = Unicode(None, allow_none=True, help="""Component ID, not specified by default. If specified, it can be used to refer the component in option or API.""").tag(sync=True)
    
    zlevel = Float(None, allow_none=True, help="""`zlevel` value of all graphical elements in .


`zlevel` is used to make layers with Canvas. Graphical elements with different `zlevel` values will be placed in different Canvases, which is a common optimization technique. We can put those frequently changed elements (like those with animations) to a separate `zlevel`. Notice that too many Canvases will increase memory cost, and should be used carefully on mobile phones to avoid crash.


Canvases with bigger `zlevel` will be placed on Canvases with smaller `zlevel`.""").tag(sync=True)
    
    z = Float(None, allow_none=True, help="""`z` value of all graphical elements in , which controls order of drawing graphical components. Components with smaller `z` values may be overwritten by those with larger `z` values.


`z` has a lower priority to `zlevel`, and will not create new Canvas.""").tag(sync=True)
    
    left = Union([Unicode(default_value=None, allow_none=True),Float(default_value=None, allow_none=True),], default_value=None, allow_none=True, help="""Distance between parallel component and the left side of the container.


`left` can be a pixel value like `20`; it can also be a percentage value relative to container width like `'20%'`; and it can also be `'left'`, `'center'`, or `'right'`.


If the `left` value is set to be `'left'`, `'center'`, or `'right'`, then the component will be aligned automatically based on position.""").tag(sync=True)
    
    top = Union([Unicode(default_value=None, allow_none=True),Float(default_value=None, allow_none=True),], default_value=None, allow_none=True, help="""Distance between parallel component and the top side of the container.


`top` can be a pixel value like `20`; it can also be a percentage value relative to container width like `'20%'`; and it can also be `'top'`, `'middle'`, or `'bottom'`.


If the `top` value is set to be `'top'`, `'middle'`, or `'bottom'`, then the component will be aligned automatically based on position.""").tag(sync=True)
    
    right = Union([Unicode(default_value=None, allow_none=True),Float(default_value=None, allow_none=True),], default_value=None, allow_none=True, help="""Distance between parallel component and the right side of the container.


`right` can be a pixel value like `20`; it can also be a percentage value relative to container width like `'20%'`.""").tag(sync=True)
    
    bottom = Union([Unicode(default_value=None, allow_none=True),Float(default_value=None, allow_none=True),], default_value=None, allow_none=True, help="""Distance between parallel component and the bottom side of the container.


`bottom` can be a pixel value like `20`; it can also be a percentage value relative to container width like `'20%'`.""").tag(sync=True)
    
    width = Union([Unicode(default_value=None, allow_none=True),Float(default_value=None, allow_none=True),], default_value=None, allow_none=True, help="""Width of parallel component. Adaptive by default.""").tag(sync=True)
    
    height = Union([Unicode(default_value=None, allow_none=True),Float(default_value=None, allow_none=True),], default_value=None, allow_none=True, help="""Height of parallel component. Adaptive by default.""").tag(sync=True)
    
    layout = Unicode(None, allow_none=True, help="""Layout modes, whose optional values are:


* `'horizontal'`: place each axis horizontally.
* `'vertical'`: place each axis vertically.""").tag(sync=True)
    
    axisExpandable = Bool(None, allow_none=True, help="""When dimension number is extremely large, say, more than 50 dimensions, there will be more than 50 axes, which may hardly display in a page.


In this case, you may use [parallel.axisExpandable](#parallel.axisExpandable) to improve the display. See this example:



Whether to enable toggling axis on clicking.""").tag(sync=True)
    
    axisExpandCenter = Float(None, allow_none=True, help="""Index of the axis which is used as the center of expanding initially. It doesn't have a default value, and needs to be assigned manually.


Please refer to <parallel.axisExpandable> for more information.""").tag(sync=True)
    
    axisExpandCount = Float(None, allow_none=True, help="""Defines how many axes are at expanding state initially. We'd suggest you assign this value manually according to dimensions.


Please refer to <parallel.axisExpandCenter> and <parallel.axisExpandable>.""").tag(sync=True)
    
    axisExpandWidth = Float(None, allow_none=True, help="""Distance between two axes when at expanding state, in pixels.


Please refer to <parallel.axisExpandable> for more information.""").tag(sync=True)
    
    axisExpandTriggerOn = Unicode(None, allow_none=True, help="""Optional values:


* `'click'`: Trigger expanding when mouse clicking.
* `'mousemove'`: Trigger expanding when mouse hovering.""").tag(sync=True)
    
    parallelAxisDefault = Dict(default_value=None, allow_none=True, help="""When configuring multiple [parallelAxis](#parallelAxis), there might be some common attributes in each axis configuration. To avoid writing them repeatedly, they can be put under [parallel.parallelAxisDefault](#parallel.parallelAxisDefault). Before initializing axis, configurations in [parallel.parallelAxisDefault](#parallel.parallelAxisDefault) will be merged into [parallelAxis](#parallelAxis) to generate the final axis configuration.


[See the sample](https://echarts.apache.org/examples/en/editor.html?c=doc-example/parallel-all&edit=1&reset=1).""").tag(sync=True)
    
        
