from traitlets import (
    Unicode, Dict, Float, Union, Any,
)
from ..basewidget import BaseWidget


class Polar(BaseWidget):
    """ 
:warning: **Autogenerated class**

Polar coordinate can be used in scatter and line chart. Every polar coordinate has an [angleAxis](#angleAxis) and a [radiusAxis](#radiusAxis).


**For example:** 




    """

    def __init__(self, **kwargs):

        super().__init__(**kwargs)  
    
    _model_name = Unicode("PolarModel").tag(sync=True)
    
    id = Unicode(None, allow_none=True, help="""Component ID, not specified by default. If specified, it can be used to refer the component in option or API.""").tag(sync=True)
    
    zlevel = Float(None, allow_none=True, help="""`zlevel` value of all graphical elements in .


`zlevel` is used to make layers with Canvas. Graphical elements with different `zlevel` values will be placed in different Canvases, which is a common optimization technique. We can put those frequently changed elements (like those with animations) to a separate `zlevel`. Notice that too many Canvases will increase memory cost, and should be used carefully on mobile phones to avoid crash.


Canvases with bigger `zlevel` will be placed on Canvases with smaller `zlevel`.""").tag(sync=True)
    
    z = Float(None, allow_none=True, help="""`z` value of all graphical elements in , which controls order of drawing graphical components. Components with smaller `z` values may be overwritten by those with larger `z` values.


`z` has a lower priority to `zlevel`, and will not create new Canvas.""").tag(sync=True)
    
    center = Any(None, allow_none=True, help="""Center position of Polar coordinate, the first of which is the horizontal position, and the second is the vertical position.


Percentage is supported. When set in percentage, the item is relative to the container width, and the second item to the height.


**Example:** 



```
// Set to absolute pixel values
center: [400, 300]
// Set to relative percent
center: ['50%', '50%']

```""").tag(sync=True)
    
    radius = Union([Float(default_value=None, allow_none=True),Unicode(default_value=None, allow_none=True),Any(default_value=None, allow_none=True),], default_value=None, allow_none=True, help="""Radius of Polar coordinate. Value can be:


* `number`: Specify outside radius directly.
* `string`: For example, `'20%'`, means that the outside radius is 20% of the viewport size (the little one between width and height of the chart container).


* `Array.<number|string>`: The first item specifies the inside radius, and the second item specifies the outside radius. Each item follows the definitions above.""").tag(sync=True)
    
    tooltip = Dict(default_value=None, allow_none=True, help="""tooltip settings in the coordinate system component.


**General Introduction:**


tooltip can be configured on different places:


* Configured on global: [tooltip](#tooltip)
* Configured in a coordinate system: [grid.tooltip](#grid.tooltip), [polar.tooltip](#polar.tooltip), [single.tooltip](#single.tooltip)
* Configured in a series: [series.tooltip](#series.tooltip)
* Configured in each item of `series.data`: [series.data.tooltip](#series.data.tooltip)""").tag(sync=True)
    
        
