from traitlets import (
    Unicode, Dict, Float, Bool, Union, Any,
)
from ..basewidget import BaseWidget


class Radar(BaseWidget):
    """ 
:warning: **Autogenerated class**

Coordinate for [radar charts](#series-radar). This component is equal to the polar component in ECharts 2. Because the polar component in the echarts 3 is reconstructed to be the standard polar coordinate component, this component is renamed to be radar to avoid confusion.


Radar chart coordinate is different from polar coordinate, in that every axis indicator of the radar chart coordinate is an individual dimension. The style of indicator coordinate axis could be configured through the following configuration items, including [name](#radar.name), [axisLine](#radar.axisLine), [axisTick](#radar.axisTick), [axisLabel](#radar.axisLabel), [splitLine](#radar.splitLine), [splitArea](#radar.splitArea).


Here is a custom example of radar component.




    """

    def __init__(self, **kwargs):

        super().__init__(**kwargs)  
    
    _model_name = Unicode("RadarModel").tag(sync=True)
    
    id = Unicode(None, allow_none=True, help="""Component ID, not specified by default. If specified, it can be used to refer the component in option or API.""").tag(sync=True)
    
    zlevel = Float(None, allow_none=True, help="""`zlevel` value of all graphical elements in .


`zlevel` is used to make layers with Canvas. Graphical elements with different `zlevel` values will be placed in different Canvases, which is a common optimization technique. We can put those frequently changed elements (like those with animations) to a separate `zlevel`. Notice that too many Canvases will increase memory cost, and should be used carefully on mobile phones to avoid crash.


Canvases with bigger `zlevel` will be placed on Canvases with smaller `zlevel`.""").tag(sync=True)
    
    z = Float(None, allow_none=True, help="""`z` value of all graphical elements in , which controls order of drawing graphical components. Components with smaller `z` values may be overwritten by those with larger `z` values.


`z` has a lower priority to `zlevel`, and will not create new Canvas.""").tag(sync=True)
    
    center = Any(None, allow_none=True, help="""Center position of , the first of which is the horizontal position, and the second is the vertical position.


Percentage is supported. When set in percentage, the item is relative to the container width, and the second item to the height.


**Example:** 



```
// Set to absolute pixel values
center: [400, 300]
// Set to relative percent
center: ['50%', '50%']

```""").tag(sync=True)
    
    radius = Union([Float(default_value=None, allow_none=True),Unicode(default_value=None, allow_none=True),Any(default_value=None, allow_none=True),], default_value=None, allow_none=True, help="""Radius of . Value can be:


* `number`: Specify outside radius directly.
* `string`: For example, `'20%'`, means that the outside radius is 20% of the viewport size (the little one between width and height of the chart container).


* `Array.<number|string>`: The first item specifies the inside radius, and the second item specifies the outside radius. Each item follows the definitions above.""").tag(sync=True)
    
    startAngle = Float(None, allow_none=True, help="""The start angle of coordinate, which is the angle of the first indicator axis.""").tag(sync=True)
    
    axisName = Dict(default_value=None, allow_none=True, help="""Name options for radar indicators.""").tag(sync=True)
    
    nameGap = Float(None, allow_none=True, help="""Distance between the indicator's name and axis.""").tag(sync=True)
    
    splitNumber = Float(None, allow_none=True, help="""Segments of indicator axis.""").tag(sync=True)
    
    shape = Unicode(None, allow_none=True, help="""Radar render type, in which `'polygon'` and `'circle'` are supported.""").tag(sync=True)
    
    scale = Bool(None, allow_none=True, help="""Whether to prevent calculating the scaling relative to zero. If it is set to be `true`, the coordinate tick would not compulsorily contain zero value, which is usually useful in scatter diagram of double numerical values axis.""").tag(sync=True)
    
    silent = Bool(None, allow_none=True, help="""Set this to `true`, to prevent interaction with the axis.""").tag(sync=True)
    
    triggerEvent = Bool(None, allow_none=True, help="""Set this to `true` to enable triggering events.


Parameters of the event include:



```
{
    // Component type: xAxis, yAxis, radiusAxis, angleAxis
    // Each of which has an attribute for index, e.g., xAxisIndex for xAxis
    componentType: string,
    // Value on axis before being formatted.
    // Click on value label to trigger event.
    value: '',
    // Name of axis.
    // Click on laben name to trigger event.
    name: ''
}

```""").tag(sync=True)
    
    axisLine = Dict(default_value=None, allow_none=True, help="""Settings related to axis line.""").tag(sync=True)
    
    axisTick = Dict(default_value=None, allow_none=True, help="""Settings related to axis tick.""").tag(sync=True)
    
    axisLabel = Dict(default_value=None, allow_none=True, help="""Settings related to axis label.""").tag(sync=True)
    
    splitLine = Dict(default_value=None, allow_none=True, help="""Split line of axis in [grid](#grid) area.""").tag(sync=True)
    
    splitArea = Dict(default_value=None, allow_none=True, help="""Split area of axis in [grid](#grid) area, not shown by default.""").tag(sync=True)
    
    indicator = Any(None, allow_none=True, help="""Indicator of radar chart, which is used to assign multiple variables(dimensions) in radar chart. Here is the example.



```
indicator: [
   { name: 'Sales (sales) ', max: 6500},
   { name: 'Administration (Administration) ', max: 16000, color: 'red'}, // Set the indicator as 'red'
   { name: 'Information Technology (Information Technology) ', max: 30000},
   { name: 'Customer Support (Customer Support) ', max: 38000},
   { name: 'Development (Development) ', max: 52000},
   { name: 'Marketing (Marketing) ', max: 25000}
]

```""").tag(sync=True)
    
        
