from ipywidgets import (
    widget_serialization
)
from traitlets import (
    Unicode, Instance, List, Union,
)
from ..basewidget import BaseWidget

from .seriesitems.line import Line
from .seriesitems.bar import Bar
from .seriesitems.pie import Pie
from .seriesitems.scatter import Scatter
from .seriesitems.effectscatter import EffectScatter
from .seriesitems.seriesradar import SeriesRadar
from .seriesitems.tree import Tree
from .seriesitems.treemap import Treemap
from .seriesitems.sunburst import Sunburst
from .seriesitems.boxplot import Boxplot
from .seriesitems.candlestick import Candlestick
from .seriesitems.heatmap import Heatmap
from .seriesitems.map import Map
from .seriesitems.seriesparallel import SeriesParallel
from .seriesitems.lines import Lines
from .seriesitems.graph import Graph
from .seriesitems.sankey import Sankey
from .seriesitems.funnel import Funnel
from .seriesitems.gauge import Gauge
from .seriesitems.pictorialbar import PictorialBar
from .seriesitems.themeriver import ThemeRiver
from .seriesitems.custom import Custom
from .seriesitems.scatter3d import Scatter3D
from .seriesitems.bar3d import Bar3D
from .seriesitems.line3d import Line3D
from .seriesitems.lines3d import Lines3D
from .seriesitems.map3d import Map3D
from .seriesitems.surface import Surface
from .seriesitems.polygons3d import Polygons3D
from .seriesitems.scattergl import ScatterGL
from .seriesitems.graphgl import GraphGL
from .seriesitems.flowgl import FlowGL

class Series(BaseWidget):
    """ 
:warning: **Autogenerated class**


    """

    def __init__(self, **kwargs):

        super().__init__(**kwargs)  
    
    _model_name = Unicode("SeriesModel").tag(sync=True)
    
    series = List(trait=Union([Instance(Line, kw=None, args=None, allow_none=True).tag(sync=True, **widget_serialization),Instance(Bar, kw=None, args=None, allow_none=True).tag(sync=True, **widget_serialization),Instance(Pie, kw=None, args=None, allow_none=True).tag(sync=True, **widget_serialization),Instance(Scatter, kw=None, args=None, allow_none=True).tag(sync=True, **widget_serialization),Instance(EffectScatter, kw=None, args=None, allow_none=True).tag(sync=True, **widget_serialization),Instance(SeriesRadar, kw=None, args=None, allow_none=True).tag(sync=True, **widget_serialization),Instance(Tree, kw=None, args=None, allow_none=True).tag(sync=True, **widget_serialization),Instance(Treemap, kw=None, args=None, allow_none=True).tag(sync=True, **widget_serialization),Instance(Sunburst, kw=None, args=None, allow_none=True).tag(sync=True, **widget_serialization),Instance(Boxplot, kw=None, args=None, allow_none=True).tag(sync=True, **widget_serialization),Instance(Candlestick, kw=None, args=None, allow_none=True).tag(sync=True, **widget_serialization),Instance(Heatmap, kw=None, args=None, allow_none=True).tag(sync=True, **widget_serialization),Instance(Map, kw=None, args=None, allow_none=True).tag(sync=True, **widget_serialization),Instance(SeriesParallel, kw=None, args=None, allow_none=True).tag(sync=True, **widget_serialization),Instance(Lines, kw=None, args=None, allow_none=True).tag(sync=True, **widget_serialization),Instance(Graph, kw=None, args=None, allow_none=True).tag(sync=True, **widget_serialization),Instance(Sankey, kw=None, args=None, allow_none=True).tag(sync=True, **widget_serialization),Instance(Funnel, kw=None, args=None, allow_none=True).tag(sync=True, **widget_serialization),Instance(Gauge, kw=None, args=None, allow_none=True).tag(sync=True, **widget_serialization),Instance(PictorialBar, kw=None, args=None, allow_none=True).tag(sync=True, **widget_serialization),Instance(ThemeRiver, kw=None, args=None, allow_none=True).tag(sync=True, **widget_serialization),Instance(Custom, kw=None, args=None, allow_none=True).tag(sync=True, **widget_serialization),Instance(Scatter3D, kw=None, args=None, allow_none=True).tag(sync=True, **widget_serialization),Instance(Bar3D, kw=None, args=None, allow_none=True).tag(sync=True, **widget_serialization),Instance(Line3D, kw=None, args=None, allow_none=True).tag(sync=True, **widget_serialization),Instance(Lines3D, kw=None, args=None, allow_none=True).tag(sync=True, **widget_serialization),Instance(Map3D, kw=None, args=None, allow_none=True).tag(sync=True, **widget_serialization),Instance(Surface, kw=None, args=None, allow_none=True).tag(sync=True, **widget_serialization),Instance(Polygons3D, kw=None, args=None, allow_none=True).tag(sync=True, **widget_serialization),Instance(ScatterGL, kw=None, args=None, allow_none=True).tag(sync=True, **widget_serialization),Instance(GraphGL, kw=None, args=None, allow_none=True).tag(sync=True, **widget_serialization),Instance(FlowGL, kw=None, args=None, allow_none=True).tag(sync=True, **widget_serialization),]), allow_none=True, default_value=None).tag(sync=True, **widget_serialization)
    
        
