from traitlets import (
    Unicode, Dict, Float, Bool, Union, Any,
)
from ..basewidget import BaseWidget


class Bar(BaseWidget):
    """ 
:warning: **Autogenerated class**

**bar chart**


Bar chart shows different data through the height of a bar, which is used in [rectangular coordinate](#grid) with at least 1 category axis.



    """

    def __init__(self, **kwargs):

        super().__init__(**kwargs)  
    
    _model_name = Unicode("BarModel").tag(sync=True)
    
    type = Unicode("bar", allow_none=True, ).tag(sync=True)
    
    id = Unicode(None, allow_none=True, help="""Component ID, not specified by default. If specified, it can be used to refer the component in option or API.""").tag(sync=True)
    
    name = Unicode(None, allow_none=True, help="""Series name used for displaying in [tooltip](#tooltip) and filtering with [legend](#legend), or updating data and configuration with `setOption`.""").tag(sync=True)
    
    colorBy = Unicode(None, allow_none=True, help="""> Since `v5.2.0`


The policy to take color from [option.color](#color). Valid values:


* `'series'`: assigns the colors in the palette by series, so that all data in the same series are in the same color;
* `'data'`: assigns colors in the palette according to data items, with each data item using a different color.""").tag(sync=True)
    
    legendHoverLink = Bool(None, allow_none=True, help="""Whether to enable highlighting chart when [legend](#legend) is being hovered.""").tag(sync=True)
    
    coordinateSystem = Unicode(None, allow_none=True, help="""The coordinate used in the series, whose options are:


* `'cartesian2d'`


 Use a two-dimensional rectangular coordinate (also known as Cartesian coordinate), with [xAxisIndex](#series-bar.xAxisIndex) and [yAxisIndex](#series-bar.yAxisIndex) to assign the corresponding axis component.


* `'polar'`


 Use polar coordinates, with [polarIndex](#series-bar.polarIndex) to assign the corresponding polar coordinate component.""").tag(sync=True)
    
    xAxisIndex = Float(None, allow_none=True, help="""Index of [x axis](#xAxis) to combine with, which is useful for multiple x axes in one chart.""").tag(sync=True)
    
    yAxisIndex = Float(None, allow_none=True, help="""Index of [y axis](#yAxis) to combine with, which is useful for multiple y axes in one chart.""").tag(sync=True)
    
    polarIndex = Float(None, allow_none=True, help="""Index of [polar coordinate](#polar) to combine with, which is useful for multiple polar axes in one chart.""").tag(sync=True)
    
    roundCap = Bool(None, allow_none=True, help="""> Since `v4.5.0`


Whether to add round caps at the end of the bar sectors. Valid only for bar series on polar coordinates.""").tag(sync=True)
    
    realtimeSort = Bool(None, allow_none=True, help="""Whether to enable realtime sorting, which is used for bar-racing effect. Please refer to the tutorial [Dynamic Sorting Bar Chart](https://echarts.apache.org/handbook/en/how-to/chart-types/bar/bar-race/) in the Handbook.""").tag(sync=True)
    
    showBackground = Bool(None, allow_none=True, help="""> Since `v4.7.0`


Whether to show background behind each bar. Use [backgroundStyle](#series-bar.backgroundStyle) to set background style.""").tag(sync=True)
    
    backgroundStyle = Dict(default_value=None, allow_none=True, help="""> Since `v4.7.0`


Background style of each bar if [showBackground](#series-bar.showBackground) is set to be `true`.""").tag(sync=True)
    
    label = Dict(default_value=None, allow_none=True, help="""Text label of , to explain some data information about graphic item like value, name and so on. `label` is placed under `itemStyle` in ECharts 2.x. In ECharts 3, to make the configuration structure flatter, `label`is taken to be at the same level with `itemStyle`, and has `emphasis` as `itemStyle` does.""").tag(sync=True)
    
    labelLine = Dict(default_value=None, allow_none=True, help="""> Since `v5.0.0`


Configuration of label guide line.""").tag(sync=True)
    
    itemStyle = Dict(default_value=None, allow_none=True, help="""Graphic style of , `emphasis` is the style when it is highlighted, like being hovered by mouse, or highlighted via legend connect.""").tag(sync=True)
    
    labelLayout = Union([Any(default_value=None, allow_none=True),Any(default_value=None, allow_none=True),], default_value=None, allow_none=True, help="""> Since `v5.0.0`


Unified layout configuration of labels.


It provide a chance to adjust the labels' `(x, y)` position, alignment based on the original layout each series provides.


This option can be a callback with following parameters.



```
// corresponding index of data
dataIndex: number
// corresponding type of data. Only available in graph, in which it can be 'node' or 'edge'
dataType?: string
// corresponding index of series
seriesIndex: number
// Displayed text of label.
text: string
// Bounding rectangle of label.
labelRect: {x: number, y: number, width: number, height: number}
// Horizontal alignment of label.
align: 'left' | 'center' | 'right'
// Vertical alignment of label.
verticalAlign: 'top' | 'middle' | 'bottom'
// Bounding rectangle of the element corresponding to.
rect: {x: number, y: number, width: number, height: number}
// Default points array of labelLine. Currently only provided in pie and funnel series.
// It's null in other series.
labelLinePoints?: number[][]

```

**Example:**


Align the labels on the right. Left 10px margin to the edge.



```
labelLayout(params) {
    return {
        x: params.rect.x + 10,
        y: params.rect.y + params.rect.height / 2,
        verticalAlign: 'middle',
        align: 'left'
    }
}

```

Set the text size based on the size of element bounding rectangle.



```

labelLayout(params) {
    return {
        fontSize: Math.max(params.rect.width / 10, 5)
    };
}

```""").tag(sync=True)
    
    emphasis = Dict(default_value=None, allow_none=True, help="""Configurations of emphasis state.""").tag(sync=True)
    
    blur = Dict(default_value=None, allow_none=True, help="""Configurations of blur state. Available when [emphasis.focus](#series-bar.emphasis.focus) is set.""").tag(sync=True)
    
    select = Dict(default_value=None, allow_none=True, help="""> Since `v5.0.0`


Configurations of select state. Available when [selectedMode](#series-bar.selectedMode) is set.""").tag(sync=True)
    
    selectedMode = Union([Bool(default_value=None, allow_none=True),Unicode(default_value=None, allow_none=True),], default_value=None, allow_none=True, help="""> Since `v5.0.0`


Selected mode. It is enabled by default, and you may set it to be `false` to disable it.


Besides, it can be set to `'single'`, `'multiple'` or `'series'`, for single selection, multiple selections and whole series selection.



> `'series'` is supported since v5.3.0""").tag(sync=True)
    
    stack = Unicode(None, allow_none=True, help="""Name of stack. On the same category axis, the series with the same `stack` name would be put on top of each other.


See also [stackStrategy](#series-bar.stackStrategy) on how to customize how values are stacked.


Notice: `stack` only supports stacking on `value` and `log` axis for now. `time` and `category` axis are not supported.""").tag(sync=True)
    
    stackStrategy = Unicode(None, allow_none=True, help="""> Since `v5.3.3`


How to stack values if the [stack](#series-bar.stack) property has been set. Options:


* `'samesign'`: only stack values if the value to be stacked has the same sign as the currently cumulated stacked value.
* `'all'`: stack all values, irrespective of the signs of the current or cumulative stacked value.
* `'positive'`: only stack positive values.
* `'negative'`: only stack negative values.""").tag(sync=True)
    
    sampling = Unicode(None, allow_none=True, help="""The downsampling strategy used when the data size is much larger than pixel size. It will improve the performance when turned on. Defaults to be turned off, indicating that all the data points will be drawn.


Options:


* `'lttb'` Use Largest-Triangle-Three-Bucket algorithm to filter points. It will keep the trends and extremas.
* `'average'` Use average value of filter points
* `'min'` Use minimum value of filter points
* `'max'` Use maximum value of filter points
* `'minmax'` Use maximum extremum absolute value of filter points (Since `v5.5.0`)
* `'sum'` Use sum of filter points""").tag(sync=True)
    
    cursor = Unicode(None, allow_none=True, help="""The mouse style when mouse hovers on an element, the same as `cursor` property in `CSS`.""").tag(sync=True)
    
    barWidth = Union([Float(default_value=None, allow_none=True),Unicode(default_value=None, allow_none=True),], default_value=None, allow_none=True, help="""The width of the bar. Adaptive when not specified.


Can be an absolute value like `40` or a percent value like `'60%'`. The percent is based on the calculated category width.


In a single coordinate system, this attribute is shared by multiple `'bar'` series. This attribute should be set on the last `'bar'` series in the coordinate system, then it will be adopted by all `'bar'` series in the coordinate system.""").tag(sync=True)
    
    barMaxWidth = Union([Float(default_value=None, allow_none=True),Unicode(default_value=None, allow_none=True),], default_value=None, allow_none=True, help="""The maximum width of the bar.


Has higher priority than [barWidth](#series-bar.barWidth).


Can be an absolute value like `40` or a percent value like `'60%'`. The percent is based on the calculated category width.


In a single coordinate system, this attribute is shared by multiple `'bar'` series. This attribute should be set on the last `'bar'` series in the coordinate system, then it will be adopted by all `'bar'` series in the coordinate system.""").tag(sync=True)
    
    barMinWidth = Union([Float(default_value=None, allow_none=True),Unicode(default_value=None, allow_none=True),], default_value=None, allow_none=True, help="""The minimum width of the bar. In cartesian the default value is `1`, otherwise the default value if `null`.


Has higher priority than [barWidth](#series-bar.barWidth).


Can be an absolute value like `40` or a percent value like `'60%'`. The percent is based on the calculated category width.


In a single coordinate system, this attribute is shared by multiple `'bar'` series. This attribute should be set on the last `'bar'` series in the coordinate system, then it will be adopted by all `'bar'` series in the coordinate system.""").tag(sync=True)
    
    barMinHeight = Float(None, allow_none=True, help="""The minimum width of bar. It could be used to avoid the following situation: the interaction would be affected when the value of some data item is too small.""").tag(sync=True)
    
    barMinAngle = Float(None, allow_none=True, help="""The minimum angle of bar. It could be used to avoid the following situation: the interaction would be affected when the value of some data item is too small. Valid only for bar series on polar coordinates.""").tag(sync=True)
    
    barGap = Unicode(None, allow_none=True, help="""The gap between bars between different series, is a percent value like `'30%'`, which means `30%` of the bar width.


Set barGap as `'-100%'` can overlap bars that belong to different series, which is useful when making a series of bar be background.


In a single coordinate system, this attribute is shared by multiple `'bar'` series. This attribute should be set on the last `'bar'` series in the coordinate system, then it will be adopted by all `'bar'` series in the coordinate system.


For example:""").tag(sync=True)
    
    barCategoryGap = Unicode(None, allow_none=True, help="""The bar gap of a single series, defaults to be `20%` of the category gap, can be set as a fixed value.


In a single coordinate system, this attribute is shared by multiple `'bar'` series. This attribute should be set on the last `'bar'` series in the coordinate system, then it will be adopted by all `'bar'` series in the coordinate system.""").tag(sync=True)
    
    large = Bool(None, allow_none=True, help="""Whether to enable the optimization of large-scale data. It could be set when large data causes performance problem.


After being enabled, `largeThreshold` can be used to indicate the minimum number for turning on the optimization.


But when the optimization enabled, the style of single data item can't be customized any more.""").tag(sync=True)
    
    largeThreshold = Float(None, allow_none=True, help="""The threshold enabling the drawing optimization.""").tag(sync=True)
    
    progressive = Float(None, allow_none=True, help="""`progressive` specifies the amount of graphic elements that can be rendered within a frame (about 16ms) if "progressive rendering" enabled.


When data amount is from thousand to more than 10 million, it will take too long time to render all of the graphic elements. Since ECharts 4, "progressive rendering" is supported in its workflow, which processes and renders data chunk by chunk alone with each frame, avoiding to block the UI thread of the browser.


Set `progressive: 0` to disable progressive permanently. By default, progressive is auto-enabled when data amount is bigger than `progressiveThreshold`.""").tag(sync=True)
    
    progressiveThreshold = Float(None, allow_none=True, help="""If current data amount is over the threshold, "progressive rendering" is enabled.""").tag(sync=True)
    
    progressiveChunkMode = Unicode(None, allow_none=True, help="""Chunk approach, optional values:


* `'sequential'`: slice data by data index.
* `'mod'`: slice data by mod, which make the data items of each chunk coming from all over the data, bringing better visual effect while progressive rendering.""").tag(sync=True)
    
    dimensions = Any(None, allow_none=True, help="""`dimensions` can be used to define dimension info for `series.data` or `dataset.source`.


Notice: if [dataset](#dataset) is used, we can definite dimensions in [dataset.dimensions](#dataset.dimensions), or provide dimension names in the first column/row of [dataset.source](#dataset.source), and not need to specify `dimensions` here. But if `dimensions` is specified here, it will be used despite the dimension definitions in dataset.


For example:



```
option = {
    dataset: {
        source: [
            // 'date', 'open', 'close', 'highest', 'lowest'
            [12, 44, 55, 66, 2],
            [23, 6, 16, 23, 1],
            ...
        ]
    },
    series: {
        type: 'xxx',
        // Specify name for each dimensions, which will be displayed in tooltip.
        dimensions: ['date', 'open', 'close', 'highest', 'lowest']
    }
}

```


```
series: {
    type: 'xxx',
    dimensions: [
        null,                // If you do not intent to defined this dimension, use null is fine.
        {type: 'ordinal'},   // Specify type of this dimension.
                             // 'ordinal' is always used in string.
                             // If type is not specified, echarts will guess type by data.
        {name: 'good', type: 'number'},
        'bad'                // Equals to {name: 'bad'}.
    ]
}

```

Each data item of `dimensions` can be:


* `string`, for example, `'someName'`, which equals to `{name: 'someName'}`.
* `Object`, where the attributes can be:
	+ name: `string`.
	+ type: `string`, supports:
		- `number`
		- `float`, that is, [Float64Array](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Float64Array)
		- `int`, that is, [Int32Array](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Int32Array)
		- `ordinal`, discrete value, which represents string generally.
		- `time`, time value, see [data](#series.data) to check the format of time value.
	+ displayName: `string`, generally used in tooltip for dimension display. If not specified, use `name` by default.


When `dimensions` is specified, the default `tooltip` will be displayed vertically, which is better to show dimension names. Otherwise, `tooltip` will displayed only value horizontally.""").tag(sync=True)
    
    encode = Dict(default_value=None, allow_none=True, help="""Define what is encoded to for each dimension of `data`. For example:



```
option = {
    dataset: {
        source: [
            // Each column is called a dimension.
            // There are five dimensions: 0, 1, 2, 3, 4.
            [12, 44, 55, 66, 2],
            [23, 6, 16, 23, 1],
            ...
        ]
    },
    series: {
        type: 'xxx',
        encode: {
            x: [3, 1, 5],      // Dimension 3, 1, 5 is mapped to x axis.
            y: 2,              // Dimension 2 is mapped to y axis.
            tooltip: [3, 2, 4] // Dimension 3, 2, 4 will be displayed in tooltip.
        }
    }
}

```

When [dimensions](#series.dimensions) is used to defined name for a certain dimension, `encode` can refer the name directly. For example:



```
series: {
    type: 'xxx',
    dimensions: ['date', 'open', 'close', 'highest', 'lowest'],
    encode: {
        x: 'date',
        y: ['open', 'close', 'highest', 'lowest']
    }
}

```

The basic structure of [encode](option.html#series.encode) is illustrated as follows, where the left part of colon is the name of axis like `'x'`, `'y'`, `'radius'`, `'angle'` or some special reserved names like "tooltip", "itemName" etc., and the right part of the colon is the dimension names or dimension indices (based on 0). One or more dimensions can be specified. Usually not all of mappings need to be specified, only specify needed ones.


The properties available in `encode` listed as follows:



```
// In any of the series and coordinate systems,
// these properties are available:
encode: {
    // Display dimension "product" and "score" in the tooltip.
    tooltip: ['product', 'score']
    // Set the series name as the concat of the names of dimensions[1] and dimensions[3].
    // (sometimes the dimension names are too long to type in series.name manually).
    seriesName: [1, 3],
    // Using dimensions[2] as the id of each data item. This is useful when dynamically
    // update data by `chart.setOption()`, where the new and old data item can be
    // corresponded by id, by which the appropriate animation can be performed when updating.
    itemId: 2,
    // Using dimensions[3] as the name of each data item. This is useful in charts like
    // 'pie', 'funnel', where data item name can be displayed in legend.
    itemName: 3,
    // Using dimensions[4] as the group ID for each data item. With universalTransition enabled,
    // the data items from the old option and those from the new one, if sharing a same group ID,
    // will then be matched and applied to a proper animation after `setOption` is called.
    itemGroupId: 4,
    // Using dimension[5] as the child group ID for each data item. This option is introduced to
    // make multiple levels drilldown and aggregation animation come true. See childGroupId for more.
    // Since v5.5.0
    itemChildGroupId: 5
}

// These properties only work in cartesian(grid) coordinate system:
encode: {
    // Map dimensions[1], dimensions[5] and dimension "score" to the X axis.
    x: [1, 5, 'score'],
    // Map dimensions[0] to the Y axis.
    y: 0
}

// These properties only work in polar coordinate system:
encode: {
    radius: 3,
    angle: 2,
    ...
}

// These properties only work in geo coordinate system:
encode: {
    lng: 3,
    lat: 2
}

// For some type of series that are not in any coordinate system,
// like 'pie', 'funnel' etc.:
encode: {
    value: 3
}

```

This is an [example](https://echarts.apache.org/examples/en/view.html?c=dataset-encode1&edit=1&reset=1) for `encode`.


Specially, in [custom series(~series-custom), some property in `encode`, corresponding to axis, can be set as null to make the series not controlled by the axis, that is, the series data will not be count in the extent of the axis, and the [dataZoom](#dataZoom) on the axis will not filter the series.



```
var option = {
    xAxis: {},
    yAxis: {},
    dataZoom: [{
        xAxisIndex: 0
    }, {
        yAxisIndex: 0
    }],
    series: {
        type: 'custom',
        renderItem: function (params, api) {
            return {
                type: 'circle',
                shape: {
                    cx: 100, // x position is always 100
                    cy: api.coord([0, api.value(0)])[1],
                    r: 30
                },
                style: {
                    fill: 'blue'
                }
            };
        },
        encode: {
            // Then the series will not be controlled
            // by x axis and corresponding dataZoom.
            x: -1,
            y: 1
        },
        data: [ ... ]
    }
};

```""").tag(sync=True)
    
    seriesLayoutBy = Unicode(None, allow_none=True, help="""When [dataset](#dataset) is used, `seriesLayoutBy` specifies whether the column or the row of `dataset` is mapped to the series, namely, the series is "layout" on columns or rows. Optional values:


* 'column': by default, the columns of `dataset` are mapped the series. In this case, each column represents a dimension.
* 'row'：the rows of `dataset` are mapped to the series. In this case, each row represents a dimension.


Check this [example](https://echarts.apache.org/examples/en/editor.html?c=dataset-series-layout-by).""").tag(sync=True)
    
    datasetIndex = Float(None, allow_none=True, help="""If [series.data](#series.data) is not specified, and [dataset](#dataset) exists, the series will use `dataset`. `datasetIndex` specifies which dataset will be used.""").tag(sync=True)
    
    dataGroupId = Unicode(None, allow_none=True, help="""A group ID assigned to all data items in the series.


This option has a lower priority than `groupId`, which means when `groupId` is specified for a certain data item the `dataGroupId` will be simply ignored for that data item. For more information, please see `series.data.groupId`.""").tag(sync=True)
    
    data = Any(None, allow_none=True, help="""Data array of series, which can be in the following forms:


Notice, if no `data` specified in series, and there is [dataset](#dataset) in option, series will use the first [dataset](#dataset) as its datasource. If `data` has been specified, [dataset](#dataset) will not used.


`series.datasetIndex` can be used to specify other [dataset](#dataset).


Basically, data is represented by a two-dimension array, like the example below, where each column is named as a "dimension".



```
series: [{
    data: [
        // dimX   dimY   other dimensions ...
        [  3.4,    4.5,   15,   43],
        [  4.2,    2.3,   20,   91],
        [  10.8,   9.5,   30,   18],
        [  7.2,    8.8,   18,   57]
    ]
}]

```

* In [cartesian (grid)](#grid), "dimX" and "dimY" correspond to [xAxis](#xAxis) and [yAxis](#yAxis) respectively.
* In [polar](#polar) "dimX" and "dimY" correspond to [radiusAxis](#radiusAxis) and [angleAxis](#angleAxis) respectively.
* Other dimensions are optional, which can be used in other places. For example:
	+ [visualMap](#visualMap) can map one or more dimensions to visual (color, symbol size ...).
	+ [series.symbolSize](#series.symbolSize) can be set as a callback function, where symbol size can be calculated by values of a certain dimension.
	+ Values in other dimensions can be shown by [tooltip.formatter](#tooltip.formatter) or [series.label.formatter](#series.label.formatter).


Especially, when there is one and only one category axis (axis.type is `'category'`), data can be simply be represented by a one-dimension array, like:



```
xAxis: {
    data: ['a', 'b', 'm', 'n']
},
series: [{
    // Each item corresponds to each item in xAxis.data.
    data: [23,  44,  55,  19]
    // In fact, it is the simplification of the format below:
    // data: [[0, 23], [1, 44], [2, 55], [3, 19]]
}]

```

  

**Relationship between "value" and [axis.type](#xAxis.type)**


* When a dimension corresponds to a value axis (axis.type is `'value'` or `'log'`):


 The value can be a `number` (like `12`) (can also be a number in a `string` format, like `'12'`).
* When a dimension corresponds to a category axis (axis.type is `'category'`):


 The value should be the ordinal of the axis.data (based on `0`), the string value of the axis.data. For example:



```
  xAxis: {
      type: 'category',
      data: ['Monday', 'Tuesday', 'Wednesday', 'Thursday']
  },
  yAxis: {
      type: 'category',
      data: ['a', 'b', 'm', 'n', 'p', 'q']
  },
  series: [{
      data: [
          // xAxis      yAxis
          [  0,           0,    2  ], // This point is located at xAxis: 'Monday', yAxis: 'a'.
          [  'Thursday',  2,    1  ], // This point is located at xAxis: 'Thursday', yAxis: 'm'.
          [  2,          'p',   2  ], // This point is located at xAxis: 'Wednesday', yAxis: 'p'.
          [  3,           3,    5  ]
      ]
  }]

```

 There is an example of double category axes: [Github Punchcard](https://echarts.apache.org/examples/en/editor.html?c=scatter-punchCard).
* When a dimension corresponds to a time axis (type is `'time'`), the value can be:


	+ a timestamp, like `1484141700832`, which represents a UTC time.
	+ a date string, in one of the formats below:
		- a subset of [ISO 8601](https://www.ecma-international.org/ecma-262/5.1/#sec-15.9.1.15), only including (all of these are treated as local time unless timezone is specified, which is consistent with [moment](https://momentjs.com/)):
			* only part of year/month/date/time are specified: `'2012-03'`, `'2012-03-01'`, `'2012-03-01 05'`, `'2012-03-01 05:06'`.
			* separated by `"T"` or a space: `'2012-03-01T12:22:33.123'`, `'2012-03-01 12:22:33.123'`.
			* timezone specified: `'2012-03-01T12:22:33Z'`, `'2012-03-01T12:22:33+8000'`, `'2012-03-01T12:22:33-05:00'`.
		- other date string format (all of these are treated as local time):
		`'2012'`, `'2012-3-1'`, `'2012/3/1'`, `'2012/03/01'`,
		`'2009/6/12 2:00'`, `'2009/6/12 2:05:08'`, `'2009/6/12 2:05:08.123'`.
	+ a JavaScript Date instance created by user:
		- Caution, when using a data string to create a Date instance, [browser differences and inconsistencies](https://dygraphs.com/date-formats.html) should be considered.
		- For example: In chrome, `new Date('2012-01-01')` is treated as a Jan 1st 2012 in UTC, while `new Date('2012-1-1')` and `new Date('2012/01/01')` are treated as Jan 1st 2012 in local timezone. In safari `new Date('2012-1-1')` is not supported.
		- So if you intent to perform `new Date(dateString)`, it is strongly recommended to use a time parse library (e.g., [moment](https://momentjs.com/)), or use `echarts.time.parse`, or check [this](https://dygraphs.com/date-formats.html).


  

**Customize a data item:**


When needing to customize a data item, it can be set as an object, where property `value` represent real value. For example:



```
[
    12,
    24,
    {
        value: [24, 32],
        // label style, only works in this data item.
        label: {},
        // item style, only works in this data item.
        itemStyle:{}
    },
    33
]
// Or
[
    [12, 332],
    [24, 32],
    {
        value: [24, 32],
        // label style, only works in this data item.
        label: {},
        // item style, only works in this data item.
        itemStyle:{}
    },
    [33, 31]
]

```

  

**Empty value:**


`'-'` or `null` or `undefined` or `NaN` can be used to describe that a data item does not exist (ps：*not exist* does not means its value is `0`).


For example, line chart can break when encounter an empty value, and scatter chart do not display graphic elements for empty values.""").tag(sync=True)
    
    clip = Bool(None, allow_none=True, help="""> Since `v4.4.0`


If clip the overflow on the coordinate system. Clip results varies between series:


* Scatter/EffectScatter：Ignore the symbols exceeds the coordinate system. Not clip the elements.
* Bar：Clip all the overflowed. With bar width kept.
* Line：Clip the overflowed line.
* Lines: Clip all the overflowed.
* Candlestick: Ignore the elements exceeds the coordinate system.
* PictorialBar: Clip all the overflowed. (Supported since v5.5.0)
* Custom: Clip all the olverflowed.


All these series have default value `true` except pictorialBar and custom series. Set it to `false` if you don't want to clip.""").tag(sync=True)
    
    markPoint = Dict(default_value=None, allow_none=True, help="""Mark point in a chart.""").tag(sync=True)
    
    markLine = Dict(default_value=None, allow_none=True, help="""Use a line in the chart to illustrate.""").tag(sync=True)
    
    markArea = Dict(default_value=None, allow_none=True, help="""Used to mark an area in chart. For example, mark a time interval.""").tag(sync=True)
    
    zlevel = Float(None, allow_none=True, help="""`zlevel` value of all graphical elements in Bar chart .


`zlevel` is used to make layers with Canvas. Graphical elements with different `zlevel` values will be placed in different Canvases, which is a common optimization technique. We can put those frequently changed elements (like those with animations) to a separate `zlevel`. Notice that too many Canvases will increase memory cost, and should be used carefully on mobile phones to avoid crash.


Canvases with bigger `zlevel` will be placed on Canvases with smaller `zlevel`.""").tag(sync=True)
    
    z = Float(None, allow_none=True, help="""`z` value of all graphical elements in Bar chart , which controls order of drawing graphical components. Components with smaller `z` values may be overwritten by those with larger `z` values.


`z` has a lower priority to `zlevel`, and will not create new Canvas.""").tag(sync=True)
    
    silent = Bool(None, allow_none=True, help="""Whether to ignore mouse events. Default value is false, for triggering and responding to mouse events.""").tag(sync=True)
    
    animation = Bool(None, allow_none=True, help="""Whether to enable animation.""").tag(sync=True)
    
    animationThreshold = Float(None, allow_none=True, help="""Whether to set graphic number threshold to animation. Animation will be disabled when graphic number is larger than threshold.""").tag(sync=True)
    
    animationDuration = Union([Float(default_value=None, allow_none=True),Any(default_value=None, allow_none=True),], default_value=None, allow_none=True, help="""Duration of the first animation, which supports callback function for different data to have different animation effect:



```
animationDuration: function (idx) {
    // delay for later data is larger
    return idx * 100;
}

```""").tag(sync=True)
    
    animationEasing = Unicode(None, allow_none=True, help="""Easing method used for the first animation. Varied easing effects can be found at [easing effect example](https://echarts.apache.org/examples/en/editor.html?c=line-easing).""").tag(sync=True)
    
    animationDelay = Union([Float(default_value=None, allow_none=True),Any(default_value=None, allow_none=True),], default_value=None, allow_none=True, help="""Delay before updating the first animation, which supports callback function for different data to have different animation effect.


For example:



```
animationDelay: function (idx) {
    // delay for later data is larger
    return idx * 100;
}

```

See [this example](https://echarts.apache.org/examples/en/editor.html?c=bar-animation-delay) for more information.""").tag(sync=True)
    
    animationDurationUpdate = Union([Float(default_value=None, allow_none=True),Any(default_value=None, allow_none=True),], default_value=None, allow_none=True, help="""Time for animation to complete, which supports callback function for different data to have different animation effect:



```
animationDurationUpdate: function (idx) {
    // delay for later data is larger
    return idx * 100;
}

```""").tag(sync=True)
    
    animationEasingUpdate = Unicode(None, allow_none=True, help="""Easing method used for animation.""").tag(sync=True)
    
    animationDelayUpdate = Union([Float(default_value=None, allow_none=True),Any(default_value=None, allow_none=True),], default_value=None, allow_none=True, help="""Delay before updating animation, which supports callback function for different data to have different animation effects.


For example:



```
animationDelayUpdate: function (idx) {
    // delay for later data is larger
    return idx * 100;
}

```

See [this example](https://echarts.apache.org/examples/en/editor.html?c=bar-animation-delay) for more information.""").tag(sync=True)
    
    universalTransition = Any(None, allow_none=True, help="""> Since `v5.2.0`


Configuration related to universal transition animation.


Universal Transition provides the ability to morph between any series. With this feature enabled, each time `setOption`, transitions between series with the same `id` will be automatically associated with each other.


One-to-many or many-to-one animations such as drill-down, aggregation, etc. can also be achieved by specifying data items' `groupId` and `childGroupId`.


This can be enabled directly by configuring `universalTransition: true` in the series. It is also possible to provide an object for more detailed configuration.""").tag(sync=True)
    
    tooltip = Dict(default_value=None, allow_none=True, help="""tooltip settings in this series.""").tag(sync=True)
    
        
