from traitlets import (
    Unicode, Dict, Float, Bool, Any,
)
from ..basewidget import BaseWidget


class Bar3D(BaseWidget):
    """ 
:warning: **Autogenerated class**

3D bar. It can be used to display data in [grid3D](#grid3D),  [geo3D](#geo3D), [globe](#globe) using attributes such as size 、color and so on.


The figure below shows the population density data of the world through a 3D bar chart on [geo3D] (~geo3D).


![](documents/asset/gl/img/geo-bar3D.jpg)



    """

    def __init__(self, **kwargs):

        super().__init__(**kwargs)  
    
    _model_name = Unicode("Bar3DModel").tag(sync=True)
    
    type = Unicode("bar3D", allow_none=True, ).tag(sync=True)
    
    name = Unicode(None, allow_none=True, help="""Series name used for displaying in [tooltip](https://echarts.apache.org/zh/option.html#tooltip) and filtering with [legend](https://echarts.apache.org/zh/option.html#legend), or updating data and configuration with `setOption`.""").tag(sync=True)
    
    coordinateSystem = Unicode(None, allow_none=True, help="""The coordinate used in the series, whose options are:


* `'cartesian3D'`


 Use a 3D rectangular coordinate (also known as Cartesian coordinate), with [xAxisIndex](#series-.xAxisIndex) and [yAxisIndex](#series-.yAxisIndex) to assign the corresponding axis component.


* `'geo3D'`
 Use 3D geographic coordinate, with [geoIndex](#series-.geoIndex) to assign the corresponding 3D geographic coordinate components.


* `'globe'`


 Use 3D globe coordinate, with [globeIndex](#series-.globeIndex) to assign the corresponding 3D globe coordinate components.""").tag(sync=True)
    
    grid3DIndex = Float(None, allow_none=True, help="""Use the index of the [grid3D](#grid3D) component. The first [grid3D](#grid3D) component is used by default.""").tag(sync=True)
    
    geo3DIndex = Float(None, allow_none=True, help="""The index of the [geo3D](#geo3D) component used by the axis.The first [grid3D](#grid3D) component is used by default.""").tag(sync=True)
    
    globeIndex = Float(None, allow_none=True, help="""The index of the [globe](#globe) component used by the axis.The first [globe](#globe) component is used by default.""").tag(sync=True)
    
    bevelSize = Float(None, allow_none=True, help="""The size of the bevel.
Support for setting values from 0 to 1. The default is 0, which means there is no bevel.


Below are the differences between beveling and no beveling.



![](documents/asset/gl/img/bar3D-no-bevel.png "bevelSize: 0")
![](documents/asset/gl/img/bar3D-bevel.png "bevelSize: 0.3")""").tag(sync=True)
    
    bevelSmoothness = Float(None, allow_none=True, help="""The smoothness of the bevel, the larger the value, the smoother.""").tag(sync=True)
    
    stack = Unicode(None, allow_none=True, help="""Stacking of bar chart. On the same category axis, the series with the same `stack` name would be put on top of each other. Note that the data items that need to be stack in different series must have the same index in the array.


See also [stackStrategy](#series-bar3D.stackStrategy) on how to customize how values are stacked.


Notice: `stack` only supports stacking on `value` and `log` axis for now. `time` and `category` axis are not supported.""").tag(sync=True)
    
    stackStrategy = Unicode(None, allow_none=True, help="""> Since ECharts `v5.3.3`


How to stack values if the [stack](#series-bar3D.stack) property has been set. Options:


* `'samesign'`: only stack values if the value to be stacked has the same sign as the currently cumulated stacked value.
* `'all'`: stack all values, irrespective of the signs of the current or cumulative stacked value.
* `'positive'`: only stack positive values.
* `'negative'`: only stack negative values.""").tag(sync=True)
    
    minHeight = Float(None, allow_none=True, help="""The minimum width of the bar.""").tag(sync=True)
    
    itemStyle = Dict(default_value=None, allow_none=True, help="""The style of the bar, including color and opacity.""").tag(sync=True)
    
    label = Dict(default_value=None, allow_none=True, help="""Configure the label of the bar.""").tag(sync=True)
    
    emphasis = Dict(default_value=None, allow_none=True, help="""Configure labels and styles for bar highlighting.""").tag(sync=True)
    
    data = Any(None, allow_none=True, help="""A data array of 3D bar. Each item of the array is a piece of data. Usually this data is an array to store each attribute/dimension of the data. For example below:



```
data: [
    [[12, 14, 10], [34, 50, 15], [56, 30, 20], [10, 15, 12], [23, 10, 14]]
]

```

For each item in the array:


1. In [grid3D] (~grid3D), the first three values of each item are `x`, `y`, `z`.
2. In [geo3D](#geo3D) and [globe](#globe), the first two values of each item are longitude `lng`, latitude `lat`, and the third value indicates the size of the value, such as the number of people. This value will be mapped to the range of [minHeight](#series-bar3D.minHeight) ~ [maxHeight](#series-bar3D.maxHeight).


In addition to the three values used by default for the coordinate system, each item can be added with any number of values for mapping the [visualMap](#visualMap) component to other graphical properties such as color.


More likely, we need to assign name to each data item, in which case each item should be an object:



```
[{
    // name of date item
    name: 'data1',
    // value of date item is 8
    value: [12, 14, 10]
}, {
    name: 'data2',
    value: 20
}]

```

Each data item can be further customized:



```
[{
    name: 'data1',
    value: [12, 14, 10]
}, {
    // name of data item
    name: 'data2',
    value : [34, 50, 15],
    // user-defined special itemStyle that only useful for this data item
    itemStyle:{}
}]

```""").tag(sync=True)
    
    shading = Unicode(None, allow_none=True, help="""The coloring effect of 3D graphics in 3D Bar. The following three coloring methods are supported in echarts-gl:


* `'color'`
Only display colors, not affected by other factors such as lighting.
* `'lambert'`
Through the classic [lambert] coloring, can express the light and dark that the light shows.
* `'realistic'`
Realistic rendering, combined with [light.ambientCubemap](#globe.light.ambientCubemap) and [postEffect](#globe.postEffect), can improve the quality and texture of the display. [Physical Based Rendering (PBR)] (<https://www.marmoset.co/posts/physically-based-rendering-and-you-can-too/>) is used in ECharts GL to represent realistic materials.""").tag(sync=True)
    
    realisticMaterial = Dict(default_value=None, allow_none=True, help="""The configuration item of the realistic material is valid when [shading](#series-bar3D.shading) is `'realistic'`.""").tag(sync=True)
    
    lambertMaterial = Dict(default_value=None, allow_none=True, help="""The configuration item of the lambert material is valid when [shading](#series-bar3D.shading) is `'lambert'`.""").tag(sync=True)
    
    colorMaterial = Dict(default_value=None, allow_none=True, help="""The color material related configuration item is valid when [shading](#series-bar3D.shading) is `'color'`.""").tag(sync=True)
    
    zlevel = Float(None, allow_none=True, help="""The layer in which the component is located.


`zlevel` is used to make layers with Canvas. Graphical elements with different `zlevel` values will be placed in different Canvases, which is a common optimization technique. We can put those frequently changed elements (like those with animations) to a separate `zlevel`. Notice that too many Canvases will increase memory cost, and should be used carefully on mobile phones to avoid the crash.


Canvases with bigger `zlevel` will be placed on Canvases with smaller `zlevel`.


**Note:** The layers of the components in echarts-gl need to be separated from the layers of the components in echarts. The same `zlevel` cannot be used for both WebGL and Canvas drawing at the same time.""").tag(sync=True)
    
    silent = Bool(None, allow_none=True, help="""Whether the graph doesn`t respond and triggers a mouse event. The default is false, which is to respond to and trigger mouse events.""").tag(sync=True)
    
    animation = Bool(None, allow_none=True, help="""Whether to enable animation.""").tag(sync=True)
    
    animationDurationUpdate = Float(None, allow_none=True, help="""The duration time for update the transition animation.""").tag(sync=True)
    
    animationEasingUpdate = Unicode(None, allow_none=True, help="""The easing effect for update transition animation.""").tag(sync=True)
    
        
