from traitlets import (
    Unicode, Dict, Float, Bool, Union, Any,
)
from ..basewidget import BaseWidget


class Boxplot(BaseWidget):
    """ 
:warning: **Autogenerated class**

[Boxplot](https://en.wikipedia.org/wiki/Box_plot) is a convenient way of graphically depicting groups of numerical data through their quartiles.


**Example:**



  

Multiple `series` can be displayed in the same coordinate system. Please refer to [this example](https://echarts.apache.org/examples/en/editor.html?c=boxplot-multi&edit=1&reset=1).


  

  




    """

    def __init__(self, **kwargs):

        super().__init__(**kwargs)  
    
    _model_name = Unicode("BoxplotModel").tag(sync=True)
    
    type = Unicode("boxplot", allow_none=True, ).tag(sync=True)
    
    id = Unicode(None, allow_none=True, help="""Component ID, not specified by default. If specified, it can be used to refer the component in option or API.""").tag(sync=True)
    
    coordinateSystem = Unicode(None, allow_none=True, help="""The coordinate used in the series, whose options are:


* `'cartesian2d'`


 Use a two-dimensional rectangular coordinate (also known as Cartesian coordinate), with [xAxisIndex](#series-boxplot.xAxisIndex) and [yAxisIndex](#series-boxplot.yAxisIndex) to assign the corresponding axis component.""").tag(sync=True)
    
    xAxisIndex = Float(None, allow_none=True, help="""Index of [x axis](#xAxis) to combine with, which is useful for multiple x axes in one chart.""").tag(sync=True)
    
    yAxisIndex = Float(None, allow_none=True, help="""Index of [y axis](#yAxis) to combine with, which is useful for multiple y axes in one chart.""").tag(sync=True)
    
    name = Unicode(None, allow_none=True, help="""Series name used for displaying in [tooltip](#tooltip) and filtering with [legend](#legend), or updating data and configuration with `setOption`.""").tag(sync=True)
    
    colorBy = Unicode(None, allow_none=True, help="""> Since `v5.2.0`


The policy to take color from [option.color](#color). Valid values:


* `'series'`: assigns the colors in the palette by series, so that all data in the same series are in the same color;
* `'data'`: assigns colors in the palette according to data items, with each data item using a different color.""").tag(sync=True)
    
    legendHoverLink = Bool(None, allow_none=True, help="""Whether to enable highlighting chart when [legend](#legend) is being hovered.""").tag(sync=True)
    
    hoverAnimation = Bool(None, allow_none=True, help="""Whether to enable the animation when hovering on box.""").tag(sync=True)
    
    layout = Unicode(None, allow_none=True, help="""Layout methods, whose optional values are:


* `'horizontal'`: horizontally layout all boxes.
* `'vertical'`: vertically layout all boxes.


The default value is decided by:


* if there is a `category` axis:
	+ if it is horizontal, use `'horizontal'`;
	+ otherwise use `'vertical'`;
* otherwise use `'horizontal'`.""").tag(sync=True)
    
    boxWidth = Any(None, allow_none=True, help="""Up and bottom boundary of box width. The array is in the form of `[min, max]`.


It could be absolute value in pixel, such as `[7, 50]`, or percentage, such as `['40%', '90%']`. The percentage means the percentage to the maximum possible width.""").tag(sync=True)
    
    itemStyle = Dict(default_value=None, allow_none=True, help="""Style of boxplot.""").tag(sync=True)
    
    emphasis = Dict(default_value=None, allow_none=True, help="""Configurations of emphasis state.""").tag(sync=True)
    
    blur = Dict(default_value=None, allow_none=True, help="""> Since `v5.0.0`


Configurations of blur state. Available when [emphasis.focus](#series-boxplot.emphasis.focus) is set.""").tag(sync=True)
    
    select = Dict(default_value=None, allow_none=True, help="""> Since `v5.0.0`


Configurations of select state. Available when [selectedMode](#series-boxplot.selectedMode) is set.""").tag(sync=True)
    
    selectedMode = Union([Bool(default_value=None, allow_none=True),Unicode(default_value=None, allow_none=True),], default_value=None, allow_none=True, help="""> Since `v5.0.0`


Selected mode. It is enabled by default, and you may set it to be `false` to disable it.


Besides, it can be set to `'single'`, `'multiple'` or `'series'`, for single selection, multiple selections and whole series selection.



> `'series'` is supported since v5.3.0""").tag(sync=True)
    
    dimensions = Any(None, allow_none=True, help="""`dimensions` can be used to define dimension info for `series.data` or `dataset.source`.


Notice: if [dataset](#dataset) is used, we can definite dimensions in [dataset.dimensions](#dataset.dimensions), or provide dimension names in the first column/row of [dataset.source](#dataset.source), and not need to specify `dimensions` here. But if `dimensions` is specified here, it will be used despite the dimension definitions in dataset.


For example:



```
option = {
    dataset: {
        source: [
            // 'date', 'open', 'close', 'highest', 'lowest'
            [12, 44, 55, 66, 2],
            [23, 6, 16, 23, 1],
            ...
        ]
    },
    series: {
        type: 'xxx',
        // Specify name for each dimensions, which will be displayed in tooltip.
        dimensions: ['date', 'open', 'close', 'highest', 'lowest']
    }
}

```


```
series: {
    type: 'xxx',
    dimensions: [
        null,                // If you do not intent to defined this dimension, use null is fine.
        {type: 'ordinal'},   // Specify type of this dimension.
                             // 'ordinal' is always used in string.
                             // If type is not specified, echarts will guess type by data.
        {name: 'good', type: 'number'},
        'bad'                // Equals to {name: 'bad'}.
    ]
}

```

Each data item of `dimensions` can be:


* `string`, for example, `'someName'`, which equals to `{name: 'someName'}`.
* `Object`, where the attributes can be:
	+ name: `string`.
	+ type: `string`, supports:
		- `number`
		- `float`, that is, [Float64Array](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Float64Array)
		- `int`, that is, [Int32Array](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Int32Array)
		- `ordinal`, discrete value, which represents string generally.
		- `time`, time value, see [data](#series.data) to check the format of time value.
	+ displayName: `string`, generally used in tooltip for dimension display. If not specified, use `name` by default.


When `dimensions` is specified, the default `tooltip` will be displayed vertically, which is better to show dimension names. Otherwise, `tooltip` will displayed only value horizontally.""").tag(sync=True)
    
    encode = Dict(default_value=None, allow_none=True, help="""Define what is encoded to for each dimension of `data`. For example:



```
option = {
    dataset: {
        source: [
            // Each column is called a dimension.
            // There are five dimensions: 0, 1, 2, 3, 4.
            [12, 44, 55, 66, 2],
            [23, 6, 16, 23, 1],
            ...
        ]
    },
    series: {
        type: 'xxx',
        encode: {
            x: [3, 1, 5],      // Dimension 3, 1, 5 is mapped to x axis.
            y: 2,              // Dimension 2 is mapped to y axis.
            tooltip: [3, 2, 4] // Dimension 3, 2, 4 will be displayed in tooltip.
        }
    }
}

```

When [dimensions](#series.dimensions) is used to defined name for a certain dimension, `encode` can refer the name directly. For example:



```
series: {
    type: 'xxx',
    dimensions: ['date', 'open', 'close', 'highest', 'lowest'],
    encode: {
        x: 'date',
        y: ['open', 'close', 'highest', 'lowest']
    }
}

```

The basic structure of [encode](option.html#series.encode) is illustrated as follows, where the left part of colon is the name of axis like `'x'`, `'y'`, `'radius'`, `'angle'` or some special reserved names like "tooltip", "itemName" etc., and the right part of the colon is the dimension names or dimension indices (based on 0). One or more dimensions can be specified. Usually not all of mappings need to be specified, only specify needed ones.


The properties available in `encode` listed as follows:



```
// In any of the series and coordinate systems,
// these properties are available:
encode: {
    // Display dimension "product" and "score" in the tooltip.
    tooltip: ['product', 'score']
    // Set the series name as the concat of the names of dimensions[1] and dimensions[3].
    // (sometimes the dimension names are too long to type in series.name manually).
    seriesName: [1, 3],
    // Using dimensions[2] as the id of each data item. This is useful when dynamically
    // update data by `chart.setOption()`, where the new and old data item can be
    // corresponded by id, by which the appropriate animation can be performed when updating.
    itemId: 2,
    // Using dimensions[3] as the name of each data item. This is useful in charts like
    // 'pie', 'funnel', where data item name can be displayed in legend.
    itemName: 3,
    // Using dimensions[4] as the group ID for each data item. With universalTransition enabled,
    // the data items from the old option and those from the new one, if sharing a same group ID,
    // will then be matched and applied to a proper animation after `setOption` is called.
    itemGroupId: 4,
    // Using dimension[5] as the child group ID for each data item. This option is introduced to
    // make multiple levels drilldown and aggregation animation come true. See childGroupId for more.
    // Since v5.5.0
    itemChildGroupId: 5
}

// These properties only work in cartesian(grid) coordinate system:
encode: {
    // Map dimensions[1], dimensions[5] and dimension "score" to the X axis.
    x: [1, 5, 'score'],
    // Map dimensions[0] to the Y axis.
    y: 0
}

// These properties only work in polar coordinate system:
encode: {
    radius: 3,
    angle: 2,
    ...
}

// These properties only work in geo coordinate system:
encode: {
    lng: 3,
    lat: 2
}

// For some type of series that are not in any coordinate system,
// like 'pie', 'funnel' etc.:
encode: {
    value: 3
}

```

This is an [example](https://echarts.apache.org/examples/en/view.html?c=dataset-encode1&edit=1&reset=1) for `encode`.


Specially, in [custom series(~series-custom), some property in `encode`, corresponding to axis, can be set as null to make the series not controlled by the axis, that is, the series data will not be count in the extent of the axis, and the [dataZoom](#dataZoom) on the axis will not filter the series.



```
var option = {
    xAxis: {},
    yAxis: {},
    dataZoom: [{
        xAxisIndex: 0
    }, {
        yAxisIndex: 0
    }],
    series: {
        type: 'custom',
        renderItem: function (params, api) {
            return {
                type: 'circle',
                shape: {
                    cx: 100, // x position is always 100
                    cy: api.coord([0, api.value(0)])[1],
                    r: 30
                },
                style: {
                    fill: 'blue'
                }
            };
        },
        encode: {
            // Then the series will not be controlled
            // by x axis and corresponding dataZoom.
            x: -1,
            y: 1
        },
        data: [ ... ]
    }
};

```""").tag(sync=True)
    
    dataGroupId = Unicode(None, allow_none=True, help="""A group ID assigned to all data items in the series.


This option has a lower priority than `groupId`, which means when `groupId` is specified for a certain data item the `dataGroupId` will be simply ignored for that data item. For more information, please see `series.data.groupId`.""").tag(sync=True)
    
    data = Any(None, allow_none=True, help="""Data should be the two-dimensional array shown as follow.



```
[
    [655, 850, 940, 980, 1175],
    [672.5, 800, 845, 885, 1012.5],
    [780, 840, 855, 880, 940],
    [621.25, 767.5, 815, 865, 1011.25],
    { // the data item could also be an Object, so that it could contains special settings for this data item.
        value: [713.75, 807.5, 810, 870, 963.75],
        itemStyle: {...}
    },
    ...
]

```

Every data item (each line in the example above) in the two-dimensional array will be rendered into a box, and each line have five values as:



```
[min,  Q1,  median (or Q2),  Q3,  max]

```

**Data Processing**


ECharts doesn't contain data processing modules, so the five statistic values should be calculated by yourself and then passes into `boxplot`.


However, ECharts also provide some simple [raw data processing tools](https://github.com/apache/echarts/tree/master/extension/dataTool). For example, this [example](https://echarts.apache.org/examples/en/editor.html?c=boxplot-light-velocity&edit=1&reset=1) uses `echarts.dataTool.prepareBoxplotData` to proceed simple data statistics.""").tag(sync=True)
    
    markPoint = Dict(default_value=None, allow_none=True, help="""Mark point in a chart.""").tag(sync=True)
    
    markLine = Dict(default_value=None, allow_none=True, help="""Use a line in the chart to illustrate.""").tag(sync=True)
    
    markArea = Dict(default_value=None, allow_none=True, help="""Used to mark an area in chart. For example, mark a time interval.""").tag(sync=True)
    
    zlevel = Float(None, allow_none=True, help="""`zlevel` value of all graphical elements in Boxplot .


`zlevel` is used to make layers with Canvas. Graphical elements with different `zlevel` values will be placed in different Canvases, which is a common optimization technique. We can put those frequently changed elements (like those with animations) to a separate `zlevel`. Notice that too many Canvases will increase memory cost, and should be used carefully on mobile phones to avoid crash.


Canvases with bigger `zlevel` will be placed on Canvases with smaller `zlevel`.""").tag(sync=True)
    
    z = Float(None, allow_none=True, help="""`z` value of all graphical elements in Boxplot , which controls order of drawing graphical components. Components with smaller `z` values may be overwritten by those with larger `z` values.


`z` has a lower priority to `zlevel`, and will not create new Canvas.""").tag(sync=True)
    
    silent = Bool(None, allow_none=True, help="""Whether to ignore mouse events. Default value is false, for triggering and responding to mouse events.""").tag(sync=True)
    
    animationDuration = Union([Float(default_value=None, allow_none=True),Any(default_value=None, allow_none=True),], default_value=None, allow_none=True, help="""Duration of the first animation, which supports callback function for different data to have different animation effect:



```
animationDuration: function (idx) {
    // delay for later data is larger
    return idx * 100;
}

```""").tag(sync=True)
    
    animationEasing = Unicode(None, allow_none=True, help="""Easing method used for the first animation. Varied easing effects can be found at [easing effect example](https://echarts.apache.org/examples/en/editor.html?c=line-easing).""").tag(sync=True)
    
    animationDelay = Union([Float(default_value=None, allow_none=True),Any(default_value=None, allow_none=True),], default_value=None, allow_none=True, help="""Delay before updating the first animation, which supports callback function for different data to have different animation effect.


For example:



```
animationDelay: function (idx) {
    // delay for later data is larger
    return idx * 100;
}

```

See [this example](https://echarts.apache.org/examples/en/editor.html?c=bar-animation-delay) for more information.""").tag(sync=True)
    
    universalTransition = Any(None, allow_none=True, help="""> Since `v5.2.0`


Configuration related to universal transition animation.


Universal Transition provides the ability to morph between any series. With this feature enabled, each time `setOption`, transitions between series with the same `id` will be automatically associated with each other.


One-to-many or many-to-one animations such as drill-down, aggregation, etc. can also be achieved by specifying data items' `groupId` and `childGroupId`.


This can be enabled directly by configuring `universalTransition: true` in the series. It is also possible to provide an object for more detailed configuration.""").tag(sync=True)
    
    tooltip = Dict(default_value=None, allow_none=True, help="""tooltip settings in this series.""").tag(sync=True)
    
        
