from traitlets import (
    Unicode, Dict, Float, Bool, Union, Any,
)
from ..basewidget import BaseWidget


class Candlestick(BaseWidget):
    """ 
:warning: **Autogenerated class**

A [candlestick](https://en.wikipedia.org/wiki/Candlestick_chart) chart (also called Japanese candlestick chart) is a style of financial chart used to describe price movements of a security, derivative, or currency.


ECharts3 supports both `'candlestick'` and `'k'` in [series.type](#(series.type) (`'k'` would automatically turns into `'candlestick'`).


**An example:**



  

**About color of increase and decrease**


Different countries or regions have different implications on the color of candle stick chart. It may use red to imply increasing with red and decreasing with blue (in China mainland, Taiwan, Japan, Koera, and so on), or to imply increasing with green and decreasing with red (in Europe, North America, Hong Kong, Singapore, and so on). Besides color, the increase and decrease of stock may also be represented with candle stick with or without filling colors.


We use red to represent increasing and blue decreasing by default. If you want to change the configuration, you may change the following parameters.


- [series-candlestick.itemStyle.color](#series-candlestick.itemStyle.color): fill color for bullish candle stick (namely, increase)
- [series-candlestick.itemStyle.color0](#series-candlestick.itemStyle.color0): fill color for bearish candle stick (namely, decrease)
- [series-candlestick.itemStyle.borderColor](#series-candlestick.itemStyle.borderColor): border color for bullish candle stick (namely, increase)
- [series-candlestick.itemStyle.borderColor0](#series-candlestick.itemStyle.borderColor0): border color for bearish candle stick (namely, decrease)
- [series-candlestick.itemStyle.borderColorDoji](#series-candlestick.itemStyle.borderColorDoji): border color for doji (when the open price is the same as the close price)


  

  




    """

    def __init__(self, **kwargs):

        super().__init__(**kwargs)  
    
    _model_name = Unicode("CandlestickModel").tag(sync=True)
    
    type = Unicode("candlestick", allow_none=True, ).tag(sync=True)
    
    id = Unicode(None, allow_none=True, help="""Component ID, not specified by default. If specified, it can be used to refer the component in option or API.""").tag(sync=True)
    
    coordinateSystem = Unicode(None, allow_none=True, help="""The coordinate used in the series, whose options are:


* `'cartesian2d'`


 Use a two-dimensional rectangular coordinate (also known as Cartesian coordinate), with [xAxisIndex](#series-candlestick.xAxisIndex) and [yAxisIndex](#series-candlestick.yAxisIndex) to assign the corresponding axis component.""").tag(sync=True)
    
    xAxisIndex = Float(None, allow_none=True, help="""Index of [x axis](#xAxis) to combine with, which is useful for multiple x axes in one chart.""").tag(sync=True)
    
    yAxisIndex = Float(None, allow_none=True, help="""Index of [y axis](#yAxis) to combine with, which is useful for multiple y axes in one chart.""").tag(sync=True)
    
    name = Unicode(None, allow_none=True, help="""Series name used for displaying in [tooltip](#tooltip) and filtering with [legend](#legend), or updating data and configuration with `setOption`.""").tag(sync=True)
    
    colorBy = Unicode(None, allow_none=True, help="""> Since `v5.2.0`


The policy to take color from [option.color](#color). Valid values:


* `'series'`: assigns the colors in the palette by series, so that all data in the same series are in the same color;
* `'data'`: assigns colors in the palette according to data items, with each data item using a different color.""").tag(sync=True)
    
    legendHoverLink = Bool(None, allow_none=True, help="""Whether to enable highlighting chart when [legend](#legend) is being hovered.""").tag(sync=True)
    
    hoverAnimation = Bool(None, allow_none=True, help="""Whether to enable animation when hovering on box.""").tag(sync=True)
    
    layout = Unicode(None, allow_none=True, help="""Layout method, whose values may be:


* `'horizontal'`: horizontally layout all boxs.
* `'vertical'`: vertically layout all boxs.


The default value is decided by:


* if there is a `category` axis:
	+ if it is horizontal, use `'horizontal'`;
	+ otherwise use `'vertical'`;
* otherwise use `'horizontal'`.""").tag(sync=True)
    
    barWidth = Float(None, allow_none=True, help="""Specify bar width. Absolute value (like `10`) or percentage (like `'20%'`, according to band width) can be used. Auto adapt by default.""").tag(sync=True)
    
    barMinWidth = Union([Float(default_value=None, allow_none=True),Unicode(default_value=None, allow_none=True),], default_value=None, allow_none=True, help="""Specify bar min width. Absolute value (like `10`) or percentage (like `'20%'`, according to band width) can be used. Auto adapt by default.""").tag(sync=True)
    
    barMaxWidth = Union([Float(default_value=None, allow_none=True),Unicode(default_value=None, allow_none=True),], default_value=None, allow_none=True, help="""Specify bar max width. Absolute value (like `10`) or percentage (like `'20%'`, according to band width) can be used. Auto adapt by default.""").tag(sync=True)
    
    itemStyle = Dict(default_value=None, allow_none=True, help="""Item style of candlestick.""").tag(sync=True)
    
    emphasis = Dict(default_value=None, allow_none=True, help="""Emphasis style of candlestick.""").tag(sync=True)
    
    blur = Dict(default_value=None, allow_none=True, help="""> Since `v5.0.0`


Configurations of blur state. Available when [emphasis.focus](#series-candlestick.emphasis.focus) is set.""").tag(sync=True)
    
    select = Dict(default_value=None, allow_none=True, help="""> Since `v5.0.0`


Configurations of select state. Available when [selectedMode](#series-candlestick.selectedMode) is set.""").tag(sync=True)
    
    selectedMode = Union([Bool(default_value=None, allow_none=True),Unicode(default_value=None, allow_none=True),], default_value=None, allow_none=True, help="""> Since `v5.0.0`


Selected mode. It is enabled by default, and you may set it to be `false` to disable it.


Besides, it can be set to `'single'`, `'multiple'` or `'series'`, for single selection, multiple selections and whole series selection.



> `'series'` is supported since v5.3.0""").tag(sync=True)
    
    large = Bool(None, allow_none=True, help="""Whether to enable the optimization of large-scale data. It could be set when large data causes performance problem.


After being enabled, `largeThreshold` can be used to indicate the minimum number for turning on the optimization.


But when the optimization enabled, the style of single data item can't be customized any more.""").tag(sync=True)
    
    largeThreshold = Float(None, allow_none=True, help="""The threshold enabling the drawing optimization.""").tag(sync=True)
    
    progressive = Float(None, allow_none=True, help="""`progressive` specifies the amount of graphic elements that can be rendered within a frame (about 16ms) if "progressive rendering" enabled.


When data amount is from thousand to more than 10 million, it will take too long time to render all of the graphic elements. Since ECharts 4, "progressive rendering" is supported in its workflow, which processes and renders data chunk by chunk alone with each frame, avoiding to block the UI thread of the browser.


Set `progressive: 0` to disable progressive permanently. By default, progressive is auto-enabled when data amount is bigger than `progressiveThreshold`.""").tag(sync=True)
    
    progressiveThreshold = Float(None, allow_none=True, help="""If current data amount is over the threshold, "progressive rendering" is enabled.""").tag(sync=True)
    
    progressiveChunkMode = Unicode(None, allow_none=True, help="""Chunk approach, optional values:


* `'sequential'`: slice data by data index.
* `'mod'`: slice data by mod, which make the data items of each chunk coming from all over the data, bringing better visual effect while progressive rendering.""").tag(sync=True)
    
    dimensions = Any(None, allow_none=True, help="""`dimensions` can be used to define dimension info for `series.data` or `dataset.source`.


Notice: if [dataset](#dataset) is used, we can definite dimensions in [dataset.dimensions](#dataset.dimensions), or provide dimension names in the first column/row of [dataset.source](#dataset.source), and not need to specify `dimensions` here. But if `dimensions` is specified here, it will be used despite the dimension definitions in dataset.


For example:



```
option = {
    dataset: {
        source: [
            // 'date', 'open', 'close', 'highest', 'lowest'
            [12, 44, 55, 66, 2],
            [23, 6, 16, 23, 1],
            ...
        ]
    },
    series: {
        type: 'xxx',
        // Specify name for each dimensions, which will be displayed in tooltip.
        dimensions: ['date', 'open', 'close', 'highest', 'lowest']
    }
}

```


```
series: {
    type: 'xxx',
    dimensions: [
        null,                // If you do not intent to defined this dimension, use null is fine.
        {type: 'ordinal'},   // Specify type of this dimension.
                             // 'ordinal' is always used in string.
                             // If type is not specified, echarts will guess type by data.
        {name: 'good', type: 'number'},
        'bad'                // Equals to {name: 'bad'}.
    ]
}

```

Each data item of `dimensions` can be:


* `string`, for example, `'someName'`, which equals to `{name: 'someName'}`.
* `Object`, where the attributes can be:
	+ name: `string`.
	+ type: `string`, supports:
		- `number`
		- `float`, that is, [Float64Array](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Float64Array)
		- `int`, that is, [Int32Array](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Int32Array)
		- `ordinal`, discrete value, which represents string generally.
		- `time`, time value, see [data](#series.data) to check the format of time value.
	+ displayName: `string`, generally used in tooltip for dimension display. If not specified, use `name` by default.


When `dimensions` is specified, the default `tooltip` will be displayed vertically, which is better to show dimension names. Otherwise, `tooltip` will displayed only value horizontally.""").tag(sync=True)
    
    encode = Dict(default_value=None, allow_none=True, help="""Define what is encoded to for each dimension of `data`. For example:



```
option = {
    dataset: {
        source: [
            // Each column is called a dimension.
            // There are five dimensions: 0, 1, 2, 3, 4.
            [12, 44, 55, 66, 2],
            [23, 6, 16, 23, 1],
            ...
        ]
    },
    series: {
        type: 'xxx',
        encode: {
            x: [3, 1, 5],      // Dimension 3, 1, 5 is mapped to x axis.
            y: 2,              // Dimension 2 is mapped to y axis.
            tooltip: [3, 2, 4] // Dimension 3, 2, 4 will be displayed in tooltip.
        }
    }
}

```

When [dimensions](#series.dimensions) is used to defined name for a certain dimension, `encode` can refer the name directly. For example:



```
series: {
    type: 'xxx',
    dimensions: ['date', 'open', 'close', 'highest', 'lowest'],
    encode: {
        x: 'date',
        y: ['open', 'close', 'highest', 'lowest']
    }
}

```

The basic structure of [encode](option.html#series.encode) is illustrated as follows, where the left part of colon is the name of axis like `'x'`, `'y'`, `'radius'`, `'angle'` or some special reserved names like "tooltip", "itemName" etc., and the right part of the colon is the dimension names or dimension indices (based on 0). One or more dimensions can be specified. Usually not all of mappings need to be specified, only specify needed ones.


The properties available in `encode` listed as follows:



```
// In any of the series and coordinate systems,
// these properties are available:
encode: {
    // Display dimension "product" and "score" in the tooltip.
    tooltip: ['product', 'score']
    // Set the series name as the concat of the names of dimensions[1] and dimensions[3].
    // (sometimes the dimension names are too long to type in series.name manually).
    seriesName: [1, 3],
    // Using dimensions[2] as the id of each data item. This is useful when dynamically
    // update data by `chart.setOption()`, where the new and old data item can be
    // corresponded by id, by which the appropriate animation can be performed when updating.
    itemId: 2,
    // Using dimensions[3] as the name of each data item. This is useful in charts like
    // 'pie', 'funnel', where data item name can be displayed in legend.
    itemName: 3,
    // Using dimensions[4] as the group ID for each data item. With universalTransition enabled,
    // the data items from the old option and those from the new one, if sharing a same group ID,
    // will then be matched and applied to a proper animation after `setOption` is called.
    itemGroupId: 4,
    // Using dimension[5] as the child group ID for each data item. This option is introduced to
    // make multiple levels drilldown and aggregation animation come true. See childGroupId for more.
    // Since v5.5.0
    itemChildGroupId: 5
}

// These properties only work in cartesian(grid) coordinate system:
encode: {
    // Map dimensions[1], dimensions[5] and dimension "score" to the X axis.
    x: [1, 5, 'score'],
    // Map dimensions[0] to the Y axis.
    y: 0
}

// These properties only work in polar coordinate system:
encode: {
    radius: 3,
    angle: 2,
    ...
}

// These properties only work in geo coordinate system:
encode: {
    lng: 3,
    lat: 2
}

// For some type of series that are not in any coordinate system,
// like 'pie', 'funnel' etc.:
encode: {
    value: 3
}

```

This is an [example](https://echarts.apache.org/examples/en/view.html?c=dataset-encode1&edit=1&reset=1) for `encode`.


Specially, in [custom series(~series-custom), some property in `encode`, corresponding to axis, can be set as null to make the series not controlled by the axis, that is, the series data will not be count in the extent of the axis, and the [dataZoom](#dataZoom) on the axis will not filter the series.



```
var option = {
    xAxis: {},
    yAxis: {},
    dataZoom: [{
        xAxisIndex: 0
    }, {
        yAxisIndex: 0
    }],
    series: {
        type: 'custom',
        renderItem: function (params, api) {
            return {
                type: 'circle',
                shape: {
                    cx: 100, // x position is always 100
                    cy: api.coord([0, api.value(0)])[1],
                    r: 30
                },
                style: {
                    fill: 'blue'
                }
            };
        },
        encode: {
            // Then the series will not be controlled
            // by x axis and corresponding dataZoom.
            x: -1,
            y: 1
        },
        data: [ ... ]
    }
};

```""").tag(sync=True)
    
    dataGroupId = Unicode(None, allow_none=True, help="""A group ID assigned to all data items in the series.


This option has a lower priority than `groupId`, which means when `groupId` is specified for a certain data item the `dataGroupId` will be simply ignored for that data item. For more information, please see `series.data.groupId`.""").tag(sync=True)
    
    data = Any(None, allow_none=True, help="""Data should be the two-dimensional array shown as follows.



```
[
    [2320.26, 2320.26, 2287.3,  2362.94],
    [2300,    2291.3,  2288.26, 2308.38],
    { // the data item could also be an Object, so that it could contains special settings for this data item.
        value: [2300,    2291.3,  2288.26, 2308.38],
        itemStyle: {...}
    },
    ...
]

```

Every data item (each line in the example above) represents a box, which contains 4 values. They are:



```
[open, close, lowest, highest]  (namely: [opening value, closing value, lowest value, highest value])

```""").tag(sync=True)
    
    markPoint = Dict(default_value=None, allow_none=True, help="""Mark point in a chart.""").tag(sync=True)
    
    markLine = Dict(default_value=None, allow_none=True, help="""Use a line in the chart to illustrate.""").tag(sync=True)
    
    markArea = Dict(default_value=None, allow_none=True, help="""Used to mark an area in chart. For example, mark a time interval.""").tag(sync=True)
    
    clip = Bool(None, allow_none=True, help="""> Since `v4.5.0`


If clip the overflow on the coordinate system. Clip results varies between series:


* Scatter/EffectScatter：Ignore the symbols exceeds the coordinate system. Not clip the elements.
* Bar：Clip all the overflowed. With bar width kept.
* Line：Clip the overflowed line.
* Lines: Clip all the overflowed.
* Candlestick: Ignore the elements exceeds the coordinate system.
* PictorialBar: Clip all the overflowed. (Supported since v5.5.0)
* Custom: Clip all the olverflowed.


All these series have default value `true` except pictorialBar and custom series. Set it to `false` if you don't want to clip.""").tag(sync=True)
    
    zlevel = Float(None, allow_none=True, help="""`zlevel` value of all graphical elements in Candlestick .


`zlevel` is used to make layers with Canvas. Graphical elements with different `zlevel` values will be placed in different Canvases, which is a common optimization technique. We can put those frequently changed elements (like those with animations) to a separate `zlevel`. Notice that too many Canvases will increase memory cost, and should be used carefully on mobile phones to avoid crash.


Canvases with bigger `zlevel` will be placed on Canvases with smaller `zlevel`.""").tag(sync=True)
    
    z = Float(None, allow_none=True, help="""`z` value of all graphical elements in Candlestick , which controls order of drawing graphical components. Components with smaller `z` values may be overwritten by those with larger `z` values.


`z` has a lower priority to `zlevel`, and will not create new Canvas.""").tag(sync=True)
    
    silent = Bool(None, allow_none=True, help="""Whether to ignore mouse events. Default value is false, for triggering and responding to mouse events.""").tag(sync=True)
    
    animationDuration = Union([Float(default_value=None, allow_none=True),Any(default_value=None, allow_none=True),], default_value=None, allow_none=True, help="""Duration of the first animation, which supports callback function for different data to have different animation effect:



```
animationDuration: function (idx) {
    // delay for later data is larger
    return idx * 100;
}

```""").tag(sync=True)
    
    animationEasing = Unicode(None, allow_none=True, help="""Easing method used for the first animation. Varied easing effects can be found at [easing effect example](https://echarts.apache.org/examples/en/editor.html?c=line-easing).""").tag(sync=True)
    
    animationDelay = Union([Float(default_value=None, allow_none=True),Any(default_value=None, allow_none=True),], default_value=None, allow_none=True, help="""Delay before updating the first animation, which supports callback function for different data to have different animation effect.


For example:



```
animationDelay: function (idx) {
    // delay for later data is larger
    return idx * 100;
}

```

See [this example](https://echarts.apache.org/examples/en/editor.html?c=bar-animation-delay) for more information.""").tag(sync=True)
    
    universalTransition = Any(None, allow_none=True, help="""> Since `v5.2.0`


Configuration related to universal transition animation.


Universal Transition provides the ability to morph between any series. With this feature enabled, each time `setOption`, transitions between series with the same `id` will be automatically associated with each other.


One-to-many or many-to-one animations such as drill-down, aggregation, etc. can also be achieved by specifying data items' `groupId` and `childGroupId`.


This can be enabled directly by configuring `universalTransition: true` in the series. It is also possible to provide an object for more detailed configuration.""").tag(sync=True)
    
    tooltip = Dict(default_value=None, allow_none=True, help="""tooltip settings in this series.""").tag(sync=True)
    
        
