from traitlets import (
    Unicode, Dict, Float, Union, Any,
)
from ..basewidget import BaseWidget


class FlowGL(BaseWidget):
    """ 
:warning: **Autogenerated class**

The `flowGL` component visualizes the traces of the vector field through the particle effects implemented by WebGL.


The figure below shows the effect of the global wind field visualized by `flowGL`.


![](documents/asset/gl/img/flowGL-wind.jpg)



    """

    def __init__(self, **kwargs):

        super().__init__(**kwargs)  
    
    _model_name = Unicode("FlowGLModel").tag(sync=True)
    
    type = Unicode("flowGL", allow_none=True, ).tag(sync=True)
    
    particleDensity = Float(None, allow_none=True, help="""The density of the particles. The actual number of particles is the square of the set number. The higher the particle density, the better the trace effect, but the greater the performance overhead. In addition to this property, you can get a clearer and more consistent trace using [particleType](#series-flowGL.particleType).""").tag(sync=True)
    
    particleType = Unicode(None, allow_none=True, help="""The type of particle. The default is `'point'`, which can be set to `'line'`. Line-type particles connect the position of the last motion to the position of the current motion with a line, which makes the trajectory more consistent.


The following are the differences between the types of point'`and`'line'`.



![](documents/asset/gl/img/flowGL-point.jpg "Point")
![](documents/asset/gl/img/flowGL-line.jpg "Line")""").tag(sync=True)
    
    particleSize = Float(None, allow_none=True, help="""The size of the particle. If [particleType](#series-flowGL.particleType) is `'line'`, will be expressed as a line width.""").tag(sync=True)
    
    particleSpeed = Float(None, allow_none=True, help="""The speed of the particle, the default is 1. Note that when [particleType](#series-flowGL.particleType) is `'point'`, the excessive speed will make the entire track become intermittent.""").tag(sync=True)
    
    particleTrail = Float(None, allow_none=True, help="""The length of the track of the particle. The larger the value, the longer the track.""").tag(sync=True)
    
    supersampling = Float(None, allow_none=True, help="""The oversampling ratio of the picture, using the '4' supersampling can effectively improve the sharpness of the picture and reduce the picture sawtooth. However, because there is a need to process more pixels, there is a higher performance requirement.


The following are the differences between no oversampling and a supersampling value of 4.



![](documents/asset/gl/img/flowGL-noss.jpg "No supersampling")
![](documents/asset/gl/img/flowGL-ss.jpg "Supersampling=4")""").tag(sync=True)
    
    gridWidth = Union([Float(default_value=None, allow_none=True),Unicode(default_value=None, allow_none=True),], default_value=None, allow_none=True, help="""The number of grid widths of the incoming grid data. `flowGL` will create a floating-point texture of the stored vector field based on this value and [gridHeight](#series-flowGL.gridHeight) for the particle's trajectory calculation.""").tag(sync=True)
    
    gridHeight = Union([Float(default_value=None, allow_none=True),Unicode(default_value=None, allow_none=True),], default_value=None, allow_none=True, help="""The number of grid heights of incoming grid data.""").tag(sync=True)
    
    data = Any(None, allow_none=True, help="""The data of the vector field, including the position of the vector and the direction of the vector (including the size). `flowGL` has no mandatory requirements for the order in which data is stored. You can even pass in sparse vector data.


Example:



```
data: [
    // Each data item contains four values representing the lng, lat of the position and the speed sLng, sLat on the corresponding dimension.
    // If it is in a Cartesian coordinate system, it is the position x, y and the speed in the corresponding dimension sx, sy
    [0, 0, 1, 1], [1, 0, 1, 1],
    [0, 1, 1, 1], [1, 1, 1, 1]
];

```

The default `flowGL` will automatically calculate [gridWidth](#series-flowGL.gridWidth) and [gridHeight](#series-flowGL.gridHeight) based on the regular grid data. But because flowGL also supports relatively sparse data formats, you can also specify these two values manually.""").tag(sync=True)
    
    itemStyle = Dict(default_value=None, allow_none=True, help="""The style of the vector field trace.""").tag(sync=True)
    
        
