from traitlets import (
    Unicode, Dict, Float, Bool, Union, Any,
)
from ..basewidget import BaseWidget


class Gauge(BaseWidget):
    """ 
:warning: **Autogenerated class**

**Gauge chart**


**Example:** 




    """

    def __init__(self, **kwargs):

        super().__init__(**kwargs)  
    
    _model_name = Unicode("GaugeModel").tag(sync=True)
    
    type = Unicode("gauge", allow_none=True, ).tag(sync=True)
    
    id = Unicode(None, allow_none=True, help="""Component ID, not specified by default. If specified, it can be used to refer the component in option or API.""").tag(sync=True)
    
    name = Unicode(None, allow_none=True, help="""Series name used for displaying in [tooltip](#tooltip) and filtering with [legend](#legend), or updating data and configuration with `setOption`.""").tag(sync=True)
    
    colorBy = Unicode(None, allow_none=True, help="""> Since `v5.2.0`


The policy to take color from [option.color](#color). Valid values:


* `'series'`: assigns the colors in the palette by series, so that all data in the same series are in the same color;
* `'data'`: assigns colors in the palette according to data items, with each data item using a different color.""").tag(sync=True)
    
    zlevel = Float(None, allow_none=True, help="""`zlevel` value of all graphical elements in .


`zlevel` is used to make layers with Canvas. Graphical elements with different `zlevel` values will be placed in different Canvases, which is a common optimization technique. We can put those frequently changed elements (like those with animations) to a separate `zlevel`. Notice that too many Canvases will increase memory cost, and should be used carefully on mobile phones to avoid crash.


Canvases with bigger `zlevel` will be placed on Canvases with smaller `zlevel`.""").tag(sync=True)
    
    z = Float(None, allow_none=True, help="""`z` value of all graphical elements in , which controls order of drawing graphical components. Components with smaller `z` values may be overwritten by those with larger `z` values.


`z` has a lower priority to `zlevel`, and will not create new Canvas.""").tag(sync=True)
    
    center = Any(None, allow_none=True, help="""Center position of , the first of which is the horizontal position, and the second is the vertical position.


Percentage is supported. When set in percentage, the item is relative to the container width, and the second item to the height.


**Example:** 



```
// Set to absolute pixel values
center: [400, 300]
// Set to relative percent
center: ['50%', '50%']

```""").tag(sync=True)
    
    radius = Union([Float(default_value=None, allow_none=True),Unicode(default_value=None, allow_none=True),], default_value=None, allow_none=True, help="""The radius of gauge chart. It can be a percentage value of the smaller of container half width and half height, also can be an absolute value.""").tag(sync=True)
    
    legendHoverLink = Bool(None, allow_none=True, help="""Whether to enable highlighting chart when [legend](#legend) is being hovered.""").tag(sync=True)
    
    startAngle = Float(None, allow_none=True, help="""The start angle of gauge chart. The direct right side of [circle center](#series-gauge.center) is `0` degree, the right above it is `90` degree, the direct left side of it is `180` degree.""").tag(sync=True)
    
    endAngle = Float(None, allow_none=True, help="""The end angle of gauge chart.""").tag(sync=True)
    
    clockwise = Bool(None, allow_none=True, help="""Whether the scale in gauge chart increases clockwise.""").tag(sync=True)
    
    data = Any(None, allow_none=True, help="""Data array of series, which can be a single data value, like:



```
[12, 34, 56, 10, 23]

```

Or, if need extra dimensions for components like [visualMap](#visualMap) to map to graphic attributes like color, it can also be in the form of array. For example:



```
[[12, 14], [34, 50], [56, 30], [10, 15], [23, 10]]

```

In this case, we can assign the second value in each array item to [visualMap](#visualMap) component.


More likely, we need to assign name to each data item, in which case each item should be an object:



```
[{
    // name of date item
    name: 'data1',
    // value of date item is 8
    value: 10
}, {
    name: 'data2',
    value: 20
}]

```

Each data item can be further customized:



```
[{
    name: 'data1',
    value: 10
}, {
    // name of data item
    name: 'data2',
    value : 56,
    // user-defined label format that only useful for this data item
    label: {},
    // user-defined special itemStyle that only useful for this data item
    itemStyle:{}
}]

```""").tag(sync=True)
    
    min = Float(None, allow_none=True, help="""The minimum data value which map to [minAngle](#series-gauge.minAngle).""").tag(sync=True)
    
    max = Float(None, allow_none=True, help="""The maximum data value which map to [maxAngle](#series-gauge.maxAngle).""").tag(sync=True)
    
    splitNumber = Float(None, allow_none=True, help="""The number of split segments of gauge chart scale.""").tag(sync=True)
    
    axisLine = Dict(default_value=None, allow_none=True, help="""The related configuration about the axis line of gauge chart.""").tag(sync=True)
    
    progress = Dict(default_value=None, allow_none=True, help="""> Since `v5.0`


Used to show current progress.""").tag(sync=True)
    
    splitLine = Dict(default_value=None, allow_none=True, help="""The style of split line.""").tag(sync=True)
    
    axisTick = Dict(default_value=None, allow_none=True, help="""The tick line style.""").tag(sync=True)
    
    axisLabel = Dict(default_value=None, allow_none=True, help="""Axis tick label.""").tag(sync=True)
    
    pointer = Dict(default_value=None, allow_none=True, help="""Gauge chart pointer.""").tag(sync=True)
    
    anchor = Dict(default_value=None, allow_none=True, help="""> Since `v5.0`


The fixed point of a pointer in a dial.""").tag(sync=True)
    
    itemStyle = Dict(default_value=None, allow_none=True, help="""The style of gauge chart.""").tag(sync=True)
    
    emphasis = Dict(default_value=None, allow_none=True, help="""Configurations of emphasis state.""").tag(sync=True)
    
    title = Dict(default_value=None, allow_none=True, help="""The title of gauge chart.""").tag(sync=True)
    
    detail = Dict(default_value=None, allow_none=True, help="""The detail about gauge chart which is used to show data.""").tag(sync=True)
    
    markPoint = Dict(default_value=None, allow_none=True, help="""Mark point in a chart.""").tag(sync=True)
    
    markLine = Dict(default_value=None, allow_none=True, help="""Use a line in the chart to illustrate.""").tag(sync=True)
    
    markArea = Dict(default_value=None, allow_none=True, help="""Used to mark an area in chart. For example, mark a time interval.""").tag(sync=True)
    
    silent = Bool(None, allow_none=True, help="""Whether to ignore mouse events. Default value is false, for triggering and responding to mouse events.""").tag(sync=True)
    
    animation = Bool(None, allow_none=True, help="""Whether to enable animation.""").tag(sync=True)
    
    animationThreshold = Float(None, allow_none=True, help="""Whether to set graphic number threshold to animation. Animation will be disabled when graphic number is larger than threshold.""").tag(sync=True)
    
    animationDuration = Union([Float(default_value=None, allow_none=True),Any(default_value=None, allow_none=True),], default_value=None, allow_none=True, help="""Duration of the first animation, which supports callback function for different data to have different animation effect:



```
animationDuration: function (idx) {
    // delay for later data is larger
    return idx * 100;
}

```""").tag(sync=True)
    
    animationEasing = Unicode(None, allow_none=True, help="""Easing method used for the first animation. Varied easing effects can be found at [easing effect example](https://echarts.apache.org/examples/en/editor.html?c=line-easing).""").tag(sync=True)
    
    animationDelay = Union([Float(default_value=None, allow_none=True),Any(default_value=None, allow_none=True),], default_value=None, allow_none=True, help="""Delay before updating the first animation, which supports callback function for different data to have different animation effect.


For example:



```
animationDelay: function (idx) {
    // delay for later data is larger
    return idx * 100;
}

```

See [this example](https://echarts.apache.org/examples/en/editor.html?c=bar-animation-delay) for more information.""").tag(sync=True)
    
    animationDurationUpdate = Union([Float(default_value=None, allow_none=True),Any(default_value=None, allow_none=True),], default_value=None, allow_none=True, help="""Time for animation to complete, which supports callback function for different data to have different animation effect:



```
animationDurationUpdate: function (idx) {
    // delay for later data is larger
    return idx * 100;
}

```""").tag(sync=True)
    
    animationEasingUpdate = Unicode(None, allow_none=True, help="""Easing method used for animation.""").tag(sync=True)
    
    animationDelayUpdate = Union([Float(default_value=None, allow_none=True),Any(default_value=None, allow_none=True),], default_value=None, allow_none=True, help="""Delay before updating animation, which supports callback function for different data to have different animation effects.


For example:



```
animationDelayUpdate: function (idx) {
    // delay for later data is larger
    return idx * 100;
}

```

See [this example](https://echarts.apache.org/examples/en/editor.html?c=bar-animation-delay) for more information.""").tag(sync=True)
    
    tooltip = Dict(default_value=None, allow_none=True, help="""tooltip settings in this series.""").tag(sync=True)
    
        
