from traitlets import (
    Unicode, Dict, Float, Bool, Union, Any,
)
from ..basewidget import BaseWidget


class Graph(BaseWidget):
    """ 
:warning: **Autogenerated class**

**relation graph**


Graph is a diagram to represent [nodes](#series-graph.nodes) and the [links](#series-graph.links) connecting nodes.


**Example:** 




    """

    def __init__(self, **kwargs):

        super().__init__(**kwargs)  
    
    _model_name = Unicode("GraphModel").tag(sync=True)
    
    type = Unicode("graph", allow_none=True, ).tag(sync=True)
    
    id = Unicode(None, allow_none=True, help="""Component ID, not specified by default. If specified, it can be used to refer the component in option or API.""").tag(sync=True)
    
    name = Unicode(None, allow_none=True, help="""Series name used for displaying in [tooltip](#tooltip) and filtering with [legend](#legend), or updating data and configuration with `setOption`.""").tag(sync=True)
    
    legendHoverLink = Bool(None, allow_none=True, help="""Whether to enable highlighting chart when [legend](#legend) is being hovered.""").tag(sync=True)
    
    coordinateSystem = Unicode(None, allow_none=True, help="""The coordinate used in the series, whose options are:


* `null` or `'none'`


 No coordinate.


* `'cartesian2d'`


 Use a two-dimensional rectangular coordinate (also known as Cartesian coordinate), with [xAxisIndex](#series-graph.xAxisIndex) and [yAxisIndex](#series-graph.yAxisIndex) to assign the corresponding axis component.


* `'polar'`


 Use polar coordinates, with [polarIndex](#series-graph.polarIndex) to assign the corresponding polar coordinate component.


* `'geo'`


 Use geographic coordinate, with [geoIndex](#series-graph.geoIndex) to assign the corresponding geographic coordinate components.


* `'calendar'`


 Use calendar coordinates, with [calendarIndex](#series-graph.calendarIndex) to assign the corresponding calendar coordinate components.


* `'none'`


 Do not use coordinate system.""").tag(sync=True)
    
    xAxisIndex = Float(None, allow_none=True, help="""Index of [x axis](#xAxis) to combine with, which is useful for multiple x axes in one chart.""").tag(sync=True)
    
    yAxisIndex = Float(None, allow_none=True, help="""Index of [y axis](#yAxis) to combine with, which is useful for multiple y axes in one chart.""").tag(sync=True)
    
    polarIndex = Float(None, allow_none=True, help="""Index of [polar coordinate](#polar) to combine with, which is useful for multiple polar axes in one chart.""").tag(sync=True)
    
    geoIndex = Float(None, allow_none=True, help="""Index of [geographic coordinate](#geo) to combine with, which is useful for multiple geographic axes in one chart.""").tag(sync=True)
    
    calendarIndex = Float(None, allow_none=True, help="""Index of [calendar coordinates](#calendar) to combine with, which is useful for multiple calendar coordinates in one chart.""").tag(sync=True)
    
    center = Any(None, allow_none=True, help="""Center of current view-port. It can be an array containing two `number`s in pixels or `string`s in percentage relative to the container width/height.
`string` is supported from version `5.3.3`.


Example:



```
center: [115.97, '30%']

```""").tag(sync=True)
    
    zoom = Float(None, allow_none=True, help="""Zoom rate of current view-port.""").tag(sync=True)
    
    layout = Unicode(None, allow_none=True, help="""Graph layout.


**Options:** 


* `'none'` No any layout, use [x](#series-graph.data.x), [y](#series-graph.data.y) provided in [node](#series-graph.data) as the position of node.
* `'circular'` Adopt circular layout, see the example [Les Miserables](https://echarts.apache.org/examples/en/editor.html?c=graph-circular-layout).
* `'force'` Adopt force-directed layout, see the example [Force](https://echarts.apache.org/examples/en/editor.html?c=graph-force), the detail about configurations of layout are in [graph.force](#series-graph.force)""").tag(sync=True)
    
    circular = Dict(default_value=None, allow_none=True, help="""Configuration about circular layout.""").tag(sync=True)
    
    force = Dict(default_value=None, allow_none=True, help="""Configuration items about force-directed layout. Force-directed layout simulates spring/charge model, which will add a repulsion between 2 nodes and add a attraction between 2 nodes of each edge. In each iteration nodes will move under the effect of repulsion and attraction. After several iterations, the nodes will be static in a balanced position. As a result, the energy local minimum of this whole model will be realized.


The result of force-directed layout has a good symmetries and clustering, which is also aesthetically pleasing.""").tag(sync=True)
    
    roam = Union([Bool(default_value=None, allow_none=True),Unicode(default_value=None, allow_none=True),], default_value=None, allow_none=True, help="""Whether to enable mouse zooming and translating. `false` by default. If either zooming or translating is wanted, it can be set to `'scale'` or `'move'`. Otherwise, set it to be `true` to enable both.""").tag(sync=True)
    
    scaleLimit = Dict(default_value=None, allow_none=True, help="""Limit of scaling, with `min` and `max`. `1` by default.""").tag(sync=True)
    
    nodeScaleRatio = Float(None, allow_none=True, help="""Related zooming ratio of nodes when mouse zooming in or out. When it is set as 0, the node will not zoom as the mouse zooms.""").tag(sync=True)
    
    draggable = Bool(None, allow_none=True, help="""If node is draggable.


Note that this option is only available when using [force-directed layout](#series-graph.force) before `v5.4.1`.""").tag(sync=True)
    
    symbol = Unicode(None, allow_none=True, help="""Symbol of node.


Icon types provided by ECharts includes


`'circle'`, `'rect'`, `'roundRect'`, `'triangle'`, `'diamond'`, `'pin'`, `'arrow'`, `'none'`


It can be set to an image with `'image://url'` , in which URL is the link to an image, or `dataURI` of an image.


An image URL example:



```
'image://http://example.website/a/b.png'

```
A `dataURI` example:



```
'image://data:image/gif;base64,R0lGODlhEAAQAMQAAORHHOVSKudfOulrSOp3WOyDZu6QdvCchPGolfO0o/XBs/fNwfjZ0frl3/zy7////wAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACH5BAkAABAALAAAAAAQABAAAAVVICSOZGlCQAosJ6mu7fiyZeKqNKToQGDsM8hBADgUXoGAiqhSvp5QAnQKGIgUhwFUYLCVDFCrKUE1lBavAViFIDlTImbKC5Gm2hB0SlBCBMQiB0UjIQA7'

```
Icons can be set to arbitrary vector path via `'path://'` in ECharts. As compared with a raster image, vector paths prevent jagging and blurring when scaled, and have better control over changing colors. The size of the vector icon will be adapted automatically. Refer to [SVG PathData](http://www.w3.org/TR/SVG/paths.html#PathData) for more information about the format of the path. You may export vector paths from tools like Adobe 


For example:



```
'path://M30.9,53.2C16.8,53.2,5.3,41.7,5.3,27.6S16.8,2,30.9,2C45,2,56.4,13.5,56.4,27.6S45,53.2,30.9,53.2z M30.9,3.5C17.6,3.5,6.8,14.4,6.8,27.6c0,13.3,10.8,24.1,24.101,24.1C44.2,51.7,55,40.9,55,27.6C54.9,14.4,44.1,3.5,30.9,3.5z M36.9,35.8c0,0.601-0.4,1-0.9,1h-1.3c-0.5,0-0.9-0.399-0.9-1V19.5c0-0.6,0.4-1,0.9-1H36c0.5,0,0.9,0.4,0.9,1V35.8z M27.8,35.8 c0,0.601-0.4,1-0.9,1h-1.3c-0.5,0-0.9-0.399-0.9-1V19.5c0-0.6,0.4-1,0.9-1H27c0.5,0,0.9,0.4,0.9,1L27.8,35.8L27.8,35.8z'

```""").tag(sync=True)
    
    symbolSize = Union([Float(default_value=None, allow_none=True),Any(default_value=None, allow_none=True),], default_value=None, allow_none=True, help="""node symbol size. It can be set to single numbers like `10`, or use an array to represent width and height. For example, `[20, 10]` means symbol width is `20`, and height is`10`.""").tag(sync=True)
    
    symbolRotate = Float(None, allow_none=True, help="""Rotate degree of node symbol. The negative value represents clockwise. Note that when `symbol` is set to be `'arrow'` in `markLine`, `symbolRotate` value will be ignored, and compulsively use tangent angle.""").tag(sync=True)
    
    symbolKeepAspect = Bool(None, allow_none=True, help="""Whether to keep aspect for symbols in the form of `path://`.""").tag(sync=True)
    
    symbolOffset = Any(None, allow_none=True, help="""Offset of node symbol relative to original position. By default, symbol will be put in the center position of data. But if symbol is from user-defined vector path or image, you may not expect symbol to be in center. In this case, you may use this attribute to set offset to default position. It can be in absolute pixel value, or in relative percentage value.


For example, `[0, '-50%']` means to move upside side position of symbol height. It can be used to make the arrow in the bottom to be at data position when symbol is pin.""").tag(sync=True)
    
    edgeSymbol = Union([Any(default_value=None, allow_none=True),Unicode(default_value=None, allow_none=True),], default_value=None, allow_none=True, help="""Symbol of two ends of edge line.


For example:



```
edgeSymbol: ['circle', 'arrow']

```""").tag(sync=True)
    
    edgeSymbolSize = Union([Any(default_value=None, allow_none=True),Float(default_value=None, allow_none=True),], default_value=None, allow_none=True, help="""Size of symbol of two ends of edge line. Can be an array or a single number.


For example:



```
// Start symbol has size 5 and end symbol has size 10
edgeSymbolSize: [5, 10],
// All has size 10
edgeSymbolSize: 10

```""").tag(sync=True)
    
    cursor = Unicode(None, allow_none=True, help="""The mouse style when mouse hovers on an element, the same as `cursor` property in `CSS`.""").tag(sync=True)
    
    itemStyle = Dict(default_value=None, allow_none=True, help="""Graphic style of , `emphasis` is the style when it is highlighted, like being hovered by mouse, or highlighted via legend connect.""").tag(sync=True)
    
    lineStyle = Dict(default_value=None, allow_none=True, help="""The style of edge line. [lineStyle.color](#series-graph.lineStyle.color) can be `'source'` or `'target'`, which will use the color of source node or target node.""").tag(sync=True)
    
    label = Dict(default_value=None, allow_none=True, help="""Text label of , to explain some data information about graphic item like value, name and so on. `label` is placed under `itemStyle` in ECharts 2.x. In ECharts 3, to make the configuration structure flatter, `label`is taken to be at the same level with `itemStyle`, and has `emphasis` as `itemStyle` does.""").tag(sync=True)
    
    edgeLabel = Dict(default_value=None, allow_none=True, ).tag(sync=True)
    
    labelLayout = Union([Any(default_value=None, allow_none=True),Any(default_value=None, allow_none=True),], default_value=None, allow_none=True, help="""> Since `v5.0.0`


Unified layout configuration of labels.


It provide a chance to adjust the labels' `(x, y)` position, alignment based on the original layout each series provides.


This option can be a callback with following parameters.



```
// corresponding index of data
dataIndex: number
// corresponding type of data. Only available in graph, in which it can be 'node' or 'edge'
dataType?: string
// corresponding index of series
seriesIndex: number
// Displayed text of label.
text: string
// Bounding rectangle of label.
labelRect: {x: number, y: number, width: number, height: number}
// Horizontal alignment of label.
align: 'left' | 'center' | 'right'
// Vertical alignment of label.
verticalAlign: 'top' | 'middle' | 'bottom'
// Bounding rectangle of the element corresponding to.
rect: {x: number, y: number, width: number, height: number}
// Default points array of labelLine. Currently only provided in pie and funnel series.
// It's null in other series.
labelLinePoints?: number[][]

```

**Example:**


Align the labels on the right. Left 10px margin to the edge.



```
labelLayout(params) {
    return {
        x: params.rect.x + 10,
        y: params.rect.y + params.rect.height / 2,
        verticalAlign: 'middle',
        align: 'left'
    }
}

```

Set the text size based on the size of element bounding rectangle.



```

labelLayout(params) {
    return {
        fontSize: Math.max(params.rect.width / 10, 5)
    };
}

```""").tag(sync=True)
    
    emphasis = Dict(default_value=None, allow_none=True, help="""Configurations of emphasis state.""").tag(sync=True)
    
    blur = Dict(default_value=None, allow_none=True, help="""> Since `v5.0.0`


Configurations of blur state. Available when [emphasis.focus](#series-graph.emphasis.focus) is set.""").tag(sync=True)
    
    select = Dict(default_value=None, allow_none=True, help="""> Since `v5.0.0`


Configurations of select state. Available when [selectedMode](#series-graph.selectedMode) is set.""").tag(sync=True)
    
    selectedMode = Union([Bool(default_value=None, allow_none=True),Unicode(default_value=None, allow_none=True),], default_value=None, allow_none=True, help="""> Since `v5.0.0`


Selected mode. It is enabled by default, and you may set it to be `false` to disable it.


Besides, it can be set to `'single'`, `'multiple'` or `'series'`, for single selection, multiple selections and whole series selection.



> `'series'` is supported since v5.3.0""").tag(sync=True)
    
    categories = Any(None, allow_none=True, help="""The categories of node, which is optional.
If there is a classification of nodes, the category of each node can be assigned through [data[i].category](#series-graph.data.category). And the style of category will also be applied to the style of nodes. `categories` can also be used in [legend](#legend).""").tag(sync=True)
    
    autoCurveness = Union([Bool(default_value=None, allow_none=True),Float(default_value=None, allow_none=True),Any(default_value=None, allow_none=True),], default_value=None, allow_none=True, help="""For the situation where there are multiple links between nodes, the curveness of each link is automatically calculated, not enabled by default.


When set `true` to enable automatic curvature calculation, the default edge curvenness array length is `20`, if the number of edges between two nodes is more than `20`, please use `number` or `Array` to set the edge curvenness array.


When set to `number`, it indicates the length of the edge curvenness array between two nodes, and the calculation result is given by the internal algorithm.


When set to `Array`, it means that the curveness array is directly specified, and the multilateral curveness is directly selected from the array.


**Notice：** if [lineStyle.curveness](#series-graph.lineStyle.curveness) has been set, this property is invalid.""").tag(sync=True)
    
    data = Any(None, allow_none=True, help="""Nodes list of graph.



```
data: [{
    name: '1',
    x: 10,
    y: 10,
    value: 10
}, {
    name: '2',
    x: 100,
    y: 100,
    value: 20,
    symbolSize: 20,
    itemStyle: {
        color: 'red'
    }
}]

```""").tag(sync=True)
    
    nodes = Any(None, allow_none=True, help="""Alias of [data](#series-graph.data)""").tag(sync=True)
    
    links = Any(None, allow_none=True, help="""Relational data between nodes. Example:



```
links: [{
    source: 'n1',
    target: 'n2'
}, {
    source: 'n2',
    target: 'n3'
}]

```""").tag(sync=True)
    
    edges = Any(None, allow_none=True, help="""Alias of [links](#series-graph.links)""").tag(sync=True)
    
    markPoint = Dict(default_value=None, allow_none=True, help="""Mark point in a chart.""").tag(sync=True)
    
    markLine = Dict(default_value=None, allow_none=True, help="""Use a line in the chart to illustrate.""").tag(sync=True)
    
    markArea = Dict(default_value=None, allow_none=True, help="""Used to mark an area in chart. For example, mark a time interval.""").tag(sync=True)
    
    zlevel = Float(None, allow_none=True, help="""`zlevel` value of all graphical elements in .


`zlevel` is used to make layers with Canvas. Graphical elements with different `zlevel` values will be placed in different Canvases, which is a common optimization technique. We can put those frequently changed elements (like those with animations) to a separate `zlevel`. Notice that too many Canvases will increase memory cost, and should be used carefully on mobile phones to avoid crash.


Canvases with bigger `zlevel` will be placed on Canvases with smaller `zlevel`.""").tag(sync=True)
    
    z = Float(None, allow_none=True, help="""`z` value of all graphical elements in , which controls order of drawing graphical components. Components with smaller `z` values may be overwritten by those with larger `z` values.


`z` has a lower priority to `zlevel`, and will not create new Canvas.""").tag(sync=True)
    
    left = Union([Unicode(default_value=None, allow_none=True),Float(default_value=None, allow_none=True),], default_value=None, allow_none=True, help="""Distance between component and the left side of the container.


`left` can be a pixel value like `20`; it can also be a percentage value relative to container width like `'20%'`; and it can also be `'left'`, `'center'`, or `'right'`.


If the `left` value is set to be `'left'`, `'center'`, or `'right'`, then the component will be aligned automatically based on position.""").tag(sync=True)
    
    top = Union([Unicode(default_value=None, allow_none=True),Float(default_value=None, allow_none=True),], default_value=None, allow_none=True, help="""Distance between component and the top side of the container.


`top` can be a pixel value like `20`; it can also be a percentage value relative to container width like `'20%'`; and it can also be `'top'`, `'middle'`, or `'bottom'`.


If the `top` value is set to be `'top'`, `'middle'`, or `'bottom'`, then the component will be aligned automatically based on position.""").tag(sync=True)
    
    right = Union([Unicode(default_value=None, allow_none=True),Float(default_value=None, allow_none=True),], default_value=None, allow_none=True, help="""Distance between component and the right side of the container.


`right` can be a pixel value like `20`; it can also be a percentage value relative to container width like `'20%'`.


Adaptive by default.""").tag(sync=True)
    
    bottom = Union([Unicode(default_value=None, allow_none=True),Float(default_value=None, allow_none=True),], default_value=None, allow_none=True, help="""Distance between component and the bottom side of the container.


`bottom` can be a pixel value like `20`; it can also be a percentage value relative to container width like `'20%'`.


Adaptive by default.""").tag(sync=True)
    
    width = Union([Unicode(default_value=None, allow_none=True),Float(default_value=None, allow_none=True),], default_value=None, allow_none=True, help="""Width of component.""").tag(sync=True)
    
    height = Union([Unicode(default_value=None, allow_none=True),Float(default_value=None, allow_none=True),], default_value=None, allow_none=True, help="""Height of component.""").tag(sync=True)
    
    silent = Bool(None, allow_none=True, help="""Whether to ignore mouse events. Default value is false, for triggering and responding to mouse events.""").tag(sync=True)
    
    animation = Bool(None, allow_none=True, help="""Whether to enable animation.""").tag(sync=True)
    
    animationThreshold = Float(None, allow_none=True, help="""Whether to set graphic number threshold to animation. Animation will be disabled when graphic number is larger than threshold.""").tag(sync=True)
    
    animationDuration = Union([Float(default_value=None, allow_none=True),Any(default_value=None, allow_none=True),], default_value=None, allow_none=True, help="""Duration of the first animation, which supports callback function for different data to have different animation effect:



```
animationDuration: function (idx) {
    // delay for later data is larger
    return idx * 100;
}

```""").tag(sync=True)
    
    animationEasing = Unicode(None, allow_none=True, help="""Easing method used for the first animation. Varied easing effects can be found at [easing effect example](https://echarts.apache.org/examples/en/editor.html?c=line-easing).""").tag(sync=True)
    
    animationDelay = Union([Float(default_value=None, allow_none=True),Any(default_value=None, allow_none=True),], default_value=None, allow_none=True, help="""Delay before updating the first animation, which supports callback function for different data to have different animation effect.


For example:



```
animationDelay: function (idx) {
    // delay for later data is larger
    return idx * 100;
}

```

See [this example](https://echarts.apache.org/examples/en/editor.html?c=bar-animation-delay) for more information.""").tag(sync=True)
    
    animationDurationUpdate = Union([Float(default_value=None, allow_none=True),Any(default_value=None, allow_none=True),], default_value=None, allow_none=True, help="""Time for animation to complete, which supports callback function for different data to have different animation effect:



```
animationDurationUpdate: function (idx) {
    // delay for later data is larger
    return idx * 100;
}

```""").tag(sync=True)
    
    animationEasingUpdate = Unicode(None, allow_none=True, help="""Easing method used for animation.""").tag(sync=True)
    
    animationDelayUpdate = Union([Float(default_value=None, allow_none=True),Any(default_value=None, allow_none=True),], default_value=None, allow_none=True, help="""Delay before updating animation, which supports callback function for different data to have different animation effects.


For example:



```
animationDelayUpdate: function (idx) {
    // delay for later data is larger
    return idx * 100;
}

```

See [this example](https://echarts.apache.org/examples/en/editor.html?c=bar-animation-delay) for more information.""").tag(sync=True)
    
    tooltip = Dict(default_value=None, allow_none=True, help="""tooltip settings in this series.""").tag(sync=True)
    
        
