from traitlets import (
    Unicode, Dict, Float, Union, Any,
)
from ..basewidget import BaseWidget


class GraphGL(BaseWidget):
    """ 
:warning: **Autogenerated class**

Uses WebGL to drawn the relational chart, support the layout and rendering of large-scale network/relational data.



    """

    def __init__(self, **kwargs):

        super().__init__(**kwargs)  
    
    _model_name = Unicode("GraphGLModel").tag(sync=True)
    
    type = Unicode("graphGL", allow_none=True, ).tag(sync=True)
    
    name = Unicode(None, allow_none=True, help="""Series name used for displaying in [tooltip](https://echarts.apache.org/zh/option.html#tooltip) and filtering with [legend](https://echarts.apache.org/zh/option.html#legend), or updating data and configuration with `setOption`.""").tag(sync=True)
    
    layout = Unicode(None, allow_none=True, help="""The continuous graph layout algorithm supports the [forceAtlas2](https://github.com/gephi/gephi/wiki/Force-Atlas-2) algorithm layout using gephi.""").tag(sync=True)
    
    forceAtlas2 = Dict(default_value=None, allow_none=True, help="""[forceAtlas2](https://github.com/gephi/gephi/wiki/Force-Atlas-2) a continuous graph layout algorithm.


The algorithm has efficient layout efficiency and stable layout results for large-scale network data.


Support for configuring GPU or CPU layout via [forceAtlas2.GPU](#series-graphGL.forceAtlas2.GPU).


The advantage of the CPU is that it is compatible, and the GPU implementation has dozens or even hundreds of performance advantages in high-end graphics cards.


Below is a performance comparison of the iteration of a layout of a 2w node (nearly 5w edges) on a GTX1070 and an i7 4GHz computer.


![](documents/asset/gl/img/gpu-layout-perf.png)""").tag(sync=True)
    
    symbol = Unicode(None, allow_none=True, help="""The shape of the scatter. The default is a circle.


Icon types provided by ECharts includes 
`'circle'`, `'rect'`, `'roundRect'`, `'triangle'`, `'diamond'`, `'pin'`, `'arrow'`, `'none'`


Icons can be set to arbitrary vector path via `'path://'` in ECharts. As compared with a raster image, vector paths prevent jagging and blurring when scaled, and have better control over changing colors. The size of the vector icon will be adapted automatically. Refer to [SVG PathData](http://www.w3.org/TR/SVG/paths.html#PathData) for more information about the format of the path. You may export vector paths from tools like Adobe""").tag(sync=True)
    
    symbolSize = Union([Float(default_value=None, allow_none=True),Any(default_value=None, allow_none=True),Any(default_value=None, allow_none=True),], default_value=None, allow_none=True, help="""symbol size. It can be set to single numbers like `10`, or use an array to represent width and height. For example, `[20, 10]` means symbol width is `20`, and height is`10`.


If size of symbols needs to be different, you can set with callback function in the following format:



```
(value: Array|number, params: Object) => number|Array

```

The first parameter `value` is the value in [data](#series-.data), and the second parameter `params` is the rest parameters of data item.""").tag(sync=True)
    
    itemStyle = Dict(default_value=None, allow_none=True, help="""The style settings for the node.""").tag(sync=True)
    
    lineStyle = Dict(default_value=None, allow_none=True, help="""The style setting of the relationship line.""").tag(sync=True)
    
    data = Any(None, allow_none=True, help="""The data set of the node.


The data format is the same as [graph.data](https://echarts.apache.org/en/option.html#series-graph.data)""").tag(sync=True)
    
    nodes = Any(None, allow_none=True, help="""Same as [graphGL.data](#series-graphGL.data).""").tag(sync=True)
    
    links = Any(None, allow_none=True, help="""Relational data between nodes.
The data format is the same as [graph.links](https://echarts.apache.org/en/option.html#series-graph.links)""").tag(sync=True)
    
    edges = Any(None, allow_none=True, help="""Same as [graphGL.links](#series-graphGL.links)""").tag(sync=True)
    
    zlevel = Float(None, allow_none=True, help="""The layer in which the component is located.


`zlevel` is used to make layers with Canvas. Graphical elements with different `zlevel` values will be placed in different Canvases, which is a common optimization technique. We can put those frequently changed elements (like those with animations) to a separate `zlevel`. Notice that too many Canvases will increase memory cost, and should be used carefully on mobile phones to avoid the crash.


Canvases with bigger `zlevel` will be placed on Canvases with smaller `zlevel`.


**Note:** The layers of the components in echarts-gl need to be separated from the layers of the components in echarts. The same `zlevel` cannot be used for both WebGL and Canvas drawing at the same time.""").tag(sync=True)
    
        
