from traitlets import (
    Unicode, Dict, Float, Bool, Any,
)
from ..basewidget import BaseWidget


class Line3D(BaseWidget):
    """ 
:warning: **Autogenerated class**

3D Line. Can be used for [grid3D] (~grid3D)


![](documents/asset/gl/img/line3D.png)



    """

    def __init__(self, **kwargs):

        super().__init__(**kwargs)  
    
    _model_name = Unicode("Line3DModel").tag(sync=True)
    
    type = Unicode("line3D", allow_none=True, ).tag(sync=True)
    
    name = Unicode(None, allow_none=True, help="""Series name used for displaying in [tooltip](https://echarts.apache.org/zh/option.html#tooltip) and filtering with [legend](https://echarts.apache.org/zh/option.html#legend), or updating data and configuration with `setOption`.""").tag(sync=True)
    
    coordinateSystem = Unicode(None, allow_none=True, help="""The coordinate used in the series, whose options are:


* `'cartesian3D'`


 Use a 3D rectangular coordinate (also known as Cartesian coordinate), with [xAxisIndex](#series-.xAxisIndex) and [yAxisIndex](#series-.yAxisIndex) to assign the corresponding axis component.""").tag(sync=True)
    
    grid3DIndex = Float(None, allow_none=True, help="""Use the index of the [grid3D](#grid3D) component. The first [grid3D](#grid3D) component is used by default.""").tag(sync=True)
    
    lineStyle = Dict(default_value=None, allow_none=True, help="""The style of the lines.""").tag(sync=True)
    
    data = Any(None, allow_none=True, help="""A data array. Each item of the array is a piece of data. Usually this data is an array to store each attribute/dimension of the data. For example below:



```
data: [
    [[12, 14, 10], [34, 50, 15], [56, 30, 20], [10, 15, 12], [23, 10, 14]]
]

```

The first three values of each item in the array are `x`, `y`, `z`. In addition to these three values, you can add other values to the [visualMap](#visualMap) component to map to other graphical properties such as colors.


More likely, we need to assign name to each data item, in which case each item should be an object:



```
[{
    // name of date item
    name: 'data1',
    // value of date item is 8
    value: [12, 14, 10]
}, {
    name: 'data2',
    value: 20
}]

```

Each data item can be further customized:



```
[{
    name: 'data1',
    value: [12, 14, 10]
}, {
    // name of data item
    name: 'data2',
    value : [34, 50, 15],
    // user-defined special itemStyle that only useful for this data item
    itemStyle:{}
}]

```""").tag(sync=True)
    
    zlevel = Float(None, allow_none=True, help="""The layer in which the component is located.


`zlevel` is used to make layers with Canvas. Graphical elements with different `zlevel` values will be placed in different Canvases, which is a common optimization technique. We can put those frequently changed elements (like those with animations) to a separate `zlevel`. Notice that too many Canvases will increase memory cost, and should be used carefully on mobile phones to avoid the crash.


Canvases with bigger `zlevel` will be placed on Canvases with smaller `zlevel`.


**Note:** The layers of the components in echarts-gl need to be separated from the layers of the components in echarts. The same `zlevel` cannot be used for both WebGL and Canvas drawing at the same time.""").tag(sync=True)
    
    silent = Bool(None, allow_none=True, help="""Whether the graph doesn`t respond and triggers a mouse event. The default is false, which is to respond to and trigger mouse events.""").tag(sync=True)
    
    animation = Bool(None, allow_none=True, help="""Whether to enable animation.""").tag(sync=True)
    
    animationDurationUpdate = Float(None, allow_none=True, help="""The duration time for update the transition animation.""").tag(sync=True)
    
    animationEasingUpdate = Unicode(None, allow_none=True, help="""The easing effect for update transition animation.""").tag(sync=True)
    
        
