from traitlets import (
    Unicode, Dict, Float, Bool, Union, Any,
)
from ..basewidget import BaseWidget


class Lines(BaseWidget):
    """ 
:warning: **Autogenerated class**

**Lines graph**


It is used to draw the line data with the information about "from" and "to"; and it is applied for drawing the air routes on map, which visualizes these routes.


ECharts 2.x uses the `markLine` to draw the migrating effect, while in ECharts 3, the `lines` graph is recommended to be used.



    """

    def __init__(self, **kwargs):

        super().__init__(**kwargs)  
    
    _model_name = Unicode("LinesModel").tag(sync=True)
    
    type = Unicode("lines", allow_none=True, ).tag(sync=True)
    
    id = Unicode(None, allow_none=True, help="""Component ID, not specified by default. If specified, it can be used to refer the component in option or API.""").tag(sync=True)
    
    name = Unicode(None, allow_none=True, help="""Series name used for displaying in [tooltip](#tooltip) and filtering with [legend](#legend), or updating data and configuration with `setOption`.""").tag(sync=True)
    
    colorBy = Unicode(None, allow_none=True, help="""> Since `v5.2.0`


The policy to take color from [option.color](#color). Valid values:


* `'series'`: assigns the colors in the palette by series, so that all data in the same series are in the same color;
* `'data'`: assigns colors in the palette according to data items, with each data item using a different color.""").tag(sync=True)
    
    coordinateSystem = Unicode(None, allow_none=True, help="""The coordinate used in the series, whose options are:


* `'cartesian2d'`


 Use a two-dimensional rectangular coordinate (also known as Cartesian coordinate), with [xAxisIndex](#series-lines.xAxisIndex) and [yAxisIndex](#series-lines.yAxisIndex) to assign the corresponding axis component.


* `'geo'`


 Use geographic coordinate, with [geoIndex](#series-lines.geoIndex) to assign the corresponding geographic coordinate components.""").tag(sync=True)
    
    xAxisIndex = Float(None, allow_none=True, help="""Index of [x axis](#xAxis) to combine with, which is useful for multiple x axes in one chart.""").tag(sync=True)
    
    yAxisIndex = Float(None, allow_none=True, help="""Index of [y axis](#yAxis) to combine with, which is useful for multiple y axes in one chart.""").tag(sync=True)
    
    geoIndex = Float(None, allow_none=True, help="""Index of [geographic coordinate](#geo) to combine with, which is useful for multiple geographic axes in one chart.""").tag(sync=True)
    
    polyline = Bool(None, allow_none=True, help="""If draw as a polyline.


Default to be `false`. Can only draw a two end straight line.


If it is set true, [data.coords](#series-lines.data.coords) can have more than two coord to draw a polyline. It is useful when visualizing GPS track data. See example [lines-bus](https://echarts.apache.org/examples/en/editor.html?c=lines-bmap-bus).""").tag(sync=True)
    
    effect = Dict(default_value=None, allow_none=True, help="""The setting about the special effects of lines.


**Tips:** All the graphs with trail effect should be put on a individual layer, which means that [zlevel](#series-lines.zlevel) need to be different with others. And the animation ([animation](#series-lines.animation): false) of this layer is suggested to be turned off at the meanwhile. Otherwise, other graphic elements in other series and the [label](#series-lines.label) of animation would produce unnecessary ghosts.""").tag(sync=True)
    
    large = Bool(None, allow_none=True, help="""Whether to enable the optimization of large-scale lines graph. It could be enabled when there is a particularly large number of data(>=5k) .


After being enabled, [largeThreshold](#series-lines.largeThreshold) can be used to indicate the minimum number for turning on the optimization.


The style of a single data item can't be customized""").tag(sync=True)
    
    largeThreshold = Float(None, allow_none=True, help="""The threshold enabling the drawing optimization.""").tag(sync=True)
    
    symbol = Union([Unicode(default_value=None, allow_none=True),Any(default_value=None, allow_none=True),], default_value=None, allow_none=True, help="""Symbol type at the two ends of the line. It can be an array for two ends, or assigned separately. See [data.symbol](#series-line.markLine.data.0.symbol) for more format information.""").tag(sync=True)
    
    symbolSize = Union([Float(default_value=None, allow_none=True),Any(default_value=None, allow_none=True),], default_value=None, allow_none=True, help="""Symbol size at the two ends of the line. It can be an array for two ends, or assigned separately.


**Attention:**  You cannot assign width and height separately as normal `symbolSize`.""").tag(sync=True)
    
    lineStyle = Dict(default_value=None, allow_none=True, ).tag(sync=True)
    
    label = Dict(default_value=None, allow_none=True, help="""Label settings. Does not work when [polyline](#series-lines.polyline) is `true`.""").tag(sync=True)
    
    labelLayout = Union([Any(default_value=None, allow_none=True),Any(default_value=None, allow_none=True),], default_value=None, allow_none=True, help="""> Since `v5.0.0`


Unified layout configuration of labels.


It provide a chance to adjust the labels' `(x, y)` position, alignment based on the original layout each series provides.


This option can be a callback with following parameters.



```
// corresponding index of data
dataIndex: number
// corresponding type of data. Only available in graph, in which it can be 'node' or 'edge'
dataType?: string
// corresponding index of series
seriesIndex: number
// Displayed text of label.
text: string
// Bounding rectangle of label.
labelRect: {x: number, y: number, width: number, height: number}
// Horizontal alignment of label.
align: 'left' | 'center' | 'right'
// Vertical alignment of label.
verticalAlign: 'top' | 'middle' | 'bottom'
// Bounding rectangle of the element corresponding to.
rect: {x: number, y: number, width: number, height: number}
// Default points array of labelLine. Currently only provided in pie and funnel series.
// It's null in other series.
labelLinePoints?: number[][]

```

**Example:**


Align the labels on the right. Left 10px margin to the edge.



```
labelLayout(params) {
    return {
        x: params.rect.x + 10,
        y: params.rect.y + params.rect.height / 2,
        verticalAlign: 'middle',
        align: 'left'
    }
}

```

Set the text size based on the size of element bounding rectangle.



```

labelLayout(params) {
    return {
        fontSize: Math.max(params.rect.width / 10, 5)
    };
}

```""").tag(sync=True)
    
    emphasis = Dict(default_value=None, allow_none=True, help="""Emphasis state.""").tag(sync=True)
    
    blur = Dict(default_value=None, allow_none=True, help="""> Since `v5.0.0`


Configurations of blur state. Available when [emphasis.focus](#series-lines.emphasis.focus) is set.""").tag(sync=True)
    
    select = Dict(default_value=None, allow_none=True, help="""> Since `v5.0.0`


Configurations of select state. Available when [selectedMode](#series-lines.selectedMode) is set.""").tag(sync=True)
    
    selectedMode = Union([Bool(default_value=None, allow_none=True),Unicode(default_value=None, allow_none=True),], default_value=None, allow_none=True, help="""> Since `v5.0.0`


Selected mode. It is enabled by default, and you may set it to be `false` to disable it.


Besides, it can be set to `'single'`, `'multiple'` or `'series'`, for single selection, multiple selections and whole series selection.



> `'series'` is supported since v5.3.0""").tag(sync=True)
    
    progressive = Float(None, allow_none=True, help="""`progressive` specifies the amount of graphic elements that can be rendered within a frame (about 16ms) if "progressive rendering" enabled.


When data amount is from thousand to more than 10 million, it will take too long time to render all of the graphic elements. Since ECharts 4, "progressive rendering" is supported in its workflow, which processes and renders data chunk by chunk alone with each frame, avoiding to block the UI thread of the browser.


Set `progressive: 0` to disable progressive permanently. By default, progressive is auto-enabled when data amount is bigger than `progressiveThreshold`.""").tag(sync=True)
    
    progressiveThreshold = Float(None, allow_none=True, help="""If current data amount is over the threshold, "progressive rendering" is enabled.""").tag(sync=True)
    
    dataGroupId = Unicode(None, allow_none=True, help="""A group ID assigned to all data items in the series.


This option has a lower priority than `groupId`, which means when `groupId` is specified for a certain data item the `dataGroupId` will be simply ignored for that data item. For more information, please see `series.data.groupId`.""").tag(sync=True)
    
    data = Any(None, allow_none=True, help="""The data set of lines.""").tag(sync=True)
    
    markPoint = Dict(default_value=None, allow_none=True, help="""Mark point in a chart.""").tag(sync=True)
    
    markLine = Dict(default_value=None, allow_none=True, help="""Use a line in the chart to illustrate.""").tag(sync=True)
    
    markArea = Dict(default_value=None, allow_none=True, help="""Used to mark an area in chart. For example, mark a time interval.""").tag(sync=True)
    
    clip = Bool(None, allow_none=True, help="""> Since `v4.4.0`


If clip the overflow on the coordinate system. Clip results varies between series:


* Scatter/EffectScatter：Ignore the symbols exceeds the coordinate system. Not clip the elements.
* Bar：Clip all the overflowed. With bar width kept.
* Line：Clip the overflowed line.
* Lines: Clip all the overflowed.
* Candlestick: Ignore the elements exceeds the coordinate system.
* PictorialBar: Clip all the overflowed. (Supported since v5.5.0)
* Custom: Clip all the olverflowed.


All these series have default value `true` except pictorialBar and custom series. Set it to `false` if you don't want to clip.""").tag(sync=True)
    
    zlevel = Float(None, allow_none=True, help="""`zlevel` value of all graphical elements in 路径图.


`zlevel` is used to make layers with Canvas. Graphical elements with different `zlevel` values will be placed in different Canvases, which is a common optimization technique. We can put those frequently changed elements (like those with animations) to a separate `zlevel`. Notice that too many Canvases will increase memory cost, and should be used carefully on mobile phones to avoid crash.


Canvases with bigger `zlevel` will be placed on Canvases with smaller `zlevel`.""").tag(sync=True)
    
    z = Float(None, allow_none=True, help="""`z` value of all graphical elements in 路径图, which controls order of drawing graphical components. Components with smaller `z` values may be overwritten by those with larger `z` values.


`z` has a lower priority to `zlevel`, and will not create new Canvas.""").tag(sync=True)
    
    silent = Bool(None, allow_none=True, help="""Whether to ignore mouse events. Default value is false, for triggering and responding to mouse events.""").tag(sync=True)
    
    animation = Bool(None, allow_none=True, help="""Whether to enable animation.""").tag(sync=True)
    
    animationThreshold = Float(None, allow_none=True, help="""Whether to set graphic number threshold to animation. Animation will be disabled when graphic number is larger than threshold.""").tag(sync=True)
    
    animationDuration = Union([Float(default_value=None, allow_none=True),Any(default_value=None, allow_none=True),], default_value=None, allow_none=True, help="""Duration of the first animation, which supports callback function for different data to have different animation effect:



```
animationDuration: function (idx) {
    // delay for later data is larger
    return idx * 100;
}

```""").tag(sync=True)
    
    animationEasing = Unicode(None, allow_none=True, help="""Easing method used for the first animation. Varied easing effects can be found at [easing effect example](https://echarts.apache.org/examples/en/editor.html?c=line-easing).""").tag(sync=True)
    
    animationDelay = Union([Float(default_value=None, allow_none=True),Any(default_value=None, allow_none=True),], default_value=None, allow_none=True, help="""Delay before updating the first animation, which supports callback function for different data to have different animation effect.


For example:



```
animationDelay: function (idx) {
    // delay for later data is larger
    return idx * 100;
}

```

See [this example](https://echarts.apache.org/examples/en/editor.html?c=bar-animation-delay) for more information.""").tag(sync=True)
    
    animationDurationUpdate = Union([Float(default_value=None, allow_none=True),Any(default_value=None, allow_none=True),], default_value=None, allow_none=True, help="""Time for animation to complete, which supports callback function for different data to have different animation effect:



```
animationDurationUpdate: function (idx) {
    // delay for later data is larger
    return idx * 100;
}

```""").tag(sync=True)
    
    animationEasingUpdate = Unicode(None, allow_none=True, help="""Easing method used for animation.""").tag(sync=True)
    
    animationDelayUpdate = Union([Float(default_value=None, allow_none=True),Any(default_value=None, allow_none=True),], default_value=None, allow_none=True, help="""Delay before updating animation, which supports callback function for different data to have different animation effects.


For example:



```
animationDelayUpdate: function (idx) {
    // delay for later data is larger
    return idx * 100;
}

```

See [this example](https://echarts.apache.org/examples/en/editor.html?c=bar-animation-delay) for more information.""").tag(sync=True)
    
    universalTransition = Any(None, allow_none=True, help="""> Since `v5.2.0`


Configuration related to universal transition animation.


Universal Transition provides the ability to morph between any series. With this feature enabled, each time `setOption`, transitions between series with the same `id` will be automatically associated with each other.


One-to-many or many-to-one animations such as drill-down, aggregation, etc. can also be achieved by specifying data items' `groupId` and `childGroupId`.


This can be enabled directly by configuring `universalTransition: true` in the series. It is also possible to provide an object for more detailed configuration.""").tag(sync=True)
    
    tooltip = Dict(default_value=None, allow_none=True, help="""tooltip settings in this series.""").tag(sync=True)
    
        
