from traitlets import (
    Unicode, Dict, Float, Bool, Any,
)
from ..basewidget import BaseWidget


class Lines3D(BaseWidget):
    """ 
:warning: **Autogenerated class**

3D lines. Like the 2D [lines] (<https://echarts.apache.org/zh/option.html#series-line)>, it is used to represent the line data from the start point to the end point. More is used in geographic visualization.


Below is an example of a visual airplane flight using [lines3D](#series-lines3D) on [globe](#globe).


![](documents/asset/gl/img/globe-airline.png)



    """

    def __init__(self, **kwargs):

        super().__init__(**kwargs)  
    
    _model_name = Unicode("Lines3DModel").tag(sync=True)
    
    type = Unicode("lines3D", allow_none=True, ).tag(sync=True)
    
    name = Unicode(None, allow_none=True, help="""Series name used for displaying in [tooltip](https://echarts.apache.org/zh/option.html#tooltip) and filtering with [legend](https://echarts.apache.org/zh/option.html#legend), or updating data and configuration with `setOption`.""").tag(sync=True)
    
    coordinateSystem = Unicode(None, allow_none=True, help="""The coordinate used in the series, whose options are:


* `'geo3D'`
 Use 3D geographic coordinate, with [geoIndex](#series-.geoIndex) to assign the corresponding 3D geographic coordinate components.


* `'globe'`


 Use 3D globe coordinate, with [globeIndex](#series-.globeIndex) to assign the corresponding 3D globe coordinate components.""").tag(sync=True)
    
    geo3DIndex = Float(None, allow_none=True, help="""The index of the [geo3D](#geo3D) component used by the axis.The first [grid3D](#grid3D) component is used by default.""").tag(sync=True)
    
    globeIndex = Float(None, allow_none=True, help="""The index of the [globe](#globe) component used by the axis.The first [globe](#globe) component is used by default.""").tag(sync=True)
    
    polyline = Bool(None, allow_none=True, help="""If draw as a polyline.


Default to be `false`. Can only draw a two end straight line.


If it is set true, [data.coords](#series-lines.data.coords) can have more than two coords to draw a polyline. It is useful when visualizing GPS track data.""").tag(sync=True)
    
    effect = Dict(default_value=None, allow_none=True, help="""The setting about the special effects of lines.""").tag(sync=True)
    
    lineStyle = Dict(default_value=None, allow_none=True, help="""The line style of the lines.""").tag(sync=True)
    
    data = Any(None, allow_none=True, help="""A data array of 3D lines.
Usually, each item of data can be a set of coordinates containing the start point and end point.


More than two coordinates can be supported when [polyline](#series-lines3D.polyline) is set to `true`.
as follows:



```
data: [
    [
        [120, 66, 1], // latitude, longitude and altitude coordinates of the start point
        [122, 67, 2]  // latitude, longitude and altitude coordinates of the end point
    ]
]

```

Sometimes you need to configure the name of the data item or a separate style. You need to write the latitude and longitude coordinates to the coords property, as follows:



```
data: [
    {
        coords: [ [120, 66], [122, 67] ],
        // The value of data
        value: 10,
        // The name of data
        name: 'foo',
        // The style of line
        lineStyle: {}
    }
]

```""").tag(sync=True)
    
    blendMode = Unicode(None, allow_none=True, help="""Sets the type of compositing operation to apply when drawing a new shape. 


Currently supporting `'source-over'`, `'lighter'`. The default is `'source-over'` mode is blended by alpha. The `'lighter'` is overlap mode. In this mode, the area where the number of graphics is concentrated can be highlighted by the overlap.""").tag(sync=True)
    
    zlevel = Float(None, allow_none=True, help="""The layer in which the component is located.


`zlevel` is used to make layers with Canvas. Graphical elements with different `zlevel` values will be placed in different Canvases, which is a common optimization technique. We can put those frequently changed elements (like those with animations) to a separate `zlevel`. Notice that too many Canvases will increase memory cost, and should be used carefully on mobile phones to avoid the crash.


Canvases with bigger `zlevel` will be placed on Canvases with smaller `zlevel`.


**Note:** The layers of the components in echarts-gl need to be separated from the layers of the components in echarts. The same `zlevel` cannot be used for both WebGL and Canvas drawing at the same time.""").tag(sync=True)
    
    silent = Bool(None, allow_none=True, help="""Whether the graph doesn`t respond and triggers a mouse event. The default is false, which is to respond to and trigger mouse events.""").tag(sync=True)
    
        
