from traitlets import (
    Unicode, Dict, Float, Bool, Union, Any,
)
from ..basewidget import BaseWidget


class Pie(BaseWidget):
    """ 
:warning: **Autogenerated class**

The pie chart is mainly used for showing proportion of different categories. Each arc length represents the proportion of data quantity.


**Tip:** The pie chart is more suitable for illustrating the numerical proportion. If you just to present the numerical differences of various categories, the [bar graph](bar) chart is more suggested. Because compared to tiny length difference, people is less sensitive to the minor radian difference. Otherwise, it can also be shown as Nightingale chart by using the [roseType](#series-pie.roseType) to distinguish different data through radius.


For multiple pie series in a single chart, you may use [left](#series-pie.left), [right](#series-pie.right), [top](#series-pie.top), [bottom](#series-pie.bottom), [width](#series-pie.width), and [height](#series-pie.height) to locate the pies. Percetage values like [radius](#series-pie.radius) or [label.edgeDistance](#series-pie.label.edgeDistance) are relative to the viewport defined by this setting.


 **The below example shows a customized Nightingale chart:** 



Since ECharts v4.6.0, we provide `'labelLine'` and `'edge'` two extra layouts. Check [label.alignTo](#series-pie.label.alignTo) for more information.



    """

    def __init__(self, **kwargs):

        super().__init__(**kwargs)  
    
    _model_name = Unicode("PieModel").tag(sync=True)
    
    type = Unicode("pie", allow_none=True, ).tag(sync=True)
    
    id = Unicode(None, allow_none=True, help="""Component ID, not specified by default. If specified, it can be used to refer the component in option or API.""").tag(sync=True)
    
    name = Unicode(None, allow_none=True, help="""Series name used for displaying in [tooltip](#tooltip) and filtering with [legend](#legend), or updating data and configuration with `setOption`.""").tag(sync=True)
    
    colorBy = Unicode(None, allow_none=True, help="""> Since `v5.2.0`


The policy to take color from [option.color](#color). Valid values:


* `'series'`: assigns the colors in the palette by series, so that all data in the same series are in the same color;
* `'data'`: assigns colors in the palette according to data items, with each data item using a different color.""").tag(sync=True)
    
    legendHoverLink = Bool(None, allow_none=True, help="""Whether to enable highlighting chart when [legend](#legend) is being hovered.""").tag(sync=True)
    
    coordinateSystem = Unicode(None, allow_none=True, help="""> Since `v5.4.0`


The coordinate used in the series, whose options are:


* `null` or `'none'`


 No coordinate.


* `'geo'`


 Use geographic coordinate, with [geoIndex](#series-pie.geoIndex) to assign the corresponding geographic coordinate components.


* `'calendar'`


 Use calendar coordinates, with [calendarIndex](#series-pie.calendarIndex) to assign the corresponding calendar coordinate components.


* `'none'`


 Do not use coordinate system.""").tag(sync=True)
    
    geoIndex = Float(None, allow_none=True, help="""> Since `v5.4.0`


Index of [geographic coordinate](#geo) to combine with, which is useful for multiple geographic axes in one chart.""").tag(sync=True)
    
    calendarIndex = Float(None, allow_none=True, help="""> Since `v5.4.0`


Index of [calendar coordinates](#calendar) to combine with, which is useful for multiple calendar coordinates in one chart.""").tag(sync=True)
    
    selectedMode = Union([Bool(default_value=None, allow_none=True),Unicode(default_value=None, allow_none=True),], default_value=None, allow_none=True, help="""Selected mode. It is enabled by default, and you may set it to be `false` to disable it.


Besides, it can be set to `'single'`, `'multiple'` or `'series'`, for single selection, multiple selections and whole series selection.



> `'series'` is supported since v5.3.0""").tag(sync=True)
    
    selectedOffset = Float(None, allow_none=True, help="""The offset distance of selected sector.""").tag(sync=True)
    
    clockwise = Bool(None, allow_none=True, help="""Whether the layout of sectors of pie chart is clockwise.""").tag(sync=True)
    
    startAngle = Float(None, allow_none=True, help="""The start angle, which range is [0, 360].""").tag(sync=True)
    
    endAngle = Union([Float(default_value=None, allow_none=True),Unicode(default_value=None, allow_none=True),], default_value=None, allow_none=True, help="""> Since `v5.5.0`


The end angle, the default value is `'auto'`.


When the value is `'auto'`, the end angle is calculated automatically based on [startAngle](#series-pie.startAngle) to ensure it is a complete circle.""").tag(sync=True)
    
    minAngle = Float(None, allow_none=True, help="""The minimum angle of sector (0 ~ 360). It prevents some sector from being too small when value is small, which will affect user interaction.""").tag(sync=True)
    
    padAngle = Float(None, allow_none=True, help="""> Since `v5.5.0`


The interval angle between the sectors (0 ~ 360).""").tag(sync=True)
    
    minShowLabelAngle = Float(None, allow_none=True, help="""If a sector is less than this angle (0 ~ 360), label and labelLine will not be displayed.""").tag(sync=True)
    
    roseType = Union([Bool(default_value=None, allow_none=True),Unicode(default_value=None, allow_none=True),], default_value=None, allow_none=True, help="""Whether to show as Nightingale chart, which distinguishs data through radius. There are 2 optional modes:


* `'radius'` Use central angle to show the percentage of data, radius to show data size.
* `'area'` All the sectors will share the same central angle, the data size is shown only through radiuses.""").tag(sync=True)
    
    avoidLabelOverlap = Bool(None, allow_none=True, help="""Whether to enable the strategy to avoid labels overlap. Defaults to be enabled, which will move the label positions in the case of labels overlapping""").tag(sync=True)
    
    stillShowZeroSum = Bool(None, allow_none=True, help="""Whether to show sector when all data are zero.""").tag(sync=True)
    
    percentPrecision = Float(None, allow_none=True, help="""The precision of the percentage value. The default value is `2`.""").tag(sync=True)
    
    cursor = Unicode(None, allow_none=True, help="""The mouse style when mouse hovers on an element, the same as `cursor` property in `CSS`.""").tag(sync=True)
    
    zlevel = Float(None, allow_none=True, help="""`zlevel` value of all graphical elements in .


`zlevel` is used to make layers with Canvas. Graphical elements with different `zlevel` values will be placed in different Canvases, which is a common optimization technique. We can put those frequently changed elements (like those with animations) to a separate `zlevel`. Notice that too many Canvases will increase memory cost, and should be used carefully on mobile phones to avoid crash.


Canvases with bigger `zlevel` will be placed on Canvases with smaller `zlevel`.""").tag(sync=True)
    
    z = Float(None, allow_none=True, help="""`z` value of all graphical elements in , which controls order of drawing graphical components. Components with smaller `z` values may be overwritten by those with larger `z` values.


`z` has a lower priority to `zlevel`, and will not create new Canvas.""").tag(sync=True)
    
    left = Union([Unicode(default_value=None, allow_none=True),Float(default_value=None, allow_none=True),], default_value=None, allow_none=True, help="""Distance between pie chart component and the left side of the container.


`left` can be a pixel value like `20`; it can also be a percentage value relative to container width like `'20%'`; and it can also be `'left'`, `'center'`, or `'right'`.


If the `left` value is set to be `'left'`, `'center'`, or `'right'`, then the component will be aligned automatically based on position.""").tag(sync=True)
    
    top = Union([Unicode(default_value=None, allow_none=True),Float(default_value=None, allow_none=True),], default_value=None, allow_none=True, help="""Distance between pie chart component and the top side of the container.


`top` can be a pixel value like `20`; it can also be a percentage value relative to container width like `'20%'`; and it can also be `'top'`, `'middle'`, or `'bottom'`.


If the `top` value is set to be `'top'`, `'middle'`, or `'bottom'`, then the component will be aligned automatically based on position.""").tag(sync=True)
    
    right = Union([Unicode(default_value=None, allow_none=True),Float(default_value=None, allow_none=True),], default_value=None, allow_none=True, help="""Distance between pie chart component and the right side of the container.


`right` can be a pixel value like `20`; it can also be a percentage value relative to container width like `'20%'`.


Adaptive by default.""").tag(sync=True)
    
    bottom = Union([Unicode(default_value=None, allow_none=True),Float(default_value=None, allow_none=True),], default_value=None, allow_none=True, help="""Distance between pie chart component and the bottom side of the container.


`bottom` can be a pixel value like `20`; it can also be a percentage value relative to container width like `'20%'`.


Adaptive by default.""").tag(sync=True)
    
    width = Union([Unicode(default_value=None, allow_none=True),Float(default_value=None, allow_none=True),], default_value=None, allow_none=True, help="""Width of pie chart component. Adaptive by default.""").tag(sync=True)
    
    height = Union([Unicode(default_value=None, allow_none=True),Float(default_value=None, allow_none=True),], default_value=None, allow_none=True, help="""Height of pie chart component. Adaptive by default.""").tag(sync=True)
    
    showEmptyCircle = Bool(None, allow_none=True, help="""> Since `v5.2.0`


If display an placeholder circle when there is no data.""").tag(sync=True)
    
    emptyCircleStyle = Dict(default_value=None, allow_none=True, help="""> Since `v5.2.0`


Style of circle placeholder.""").tag(sync=True)
    
    label = Dict(default_value=None, allow_none=True, help="""Text label of pie chart, to explain some data information about graphic item like value, name and so on. `label` is placed under `itemStyle` in ECharts 2.x. In ECharts 3, to make the configuration structure flatter, `label`is taken to be at the same level with `itemStyle`, and has `emphasis` as `itemStyle` does.""").tag(sync=True)
    
    labelLine = Dict(default_value=None, allow_none=True, help="""The style of visual guide line. Will show when [label position](#series-pie.label.position) is set as `'outside'`.""").tag(sync=True)
    
    labelLayout = Union([Any(default_value=None, allow_none=True),Any(default_value=None, allow_none=True),], default_value=None, allow_none=True, help="""> Since `v5.0.0`


Unified layout configuration of labels.


It provide a chance to adjust the labels' `(x, y)` position, alignment based on the original layout each series provides.


This option can be a callback with following parameters.



```
// corresponding index of data
dataIndex: number
// corresponding type of data. Only available in graph, in which it can be 'node' or 'edge'
dataType?: string
// corresponding index of series
seriesIndex: number
// Displayed text of label.
text: string
// Bounding rectangle of label.
labelRect: {x: number, y: number, width: number, height: number}
// Horizontal alignment of label.
align: 'left' | 'center' | 'right'
// Vertical alignment of label.
verticalAlign: 'top' | 'middle' | 'bottom'
// Bounding rectangle of the element corresponding to.
rect: {x: number, y: number, width: number, height: number}
// Default points array of labelLine. Currently only provided in pie and funnel series.
// It's null in other series.
labelLinePoints?: number[][]

```

**Example:**


Align the labels on the right. Left 10px margin to the edge.



```
labelLayout(params) {
    return {
        x: params.rect.x + 10,
        y: params.rect.y + params.rect.height / 2,
        verticalAlign: 'middle',
        align: 'left'
    }
}

```

Set the text size based on the size of element bounding rectangle.



```

labelLayout(params) {
    return {
        fontSize: Math.max(params.rect.width / 10, 5)
    };
}

```""").tag(sync=True)
    
    itemStyle = Dict(default_value=None, allow_none=True, help="""Graphic style of , `emphasis` is the style when it is highlighted, like being hovered by mouse, or highlighted via legend connect.""").tag(sync=True)
    
    emphasis = Dict(default_value=None, allow_none=True, help="""Configurations of emphasis state.""").tag(sync=True)
    
    blur = Dict(default_value=None, allow_none=True, help="""> Since `v5.0.0`


Configurations of blur state. Available when [emphasis.focus](#series-pie.emphasis.focus) is set.""").tag(sync=True)
    
    select = Dict(default_value=None, allow_none=True, help="""> Since `v5.0.0`


Configurations of select state. Available when [selectedMode](#series-pie.selectedMode) is set.""").tag(sync=True)
    
    center = Any(None, allow_none=True, help="""Center position of Pie chart, the first of which is the horizontal position, and the second is the vertical position.


Percentage is supported. When set in percentage, the item is relative to the container width, and the second item to the height.


**Example:** 



```
// Set to absolute pixel values
center: [400, 300]
// Set to relative percent
center: ['50%', '50%']

```""").tag(sync=True)
    
    radius = Union([Float(default_value=None, allow_none=True),Unicode(default_value=None, allow_none=True),Any(default_value=None, allow_none=True),], default_value=None, allow_none=True, help="""Radius of Pie chart. Value can be:


* `number`: Specify outside radius directly.
* `string`: For example, `'20%'`, means that the outside radius is 20% of the viewport size (the little one between width and height of the chart container).


* `Array.<number|string>`: The first item specifies the inside radius, and the second item specifies the outside radius. Each item follows the definitions above.


Donut chart can be achieved by setting a inner radius.""").tag(sync=True)
    
    seriesLayoutBy = Unicode(None, allow_none=True, help="""When [dataset](#dataset) is used, `seriesLayoutBy` specifies whether the column or the row of `dataset` is mapped to the series, namely, the series is "layout" on columns or rows. Optional values:


* 'column': by default, the columns of `dataset` are mapped the series. In this case, each column represents a dimension.
* 'row'：the rows of `dataset` are mapped to the series. In this case, each row represents a dimension.


Check this [example](https://echarts.apache.org/examples/en/editor.html?c=dataset-series-layout-by).""").tag(sync=True)
    
    datasetIndex = Float(None, allow_none=True, help="""If [series.data](#series.data) is not specified, and [dataset](#dataset) exists, the series will use `dataset`. `datasetIndex` specifies which dataset will be used.""").tag(sync=True)
    
    dimensions = Any(None, allow_none=True, help="""`dimensions` can be used to define dimension info for `series.data` or `dataset.source`.


Notice: if [dataset](#dataset) is used, we can definite dimensions in [dataset.dimensions](#dataset.dimensions), or provide dimension names in the first column/row of [dataset.source](#dataset.source), and not need to specify `dimensions` here. But if `dimensions` is specified here, it will be used despite the dimension definitions in dataset.


For example:



```
option = {
    dataset: {
        source: [
            // 'date', 'open', 'close', 'highest', 'lowest'
            [12, 44, 55, 66, 2],
            [23, 6, 16, 23, 1],
            ...
        ]
    },
    series: {
        type: 'xxx',
        // Specify name for each dimensions, which will be displayed in tooltip.
        dimensions: ['date', 'open', 'close', 'highest', 'lowest']
    }
}

```


```
series: {
    type: 'xxx',
    dimensions: [
        null,                // If you do not intent to defined this dimension, use null is fine.
        {type: 'ordinal'},   // Specify type of this dimension.
                             // 'ordinal' is always used in string.
                             // If type is not specified, echarts will guess type by data.
        {name: 'good', type: 'number'},
        'bad'                // Equals to {name: 'bad'}.
    ]
}

```

Each data item of `dimensions` can be:


* `string`, for example, `'someName'`, which equals to `{name: 'someName'}`.
* `Object`, where the attributes can be:
	+ name: `string`.
	+ type: `string`, supports:
		- `number`
		- `float`, that is, [Float64Array](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Float64Array)
		- `int`, that is, [Int32Array](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Int32Array)
		- `ordinal`, discrete value, which represents string generally.
		- `time`, time value, see [data](#series.data) to check the format of time value.
	+ displayName: `string`, generally used in tooltip for dimension display. If not specified, use `name` by default.


When `dimensions` is specified, the default `tooltip` will be displayed vertically, which is better to show dimension names. Otherwise, `tooltip` will displayed only value horizontally.""").tag(sync=True)
    
    encode = Dict(default_value=None, allow_none=True, help="""Define what is encoded to for each dimension of `data`. For example:



```
option = {
    dataset: {
        source: [
            // Each column is called a dimension.
            // There are five dimensions: 0, 1, 2, 3, 4.
            [12, 44, 55, 66, 2],
            [23, 6, 16, 23, 1],
            ...
        ]
    },
    series: {
        type: 'xxx',
        encode: {
            x: [3, 1, 5],      // Dimension 3, 1, 5 is mapped to x axis.
            y: 2,              // Dimension 2 is mapped to y axis.
            tooltip: [3, 2, 4] // Dimension 3, 2, 4 will be displayed in tooltip.
        }
    }
}

```

When [dimensions](#series.dimensions) is used to defined name for a certain dimension, `encode` can refer the name directly. For example:



```
series: {
    type: 'xxx',
    dimensions: ['date', 'open', 'close', 'highest', 'lowest'],
    encode: {
        x: 'date',
        y: ['open', 'close', 'highest', 'lowest']
    }
}

```

The basic structure of [encode](option.html#series.encode) is illustrated as follows, where the left part of colon is the name of axis like `'x'`, `'y'`, `'radius'`, `'angle'` or some special reserved names like "tooltip", "itemName" etc., and the right part of the colon is the dimension names or dimension indices (based on 0). One or more dimensions can be specified. Usually not all of mappings need to be specified, only specify needed ones.


The properties available in `encode` listed as follows:



```
// In any of the series and coordinate systems,
// these properties are available:
encode: {
    // Display dimension "product" and "score" in the tooltip.
    tooltip: ['product', 'score']
    // Set the series name as the concat of the names of dimensions[1] and dimensions[3].
    // (sometimes the dimension names are too long to type in series.name manually).
    seriesName: [1, 3],
    // Using dimensions[2] as the id of each data item. This is useful when dynamically
    // update data by `chart.setOption()`, where the new and old data item can be
    // corresponded by id, by which the appropriate animation can be performed when updating.
    itemId: 2,
    // Using dimensions[3] as the name of each data item. This is useful in charts like
    // 'pie', 'funnel', where data item name can be displayed in legend.
    itemName: 3,
    // Using dimensions[4] as the group ID for each data item. With universalTransition enabled,
    // the data items from the old option and those from the new one, if sharing a same group ID,
    // will then be matched and applied to a proper animation after `setOption` is called.
    itemGroupId: 4,
    // Using dimension[5] as the child group ID for each data item. This option is introduced to
    // make multiple levels drilldown and aggregation animation come true. See childGroupId for more.
    // Since v5.5.0
    itemChildGroupId: 5
}

// These properties only work in cartesian(grid) coordinate system:
encode: {
    // Map dimensions[1], dimensions[5] and dimension "score" to the X axis.
    x: [1, 5, 'score'],
    // Map dimensions[0] to the Y axis.
    y: 0
}

// These properties only work in polar coordinate system:
encode: {
    radius: 3,
    angle: 2,
    ...
}

// These properties only work in geo coordinate system:
encode: {
    lng: 3,
    lat: 2
}

// For some type of series that are not in any coordinate system,
// like 'pie', 'funnel' etc.:
encode: {
    value: 3
}

```

This is an [example](https://echarts.apache.org/examples/en/view.html?c=dataset-encode1&edit=1&reset=1) for `encode`.


Specially, in [custom series(~series-custom), some property in `encode`, corresponding to axis, can be set as null to make the series not controlled by the axis, that is, the series data will not be count in the extent of the axis, and the [dataZoom](#dataZoom) on the axis will not filter the series.



```
var option = {
    xAxis: {},
    yAxis: {},
    dataZoom: [{
        xAxisIndex: 0
    }, {
        yAxisIndex: 0
    }],
    series: {
        type: 'custom',
        renderItem: function (params, api) {
            return {
                type: 'circle',
                shape: {
                    cx: 100, // x position is always 100
                    cy: api.coord([0, api.value(0)])[1],
                    r: 30
                },
                style: {
                    fill: 'blue'
                }
            };
        },
        encode: {
            // Then the series will not be controlled
            // by x axis and corresponding dataZoom.
            x: -1,
            y: 1
        },
        data: [ ... ]
    }
};

```""").tag(sync=True)
    
    dataGroupId = Unicode(None, allow_none=True, help="""A group ID assigned to all data items in the series.


This option has a lower priority than `groupId`, which means when `groupId` is specified for a certain data item the `dataGroupId` will be simply ignored for that data item. For more information, please see `series.data.groupId`.""").tag(sync=True)
    
    data = Any(None, allow_none=True, help="""Data array of series, which can be a single data value, like:



```
[12, 34, 56, 10, 23]

```

Or, if need extra dimensions for components like [visualMap](#visualMap) to map to graphic attributes like color, it can also be in the form of array. For example:



```
[[12, 14], [34, 50], [56, 30], [10, 15], [23, 10]]

```

In this case, we can assign the second value in each array item to [visualMap](#visualMap) component.


More likely, we need to assign name to each data item, in which case each item should be an object:



```
[{
    // name of date item
    name: 'data1',
    // value of date item is 8
    value: 10
}, {
    name: 'data2',
    value: 20
}]

```

Each data item can be further customized:



```
[{
    name: 'data1',
    value: 10
}, {
    // name of data item
    name: 'data2',
    value : 56,
    // user-defined label format that only useful for this data item
    label: {},
    // user-defined special itemStyle that only useful for this data item
    itemStyle:{}
}]

```""").tag(sync=True)
    
    markPoint = Dict(default_value=None, allow_none=True, help="""Mark point in a chart.""").tag(sync=True)
    
    markLine = Dict(default_value=None, allow_none=True, help="""Use a line in the chart to illustrate.""").tag(sync=True)
    
    markArea = Dict(default_value=None, allow_none=True, help="""Used to mark an area in chart. For example, mark a time interval.""").tag(sync=True)
    
    silent = Bool(None, allow_none=True, help="""Whether to ignore mouse events. Default value is false, for triggering and responding to mouse events.""").tag(sync=True)
    
    animationType = Unicode(None, allow_none=True, help="""Initial animation type.


* `'expansion'` Default expansion animation.
* `'scale'` Scale animation. You can use it with `animationEasing='elasticOut'` to have popup effect.""").tag(sync=True)
    
    animationTypeUpdate = Unicode(None, allow_none=True, help="""> Since `v4.4.0`


Animation type when data updates.


* `'transition'` Changing start and end angle of each sector from the old value to new value.
* `'expansion'` The whole pie expands again.""").tag(sync=True)
    
    animation = Bool(None, allow_none=True, help="""Whether to enable animation.""").tag(sync=True)
    
    animationThreshold = Float(None, allow_none=True, help="""Whether to set graphic number threshold to animation. Animation will be disabled when graphic number is larger than threshold.""").tag(sync=True)
    
    animationDuration = Union([Float(default_value=None, allow_none=True),Any(default_value=None, allow_none=True),], default_value=None, allow_none=True, help="""Duration of the first animation, which supports callback function for different data to have different animation effect:



```
animationDuration: function (idx) {
    // delay for later data is larger
    return idx * 100;
}

```""").tag(sync=True)
    
    animationEasing = Unicode(None, allow_none=True, help="""Easing method used for the first animation. Varied easing effects can be found at [easing effect example](https://echarts.apache.org/examples/en/editor.html?c=line-easing).""").tag(sync=True)
    
    animationDelay = Union([Float(default_value=None, allow_none=True),Any(default_value=None, allow_none=True),], default_value=None, allow_none=True, help="""Delay before updating the first animation, which supports callback function for different data to have different animation effect.


For example:



```
animationDelay: function (idx) {
    // delay for later data is larger
    return idx * 100;
}

```

See [this example](https://echarts.apache.org/examples/en/editor.html?c=bar-animation-delay) for more information.""").tag(sync=True)
    
    animationDurationUpdate = Union([Float(default_value=None, allow_none=True),Any(default_value=None, allow_none=True),], default_value=None, allow_none=True, help="""Time for animation to complete, which supports callback function for different data to have different animation effect:



```
animationDurationUpdate: function (idx) {
    // delay for later data is larger
    return idx * 100;
}

```""").tag(sync=True)
    
    animationEasingUpdate = Unicode(None, allow_none=True, help="""Easing method used for animation.""").tag(sync=True)
    
    animationDelayUpdate = Union([Float(default_value=None, allow_none=True),Any(default_value=None, allow_none=True),], default_value=None, allow_none=True, help="""Delay before updating animation, which supports callback function for different data to have different animation effects.


For example:



```
animationDelayUpdate: function (idx) {
    // delay for later data is larger
    return idx * 100;
}

```

See [this example](https://echarts.apache.org/examples/en/editor.html?c=bar-animation-delay) for more information.""").tag(sync=True)
    
    universalTransition = Any(None, allow_none=True, help="""> Since `v5.2.0`


Configuration related to universal transition animation.


Universal Transition provides the ability to morph between any series. With this feature enabled, each time `setOption`, transitions between series with the same `id` will be automatically associated with each other.


One-to-many or many-to-one animations such as drill-down, aggregation, etc. can also be achieved by specifying data items' `groupId` and `childGroupId`.


This can be enabled directly by configuring `universalTransition: true` in the series. It is also possible to provide an object for more detailed configuration.""").tag(sync=True)
    
    tooltip = Dict(default_value=None, allow_none=True, help="""tooltip settings in this series.""").tag(sync=True)
    
        
