from traitlets import (
    Unicode, Dict, Float, Bool,
)
from ..basewidget import BaseWidget


class Polygons3D(BaseWidget):
    """ 
:warning: **Autogenerated class**

`polygons3D` is used to visualize polygon data with high information on the map, which is often used for drawing of buildings.
The picture below shows the nearly 50w number of New York buildings drawn with `polygons3D`.


![](documents/asset/gl/img/polygons3D-ny.jpg)



    """

    def __init__(self, **kwargs):

        super().__init__(**kwargs)  
    
    _model_name = Unicode("Polygons3DModel").tag(sync=True)
    
    type = Unicode("polygons3D", allow_none=True, ).tag(sync=True)
    
    multiPolygon = Bool(None, allow_none=True, help="""Whether a data contains multiple polygons.""").tag(sync=True)
    
    itemStyle = Dict(default_value=None, allow_none=True, help="""Graphic styles, including color, transparency, strokes, and etc.""").tag(sync=True)
    
    emphasis = Dict(default_value=None, allow_none=True, help="""Mouse hover Highlights the style of graphics and labels.""").tag(sync=True)
    
    data = Dict(default_value=None, allow_none=True, help="""A list of data for the polygon.



```
data: [{
    // A square
    coords: [[0, 0], [100, 0], [100, 100], [0, 100]],
    // Height
    height: 3
}, {
    // A triangle
    coords: [[50, 0], [100, 100], [0, 100]],
    // Height
    height: 5
}]

```""").tag(sync=True)
    
    progressiveThreshold = Float(None, allow_none=True, help="""Enable progressive rendering thresholds, progressive rendering can be loading the screen without blocking.""").tag(sync=True)
    
    progressive = Float(None, allow_none=True, help="""Progressively render the amount of data per render.""").tag(sync=True)
    
        
