from traitlets import (
    Unicode, Dict, Float, Bool, Union, Any,
)
from ..basewidget import BaseWidget


class Scatter3D(BaseWidget):
    """ 
:warning: **Autogenerated class**

3D scatter chart. It can be used to display data in [grid3D](#grid3D),  [geo3D](#geo3D), [globe](#globe) using attributes such as size、color and so on.


This example is a 3D simplex noise drawn with a bubble chart.


![](documents/asset/gl/img/scatter3D.png)



    """

    def __init__(self, **kwargs):

        super().__init__(**kwargs)  
    
    _model_name = Unicode("Scatter3DModel").tag(sync=True)
    
    type = Unicode("scatter3D", allow_none=True, ).tag(sync=True)
    
    name = Unicode(None, allow_none=True, help="""Series name used for displaying in [tooltip](https://echarts.apache.org/zh/option.html#tooltip) and filtering with [legend](https://echarts.apache.org/zh/option.html#legend), or updating data and configuration with `setOption`.""").tag(sync=True)
    
    coordinateSystem = Unicode(None, allow_none=True, help="""The coordinate used in the series, whose options are:


* `'cartesian3D'`


 Use a 3D rectangular coordinate (also known as Cartesian coordinate), with [xAxisIndex](#series-.xAxisIndex) and [yAxisIndex](#series-.yAxisIndex) to assign the corresponding axis component.


* `'geo3D'`
 Use 3D geographic coordinate, with [geoIndex](#series-.geoIndex) to assign the corresponding 3D geographic coordinate components.


* `'globe'`


 Use 3D globe coordinate, with [globeIndex](#series-.globeIndex) to assign the corresponding 3D globe coordinate components.""").tag(sync=True)
    
    grid3DIndex = Float(None, allow_none=True, help="""Use the index of the [grid3D](#grid3D) component. The first [grid3D](#grid3D) component is used by default.""").tag(sync=True)
    
    geo3DIndex = Float(None, allow_none=True, help="""The index of the [geo3D](#geo3D) component used by the axis.The first [grid3D](#grid3D) component is used by default.""").tag(sync=True)
    
    globeIndex = Float(None, allow_none=True, help="""The index of the [globe](#globe) component used by the axis.The first [globe](#globe) component is used by default.""").tag(sync=True)
    
    symbol = Unicode(None, allow_none=True, help="""The shape of the scatter. The default is a circle.


Icon types provided by ECharts includes 
`'circle'`, `'rect'`, `'roundRect'`, `'triangle'`, `'diamond'`, `'pin'`, `'arrow'`, `'none'`


Icons can be set to arbitrary vector path via `'path://'` in ECharts. As compared with a raster image, vector paths prevent jagging and blurring when scaled, and have better control over changing colors. The size of the vector icon will be adapted automatically. Refer to [SVG PathData](http://www.w3.org/TR/SVG/paths.html#PathData) for more information about the format of the path. You may export vector paths from tools like Adobe""").tag(sync=True)
    
    symbolSize = Union([Float(default_value=None, allow_none=True),Any(default_value=None, allow_none=True),Any(default_value=None, allow_none=True),], default_value=None, allow_none=True, help="""symbol size. It can be set to single numbers like `10`, or use an array to represent width and height. For example, `[20, 10]` means symbol width is `20`, and height is`10`.


If size of symbols needs to be different, you can set with callback function in the following format:



```
(value: Array|number, params: Object) => number|Array

```

The first parameter `value` is the value in [data](#series-.data), and the second parameter `params` is the rest parameters of data item.""").tag(sync=True)
    
    itemStyle = Dict(default_value=None, allow_none=True, help="""Sets the style of scatter such as colors, strokes, etc.""").tag(sync=True)
    
    label = Dict(default_value=None, allow_none=True, help="""Sets the style of label.""").tag(sync=True)
    
    emphasis = Dict(default_value=None, allow_none=True, help="""Graphics and labels are highlighted.""").tag(sync=True)
    
    data = Any(None, allow_none=True, help="""The data array of scatter3D. Each item in the array is a piece of data. Usually, this data stores each attribute/dimension of the data in an array. As Follows:



```
data: [
    [[12, 14, 10], [34, 50, 15], [56, 30, 20], [10, 15, 12], [23, 10, 14]]
]

```

For each item in the array：


1. In [grid3D](#grid3D) ,the first three values of each item are`x`, `y`, `z`.
2. In [geo3D](#geo3D) and <globe> ,the first two values of each item are longitude `lng`, latitude `lat`,


In addition to the default values for the coordinates, each item can be added with any number of values to [visualMap](#visualMap) the component for any other graphical property, such as color, etc.


More likely, we need to assign name to each data item, in which case each item should be an object:



```
[{
    // name of date item
    name: 'data1',
    // value of date item is 8
    value: [12, 14, 10]
}, {
    name: 'data2',
    value: 20
}]

```

Each data item can be further customized:



```
[{
    name: 'data1',
    value: [12, 14, 10]
}, {
    // name of data item
    name: 'data2',
    value : [34, 50, 15],
    // user-defined special itemStyle that only useful for this data item
    itemStyle:{}
}]

```""").tag(sync=True)
    
    blendMode = Unicode(None, allow_none=True, help="""Sets the type of compositing operation to apply when drawing a new shape. 


Currently supporting `'source-over'`, `'lighter'`. The default is `'source-over'` mode is blended by alpha. The `'lighter'` is overlap mode. In this mode, the area where the number of graphics is concentrated can be highlighted by the overlap.""").tag(sync=True)
    
    zlevel = Float(None, allow_none=True, help="""The layer in which the component is located.


`zlevel` is used to make layers with Canvas. Graphical elements with different `zlevel` values will be placed in different Canvases, which is a common optimization technique. We can put those frequently changed elements (like those with animations) to a separate `zlevel`. Notice that too many Canvases will increase memory cost, and should be used carefully on mobile phones to avoid the crash.


Canvases with bigger `zlevel` will be placed on Canvases with smaller `zlevel`.


**Note:** The layers of the components in echarts-gl need to be separated from the layers of the components in echarts. The same `zlevel` cannot be used for both WebGL and Canvas drawing at the same time.""").tag(sync=True)
    
    silent = Bool(None, allow_none=True, help="""Whether the graph doesn`t respond and triggers a mouse event. The default is false, which is to respond to and trigger mouse events.""").tag(sync=True)
    
    animation = Bool(None, allow_none=True, help="""Whether to enable animation.""").tag(sync=True)
    
    animationDurationUpdate = Float(None, allow_none=True, help="""The duration time for update the transition animation.""").tag(sync=True)
    
    animationEasingUpdate = Unicode(None, allow_none=True, help="""The easing effect for update transition animation.""").tag(sync=True)
    
        
