from traitlets import (
    Unicode, Dict, Float, Union, Any,
)
from ..basewidget import BaseWidget


class ScatterGL(BaseWidget):
    """ 
:warning: **Autogenerated class**

A 2D scatter/bubble plot drawn using WebGL.


It is used in the same way as [scatter](https://echarts.apache.org/en/option.html#series-scatter).



    """

    def __init__(self, **kwargs):

        super().__init__(**kwargs)  
    
    _model_name = Unicode("ScatterGLModel").tag(sync=True)
    
    type = Unicode("scatterGL", allow_none=True, ).tag(sync=True)
    
    name = Unicode(None, allow_none=True, help="""Series name used for displaying in [tooltip](https://echarts.apache.org/zh/option.html#tooltip) and filtering with [legend](https://echarts.apache.org/zh/option.html#legend), or updating data and configuration with `setOption`.""").tag(sync=True)
    
    coordinateSystem = Unicode(None, allow_none=True, help="""The coordinate system used.


Same as [scatter.coordinateSystem](https://echarts.apache.org/en/option.html#series-scatter.coordinateSystem)""").tag(sync=True)
    
    symbol = Unicode(None, allow_none=True, help="""The shape of the scatter. The default is a circle.


Icon types provided by ECharts includes 
`'circle'`, `'rect'`, `'roundRect'`, `'triangle'`, `'diamond'`, `'pin'`, `'arrow'`, `'none'`


Icons can be set to arbitrary vector path via `'path://'` in ECharts. As compared with a raster image, vector paths prevent jagging and blurring when scaled, and have better control over changing colors. The size of the vector icon will be adapted automatically. Refer to [SVG PathData](http://www.w3.org/TR/SVG/paths.html#PathData) for more information about the format of the path. You may export vector paths from tools like Adobe""").tag(sync=True)
    
    symbolSize = Union([Float(default_value=None, allow_none=True),Any(default_value=None, allow_none=True),Any(default_value=None, allow_none=True),], default_value=None, allow_none=True, help="""symbol size. It can be set to single numbers like `10`, or use an array to represent width and height. For example, `[20, 10]` means symbol width is `20`, and height is`10`.


If size of symbols needs to be different, you can set with callback function in the following format:



```
(value: Array|number, params: Object) => number|Array

```

The first parameter `value` is the value in [data](#series-.data), and the second parameter `params` is the rest parameters of data item.""").tag(sync=True)
    
    itemStyle = Dict(default_value=None, allow_none=True, help="""Sets the style of scatter""").tag(sync=True)
    
    data = Any(None, allow_none=True, help="""The data array of scatter.


The data format is the same as [scatter.data](https://echarts.apache.org/en/option.html#series-scatter.data)""").tag(sync=True)
    
    blendMode = Unicode(None, allow_none=True, help="""Sets the type of compositing operation to apply when drawing a new shape. 


Currently supporting `'source-over'`, `'lighter'`. The default is `'source-over'` mode is blended by alpha. The `'lighter'` is overlap mode. In this mode, the area where the number of graphics is concentrated can be highlighted by the overlap.""").tag(sync=True)
    
    zlevel = Float(None, allow_none=True, help="""The layer in which the component is located.


`zlevel` is used to make layers with Canvas. Graphical elements with different `zlevel` values will be placed in different Canvases, which is a common optimization technique. We can put those frequently changed elements (like those with animations) to a separate `zlevel`. Notice that too many Canvases will increase memory cost, and should be used carefully on mobile phones to avoid the crash.


Canvases with bigger `zlevel` will be placed on Canvases with smaller `zlevel`.


**Note:** The layers of the components in echarts-gl need to be separated from the layers of the components in echarts. The same `zlevel` cannot be used for both WebGL and Canvas drawing at the same time.""").tag(sync=True)
    
    progressiveThreshold = Float(None, allow_none=True, help="""Enable progressive rendering thresholds, progressive rendering can be loading the screen without blocking.""").tag(sync=True)
    
    progressive = Float(None, allow_none=True, help="""Progressively render the amount of data per render.""").tag(sync=True)
    
        
